from .representation import Representation
from .data import GlobalRepresentation, AtomicRepresentation
from .composed import Composed
from .soap import SOAP
from .mbtr import MBTR1, MBTR2, MBTR3, MBTR4
from .sf import SymmetryFunctions
from .coulomb_matrix import CoulombMatrix

from .soap import components as components_soap
from .mbtr import components as components_mbtr
from .sf import components as components_sf

components = [
    GlobalRepresentation,
    AtomicRepresentation,
    Composed,
    CoulombMatrix,
    *components_sf,
    *components_mbtr,
    *components_soap,
]
