/*
 * Decompiled with CFR 0.152.
 */
package patsy;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jpmml.python.ParseException;
import org.jpmml.python.PushbackPythonParserTokenManager;
import org.jpmml.python.SimpleCharStream;
import org.jpmml.python.StringProvider;
import org.jpmml.python.Token;
import patsy.PatsyFactor;
import patsy.PatsyOperation;
import patsy.PatsyOperator;
import patsy.PatsyTerm;
import patsy.PatsyToken;

public class FormulaParser {
    public static void main(String ... args) throws Exception {
        PatsyTerm patsyTerm = FormulaParser.parseFormula(args[0]);
        System.out.println(patsyTerm);
    }

    public static PatsyTerm parseFormula(String string) throws ParseException {
        SimpleCharStream simpleCharStream = new SimpleCharStream(new StringProvider(string));
        PushbackPythonParserTokenManager tokenManager = new PushbackPythonParserTokenManager(simpleCharStream);
        EnumSet<PatsyOperator> privatePatsyOperators = EnumSet.of(PatsyOperator.OPEN_PAREN);
        EnumSet<PatsyOperator> patsyOperators = EnumSet.complementOf(privatePatsyOperators);
        Set<Integer> patsyOperatorTokens = patsyOperators.stream().map(patsyOperator -> patsyOperator.getKind()).collect(Collectors.toSet());
        List<PatsyToken> patsyTokens = FormulaParser.tokenizeFormula(tokenManager, patsyOperatorTokens);
        return FormulaParser.infixParse(patsyTokens, patsyOperators);
    }

    private static PatsyTerm infixParse(List<PatsyToken> patsyTokens, Set<PatsyOperator> patsyOperators) throws ParseException {
        HashMap<Integer, PatsyOperator> unaryPatsyOperators = new HashMap<Integer, PatsyOperator>();
        HashMap<Integer, PatsyOperator> binaryPatsyOperators = new HashMap<Integer, PatsyOperator>();
        block4: for (PatsyOperator patsyOperator : patsyOperators) {
            int kind = patsyOperator.getKind();
            int arity = patsyOperator.getArity();
            switch (arity) {
                case 1: {
                    unaryPatsyOperators.put(kind, patsyOperator);
                    continue block4;
                }
                case 2: {
                    binaryPatsyOperators.put(kind, patsyOperator);
                    continue block4;
                }
            }
            throw new ParseException();
        }
        boolean wantNoun = true;
        ArrayDeque<PatsyTerm> nounStack = new ArrayDeque<PatsyTerm>();
        ArrayDeque<PatsyOperator> opStack = new ArrayDeque<PatsyOperator>();
        for (PatsyToken patsyToken : patsyTokens) {
            if (wantNoun) {
                wantNoun = FormulaParser.readNoun(patsyToken, nounStack, opStack, unaryPatsyOperators, binaryPatsyOperators);
                continue;
            }
            wantNoun = FormulaParser.readOp(patsyToken, nounStack, opStack, unaryPatsyOperators, binaryPatsyOperators);
        }
        while (!opStack.isEmpty()) {
            if (opStack.peek() == PatsyOperator.OPEN_PAREN) {
                throw new ParseException();
            }
            FormulaParser.runOp(nounStack, opStack);
        }
        if (nounStack.size() != 1) {
            throw new ParseException();
        }
        return (PatsyTerm)nounStack.pop();
    }

    private static boolean readNoun(PatsyToken patsyToken, Deque<PatsyTerm> nounStack, Deque<PatsyOperator> opStack, Map<Integer, PatsyOperator> unaryPatsyOperators, Map<Integer, PatsyOperator> binaryPatsyOperators) throws ParseException {
        int kind = patsyToken.getKind();
        if (kind == 4) {
            opStack.push(PatsyOperator.OPEN_PAREN);
            return true;
        }
        PatsyOperator unaryPatsyOperator = unaryPatsyOperators.get(kind);
        if (unaryPatsyOperator != null) {
            opStack.push(unaryPatsyOperator);
            return true;
        }
        if (kind == -1) {
            nounStack.push(new PatsyFactor(patsyToken));
            return false;
        }
        throw new ParseException();
    }

    private static boolean readOp(PatsyToken patsyToken, Deque<PatsyTerm> nounStack, Deque<PatsyOperator> opStack, Map<Integer, PatsyOperator> unaryPatsyOperators, Map<Integer, PatsyOperator> binaryPatsyOperators) throws ParseException {
        int kind = patsyToken.getKind();
        if (kind == 5) {
            while (!opStack.isEmpty() && opStack.peek() != PatsyOperator.OPEN_PAREN) {
                FormulaParser.runOp(nounStack, opStack);
            }
            if (opStack.isEmpty()) {
                throw new ParseException();
            }
            if (opStack.peek() != PatsyOperator.OPEN_PAREN) {
                throw new ParseException();
            }
            opStack.pop();
            return false;
        }
        PatsyOperator binaryPatsyOperator = binaryPatsyOperators.get(kind);
        if (binaryPatsyOperator != null) {
            while (!opStack.isEmpty() && Integer.compare(binaryPatsyOperator.getPrecedence(), opStack.peek().getPrecedence()) <= 0) {
                FormulaParser.runOp(nounStack, opStack);
            }
            opStack.push(binaryPatsyOperator);
            return true;
        }
        throw new ParseException();
    }

    private static void runOp(Deque<PatsyTerm> nounStack, Deque<PatsyOperator> opStack) {
        PatsyOperator patsyOperator = opStack.pop();
        ArrayList<PatsyTerm> patsyTerms = new ArrayList<PatsyTerm>();
        for (int i = 0; i < patsyOperator.getArity(); ++i) {
            patsyTerms.add(nounStack.pop());
        }
        Collections.reverse(patsyTerms);
        nounStack.push(new PatsyOperation(patsyOperator, patsyTerms));
    }

    private static List<PatsyToken> tokenizeFormula(PushbackPythonParserTokenManager tokenManager, Set<Integer> patsyOperatorTokens) throws ParseException {
        ArrayList<PatsyToken> result = new ArrayList<PatsyToken>();
        patsyOperatorTokens.add(4);
        patsyOperatorTokens.add(5);
        HashSet<Integer> pythonEndTokens = new HashSet<Integer>(patsyOperatorTokens);
        pythonEndTokens.remove(4);
        while (true) {
            Token token = tokenManager.getNextToken();
            if (token.kind == 0) break;
            if (patsyOperatorTokens.contains(token.kind)) {
                result.add(new PatsyToken(token));
                continue;
            }
            tokenManager.pushBack(token);
            List<Token> tokens = FormulaParser.readPythonExpr(tokenManager, pythonEndTokens);
            if (tokens.isEmpty()) {
                throw new ParseException();
            }
            result.add(new PatsyToken(tokens));
        }
        return result;
    }

    private static List<Token> readPythonExpr(PushbackPythonParserTokenManager tokenManager, Set<Integer> pythonEndTokens) throws ParseException {
        ArrayList<Token> result = new ArrayList<Token>();
        int bracketLevel = 0;
        while (true) {
            Token token = tokenManager.getNextToken();
            if (token.kind == 0) {
                tokenManager.pushBack(token);
                break;
            }
            if (bracketLevel == 0 && pythonEndTokens.contains(token.kind)) {
                tokenManager.pushBack(token);
                break;
            }
            switch (token.kind) {
                case 4: 
                case 22: {
                    ++bracketLevel;
                    break;
                }
                case 5: 
                case 23: {
                    if (--bracketLevel >= 0) break;
                    throw new ParseException();
                }
            }
            result.add(token);
        }
        if (bracketLevel != 0) {
            throw new ParseException();
        }
        return result;
    }
}

