/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataType;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.AbstractTranslator;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.NullProvider;
import org.jpmml.python.ParseException;
import org.jpmml.python.Provider;
import org.jpmml.python.PythonParserConstants;
import org.jpmml.python.PythonParserTokenManager;
import org.jpmml.python.PythonParserUtil;
import org.jpmml.python.Scope;
import org.jpmml.python.SimpleCharStream;
import org.jpmml.python.StringProvider;
import org.jpmml.python.Token;
import org.jpmml.python.TokenMgrException;

public class PredicateTranslator
extends AbstractTranslator
implements PythonParserConstants {
    public PythonParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[15];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public PredicateTranslator(Scope scope) {
        this(new NullProvider());
        this.setScope(scope);
    }

    public Predicate translatePredicate(String string) {
        Predicate predicate;
        this.ReInit(new StringProvider(string));
        try {
            predicate = this.translatePredicateInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Python predicate '" + string + "' is either invalid or not supported", pe);
        }
        return predicate;
    }

    private static SimplePredicate.Operator translateRelationalOperator(Token operator) throws ParseException {
        switch (operator.kind) {
            case 9: {
                return SimplePredicate.Operator.EQUAL;
            }
            case 10: {
                return SimplePredicate.Operator.NOT_EQUAL;
            }
            case 11: {
                return SimplePredicate.Operator.LESS_THAN;
            }
            case 12: {
                return SimplePredicate.Operator.LESS_OR_EQUAL;
            }
            case 13: {
                return SimplePredicate.Operator.GREATER_THAN;
            }
            case 14: {
                return SimplePredicate.Operator.GREATER_OR_EQUAL;
            }
        }
        throw new ParseException();
    }

    private static String getOnlyArgument(Apply apply) {
        List expressions = apply.getExpressions();
        ClassDictUtil.checkSize(1, expressions);
        FieldRef fieldRef = (FieldRef)expressions.get(0);
        return fieldRef.requireField();
    }

    private static Array createArray(List<?> values) {
        DataType dataType = TypeUtil.getDataType(values, (DataType)DataType.STRING);
        switch (dataType) {
            case INTEGER: {
                return PMMLUtil.createIntArray(values);
            }
            case FLOAT: 
            case DOUBLE: {
                return PMMLUtil.createRealArray(values);
            }
        }
        return PMMLUtil.createStringArray(values);
    }

    private static SimplePredicate createSimplePredicate(Object left, SimplePredicate.Operator operator, Object right) {
        String name = PredicateTranslator.asFieldName(left);
        Object value = right != null ? PredicateTranslator.asValue(right) : null;
        return new SimplePredicate(name, operator, value);
    }

    private static SimpleSetPredicate createSimpleSetPredicate(Object left, SimpleSetPredicate.BooleanOperator booleanOperator, Object right) {
        String name = PredicateTranslator.asFieldName(left);
        Array array = (Array)right;
        return new SimpleSetPredicate(name, booleanOperator, array);
    }

    private static CompoundPredicate createCompoundPredicate(Predicate left, CompoundPredicate.BooleanOperator booleanOperator, Predicate right) {
        CompoundPredicate compoundPredicate;
        if (left instanceof CompoundPredicate && (compoundPredicate = (CompoundPredicate)left).requireBooleanOperator() == booleanOperator) {
            compoundPredicate.addPredicates(new Predicate[]{right});
            return compoundPredicate;
        }
        compoundPredicate = new CompoundPredicate(booleanOperator, null).addPredicates(new Predicate[]{left, right});
        return compoundPredicate;
    }

    private static String asFieldName(Object object) {
        if (object instanceof Feature) {
            Feature feature = (Feature)object;
            return feature.getName();
        }
        if (object instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)object;
            return fieldRef.requireField();
        }
        throw new IllegalArgumentException("The left-hand side of the predicate (" + object + ") is not a feature reference");
    }

    private static Object asValue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("The right-hand side of the predicate (" + object + ") is not a value");
    }

    private static Predicate asPredicate(Object object) {
        Feature feature;
        if (object instanceof Predicate) {
            Predicate predicate = (Predicate)object;
            return predicate;
        }
        if (object instanceof Apply) {
            Apply apply = (Apply)object;
            switch (apply.requireFunction()) {
                case "isMissing": {
                    return new SimplePredicate(PredicateTranslator.getOnlyArgument(apply), SimplePredicate.Operator.IS_MISSING, null);
                }
                case "isNotMissing": {
                    return new SimplePredicate(PredicateTranslator.getOnlyArgument(apply), SimplePredicate.Operator.IS_NOT_MISSING, null);
                }
            }
        }
        if (object instanceof Feature && (feature = (Feature)object).getDataType() == DataType.BOOLEAN) {
            return new SimplePredicate(feature.getName(), SimplePredicate.Operator.EQUAL, (Object)Boolean.TRUE);
        }
        if (Boolean.FALSE.equals(object)) {
            return False.INSTANCE;
        }
        if (Boolean.TRUE.equals(object)) {
            return True.INSTANCE;
        }
        throw new IllegalArgumentException("The expression (" + object + ") is not a predicate");
    }

    private static Object asArgument(Object object) {
        if (object instanceof Feature) {
            Feature feature = (Feature)object;
            return feature;
        }
        throw new IllegalArgumentException("The function argument (" + object + ") is not a feature reference");
    }

    private static Object toNegative(Object object) throws ParseException {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? -1 : 0;
        }
        if (object instanceof Integer) {
            return -((Integer)object).intValue();
        }
        if (object instanceof Double) {
            return -((Double)object).doubleValue();
        }
        throw new ParseException();
    }

    private final Token String() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 43: {
                token = this.jj_consume_token(43);
                break;
            }
            case 50: {
                token = this.jj_consume_token(50);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    private final Token Sign() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    private final String DottedName() throws ParseException {
        StringBuilder sb = new StringBuilder();
        Token name = this.jj_consume_token(42);
        sb.append(name.image);
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(25);
            name = this.jj_consume_token(42);
            sb.append('.').append(name.image);
        }
        return sb.toString();
    }

    private final String CanonicalizedDottedName() throws ParseException {
        String dottedName = this.DottedName();
        return this.canonicalizeDottedName(dottedName);
    }

    private final Predicate translatePredicateInternal() throws ParseException {
        Predicate predicate = this.Predicate();
        this.jj_consume_token(0);
        return predicate;
    }

    private final Predicate Predicate() throws ParseException {
        Predicate predicate = this.LogicalOrExpression();
        return predicate;
    }

    private final Predicate LogicalOrExpression() throws ParseException {
        Predicate left = this.LogicalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(6);
            Predicate right = this.LogicalAndExpression();
            left = PredicateTranslator.createCompoundPredicate(left, CompoundPredicate.BooleanOperator.OR, right);
        }
        return left;
    }

    private final Predicate LogicalAndExpression() throws ParseException {
        Predicate left = this.ComparisonExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            Predicate right = this.ComparisonExpression();
            left = PredicateTranslator.createCompoundPredicate(left, CompoundPredicate.BooleanOperator.AND, right);
        }
        return left;
    }

    private final Predicate ComparisonExpression() throws ParseException {
        Token operator = null;
        Object left = this.PrimaryExpression();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(38);
            this.jj_consume_token(29);
            left = PredicateTranslator.createSimplePredicate(left, SimplePredicate.Operator.IS_MISSING, null);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 38: {
                    this.jj_consume_token(38);
                    this.jj_consume_token(8);
                    this.jj_consume_token(29);
                    left = PredicateTranslator.createSimplePredicate(left, SimplePredicate.Operator.IS_NOT_MISSING, null);
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    Array right = this.ListMakerExpression();
                    left = PredicateTranslator.createSimpleSetPredicate(left, SimpleSetPredicate.BooleanOperator.IS_IN, right);
                    break;
                }
                case 8: {
                    this.jj_consume_token(8);
                    this.jj_consume_token(37);
                    Array right = this.ListMakerExpression();
                    left = PredicateTranslator.createSimpleSetPredicate(left, SimpleSetPredicate.BooleanOperator.IS_NOT_IN, right);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: {
                            operator = this.jj_consume_token(9);
                            break;
                        }
                        case 10: {
                            operator = this.jj_consume_token(10);
                            break;
                        }
                        case 11: {
                            operator = this.jj_consume_token(11);
                            break;
                        }
                        case 12: {
                            operator = this.jj_consume_token(12);
                            break;
                        }
                        case 13: {
                            operator = this.jj_consume_token(13);
                            break;
                        }
                        case 14: {
                            operator = this.jj_consume_token(14);
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    Object right = this.UnaryExpression();
                    left = PredicateTranslator.createSimplePredicate(left, PredicateTranslator.translateRelationalOperator(operator), right);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    left = PredicateTranslator.asPredicate(left);
                }
            }
        }
        return (Predicate)left;
    }

    private final Object UnaryExpression() throws ParseException {
        Object result;
        Token sign = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 17: {
                sign = this.Sign();
                result = this.UnaryExpression();
                break;
            }
            case 4: 
            case 28: 
            case 30: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: {
                result = this.PrimaryExpression();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (sign != null && sign.kind == 17) {
            result = PredicateTranslator.toNegative(result);
        }
        return result;
    }

    private final Object PrimaryExpression() throws ParseException {
        Object result;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                String dottedName = this.CanonicalizedDottedName();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        result = this.ArrayIndexingExpression(dottedName);
                        break block0;
                    }
                    case 4: {
                        result = this.FunctionInvocationExpression(dottedName);
                        break block0;
                    }
                }
                this.jj_la1[7] = this.jj_gen;
                result = this.NameInvocationExpression(dottedName);
                break;
            }
            case 4: {
                result = this.ParenthesizedExpression();
                break;
            }
            case 28: 
            case 30: 
            case 40: 
            case 41: 
            case 43: 
            case 50: {
                result = this.LiteralExpression();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    private final Feature ArrayIndexingExpression(String dottedName) throws ParseException {
        Feature feature;
        Token sign = null;
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            this.jj_consume_token(22);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: 
                case 17: {
                    sign = this.Sign();
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                }
            }
            Token column = this.jj_consume_token(40);
            this.jj_consume_token(23);
            Scope scope = this.ensureScope();
            int colIndex = PythonParserUtil.parseInt(sign, column);
            feature = scope.getFeature(dottedName, colIndex);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: {
                    this.jj_consume_token(22);
                    Token column = this.String();
                    this.jj_consume_token(23);
                    Scope scope = this.ensureScope();
                    String colName = PythonParserUtil.parseString(column);
                    feature = scope.getFeature(dottedName, colName);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return feature;
    }

    private final Object FunctionInvocationExpression(String dottedName) throws ParseException {
        List<Object> arguments = this.Arguments();
        return this.encodeFunction(dottedName, arguments);
    }

    private final List<Object> Arguments() throws ParseException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            this.jj_consume_token(4);
            this.jj_consume_token(5);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    Object argument = this.PrimaryExpression();
                    arguments.add(PredicateTranslator.asArgument(argument));
                    block6: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 24: {
                                break;
                            }
                            default: {
                                this.jj_la1[11] = this.jj_gen;
                                break block6;
                            }
                        }
                        this.jj_consume_token(24);
                        argument = this.PrimaryExpression();
                        arguments.add(PredicateTranslator.asArgument(argument));
                    }
                    this.jj_consume_token(5);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return arguments;
    }

    private final Object NameInvocationExpression(String dottedName) throws ParseException {
        Scope scope = this.ensureScope();
        Feature feature = scope.getFeature(dottedName);
        return feature;
    }

    private final Predicate ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(4);
        Predicate predicate = this.Predicate();
        this.jj_consume_token(5);
        return predicate;
    }

    private final Object LiteralExpression() throws ParseException {
        Token value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: {
                value = this.jj_consume_token(28);
                break;
            }
            case 30: {
                value = this.jj_consume_token(30);
                break;
            }
            case 40: {
                value = this.jj_consume_token(40);
                break;
            }
            case 41: {
                value = this.jj_consume_token(41);
                break;
            }
            case 43: 
            case 50: {
                value = this.String();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return PythonParserUtil.parseValue(value);
    }

    private final Array ListMakerExpression() throws ParseException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.jj_consume_token(22);
        Object predicate = this.UnaryExpression();
        values.add(PredicateTranslator.asValue(predicate));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(24);
            predicate = this.UnaryExpression();
            values.add(PredicateTranslator.asValue(predicate));
        }
        this.jj_consume_token(23);
        return PredicateTranslator.createArray(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_null_632_39_6()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_Sign_462_9_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(16)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(17)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(42);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_null_632_39_6() {
        return this.jj_3R_Sign_462_9_7();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 196608, 64, 128, 32256, 32512, 1342373904, 0x400010, 0x50000010, 196608, 0x400000, 0x1000000, 16, 0x50000000, 0x1000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{264192, 0, 0, 0, 0, 96, 265984, 0, 265984, 0, 0, 0, 0, 264960, 0};
    }

    public PredicateTranslator(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PythonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PredicateTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new PythonParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PredicateTranslator(PythonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PythonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[51];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 15; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 51; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : PythonParserTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PredicateTranslator.jj_la1_init_0();
        PredicateTranslator.jj_la1_init_1();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

