/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureResolver;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;
import org.jpmml.python.AbstractTranslator;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.NullProvider;
import org.jpmml.python.ParseException;
import org.jpmml.python.Provider;
import org.jpmml.python.PythonParserConstants;
import org.jpmml.python.PythonParserTokenManager;
import org.jpmml.python.PythonParserUtil;
import org.jpmml.python.Scope;
import org.jpmml.python.SimpleCharStream;
import org.jpmml.python.StringProvider;
import org.jpmml.python.Token;
import org.jpmml.python.TokenMgrException;

public class ExpressionTranslator
extends AbstractTranslator
implements PythonParserConstants {
    private Deque<String> indents = new ArrayDeque<String>();
    private Map<String, FieldRef> variableMap = new LinkedHashMap<String, FieldRef>();
    public PythonParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[50];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public ExpressionTranslator(Scope scope) {
        this(new NullProvider());
        this.setScope(scope);
    }

    public DerivedField translateDef(String string) {
        DerivedField derivedField;
        this.ReInit(new StringProvider(ExpressionTranslator.ensureTerminator(string)));
        try {
            derivedField = this.translateDefInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Python function definition '" + ExpressionTranslator.toSingleLine(string) + "' is either invalid or not supported", pe);
        }
        return derivedField;
    }

    public Expression translateStatement(String string) {
        return this.translateStatement(string, true);
    }

    public Expression translateStatement(String string, boolean compact) {
        Expression statement;
        this.ReInit(new StringProvider(ExpressionTranslator.ensureTerminator(string)));
        try {
            statement = this.translateStatementInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Python statement '" + ExpressionTranslator.toSingleLine(string) + "' is either invalid or not supported", pe);
        }
        if (compact) {
            statement = ExpressionTranslator.compact(statement);
        }
        return statement;
    }

    public Expression translateExpression(String string) {
        return this.translateExpression(string, true);
    }

    public Expression translateExpression(String string, boolean compact) {
        Expression expression;
        this.ReInit(new StringProvider(string));
        try {
            expression = this.translateExpressionInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Python expression '" + ExpressionTranslator.toSingleLine(string) + "' is either invalid or not supported", pe);
        }
        if (compact) {
            expression = ExpressionTranslator.compact(expression);
        }
        return expression;
    }

    public Constant encodeConstant(String dottedName) {
        switch (dottedName) {
            case "math.e": 
            case "numpy.e": {
                return PMMLUtil.createConstant((Object)Math.E, (DataType)DataType.DOUBLE);
            }
            case "numpy.NZERO": {
                return PMMLUtil.createConstant((Object)-0.0, (DataType)DataType.DOUBLE);
            }
            case "math.pi": 
            case "numpy.pi": {
                return PMMLUtil.createConstant((Object)Math.PI, (DataType)DataType.DOUBLE);
            }
            case "numpy.PZERO": {
                return PMMLUtil.createConstant((Object)0.0, (DataType)DataType.DOUBLE);
            }
        }
        switch (dottedName) {
            case "math.nan": 
            case "numpy.nan": 
            case "numpy.NaN": 
            case "numpy.NAN": 
            case "pandas.NA": 
            case "pandas.NaT": {
                return PMMLUtil.createMissingConstant();
            }
        }
        throw new IllegalArgumentException("Constant '" + dottedName + "' is not supported");
    }

    private String getIndent() throws ParseException {
        Token nextToken = this.getToken(1);
        return PythonParserUtil.getWhitespace(nextToken);
    }

    private void checkIndent(String indent) throws ParseException {
        String expectedIndent = this.indents.peek();
        if (!indent.equals(expectedIndent)) {
            throw new ParseException("Unexpected indent");
        }
    }

    public static Expression compact(Expression expression) {
        ExpressionCompactor expressionCompactor = new ExpressionCompactor();
        expressionCompactor.applyTo((Visitable)expression);
        return expression;
    }

    private static String translateRelationalOperator(Token operator) throws ParseException {
        switch (operator.kind) {
            case 9: {
                return "equal";
            }
            case 10: {
                return "notEqual";
            }
            case 11: {
                return "lessThan";
            }
            case 12: {
                return "lessOrEqual";
            }
            case 13: {
                return "greaterThan";
            }
            case 14: {
                return "greaterOrEqual";
            }
        }
        throw new ParseException();
    }

    private static String translateArithmeticOperator(Token operator) {
        switch (operator.kind) {
            case 20: {
                return "modulo";
            }
        }
        return operator.image;
    }

    private static Apply translateTrailerFunction(Expression expression, String name, List<Expression> arguments) {
        if ("startswith".equals(name) || "endswith".equals(name)) {
            ClassDictUtil.checkSize(1, arguments);
            Expression argument = arguments.get(0);
            if (!(argument instanceof Constant)) {
                throw new IllegalArgumentException();
            }
            Constant constant = (Constant)argument;
            if (constant.getDataType() != DataType.STRING) {
                throw new IllegalArgumentException();
            }
            String value = (String)constant.getValue();
            switch (name) {
                case "startswith": {
                    return PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{ExpressionTranslator.translateStringSlice(expression, 0, value.length()), constant});
                }
                case "endswith": {
                    return PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{ExpressionTranslator.translateStringSlice(expression, -value.length(), null), constant});
                }
            }
        } else if ("lower".equals(name) || "upper".equals(name)) {
            ClassDictUtil.checkSize(0, arguments);
            switch (name) {
                case "lower": {
                    return PMMLUtil.createApply((String)"lowercase", (Expression[])new Expression[]{expression});
                }
                case "upper": {
                    return PMMLUtil.createApply((String)"uppercase", (Expression[])new Expression[]{expression});
                }
            }
        } else if ("strip".equals(name)) {
            ClassDictUtil.checkSize(0, arguments);
            switch (name) {
                case "strip": {
                    return PMMLUtil.createApply((String)"trimBlanks", (Expression[])new Expression[]{expression});
                }
            }
        }
        throw new IllegalArgumentException("Function '" + name + "' is not supported");
    }

    private static Expression translateStringSlice(Expression expression, Integer startPos, Integer stopPos) {
        if (startPos == null && stopPos == null) {
            return expression;
        }
        Object offsetExpression = startPos != null && startPos >= 0 ? PMMLUtil.createConstant((Object)(startPos + 1), (DataType)DataType.INTEGER) : (startPos != null && startPos < 0 ? PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{expression}), PMMLUtil.createConstant((Object)(-startPos.intValue() - 1), (DataType)DataType.INTEGER)}), PMMLUtil.createConstant((Object)1, (DataType)DataType.INTEGER)}) : PMMLUtil.createConstant((Object)1, (DataType)DataType.INTEGER));
        Object lengthExpression = stopPos != null && stopPos >= 0 ? (startPos != null && startPos >= 0 ? PMMLUtil.createConstant((Object)Math.max(stopPos - startPos, 0), (DataType)DataType.INTEGER) : (startPos != null && startPos < 0 ? PMMLUtil.createConstant((Object)0, (DataType)DataType.INTEGER) : PMMLUtil.createConstant((Object)stopPos, (DataType)DataType.INTEGER))) : (stopPos != null && stopPos < 0 ? (startPos != null && startPos >= 0 ? PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{expression}), PMMLUtil.createConstant((Number)(startPos + -stopPos.intValue()))}), PMMLUtil.createConstant((Object)0, (DataType)DataType.INTEGER)}) : (startPos != null && startPos < 0 ? PMMLUtil.createConstant((Object)Math.max(stopPos - startPos, 0), (DataType)DataType.INTEGER) : PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{expression}), PMMLUtil.createConstant((Number)(-stopPos.intValue()))}), PMMLUtil.createConstant((Object)0, (DataType)DataType.INTEGER)}))) : PMMLUtil.createConstant((Object)Integer.MAX_VALUE, (DataType)DataType.INTEGER));
        return PMMLUtil.createApply((String)"substring", (Expression[])new Expression[]{expression, offsetExpression, lengthExpression});
    }

    private static String ensureTerminator(String string) {
        if (string.endsWith("\n") && !string.endsWith("\n\n")) {
            string = string + "\n";
        }
        return string;
    }

    private static Expression getOnlyStatement(List<Expression> statements) {
        for (int i = 0; i < statements.size(); ++i) {
            Expression statement = statements.get(i);
            if (statement == null) continue;
            statements = statements.subList(i, statements.size());
            break;
        }
        return (Expression)Iterables.getOnlyElement(statements);
    }

    private final Token String() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 43: {
                token = this.jj_consume_token(43);
                break;
            }
            case 50: {
                token = this.jj_consume_token(50);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    private final Token Sign() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    private final String DottedName() throws ParseException {
        StringBuilder sb = new StringBuilder();
        Token name = this.jj_consume_token(42);
        sb.append(name.image);
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(25);
            name = this.jj_consume_token(42);
            sb.append('.').append(name.image);
        }
        return sb.toString();
    }

    private final String CanonicalizedDottedName() throws ParseException {
        String dottedName = this.DottedName();
        return this.canonicalizeDottedName(dottedName);
    }

    private final DerivedField translateDefInternal() throws ParseException {
        DerivedField derivedField = this.Def();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(3);
        }
        this.jj_consume_token(0);
        return derivedField;
    }

    private final Expression translateStatementInternal() throws ParseException {
        Expression expression = this.Statement();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(3);
        }
        this.jj_consume_token(0);
        return expression;
    }

    private final Expression translateExpressionInternal() throws ParseException {
        Expression expression = this.Expression();
        this.jj_consume_token(0);
        return expression;
    }

    private final DerivedField Def() throws ParseException {
        this.variableMap.clear();
        this.jj_consume_token(32);
        Token name = this.jj_consume_token(42);
        List<Token> parameters = this.Parameters();
        this.jj_consume_token(26);
        Block block = this.Block();
        this.variableMap.clear();
        return this.createDerivedField(name.image, ExpressionTranslator.getOnlyStatement(block));
    }

    private final List<Token> Parameters() throws ParseException {
        ArrayList<Token> names = new ArrayList<Token>();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(4);
            this.jj_consume_token(5);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    Token name = this.jj_consume_token(42);
                    names.add(name);
                    block6: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 24: {
                                break;
                            }
                            default: {
                                this.jj_la1[4] = this.jj_gen;
                                break block6;
                            }
                        }
                        this.jj_consume_token(24);
                        name = this.jj_consume_token(42);
                        names.add(name);
                    }
                    this.jj_consume_token(5);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return names;
    }

    private final Block Block() throws ParseException {
        List<Expression> statements;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 3: {
                block7: while (true) {
                    this.jj_consume_token(3);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 3: {
                            continue block7;
                        }
                    }
                    break;
                }
                this.jj_la1[6] = this.jj_gen;
                this.Indent();
                statements = this.Statements();
                this.Dedent();
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: {
                statements = this.SimpleStatements();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new Block(statements);
    }

    private void Indent() throws ParseException {
        String prevIndent;
        String indent = this.getIndent();
        if (!this.indents.isEmpty() && !indent.startsWith(prevIndent = this.indents.peek())) {
            throw new ParseException();
        }
        this.indents.push(indent);
    }

    private void Dedent() throws ParseException {
        this.indents.pop();
    }

    private final List<Expression> Statements() throws ParseException {
        ArrayList<Expression> statements = new ArrayList<Expression>();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                case 4: 
                case 8: 
                case 16: 
                case 17: 
                case 28: 
                case 29: 
                case 30: 
                case 35: 
                case 36: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 50: {
                    Expression statement = this.Statement();
                    statements.add(statement);
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 4: 
                case 8: 
                case 16: 
                case 17: 
                case 28: 
                case 29: 
                case 30: 
                case 35: 
                case 36: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 50: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[9] = this.jj_gen;
        return statements;
    }

    private final Expression Statement() throws ParseException {
        Expression statement;
        String indent = this.getIndent();
        this.checkIndent(indent);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                statement = this.CompoundStatement();
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: {
                List<Expression> statements = this.SimpleStatements();
                statement = ExpressionTranslator.getOnlyStatement(statements);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statement;
    }

    private final Expression CompoundStatement() throws ParseException {
        Apply statement = this.IfStatement();
        return statement;
    }

    private final List<Expression> SimpleStatements() throws ParseException {
        ArrayList<Expression> statements = new ArrayList<Expression>();
        Expression statement = this.SimpleStatement();
        statements.add(statement);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(27);
            statement = this.SimpleStatement();
            statements.add(statement);
        }
        this.jj_consume_token(3);
        return statements;
    }

    private final Expression SimpleStatement() throws ParseException {
        Expression expression;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: {
                expression = this.Assignment();
                break;
            }
            case 39: {
                expression = this.ReturnStatement();
                break;
            }
            case 36: {
                expression = this.ImportStatement();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    private final Apply IfStatement() throws ParseException {
        Apply if_statement;
        this.jj_consume_token(35);
        Expression condition = this.Expression();
        this.jj_consume_token(26);
        Block block = this.Block();
        Apply tail = if_statement = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{condition, ExpressionTranslator.getOnlyStatement(block)});
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block6;
                }
            }
            Apply elif_statement = this.ElIfStatement();
            tail.addExpressions(new Expression[]{elif_statement});
            tail = elif_statement;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 34: {
                block = this.ElseBlock();
                tail.addExpressions(new Expression[]{ExpressionTranslator.getOnlyStatement(block)});
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        return if_statement;
    }

    private final Apply ElIfStatement() throws ParseException {
        this.jj_consume_token(33);
        Expression condition = this.Expression();
        this.jj_consume_token(26);
        Block block = this.Block();
        return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{condition, ExpressionTranslator.getOnlyStatement(block)});
    }

    private final Block ElseBlock() throws ParseException {
        this.jj_consume_token(34);
        this.jj_consume_token(26);
        Block block = this.Block();
        return block;
    }

    private final Expression Assignment() throws ParseException {
        Token name;
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            name = this.jj_consume_token(42);
            this.jj_consume_token(15);
        } else {
            name = null;
        }
        Expression expression = this.Expression();
        if (name != null) {
            if (expression instanceof FieldRef) {
                FieldRef fieldRef = (FieldRef)expression;
                this.variableMap.put(name.image, fieldRef);
                return null;
            }
            DerivedField derivedField = this.createDerivedField(name.image, expression);
        }
        return null;
    }

    private final Expression ReturnStatement() throws ParseException {
        this.jj_consume_token(39);
        Expression expression = this.Expression();
        return expression;
    }

    private final Expression ImportStatement() throws ParseException {
        this.jj_consume_token(36);
        this.DottedAsName();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(24);
            this.DottedAsName();
        }
        return null;
    }

    private final void DottedAsName() throws ParseException {
        Token name = null;
        String dottedName = this.DottedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                name = this.jj_consume_token(42);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        Map<String, String> moduleImports = this.getModuleImports();
        moduleImports.put(name != null ? name.image : dottedName, dottedName);
    }

    private final Expression Expression() throws ParseException {
        Expression expression = this.IfElseExpression();
        return expression;
    }

    private final Expression IfElseExpression() throws ParseException {
        Expression left = this.LogicalOrExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                Expression center = this.Expression();
                this.jj_consume_token(34);
                Expression right = this.Expression();
                left = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{center, left, right});
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        return left;
    }

    private final Expression LogicalOrExpression() throws ParseException {
        Expression left = this.LogicalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(6);
            Expression right = this.LogicalAndExpression();
            left = PMMLUtil.createApply((String)"or", (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    private final Expression LogicalAndExpression() throws ParseException {
        Expression left = this.NegationExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            Expression right = this.NegationExpression();
            left = PMMLUtil.createApply((String)"and", (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    private final Expression NegationExpression() throws ParseException {
        Token operator = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                operator = this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        Expression expression = this.ComparisonExpression();
        if (operator != null) {
            return PMMLUtil.createApply((String)"not", (Expression[])new Expression[]{expression});
        }
        return expression;
    }

    private final Expression ComparisonExpression() throws ParseException {
        Expression left = this.AdditiveExpression();
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            this.jj_consume_token(38);
            this.jj_consume_token(29);
            left = PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{left});
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 38: {
                    this.jj_consume_token(38);
                    this.jj_consume_token(8);
                    this.jj_consume_token(29);
                    left = PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{left});
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    Expression[] right = this.ListMakerExpression();
                    left = PMMLUtil.createApply((String)"isIn", (Expression[])new Expression[]{left}).addExpressions(right);
                    break;
                }
                case 8: {
                    this.jj_consume_token(8);
                    this.jj_consume_token(37);
                    Expression[] right = this.ListMakerExpression();
                    left = PMMLUtil.createApply((String)"isNotIn", (Expression[])new Expression[]{left}).addExpressions(right);
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            Token operator;
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 9: {
                                    operator = this.jj_consume_token(9);
                                    break;
                                }
                                case 10: {
                                    operator = this.jj_consume_token(10);
                                    break;
                                }
                                case 11: {
                                    operator = this.jj_consume_token(11);
                                    break;
                                }
                                case 12: {
                                    operator = this.jj_consume_token(12);
                                    break;
                                }
                                case 13: {
                                    operator = this.jj_consume_token(13);
                                    break;
                                }
                                case 14: {
                                    operator = this.jj_consume_token(14);
                                    break;
                                }
                                default: {
                                    this.jj_la1[21] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            Expression right = this.AdditiveExpression();
                            left = PMMLUtil.createApply((String)ExpressionTranslator.translateRelationalOperator(operator), (Expression[])new Expression[]{left, right});
                            break block0;
                        }
                    }
                    this.jj_la1[22] = this.jj_gen;
                }
            }
        }
        return left;
    }

    private final Expression AdditiveExpression() throws ParseException {
        Expression left = this.MultiplicativeExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: {
                    operator = this.jj_consume_token(16);
                    break;
                }
                case 17: {
                    operator = this.jj_consume_token(17);
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.MultiplicativeExpression();
            if (operator.kind == 16 && TypeUtil.isString((Expression)left, (FeatureResolver)this) && TypeUtil.isString((Expression)right, (FeatureResolver)this)) {
                left = PMMLUtil.createApply((String)"concat", (Expression[])new Expression[]{left, right});
                continue;
            }
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateArithmeticOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    private final Expression MultiplicativeExpression() throws ParseException {
        Expression left = this.UnaryExpression();
        block8: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: {
                    operator = this.jj_consume_token(18);
                    break;
                }
                case 19: {
                    operator = this.jj_consume_token(19);
                    break;
                }
                case 20: {
                    operator = this.jj_consume_token(20);
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.UnaryExpression();
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateArithmeticOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    private final Expression UnaryExpression() throws ParseException {
        Expression expression;
        Token sign = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 17: {
                sign = this.Sign();
                expression = this.UnaryExpression();
                break;
            }
            case 4: 
            case 28: 
            case 29: 
            case 30: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: {
                expression = this.PrimaryExpression();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (sign != null && sign.kind == 17) {
            expression = PMMLUtil.toNegative((Expression)expression);
        }
        return expression;
    }

    private final Expression PrimaryExpression() throws ParseException {
        Expression expression;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                String dottedName = this.CanonicalizedDottedName();
                if (this.jj_2_5(Integer.MAX_VALUE)) {
                    expression = this.ArrayIndexingExpression(dottedName);
                    block39: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 22: 
                            case 25: {
                                break;
                            }
                            default: {
                                this.jj_la1[29] = this.jj_gen;
                                break block0;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 25: {
                                expression = this.TrailerFunctionInvocationExpression(expression);
                                continue block39;
                            }
                            case 22: {
                                expression = this.StringSlicingExpression(expression);
                                continue block39;
                            }
                        }
                        break;
                    }
                    this.jj_la1[30] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        expression = this.FunctionInvocationExpression(dottedName);
                        block40: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 22: 
                                case 25: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[31] = this.jj_gen;
                                    break block0;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 25: {
                                    expression = this.TrailerFunctionInvocationExpression(expression);
                                    continue block40;
                                }
                                case 22: {
                                    expression = this.StringSlicingExpression(expression);
                                    continue block40;
                                }
                            }
                            break;
                        }
                        this.jj_la1[32] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[36] = this.jj_gen;
                expression = this.NameInvocationExpression(dottedName);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        expression = this.StringSlicingExpression(expression);
                        block41: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 22: 
                                case 25: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[33] = this.jj_gen;
                                    break block0;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 25: {
                                    expression = this.TrailerFunctionInvocationExpression(expression);
                                    continue block41;
                                }
                                case 22: {
                                    expression = this.StringSlicingExpression(expression);
                                    continue block41;
                                }
                            }
                            break;
                        }
                        this.jj_la1[34] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[35] = this.jj_gen;
                break;
            }
            case 4: {
                expression = this.ParenthesizedExpression();
                block42: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 22: 
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 25: {
                            expression = this.TrailerFunctionInvocationExpression(expression);
                            continue block42;
                        }
                        case 22: {
                            expression = this.StringSlicingExpression(expression);
                            continue block42;
                        }
                    }
                    break;
                }
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 28: 
            case 29: 
            case 30: 
            case 40: 
            case 41: 
            case 43: 
            case 50: {
                expression = this.LiteralExpression();
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    private final FieldRef ArrayIndexingExpression(String dottedName) throws ParseException {
        Feature feature;
        Token sign = null;
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(22);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: 
                case 17: {
                    sign = this.Sign();
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                }
            }
            Token column = this.jj_consume_token(40);
            this.jj_consume_token(23);
            Scope scope = this.ensureScope();
            int colIndex = PythonParserUtil.parseInt(sign, column);
            feature = scope.getFeature(dottedName, colIndex);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: {
                    this.jj_consume_token(22);
                    Token column = this.String();
                    this.jj_consume_token(23);
                    Scope scope = this.ensureScope();
                    String colName = PythonParserUtil.parseString(column);
                    feature = scope.getFeature(dottedName, colName);
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return feature.ref();
    }

    private final Expression FunctionInvocationExpression(String dottedName) throws ParseException {
        List<Expression> arguments = this.Arguments();
        Scope scope = this.ensureScope();
        int dot = dottedName.lastIndexOf(46);
        if (dot > -1) {
            String featureName = dottedName.substring(0, dot);
            String functionName = dottedName.substring(dot + 1);
            Feature feature = scope.resolveFeature(featureName);
            if (feature != null) {
                return ExpressionTranslator.translateTrailerFunction((Expression)feature.ref(), functionName, arguments);
            }
        }
        return this.encodeFunction(dottedName, arguments);
    }

    private final Apply TrailerFunctionInvocationExpression(Expression expression) throws ParseException {
        this.jj_consume_token(25);
        Token name = this.jj_consume_token(42);
        List<Expression> arguments = this.Arguments();
        return ExpressionTranslator.translateTrailerFunction(expression, name.image, arguments);
    }

    private final List<Expression> Arguments() throws ParseException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            this.jj_consume_token(4);
            this.jj_consume_token(5);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    Expression expression = this.Expression();
                    expressions.add(expression);
                    block6: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 24: {
                                break;
                            }
                            default: {
                                this.jj_la1[42] = this.jj_gen;
                                break block6;
                            }
                        }
                        this.jj_consume_token(24);
                        expression = this.Expression();
                        expressions.add(expression);
                    }
                    this.jj_consume_token(5);
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expressions;
    }

    private final Expression StringSlicingExpression(Expression expression) throws ParseException {
        Token startSign = null;
        Token start = null;
        Token stopSign = null;
        Token stop = null;
        this.jj_consume_token(22);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 17: 
            case 40: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: 
                    case 17: {
                        startSign = this.Sign();
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                    }
                }
                start = this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 17: 
            case 40: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: 
                    case 17: {
                        stopSign = this.Sign();
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                    }
                }
                stop = this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        this.jj_consume_token(23);
        Integer startPos = null;
        if (start != null) {
            startPos = PythonParserUtil.parseInt(startSign, start);
        }
        Integer stopPos = null;
        if (stop != null) {
            stopPos = PythonParserUtil.parseInt(stopSign, stop);
        }
        return ExpressionTranslator.translateStringSlice(expression, startPos, stopPos);
    }

    private final Expression NameInvocationExpression(String dottedName) throws ParseException {
        int dot = dottedName.indexOf(46);
        if (dot > -1) {
            return this.encodeConstant(dottedName);
        }
        FieldRef fieldRef = this.variableMap.get(dottedName);
        if (fieldRef != null) {
            return fieldRef;
        }
        Scope scope = this.ensureScope();
        Feature feature = scope.getFeature(dottedName);
        return feature.ref();
    }

    private final Expression ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(4);
        Expression expression = this.Expression();
        this.jj_consume_token(5);
        return expression;
    }

    private final Constant LiteralExpression() throws ParseException {
        DataType dataType;
        Token value;
        Boolean missing = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29: {
                value = this.jj_consume_token(29);
                dataType = null;
                missing = Boolean.TRUE;
                break;
            }
            case 28: {
                value = this.jj_consume_token(28);
                dataType = DataType.BOOLEAN;
                break;
            }
            case 30: {
                value = this.jj_consume_token(30);
                dataType = DataType.BOOLEAN;
                break;
            }
            case 40: {
                value = this.jj_consume_token(40);
                dataType = DataType.INTEGER;
                break;
            }
            case 41: {
                value = this.jj_consume_token(41);
                dataType = DataType.DOUBLE;
                break;
            }
            case 43: 
            case 50: {
                value = this.String();
                dataType = DataType.STRING;
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Constant constant = new Constant().setValue(PythonParserUtil.parseValue(value)).setDataType(dataType).setMissing(missing);
        return constant;
    }

    private final Expression[] ListMakerExpression() throws ParseException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        this.jj_consume_token(22);
        Expression expression = this.Expression();
        expressions.add(expression);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(24);
            expression = this.Expression();
            expressions.add(expression);
        }
        this.jj_consume_token(23);
        return expressions.toArray(new Expression[expressions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    private boolean jj_3R_ArrayIndexingExpression_1107_17_22() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ArrayIndexingExpression_1108_29_25()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_null_1107_39_21() {
        return this.jj_3R_Sign_577_9_24();
    }

    private boolean jj_3R_String_561_9_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(43)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(50)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_Sign_577_9_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(16)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(17)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3_5() {
        return this.jj_3R_ArrayIndexingExpression_1106_9_20();
    }

    private boolean jj_3R_ArrayIndexingExpression_1106_9_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ArrayIndexingExpression_1107_17_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_ArrayIndexingExpression_1116_17_23()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_ArrayIndexingExpression_1108_29_25() {
        return this.jj_3R_Sign_577_9_24();
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_null_1107_39_21()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_ArrayIndexingExpression_1116_17_23() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_3R_String_561_9_26()) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 196608, 8, 8, 0x1000000, 16, 8, 1879245080, 1879245080, 1879245080, 1879245072, 0x8000000, 1879245072, 0, 0, 0x1000000, Integer.MIN_VALUE, 0, 64, 128, 256, 32256, 32256, 256, 196608, 196608, 0x1C0000, 0x1C0000, 1879244816, 0x2400000, 0x2400000, 0x2400000, 0x2400000, 0x2400000, 0x2400000, 0x400000, 16, 0x2400000, 0x2400000, 0x70000010, 196608, 0x400000, 0x1000000, 16, 196608, 196608, 196608, 196608, 0x70000000, 0x1000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{264192, 0, 0, 0, 0, 0, 0, 266128, 266136, 266136, 266136, 0, 266128, 2, 4, 0, 0, 8, 0, 0, 0, 0, 0, 96, 0, 0, 0, 0, 265984, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 265984, 0, 0, 0, 0, 0, 256, 0, 256, 264960, 0};
    }

    public ExpressionTranslator(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PythonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 50; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new PythonParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 50; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(PythonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 50; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PythonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 50; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[51];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 50; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 51; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : PythonParserTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ExpressionTranslator.jj_la1_init_0();
        ExpressionTranslator.jj_la1_init_1();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class Block
    extends ArrayList<Expression> {
        private Block(List<Expression> statements) {
            super(statements);
        }
    }
}

