#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

with open('requirements.txt', 'r') as req_file:
    requirements = req_file.read().splitlines()

test_requirements = ['pytest>=3', ]

setup(
    author="craftworks",
    author_email='dev-accounts@craftworks.at',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Python lib for navio",
    install_requires=requirements,
    license="MIT license",
    long_description_content_type='text/markdown',
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='pynavio',
    name='pynavio',
    packages=find_packages(include=['pynavio', 'pynavio.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/craftworksgmbh/craftworks-pynavio',
    version='0.2.4',
    zip_safe=False,

)
