#!/usr/bin/python
# encoding=utf-8

"""
@Author  :  Lijiawei
@Date    :  2022/11/26 3:55 下午
@Desc    :  tools line.
"""
import os
import stat


def make_file_executable(file_path):
    """
    If the path does not have executable permissions, execute chmod +x
    :param file_path:
    :return:
    """
    if os.path.isfile(file_path):
        mode = os.lstat(file_path)[stat.ST_MODE]
        executable = True if mode & stat.S_IXUSR else False
        if not executable:
            os.chmod(file_path, mode | stat.S_IXUSR | stat.S_IXGRP | stat.S_IXOTH)
        return True
    return False


def log2list(path):
    """

    :param path:
    :return:
    """
    res = []
    i = 0
    for line in open(path, "r", encoding='UTF-8'):
        res.append({f"line{i + 1}": line.replace('\n', '')})
    return res
