# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['conversant',
 'conversant.demo',
 'conversant.prompts',
 'conversant.search',
 'conversant.utils']

package_data = \
{'': ['*'],
 'conversant': ['personas/client-support/*',
                'personas/fantasy-wizard/*',
                'personas/fortune-teller/*',
                'personas/injured-person/*',
                'personas/math-teacher/*',
                'personas/personal-stylist/*',
                'personas/personal-trainer/*',
                'personas/watch-sales-agent/*']}

install_requires = \
['cohere>=2.8.0,<3.0.0',
 'emoji>=2.1.0,<3.0.0',
 'emojificate>=0.6.0,<0.7.0',
 'pydantic>=1.10.2,<2.0.0',
 'streamlit-ace>=0.1.1,<0.2.0',
 'streamlit-talk>=0.0.3,<0.0.4',
 'toml>=0.10.2,<0.11.0']

setup_kwargs = {
    'name': 'conversant',
    'version': '0.1.2',
    'description': 'Conversational AI tooling',
    'long_description': '```\n################################################################################\n#    ____      _                     ____                  _ _                 #\n#   / ___|___ | |__   ___ _ __ ___  / ___|  __ _ _ __   __| | |__   _____  __  #\n#  | |   / _ \\| \'_ \\ / _ \\ \'__/ _ \\ \\___ \\ / _` | \'_ \\ / _` | \'_ \\ / _ \\ \\/ /  #\n#  | |__| (_) | | | |  __/ | |  __/  ___) | (_| | | | | (_| | |_) | (_) >  <   #\n#   \\____\\___/|_| |_|\\___|_|  \\___| |____/ \\__,_|_| |_|\\__,_|_.__/ \\___/_/\\_\\  #\n#                                                                              #\n# This project is part of Cohere Sandbox, Cohere\'s Experimental Open Source    #\n# offering. This project provides a library, tooling, or demo making use of    #\n# the Cohere Platform. You should expect (self-)documented, high quality code  #\n# but be warned that this is EXPERIMENTAL. Therefore, also expect rough edges, #\n# non-backwards compatible changes, or potential changes in functionality as   #\n# the library, tool, or demo evolves. Please consider referencing a specific   #\n# git commit or version if depending upon the project in any mission-critical  #\n# code as part of your own projects.                                           #\n#                                                                              #\n# Please don\'t hesitate to raise issues or submit pull requests, and thanks    #\n# for checking out this project!                                               #\n#                                                                              #\n################################################################################\n```\n\n**Maintainer:** [Cohere ConvAI Team](mailto:convai@cohere.com) \\\n**Project maintained until at least (YYYY-MM-DD):** 2023-03-01\n\n# Conversant\n[![tests](https://github.com/cohere-ai/sandbox-conversant-lib/actions/workflows/run_tests.yaml/badge.svg)](https://github.com/cohere-ai/sandbox-conversant-lib/actions/workflows/run_tests.yaml/badge.svg)\n[![PyPI](https://img.shields.io/pypi/v/conversant.svg)](https://img.shields.io/pypi/v/conversant.svg)\n[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)\n\nBuild conversational AI on top of [Cohere](https://cohere.ai/)\'s [large language models](https://docs.cohere.ai/generate-reference/)\n- 🗣 Use large language models quickly with Cohere\'s [API](https://docs.cohere.ai/api-reference/)\n- 😃 Customize personas\n- 💁 Leave management of chat history up to `conversant`\n- \U0001faa8 Ground conversations in your provided facts (soon!)\n- 🐍 Install `conversant` with pip\n\n`conversant` is a work-in-progress framework for building customizable dialogue agents (aka chatbots) that can answer questions and converse with users with a variety of different chatbot personas. `conversant` aims\nto be modular, flexible and extensible so you can create any kind of chatbots you want!\n\nWe provide several custom personas for you, including 🧑\u200d💼 a client support agent, ⌚️ a watch sales agent, 🧑\u200d🏫 a math teacher, and 🧙 a fantasy wizard. Create your own persona with just a description and some example conversations!\n\nRead more about how `conversant` is part of the Cohere Sandbox on our [launch blog post](https://txt.cohere.ai/introducing-sandbox-coheres-experimental-open-source-initiative/).\n\nTry `conversant` on our Streamlit demo [here](https://conversant.streamlit.app/)! 🎉\n\n## Table of Contents\n1. [Installation and Usage](#installation-and-usage)\n   1. [Installation](#installation)\n   2. [Streamlit Demo](#streamlit-demo)\n   3. [Running Your Own Demo Locally](#running-your-own-demo-locally)\n   4. [Creating a Custom Persona](#creating-a-custom-persona)\n   5. [Editing a Persona on the Demo](#editing-a-persona-on-the-demo)\n   6. [Usage](#usage)\n2. [How Conversant Works](#how-conversant-works)\n3. [Documentation](#documentation)\n4. [Get Support](#get-support)\n5. [Contributing Guidelines](#contributing-guidelines)\n6. [License](#license)\n\n## Installation and Usage\n\n### Installation\n\n`conversant` is available [on PyPI](https://pypi.org/project/conversant/), and is tested on Python 3.8+ and [Cohere](https://pypi.org/project/cohere/) 2.8.0+.\n```\npip install conversant\n```\n### Streamlit Demo\n\nWant to see it in action first? You can use `conversant` on a [Streamlit](https://docs.streamlit.io/) app without installing anything [here](https://conversant.streamlit.app/)! 🎉\n\n<p float="none">\n  <img src="https://github.com/cohere-ai/sandbox-conversant-lib/raw/main/static/fortune-teller-setup.png" alt="Screenshot showing the available personas on the Streamlit demo, with the Fortune Teller persona selected by default.." height="550"/>\n  <img src="https://github.com/cohere-ai/sandbox-conversant-lib/raw/main/static/fortune-teller-chat.png" alt="Screenshot showing an exchange between a Fortune Teller chatbot and a user." height="550"/>\n</p>\n\n### Running Your Own Demo Locally\n\nCohere uses Streamlit to create its demo applications. If you’re new to Streamlit, you can install it [here](https://docs.streamlit.io/library/get-started/installation) and read more about running Streamlit commands [here](https://docs.streamlit.io/library/get-started/main-concepts).\n\nIf you\'d like to spin up your own instance of the Streamlit demo, you will first need a `COHERE_API_KEY`. \nYou can generate one by visiting [dashboard.cohere.ai](https://dashboard.cohere.ai/welcome/register?utm_source=github&utm_medium=content&utm_campaign=sandbox&utm_content=conversant). \nAdd the key to `.streamlit/secrets.toml`:\n```\nCOHERE_API_KEY = "YOUR_API_KEY_HERE"\n```\n\nAlternatively, set the key as an environment variable.\n```\nexport COHERE_API_KEY = "YOUR_API_KEY_HERE"\n```\n\n Start the Streamlit app from `conversant/demo/streamlit_example.py`:\n```\nstreamlit run conversant/demo/streamlit_example.py\n```\n\n### Creating a Custom Persona\nOnce you have your own instance of the Streamlit app, you can begin experimenting with creating custom personas! Check out the `config.json` for each persona in [`conversant/personas`](/conversant/personas/) directory. You\'ll need to create a subfolder within this directory that corresponds to your new persona and add a `config.json` file. The directory structure should look like this:\n\n```\nconversant/personas\n├── fortune-teller\n│   └── config.json\n└── your-persona-name # new\n    └── config.json\n```\n\nThe config file should contain the following:\n- `chatbot_config`: \n  -  `max_context_examples`: The length of the chat history for the chatbot to use in reply.\n  -  `avatar`: Optional emoji shortcode or URL to image as the chatbot\'s avatar. Defaults to 🤖.\n-  `client_config`: Parameters for [`co.generate()`](https://docs.cohere.ai/generate-reference)\n-  `chat_prompt_config`: \n   - `preamble`: Description of the persona.\n   - `example_separator`: A string that separates each example conversation.\n   - `headers`: A name for the `bot` and the `user`.\n   - `examples`: A few conversation examples (few-shot), or empty (zero-shot).\n\n`conversant` will take care of the rest! As an example, check out [`fortune-teller/config.json`](/conversant/personas/fortune-teller/config.json). When you launch the Streamlit app, the new persona will appear in the drop down menu.\n\n### Editing a Persona on the Demo\nYou can also edit a persona on the Streamlit app!\n<img src="https://github.com/cohere-ai/sandbox-conversant-lib/raw/main/static/fortune-teller-edit.png" alt="Screenshot showing the interface for editing a persona on the Streamlit app."/>\n\n### Usage\n\nWith `conversant`, you can create a chatbot powered by [Cohere](https://cohere.ai/)\'s large language models with just the following code snippet.\n```python\nimport cohere\n\nco = cohere.Client("YOUR_API_KEY_HERE")\nbot = conversant.PromptChatbot.from_persona("fantasy-wizard", client=co)\nprint(bot.reply("Hello!"))\n>>> "Well met, fair traveller. What bringest thou to mine village?"\n```\n\nYou can also define your own persona by passing in your own `ChatPrompt`. \n```python\nfrom conversant.prompts import ChatPrompt\n\nshakespeare_config = {\n    "preamble": "Below is a conversation between Shakespeare and a Literature Student.",\n    "example_separator": "<CONVERSATION>\\n",\n    "headers": {\n        "user": "Literature Student",\n        "bot": "William Shakespeare",\n    },\n    "examples": [\n        [\n            {\n                "user": "Who are you?",\n                "bot": "Mine own nameth is Shakespeare, and I speaketh in riddles.",\n            },\n        ]\n    ],\n}\nshakespeare_bot = PromptChatbot(\n    client=co, prompt=ChatPrompt.from_dict(shakespeare_config)\n)\nprint(shakespeare_bot.reply("Hello!"))\n>>> "Greeteth, and welcome. I am Shakespeare, the great poet, dramatist, and playwright."\n```\n\n<!-- From here, it\'s also possible to talk to your chatbot using the [Streamlit](https://docs.streamlit.io/) app! This will launch the demo with your chatbot persona pre-selected. For this to work, `COHERE_API_KEY` needs to be set as an environment variable.\n```python\nfrom conversant.utils import demo_utils\ndemo_utils.launch_streamlit(shakespeare_bot)\n``` -->\n## How Conversant Works\n`conversant` uses prompt completion to define a chatbot persona with a description and a few examples. The prompt is sent as input to Cohere\'s [`co.generate()`](https://docs.cohere.ai/generate-reference/) endpoint for an autoregressive language model to generate text in a few-shot manner from the examples and the current dialogue context. \n\nEach user message and chatbot response is appended to a chat history so that future responses are conditioned on the dialogue context at that point in time.\n\nIn the future, we plan to add functionality for a chatbot to be factually grounded using text that is retrieved from a local document cache.\n\nFor more information, refer to [this section in `CONTRIBUTORS.md`](CONTRIBUTORS.md#conversant-schematic).\n\n## Documentation\nFull documentation can be found [here](https://cohere-ai.github.io/sandbox-conversant-lib/).\n\n## Get Support\n\nIf you have any questions or comments, please file an issue or reach out to us on [Discord](discord.gg/co-mmunity).\n\n## Contributing Guidelines\nIf you would like to contribute to this project, please read [`CONTRIBUTORS.md`](CONTRIBUTORS.md)\nin this repository, and sign the Contributor License Agreement before submitting\nany pull requests. A link to sign the Cohere CLA will be generated the first time \nyou make a pull request to a Cohere repository.\n\nIn addition to guidelines around submitting code to this repository, [`CONTRIBUTORS.md`](CONTRIBUTORS.md) contains a walkthrough to help developers get started, as well as schematics that explain how `conversant` works under the hood. :wrench:\n\n## License\n`conversant` has an [MIT License](LICENSE).\n',
    'author': 'Cohere ConvAI',
    'author_email': 'convai@cohere.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/cohere-ai/sandbox-conversant-lib',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
