# generated by datamodel-codegen:
#   filename:  https://schemas.getdbt.com/dbt/manifest/v6.json
#   timestamp: 2022-10-20T14:30:21+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Extra, Field, constr


class ManifestMetadata(BaseModel):
    class Config:
        extra = Extra.forbid

    dbt_schema_version: Optional[
        str
    ] = 'https://schemas.getdbt.com/dbt/manifest/v6.json'
    dbt_version: Optional[str] = '1.2.0'
    generated_at: Optional[datetime] = '2022-07-26T13:02:44.173047Z'
    invocation_id: Optional[Optional[str]] = 'b98791cb-6931-421b-aeb5-945dc062e419'
    env: Optional[Dict[str, str]] = {}
    project_id: Optional[Optional[str]] = Field(
        None, description='A unique identifier for the project'
    )
    user_id: Optional[
        Optional[
            constr(
                regex=r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}'
            )
        ]
    ] = Field(None, description='A unique identifier for the user')
    send_anonymous_usage_stats: Optional[Optional[bool]] = Field(
        None, description='Whether dbt is configured to send anonymous usage statistics'
    )
    adapter_type: Optional[Optional[str]] = Field(
        None, description='The type name of the adapter'
    )


class ResourceType(Enum):
    analysis = 'analysis'


class FileHash(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    checksum: str


class Hook(BaseModel):
    class Config:
        extra = Extra.forbid

    sql: str
    transaction: Optional[bool] = True
    index: Optional[Optional[int]] = None


class DependsOn(BaseModel):
    class Config:
        extra = Extra.forbid

    macros: Optional[List[str]] = []
    nodes: Optional[List[str]] = []


class ColumnInfo(BaseModel):
    class Config:
        extra = Extra.allow

    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    data_type: Optional[Optional[str]] = None
    quote: Optional[Optional[bool]] = None
    tags: Optional[List[str]] = []


class Docs(BaseModel):
    class Config:
        extra = Extra.forbid

    show: Optional[bool] = True


class InjectedCTE(BaseModel):
    class Config:
        extra = Extra.forbid

    id: str
    sql: str


class ResourceType1(Enum):
    test = 'test'


class TestConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True
    alias: Optional[Optional[str]] = None
    schema_: Optional[Optional[str]] = Field('dbt_test__audit', alias='schema')
    database: Optional[Optional[str]] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'test'
    severity: Optional[
        constr(regex=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')
    ] = 'ERROR'
    store_failures: Optional[Optional[bool]] = None
    where: Optional[Optional[str]] = None
    limit: Optional[Optional[int]] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class ResourceType2(Enum):
    model = 'model'


class ResourceType3(Enum):
    operation = 'operation'


class ResourceType4(Enum):
    rpc = 'rpc'


class ResourceType5(Enum):
    sql_operation = 'sql operation'


class ResourceType6(Enum):
    test = 'test'


class TestMetadata(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    kwargs: Optional[Dict[str, Any]] = {}
    namespace: Optional[Optional[str]] = None


class ResourceType7(Enum):
    seed = 'seed'


class SeedConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True
    alias: Optional[Optional[str]] = None
    schema_: Optional[Optional[str]] = Field(None, alias='schema')
    database: Optional[Optional[str]] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'seed'
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[Optional[bool]] = None
    unique_key: Optional[Optional[Union[str, List[str]]]] = None
    on_schema_change: Optional[Optional[str]] = 'ignore'
    grants: Optional[Dict[str, Any]] = {}
    quote_columns: Optional[Optional[bool]] = None


class ResourceType8(Enum):
    snapshot = 'snapshot'


class ResourceType9(Enum):
    analysis = 'analysis'


class ResourceType10(Enum):
    test = 'test'


class ParsedSingularTestNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType10
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = {
        'enabled': True,
        'alias': None,
        'schema': 'dbt_test__audit',
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'test',
        'severity': 'ERROR',
        'store_failures': None,
        'where': None,
        'limit': None,
        'fail_calc': 'count(*)',
        'warn_if': '!= 0',
        'error_if': '!= 0',
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.187786
    config_call_dict: Optional[Dict[str, Any]] = {}


class ResourceType11(Enum):
    operation = 'operation'


class ResourceType12(Enum):
    model = 'model'


class ResourceType13(Enum):
    rpc = 'rpc'


class ResourceType14(Enum):
    sql_operation = 'sql operation'


class ResourceType15(Enum):
    test = 'test'


class ParsedGenericTestNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    test_metadata: TestMetadata
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType15
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = {
        'enabled': True,
        'alias': None,
        'schema': 'dbt_test__audit',
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'test',
        'severity': 'ERROR',
        'store_failures': None,
        'where': None,
        'limit': None,
        'fail_calc': 'count(*)',
        'warn_if': '!= 0',
        'error_if': '!= 0',
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.1920261
    config_call_dict: Optional[Dict[str, Any]] = {}
    column_name: Optional[Optional[str]] = None
    file_key_name: Optional[Optional[str]] = None


class ResourceType16(Enum):
    seed = 'seed'


class ParsedSeedNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType16
    alias: str
    checksum: FileHash
    config: Optional[SeedConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'seed',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'quote_columns': None,
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.192925
    config_call_dict: Optional[Dict[str, Any]] = {}


class ResourceType17(Enum):
    snapshot = 'snapshot'


class SnapshotConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True
    alias: Optional[Optional[str]] = None
    schema_: Optional[Optional[str]] = Field(None, alias='schema')
    database: Optional[Optional[str]] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'snapshot'
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[Optional[bool]] = None
    unique_key: Optional[Optional[str]] = None
    on_schema_change: Optional[Optional[str]] = 'ignore'
    grants: Optional[Dict[str, Any]] = {}
    strategy: Optional[Optional[str]] = None
    target_schema: Optional[Optional[str]] = None
    target_database: Optional[Optional[str]] = None
    updated_at: Optional[Optional[str]] = None
    check_cols: Optional[Optional[Union[str, List[str]]]] = None


class ResourceType18(Enum):
    source = 'source'


class Quoting(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[bool]] = None
    schema_: Optional[Optional[bool]] = Field(None, alias='schema')
    identifier: Optional[Optional[bool]] = None
    column: Optional[Optional[bool]] = None


class FreshnessMetadata(BaseModel):
    class Config:
        extra = Extra.forbid

    dbt_schema_version: Optional[str] = 'https://schemas.getdbt.com/dbt/sources/v3.json'
    dbt_version: Optional[str] = '1.2.0'
    generated_at: Optional[datetime] = '2022-07-26T13:02:44.168999Z'
    invocation_id: Optional[Optional[str]] = 'b98791cb-6931-421b-aeb5-945dc062e419'
    env: Optional[Dict[str, str]] = {}


class Status(Enum):
    runtime_error = 'runtime error'


class SourceFreshnessRuntimeError(BaseModel):
    class Config:
        extra = Extra.forbid

    unique_id: str
    error: Optional[Optional[Union[str, int]]] = None
    status: Status


class Status1(Enum):
    pass_ = 'pass'
    warn = 'warn'
    error = 'error'
    runtime_error = 'runtime error'


class PeriodEnum(Enum):
    minute = 'minute'
    hour = 'hour'
    day = 'day'


class Time(BaseModel):
    class Config:
        extra = Extra.forbid

    count: Optional[Optional[int]] = None
    period: Optional[Optional[PeriodEnum]] = None


class TimingInfo(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    started_at: Optional[Optional[datetime]] = None
    completed_at: Optional[Optional[datetime]] = None


class ExternalPartition(BaseModel):
    class Config:
        extra = Extra.allow

    name: Optional[str] = ''
    description: Optional[str] = ''
    data_type: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}


class SourceConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True


class ResourceType19(Enum):
    macro = 'macro'


class MacroDependsOn(BaseModel):
    class Config:
        extra = Extra.forbid

    macros: Optional[List[str]] = []


class MacroArgument(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    type: Optional[Optional[str]] = None
    description: Optional[str] = ''


class ParsedDocumentation(BaseModel):
    class Config:
        extra = Extra.forbid

    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    block_contents: str


class Type(Enum):
    dashboard = 'dashboard'
    notebook = 'notebook'
    analysis = 'analysis'
    ml = 'ml'
    application = 'application'


class ResourceType20(Enum):
    model = 'model'
    analysis = 'analysis'
    test = 'test'
    snapshot = 'snapshot'
    operation = 'operation'
    seed = 'seed'
    rpc = 'rpc'
    sql_operation = 'sql operation'
    docs_block = 'docs block'
    source = 'source'
    macro = 'macro'
    exposure = 'exposure'
    metric = 'metric'


class MaturityEnum(Enum):
    low = 'low'
    medium = 'medium'
    high = 'high'


class ExposureOwner(BaseModel):
    class Config:
        extra = Extra.forbid

    email: str
    name: Optional[Optional[str]] = None


class ResourceType21(Enum):
    model = 'model'
    analysis = 'analysis'
    test = 'test'
    snapshot = 'snapshot'
    operation = 'operation'
    seed = 'seed'
    rpc = 'rpc'
    sql_operation = 'sql operation'
    docs_block = 'docs block'
    source = 'source'
    macro = 'macro'
    exposure = 'exposure'
    metric = 'metric'


class MetricFilter(BaseModel):
    class Config:
        extra = Extra.forbid

    field: str
    operator: str
    value: str


class NodeConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True
    alias: Optional[Optional[str]] = None
    schema_: Optional[Optional[str]] = Field(None, alias='schema')
    database: Optional[Optional[str]] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'view'
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[Optional[bool]] = None
    unique_key: Optional[Optional[Union[str, List[str]]]] = None
    on_schema_change: Optional[Optional[str]] = 'ignore'
    grants: Optional[Dict[str, Any]] = {}


class CompiledSingularTestNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType1
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = {
        'enabled': True,
        'alias': None,
        'schema': 'dbt_test__audit',
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'test',
        'severity': 'ERROR',
        'store_failures': None,
        'where': None,
        'limit': None,
        'fail_calc': 'count(*)',
        'warn_if': '!= 0',
        'error_if': '!= 0',
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.177789
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledModelNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType2
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.1790001
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledHookNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType3
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.180038
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None
    index: Optional[Optional[int]] = None


class CompiledRPCNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType4
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.1810539
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledSqlNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType5
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.182029
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledGenericTestNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    test_metadata: TestMetadata
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType6
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = {
        'enabled': True,
        'alias': None,
        'schema': 'dbt_test__audit',
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'test',
        'severity': 'ERROR',
        'store_failures': None,
        'where': None,
        'limit': None,
        'fail_calc': 'count(*)',
        'warn_if': '!= 0',
        'error_if': '!= 0',
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.183202
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None
    column_name: Optional[Optional[str]] = None
    file_key_name: Optional[Optional[str]] = None


class CompiledSeedNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType7
    alias: str
    checksum: FileHash
    config: Optional[SeedConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'seed',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'quote_columns': None,
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.1849642
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledSnapshotNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType8
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.18593
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class ParsedAnalysisNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType9
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.1869571
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedHookNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType11
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.188651
    config_call_dict: Optional[Dict[str, Any]] = {}
    index: Optional[Optional[int]] = None


class ParsedModelNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType12
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.1895108
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedRPCNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType13
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.190333
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedSqlNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType14
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.191165
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedSnapshotNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType17
    alias: str
    checksum: FileHash
    config: SnapshotConfig
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.194531
    config_call_dict: Optional[Dict[str, Any]] = {}


class FreshnessThreshold(BaseModel):
    class Config:
        extra = Extra.forbid

    warn_after: Optional[Optional[Time]] = {'count': None, 'period': None}
    error_after: Optional[Optional[Time]] = {'count': None, 'period': None}
    filter: Optional[Optional[str]] = None


class SourceFreshnessOutput(BaseModel):
    class Config:
        extra = Extra.forbid

    unique_id: str
    max_loaded_at: datetime
    snapshotted_at: datetime
    max_loaded_at_time_ago_in_s: float
    status: Status1
    criteria: FreshnessThreshold
    adapter_response: Dict[str, Any]
    timing: List[TimingInfo]
    thread_id: str
    execution_time: float


class ExternalTable(BaseModel):
    class Config:
        extra = Extra.allow

    location: Optional[Optional[str]] = None
    file_format: Optional[Optional[str]] = None
    row_format: Optional[Optional[str]] = None
    tbl_properties: Optional[Optional[str]] = None
    partitions: Optional[Optional[List[ExternalPartition]]] = None


class ParsedMacro(BaseModel):
    class Config:
        extra = Extra.forbid

    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    macro_sql: str
    resource_type: ResourceType19
    tags: Optional[List[str]] = []
    depends_on: Optional[MacroDependsOn] = {'macros': []}
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    arguments: Optional[List[MacroArgument]] = []
    created_at: Optional[float] = 1658840564.1967978


class ParsedExposure(BaseModel):
    class Config:
        extra = Extra.forbid

    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    type: Type
    owner: ExposureOwner
    resource_type: Optional[ResourceType20] = 'exposure'
    description: Optional[str] = ''
    maturity: Optional[Optional[MaturityEnum]] = None
    meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    url: Optional[Optional[str]] = None
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    created_at: Optional[float] = 1658840564.197692


class ParsedMetric(BaseModel):
    class Config:
        extra = Extra.forbid

    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    description: str
    label: str
    type: str
    sql: str
    timestamp: Optional[Optional[str]] = None
    filters: List[MetricFilter]
    time_grains: List[str]
    dimensions: List[str]
    model: Optional[Optional[str]] = None
    model_unique_id: Optional[Optional[str]] = None
    resource_type: Optional[ResourceType21] = 'metric'
    meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    sources: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    refs: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    created_at: Optional[float] = 1658840564.1985369


class CompiledAnalysisNode(BaseModel):
    class Config:
        extra = Extra.forbid

    raw_sql: str
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1658840564.1760619
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class ParsedSourceDefinition(BaseModel):
    class Config:
        extra = Extra.forbid

    fqn: List[str]
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    source_name: str
    source_description: str
    loader: str
    identifier: str
    resource_type: ResourceType18
    quoting: Optional[Quoting] = {
        'database': None,
        'schema': None,
        'identifier': None,
        'column': None,
    }
    loaded_at_field: Optional[Optional[str]] = None
    freshness: Optional[Optional[FreshnessThreshold]] = None
    external: Optional[Optional[ExternalTable]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    source_meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[SourceConfig] = {'enabled': True}
    patch_path: Optional[Optional[str]] = None
    unrendered_config: Optional[Dict[str, Any]] = {}
    relation_name: Optional[Optional[str]] = None
    created_at: Optional[float] = 1658840564.196107


class Model(BaseModel):
    class Config:
        extra = Extra.forbid

    metadata: ManifestMetadata = Field(..., description='Metadata about the manifest')
    nodes: Dict[
        str,
        Union[
            CompiledAnalysisNode,
            CompiledSingularTestNode,
            CompiledModelNode,
            CompiledHookNode,
            CompiledRPCNode,
            CompiledSqlNode,
            CompiledGenericTestNode,
            CompiledSeedNode,
            CompiledSnapshotNode,
            ParsedAnalysisNode,
            ParsedSingularTestNode,
            ParsedHookNode,
            ParsedModelNode,
            ParsedRPCNode,
            ParsedSqlNode,
            ParsedGenericTestNode,
            ParsedSeedNode,
            ParsedSnapshotNode,
        ],
    ] = Field(
        ..., description='The nodes defined in the dbt project and its dependencies'
    )
    sources: Dict[str, ParsedSourceDefinition] = Field(
        ..., description='The sources defined in the dbt project and its dependencies'
    )
    macros: Dict[str, ParsedMacro] = Field(
        ..., description='The macros defined in the dbt project and its dependencies'
    )
    docs: Dict[str, ParsedDocumentation] = Field(
        ..., description='The docs defined in the dbt project and its dependencies'
    )
    exposures: Dict[str, ParsedExposure] = Field(
        ..., description='The exposures defined in the dbt project and its dependencies'
    )
    metrics: Dict[str, ParsedMetric] = Field(
        ..., description='The metrics defined in the dbt project and its dependencies'
    )
    selectors: Dict[str, Any] = Field(
        ..., description='The selectors defined in selectors.yml'
    )
    disabled: Optional[
        Optional[
            Dict[
                str,
                List[
                    Union[
                        CompiledAnalysisNode,
                        CompiledSingularTestNode,
                        CompiledModelNode,
                        CompiledHookNode,
                        CompiledRPCNode,
                        CompiledSqlNode,
                        CompiledGenericTestNode,
                        CompiledSeedNode,
                        CompiledSnapshotNode,
                        ParsedAnalysisNode,
                        ParsedSingularTestNode,
                        ParsedHookNode,
                        ParsedModelNode,
                        ParsedRPCNode,
                        ParsedSqlNode,
                        ParsedGenericTestNode,
                        ParsedSeedNode,
                        ParsedSnapshotNode,
                        ParsedSourceDefinition,
                    ]
                ],
            ]
        ]
    ] = Field(None, description='A mapping of the disabled nodes in the target')
    parent_map: Optional[Optional[Dict[str, List[str]]]] = Field(
        None, description='A mapping from\xa0child nodes to their dependencies'
    )
    child_map: Optional[Optional[Dict[str, List[str]]]] = Field(
        None, description='A mapping from parent nodes to their dependents'
    )
