#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['recon', 'recon.cli', 'recon.prodigy']

package_data = \
{'': ['*'], 'recon.prodigy': ['templates/*']}

install_requires = \
['pydantic == 1.5',
 'spacy >= 2.3.0, <3.0.0',
 'scipy',
 'snorkel == 0.9.6',
 'typer >= 0.0.8',
 'tqdm']

extras_require = \
{'all': ['colorama', 'click-completion'],
 'dev': ['jupyterlab >= 1.2.0, <1.3',
         'ipywidgets',
         'autoflake >=1.3.1,<2.0.0',
         'flake8 >=3.8.3,<4.0.0'],
 'doc': ['mkdocs >=1.1.2,<2.0.0',
         'mkdocs-material >=5.4.0,<6.0.0',
         'markdown-include >=0.5.1,<0.6.0',
         'mkdocstrings'],
 'test': ['pytest == 5.3.0',
          'pytest-cov',
          'coverage',
          'pytest-xdist',
          'pytest-sugar',
          'mypy',
          'black',
          'isort']}

entry_points = \
{'console_scripts': ['recon = recon.cli:app'],
 'prodigy_recipes': ['recon.ner_correct = recon:prodigy_recipes.ner_correct',
                     'recon.ner_merge = recon:prodigy_recipes.ner_merge']}

setup(name='reconner',
      version='0.6.1',
      description='ReconNER, Debug annotated Named Entity Recognition (NER) data for inconsitencies and get insights on improving the quality of your data.',
      author='Kabir Khan',
      author_email='kabirkhan1137@outlook.com',
      url='https://github.com/kabirkhan/recon',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.6',
     )
