from redis import Redis
from scrapy import Request as Request
from scrapy.crawler import Crawler as Crawler
from scrapy.spiders import CrawlSpider, Spider
from typing import Any, Generator, NoReturn, Optional, Union

class RedisMixin:
    redis_key: str = ...
    redis_batch_size: int = ...
    redis_encoding: str = ...
    server: Redis = ...
    def start_requests(self) -> Generator[Request, None, None]: ...
    fetch_data: Any = ...
    def setup_redis(self, crawler: Optional[Crawler]=...) -> Any: ...
    def pop_list_queue(self, redis_key: str, batch_size: int) -> list: ...
    def pop_priority_queue(self, redis_key: str, batch_size: int) -> list: ...
    def next_requests(self) -> Generator[Request, None, None]: ...
    def make_request_from_data(self, data: Union[str, bytes]) -> Request: ...
    def schedule_next_requests(self) -> None: ...
    def spider_idle(self) -> NoReturn: ...

class RedisSpider(RedisMixin, Spider):
    @classmethod
    def from_crawler(cls: Any, crawler: Any, *args: Any, **kwargs: Any) -> RedisSpider: ...

class RedisCrawlSpider(RedisMixin, CrawlSpider):
    @classmethod
    def from_crawler(cls: Any, crawler: Crawler, *args: Any, **kwargs: Any) -> RedisCrawlSpider: ...
