from redis import Redis
from scrapy import Request as Request, Spider as Spider
from typing import Any, AnyStr, Callable, Optional

class Base:
    server: Any = ...
    spider: Any = ...
    key: Any = ...
    serializer: Any = ...
    def __init__(self, server: Redis, spider: Spider, key: AnyStr, serializer: Optional[Callable[[dict], str]]=...) -> None: ...
    def __len__(self) -> int: ...
    def push(self, request: Request) -> None: ...
    def pop(self, timeout: Optional[int]=...) -> None: ...
    def clear(self) -> None: ...

class FifoQueue(Base):
    def __len__(self) -> int: ...
    def push(self, request: Request) -> int: ...
    def pop(self, timeout: Optional[int]=...) -> Request: ...

class PriorityQueue(Base):
    def __len__(self) -> None: ...
    def push(self, request: Request) -> None: ...
    def pop(self, timeout: Optional[int]=...) -> Request: ...

class LifoQueue(Base):
    def __len__(self) -> int: ...
    def push(self, request: Request) -> None: ...
    def pop(self, timeout: Optional[int]=...) -> Any: ...
SpiderQueue = FifoQueue
SpiderStack = LifoQueue
SpiderPriorityQueue = PriorityQueue
