/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.pal.statistics;

public class FisherExact {
    private static final boolean DEBUG = false;
    private double[] f;
    int maxSize;

    public FisherExact(int n) {
        this.maxSize = n;
        double d = 1.0;
        this.f = new double[n + 1];
        this.f[0] = 0.0;
        for (int i = 1; i <= this.maxSize; ++i) {
            this.f[i] = this.f[i - 1] + Math.log(i);
        }
    }

    public FisherExact(int n, boolean bl) {
        int n2;
        this.maxSize = n;
        double d = 1.0;
        this.f = new double[n + 1];
        this.f[0] = 0.0;
        for (n2 = 1; n2 <= this.maxSize; ++n2) {
            this.f[n2] = this.f[n2 - 1] + Math.log(n2);
        }
        n2 = 0;
        double d2 = 0.05;
        for (int i = 1; i < n; ++i) {
            for (int j = 1; j < n; ++j) {
                for (int k = 1; k < n; ++k) {
                    for (int i2 = 1; i2 < n; ++i2) {
                        if (!(this.getTwoTailedP(i, j, k, i2) < d2)) continue;
                        ++n2;
                    }
                }
            }
        }
        System.out.printf("MaxSize %d minP: %g  Count: %d %n", n, d2, n2);
    }

    public final double getP(int n, int n2, int n3, int n4) {
        int n5 = n + n2 + n3 + n4;
        if (n5 > this.maxSize) {
            return Double.NaN;
        }
        double d = this.f[n + n2] + this.f[n3 + n4] + this.f[n + n3] + this.f[n2 + n4] - (this.f[n] + this.f[n2] + this.f[n3] + this.f[n4] + this.f[n5]);
        return Math.exp(d);
    }

    public final double getCumlativeP(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n + n2 + n3 + n4;
        if (n7 > this.maxSize) {
            return Double.NaN;
        }
        double d = 0.0;
        d += this.getP(n, n2, n3, n4);
        if (n * n4 >= n2 * n3) {
            n6 = n3 < n2 ? n3 : n2;
            for (n5 = 0; n5 < n6; ++n5) {
                d += this.getP(++n, --n2, --n3, ++n4);
            }
        }
        if (n * n4 < n2 * n3) {
            n6 = n < n4 ? n : n4;
            for (n5 = 0; n5 < n6; ++n5) {
                double d2 = this.getP(--n, ++n2, ++n3, --n4);
                d += d2;
            }
        }
        return d;
    }

    public final double getRightTailedP(int n, int n2, int n3, int n4) {
        int n5 = n + n2 + n3 + n4;
        if (n5 > this.maxSize) {
            return Double.NaN;
        }
        double d = 0.0;
        d += this.getP(n, n2, n3, n4);
        int n6 = n3 < n2 ? n3 : n2;
        for (int i = 0; i < n6; ++i) {
            d += this.getP(++n, --n2, --n3, ++n4);
        }
        return d;
    }

    public final double getRightTailedPQuick(int n, int n2, int n3, int n4, double d) {
        double d2 = 0.0;
        d2 += this.getP(n, n2, n3, n4);
        int n5 = n3 < n2 ? n3 : n2;
        for (int i = 0; i < n5 && d2 < d; d2 += this.getP(++n, --n2, --n3, ++n4), ++i) {
        }
        return d2;
    }

    public final double getLeftTailedP(int n, int n2, int n3, int n4) {
        int n5 = n + n2 + n3 + n4;
        if (n5 > this.maxSize) {
            return Double.NaN;
        }
        double d = 0.0;
        d += this.getP(n, n2, n3, n4);
        int n6 = n < n4 ? n : n4;
        for (int i = 0; i < n6; ++i) {
            double d2 = this.getP(--n, ++n2, ++n3, --n4);
            d += d2;
        }
        return d;
    }

    public final double getTwoTailedP(int n, int n2, int n3, int n4) {
        double d;
        int n5;
        int n6 = n + n2 + n3 + n4;
        if (n6 > this.maxSize) {
            return Double.NaN;
        }
        double d2 = 0.0;
        double d3 = this.getP(n, n2, n3, n4);
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        d2 += d3;
        int n11 = n3 < n2 ? n3 : n2;
        for (n5 = 0; n5 < n11; ++n5) {
            if (!((d = this.getP(++n, --n2, --n3, ++n4)) <= d3)) continue;
            d2 += d;
        }
        n = n7;
        n2 = n8;
        n3 = n9;
        n4 = n10;
        n11 = n < n4 ? n : n4;
        for (n5 = 0; n5 < n11; ++n5) {
            if (!((d = this.getP(--n, ++n2, ++n3, --n4)) <= d3)) continue;
            d2 += d;
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        int[][] nArray = new int[15][4];
        nArray[0] = new int[]{2, 3, 6, 4};
        nArray[1] = new int[]{2, 1, 3, 0};
        nArray[2] = new int[]{3, 0, 2, 1};
        nArray[3] = new int[]{1, 2, 0, 3};
        nArray[4] = new int[]{3, 1, 1, 3};
        nArray[5] = new int[]{1, 3, 3, 1};
        nArray[6] = new int[]{0, 1, 1, 0};
        nArray[7] = new int[]{1, 0, 0, 1};
        nArray[8] = new int[]{11, 0, 0, 6};
        nArray[9] = new int[]{10, 1, 1, 5};
        nArray[10] = new int[]{5, 6, 6, 0};
        nArray[11] = new int[]{9, 2, 2, 4};
        nArray[12] = new int[]{6, 5, 5, 1};
        nArray[13] = new int[]{8, 3, 3, 3};
        nArray[14] = new int[]{7, 4, 4, 2};
        FisherExact fisherExact = new FisherExact(100);
        for (int i = 0; i < nArray.length; ++i) {
            System.out.println("\na=" + nArray[i][0] + " b=" + nArray[i][1] + " c=" + nArray[i][2] + " d=" + nArray[i][3]);
            System.out.print("*****Original algorithm: ");
            double d = fisherExact.getCumlativeP(nArray[i][0], nArray[i][1], nArray[i][2], nArray[i][3]);
            System.out.println("\tcumulativeP = " + d);
            System.out.print("*****Left Tailed: ");
            double d2 = fisherExact.getLeftTailedP(nArray[i][0], nArray[i][1], nArray[i][2], nArray[i][3]);
            System.out.println("\tleftTailedP = " + d2);
            System.out.print("*****Right Tailed: ");
            double d3 = fisherExact.getRightTailedP(nArray[i][0], nArray[i][1], nArray[i][2], nArray[i][3]);
            System.out.println("\trightTailedP = " + d3);
            System.out.print("*****Two Tailed: ");
            double d4 = fisherExact.getTwoTailedP(nArray[i][0], nArray[i][1], nArray[i][2], nArray[i][3]);
            System.out.println("\ttwoTailedP = " + d4);
        }
    }
}

