/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.LinkListVector;
import Trace.PhdData;
import Trace.PhdFile;
import Trace.PolyPeak;
import Trace.TraceFile;
import java.util.Observable;
import java.util.Observer;

public class PolyData
extends Observable
implements Observer {
    public PolyPeak[] alternate_peaks;
    public boolean loaded = false;
    public TraceFile trace = null;
    public PhdFile phd = null;
    private Observer observer = null;

    public PolyData(TraceFile t, PhdFile p) {
        this.trace = t;
        this.phd = p;
        this.build_polydata();
    }

    public PolyData(String name) {
        this.phd = new PhdFile(name, this);
        this.trace = new TraceFile(name, this);
    }

    public PolyData(String name, Observer o) {
        this.observer = o;
        this.addObserver(o);
        this.phd = new PhdFile(name, this);
        this.trace = new TraceFile(name, this);
    }

    public void update(Observable o, Object arg) {
        if (this.trace != null && this.phd != null && this.trace.loaded() && this.phd.loaded) {
            this.build_polydata();
        }
    }

    void build_polydata() {
        this.alternate_peaks = new PolyPeak[this.phd.data.size()];
        LinkListVector[] peaks = this.find_peaks();
        this.call_alternates(peaks);
        this.loaded = true;
        if (this.observer != null) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    LinkListVector[] find_peaks() {
        int this_sample = 0;
        int last_sample = 0;
        LinkListVector[] peaks = new LinkListVector[4];
        int minimum_amp = (int)((double)this.trace.max_amplitude * 0.05);
        for (short i = 0; i < 4; i = (short)(i + 1)) {
            PolyPeak p = new PolyPeak(i);
            LinkListVector v = peaks[i] = new LinkListVector();
            for (int j = 0; j < this.trace.num_samples; ++j) {
                this_sample = this.trace.trace_data[i][j];
                if (this_sample > last_sample) {
                    if (p.peak > 0) {
                        p.end = j - 1;
                        if (p.amplitude > minimum_amp) {
                            v.addElement(p);
                        }
                        p = new PolyPeak(i);
                    } else if (p.clip_start > 0) {
                        p.peak = p.clip_start + (p.clip_end - p.clip_start) / 2;
                        p.amplitude = last_sample;
                        p.end = j - 1;
                        if (p.amplitude > minimum_amp) {
                            v.addElement(p);
                        }
                        p = new PolyPeak(i);
                    }
                    if (p.start == -1) {
                        p.start = j;
                    }
                } else if (this_sample == last_sample) {
                    if (p.clip_start == 0) {
                        p.clip_start = j - 1;
                    }
                    p.clip_end = j;
                } else if (this_sample < last_sample && p.peak == 0) {
                    p.peak = p.clip_start == 0 ? j - 1 : p.clip_start + (p.clip_end - p.clip_start) / 2;
                    p.amplitude = last_sample;
                }
                last_sample = this_sample;
            }
        }
        return peaks;
    }

    void call_alternates(LinkListVector[] peaks) {
        int pmax = this.phd.data.size() - 1;
        for (int i = 0; i <= pmax; ++i) {
            int ignore;
            PhdData called = (PhdData)this.phd.data.elementAt(i);
            PhdData prev = i == 0 ? null : (PhdData)this.phd.data.elementAt(i - 1);
            PhdData next = i == pmax ? null : (PhdData)this.phd.data.elementAt(i + 1);
            switch (called.base) {
                case 'A': 
                case 'a': {
                    ignore = 0;
                    break;
                }
                case 'C': 
                case 'c': {
                    ignore = 1;
                    break;
                }
                case 'G': 
                case 'g': {
                    ignore = 2;
                    break;
                }
                case 'T': 
                case 't': {
                    ignore = 3;
                    break;
                }
                default: {
                    ignore = -1;
                }
            }
            PolyPeak best = null;
            block7: for (int j = 0; j < 4; ++j) {
                PolyPeak p;
                if (j == ignore) continue;
                while ((p = (PolyPeak)peaks[j].current()) != null) {
                    if (prev != null && p.peak < prev.position) {
                        if (peaks[j].next()) continue;
                        continue block7;
                    }
                    if (this.peak_check(called, prev, next, p, best)) {
                        best = p;
                    }
                    if ((p = (PolyPeak)peaks[j].get_next()) == null || !this.peak_check(called, prev, next, p, best)) continue block7;
                    best = p;
                    continue block7;
                }
            }
            if (best == null) {
                this.alternate_peaks[i] = null;
                continue;
            }
            best.called = called;
            this.alternate_peaks[i] = best;
        }
    }

    boolean peak_check(PhdData current, PhdData prev, PhdData next, PolyPeak p, PolyPeak best) {
        boolean result = false;
        if (!(prev != null && p.peak <= prev.position || next != null && p.peak >= next.position)) {
            PhdData phd;
            PhdData phdData = phd = p.peak < current.position ? prev : next;
            if (!(phd != null && Math.abs(current.position - p.peak) >= Math.abs(phd.position - p.peak) || best != null && p.amplitude <= best.amplitude)) {
                result = true;
            }
        }
        return result;
    }
}

