/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import TCGA.AnnotationFlatfile2;
import TCGA.AnnotationGridPanel2;
import TCGA.AnnotationViewer;
import TCGA.BinIndex;
import TCGA.BooleanOption;
import TCGA.ChromDecoratorPanel;
import TCGA.ChromScaleClicker;
import TCGA.ChromScalePanel2;
import TCGA.ClusterControl;
import TCGA.CombineInfo;
import TCGA.CommentOptions;
import TCGA.ContrastControl;
import TCGA.CopyNumberSummaryInfo2;
import TCGA.CopyNumberVariationImage;
import TCGA.CustomSortControl;
import TCGA.ErrorReporter;
import TCGA.EuclideanClusterControl;
import TCGA.FrequencyReporter;
import TCGA.GISTIC;
import TCGA.GenomicBin;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSet;
import TCGA.HeatmapConfiguration;
import TCGA.HeatmapLocalFileLauncher;
import TCGA.HelpLauncher;
import TCGA.KeyboardScrollListener;
import TCGA.LoadingTracker;
import TCGA.MouseDragScroller;
import TCGA.NavigationBar;
import TCGA.NavigationControl;
import TCGA.NavigationRequest;
import TCGA.Observable2;
import TCGA.Options;
import TCGA.Pathway;
import TCGA.PathwayGenes;
import TCGA.PearsonClusterControl;
import TCGA.RubberBandSelection;
import TCGA.SampleSubsets;
import TCGA.ScalePanel2;
import TCGA.SelectionNotifier;
import TCGA.SetVisible;
import TCGA.SummaryPanelAnyVariation;
import TCGA.SummaryPanelIncreaseDecrease;
import TCGA.TrackInfo;
import TCGA.TrackPanel;
import TCGA.URLLauncher;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Heatmap6
extends JFrame
implements Observer,
MouseListener,
AdjustmentListener,
ActionListener,
MouseWheelListener,
Runnable,
ComponentListener {
    private JPanel main_panel;
    private CopyNumberVariationImage cnvi = null;
    private CopyNumberSummaryInfo2 cnsi;
    private ChromDecoratorPanel isp;
    private SummaryPanelIncreaseDecrease sp_cnc_incr;
    private SummaryPanelAnyVariation sp_cnc_any;
    private NavigationControl nc;
    private ChromScalePanel2 csp;
    private JMenuItem mi_contrast;
    private JMenuItem mi_view_annotations;
    private JMenuItem mi_nav;
    private JMenuItem mi_help_zoom;
    private JCheckBoxMenuItem mi_show_zoom;
    private ContrastControl cc = null;
    private AnnotationViewer av = null;
    private AnnotationGridPanel2 agp = null;
    private NavigationBar nb = null;
    private JPanel jp_heatmap = null;
    private JScrollBar jsb_h;
    private JScrollBar jsb_v;
    private ArrayList<TrackPanel> tracks = null;
    private HeatmapConfiguration config;
    private static String LABEL_ZOOM_IN = "Zoom in";
    private static String LABEL_ZOOM_OUT = "Zoom out";
    private static String LABEL_ZOOM_OUT_MAX = "Zoom out max";
    private static String LABEL_ZOOM_RESET = "Zoom 1:1";
    private static String LABEL_ZOOM_TO_SELECTION = "Zoom to selection";
    private static String LABEL_SET_Y_SCALING = "Set vertical magnification...";
    private static String LABEL_SHOW_ZOOM_INDICATOR = "Display magnification level";
    private static String LABEL_SET_ANNOT_TOOLTIP = "Set annotation tooltip...";
    private static String LABEL_HELP = "Documentation";
    private static String LABEL_LINK_HEATMAPS = "Heatmap dataset index";
    private static String LABEL_LINK_CGWB = "Cancer Genome Workbench";
    private JScrollPane jsp_heatmap;
    private JScrollPane jsp_cnc_incr;
    private JScrollPane jsp_cnc_any;
    private JScrollPane jsp_chrom;
    private JScrollPane jsp_annot;
    private boolean laid_out = false;
    private boolean initial_gui_built = false;
    private JLabel loading_label;
    private int start_y_scaling;
    private boolean show_zoom_level = true;
    private boolean show_total_histogram = true;
    private LoadingTracker loading_tracker = null;

    public Heatmap6(HeatmapConfiguration config) throws Exception {
        this.config = config;
        this.setup();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof CopyNumberVariationImage) {
            this.layout_all();
            if (this.isp != null) {
                this.isp.set_image_size(((CopyNumberVariationImage)o).get_raw_size());
                this.isp.repaint();
                this.csp.repaint();
                if (this.agp != null) {
                    this.agp.repaint();
                }
            }
        } else if (o instanceof NavigationControl) {
            NavigationControl nc = (NavigationControl)o;
            if (arg instanceof ArrayList) {
                this.launch_subwindow((ArrayList)arg, nc.get_selected_pathway(), nc.get_selected_combinations());
            } else {
                Rectangle selection = (Rectangle)arg;
                RubberBandSelection rbs = this.isp.get_selection();
                Integer wants_sort_bin = nc.wants_sort_bin();
                if (wants_sort_bin != null) {
                    this.isp.sort_by_bin(wants_sort_bin, null);
                }
                rbs.set_selection(selection);
                rbs.set_selected_label(nc.get_selected_label());
                if (nc.wants_zoom()) {
                    this.isp.zoom_to_selection();
                } else {
                    this.isp.center_on_region(selection);
                }
                this.isp.repaint();
                this.setVisible(true);
            }
        } else if (o instanceof ChromScaleClicker) {
            Rectangle selection = this.config.gm.generate_selection((GenomicBin)arg);
            this.isp.get_selection().set_selection(selection);
            this.isp.zoom_to_selection();
        } else if (o instanceof GenomicMeasurement) {
            if (!this.laid_out && this.loading_label != null) {
                if (this.loading_tracker == null) {
                    this.loading_tracker = new LoadingTracker();
                }
                this.loading_tracker.track((GenomicMeasurement)o);
                int file_count = this.loading_tracker.get_file_count();
                int cell_count = this.loading_tracker.get_cell_count();
                this.loading_label.setText("Loading...(" + cell_count + " cells from " + file_count + " file" + (file_count == 1 ? "" : "s") + ")");
                this.pack();
            }
            this.layout_all();
        } else if (o instanceof AnnotationFlatfile2) {
            this.layout_all();
        } else if (o instanceof GenomicSet) {
            this.layout_all();
        } else if (o instanceof SelectionNotifier) {
            Rectangle selection = (Rectangle)arg;
            this.isp.get_selection().set_selection(selection);
            this.isp.zoom_to_selection();
        } else if (o instanceof Observable2) {
            if (arg instanceof Pathway) {
                this.launch_pathway_subwindow((Pathway)arg);
            } else if (arg instanceof Rectangle) {
                this.launch_selection_subwindow((Rectangle)arg);
            } else if (arg instanceof NavigationRequest) {
                NavigationRequest nr = (NavigationRequest)arg;
                if (nr.pathway != null) {
                    this.launch_pathway_subwindow(nr.pathway);
                } else if (nr.bin_index_list != null) {
                    this.launch_subwindow(nr.bin_index_list, null, null);
                } else {
                    Rectangle selection = null;
                    if (nr.bin_index != null) {
                        if (nr.wants_sort) {
                            this.isp.sort_by_bin(nr.bin_index, null);
                        }
                        selection = this.config.gm.generate_selection(nr.bin_index);
                    } else if (nr.selection != null) {
                        selection = nr.selection;
                    }
                    if (selection != null) {
                        RubberBandSelection rbs = this.isp.get_selection();
                        rbs.set_selection(selection);
                        rbs.set_selected_label(nr.marker);
                        if (nr.wants_zoom) {
                            this.isp.zoom_to_selection();
                        } else {
                            this.isp.center_on_region(selection);
                        }
                        this.isp.repaint();
                        this.setVisible(true);
                    }
                }
            } else {
                System.err.println("WTF update from " + arg);
            }
        } else {
            System.err.println("ERROR: unhandled update from " + o);
        }
    }

    private boolean everything_loaded() {
        boolean gs_ok;
        boolean cnvi_ok = this.cnvi != null && this.cnvi.is_complete();
        boolean af_ok = this.config.af == null ? true : this.config.af.is_loaded();
        boolean vasari_ok = this.config.vasari == null ? true : this.config.vasari.is_loaded();
        boolean gm_ok = this.config.gm.is_loaded();
        boolean bl = gs_ok = this.config.gs != null && this.config.gs.is_loaded();
        if (gm_ok) {
            if (this.config.gm_supplemental.size() > 0) {
                this.config.show_up_down_histogram = false;
                this.config.display_sample_names = true;
                Options.MAX_VERTICAL_SCALE_FACTOR = 16.0f;
                this.config.gm.combine_datasets(this.config.gm_supplemental, this.config.parent_ref);
            }
            this.config.gm.get_color_manager().set_config(this.config);
            if (this.config.gs == null) {
                this.config.gs = this.config.gm.is_genome_formatted() ? new GenomicSet(this.config.gm, 1, this) : new GenomicSet(this.config.gm, 2, this);
            }
            if (this.cnsi == null) {
                this.cnsi = new CopyNumberSummaryInfo2(this.config.gm);
            }
            if (this.cnvi == null) {
                this.cnvi = new CopyNumberVariationImage(this.config.gm);
                this.cnvi.addObserver(this);
                this.config.gm.addObserver(this.cnvi);
            }
        }
        return cnvi_ok && af_ok && vasari_ok && gm_ok && gs_ok;
    }

    private void create_final_gui() {
        if (this.everything_loaded() && !this.laid_out) {
            int f;
            int bin_count;
            int gm_columns;
            CommentOptions gm_options;
            String option;
            if (Options.STARTUP_RESTRICT_COLUMNS || Options.INTERACTIVE_RESTRICT_COLUMNS) {
                if (Options.RESTRICT_PRESERVE_BINS) {
                    System.err.println("fix me: bin layout preservation disabled");
                } else {
                    System.err.println("building new GenomicSet");
                    this.config.gs = new GenomicSet(this.config.gm, 2, null);
                }
            }
            this.laid_out = true;
            if (Options.INCLUDE_DEVELOPMENT_CODE) {
                System.err.println("**** WARNING: build includes development features!");
            }
            if (this.config.af != null) {
                Exception e = this.config.af.get_parse_exception();
                if (e != null) {
                    JOptionPane.showMessageDialog(this, "Could not access protected sample annotation data.  Your session may have expired.  The viewer will display without annotations.", "Access denied", 0);
                    this.config.af = null;
                } else {
                    this.config.af.index_annotations(this.config.gm);
                }
            }
            if (this.config.vasari != null) {
                this.config.vasari.index_annotations(this.config.gm);
            }
            if ((option = (gm_options = this.config.gm.get_options()).get("bin_by_marker_name")) != null && option.equals("true")) {
                this.config.gs = new GenomicSet(this.config.gm, 2, null);
            }
            if ((gm_columns = this.config.gm.get_headers().length) != (bin_count = this.config.gs.get_bin_count())) {
                System.err.println("WARNING: bin count doesn't match data count! bins=" + bin_count + " cols=" + gm_columns);
            }
            if (gm_columns < Options.DISABLE_HORIZONTAL_ZOOM_COLUMNS && (this.config.gm_supplemental.size() <= 0 || Options.COMBINE_DATASETS_ADD_ROWS_MODE)) {
                this.config.enable_horizontal_zoom.setValue(false);
            }
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.config.title == null && (option = gm_options.get("title")) != null) {
                this.config.title = option;
                this.set_title();
            }
            this.show_total_histogram = true;
            if (gm_options.option_equals_lc("total_histogram", "off")) {
                this.show_total_histogram = false;
            }
            if (gm_options.option_equals_lc("up_down_histogram", "off")) {
                this.config.show_up_down_histogram = false;
            }
            int img_width = this.cnvi.getWidth();
            this.jsb_h = new JScrollBar(0, 0, 0, 0, img_width);
            this.jsb_h.addAdjustmentListener(this);
            this.jsb_v = new JScrollBar(1, 0, 0, 0, this.cnvi.getHeight());
            this.jsb_v.addAdjustmentListener(this);
            BufferedImage cnvi_bi = this.cnvi.get_image();
            this.isp = new ChromDecoratorPanel(cnvi_bi, this.jsb_h, this.jsb_v, this.config);
            this.isp.addObserver(this);
            this.isp.addKeyListener(new KeyboardScrollListener(this.jsb_h, this.jsb_v));
            if (this.config.af != null) {
                this.isp.set_tooltip_field("age of onset");
            }
            if (this.config.display_sample_names) {
                this.isp.set_display_sample_ids(true);
            }
            this.tracks = new ArrayList();
            for (TrackInfo ti : gm_options.get_tracks()) {
                ti.set_width(gm_columns);
                TrackPanel tp = new TrackPanel(ti, this.jsb_h);
                tp.get_selection_notifier().addObserver(this);
                this.tracks.add(tp);
            }
            if (this.config.show_up_down_histogram) {
                GISTIC gistic = this.config.gm.get_options().get_gistic();
                if (gistic != null) {
                    gistic.bin_infill(this.config.gs);
                }
                this.sp_cnc_incr = new SummaryPanelIncreaseDecrease(this.cnsi, img_width, this.config.gm.get_color_manager().get_all_color_schemes().get(0), gistic);
            }
            if (this.show_total_histogram) {
                this.sp_cnc_any = new SummaryPanelAnyVariation(this.cnsi, img_width);
                this.sp_cnc_any.set_horizontal_scrollbar(this.jsb_h);
            }
            this.csp = new ChromScalePanel2(this.config.gs, img_width);
            this.csp.get_clicker().addObserver(this);
            int y_used = 0;
            if (this.config.show_up_down_histogram) {
                y_used += this.sp_cnc_incr.get_scaled_size().height;
            }
            if (this.show_total_histogram) {
                y_used += this.sp_cnc_any.get_scaled_size().height;
            }
            y_used += this.csp.get_scaled_size().height;
            for (TrackPanel tp : this.tracks) {
                y_used += tp.get_scaled_size().height;
            }
            this.start_y_scaling = this.guess_y_scaling(y_used);
            this.isp.set_min_vertical_scale_level(this.start_y_scaling);
            if (this.config.minimum_initial_vertical_scale_factor != null && this.start_y_scaling < (f = (int)this.config.minimum_initial_vertical_scale_factor.floatValue())) {
                this.start_y_scaling = f;
            }
            this.isp.set_vertical_scale_level(this.start_y_scaling);
            float max_y_scale = this.get_max_vertical_scale_factor();
            if ((float)this.start_y_scaling > max_y_scale) {
                max_y_scale = this.start_y_scaling;
            }
            this.isp.set_max_vertical_scale_level(max_y_scale);
            this.isp.set_max_horizontal_scale_level(150.0f);
            int max = (int)((float)screen.height * Options.MAX_Y_WINDOW_SIZE_FRACTION) - y_used;
            Dimension visible_image_size = this.cnvi.get_raw_size();
            this.isp.set_image_size(visible_image_size);
            int py = this.isp.get_scaled_size().height;
            if (py > max) {
                py = max;
            }
            this.main_panel.removeAll();
            BoxLayout bl = new BoxLayout(this.main_panel, 1);
            this.main_panel.setLayout(bl);
            this.isp.set_horizontal_scrollbar(this.jsb_h);
            if (this.config.show_up_down_histogram) {
                this.sp_cnc_incr.set_horizontal_scrollbar(this.jsb_h);
            }
            this.csp.set_horizontal_scrollbar(this.jsb_h);
            this.isp.addMouseWheelListener(this);
            new MouseDragScroller(this.isp, this.jsb_h, this.jsb_v);
            this.jp_heatmap = new JPanel();
            this.jp_heatmap.setLayout(new BorderLayout());
            this.jp_heatmap.add("Center", this.isp);
            this.jp_heatmap.add("East", this.jsb_v);
            this.main_panel.add(this.jp_heatmap);
            for (TrackPanel tp : this.tracks) {
                this.main_panel.add(tp);
            }
            if (this.config.show_up_down_histogram) {
                this.main_panel.add(this.sp_cnc_incr);
            }
            if (this.show_total_histogram) {
                this.main_panel.add(this.sp_cnc_any);
            }
            this.main_panel.add(this.csp);
            this.main_panel.add(this.jsb_h);
            this.getContentPane().setLayout(new BorderLayout());
            JSplitPane sp = null;
            if (this.config.af == null && this.config.vasari == null) {
                this.getContentPane().add("Center", this.main_panel);
            } else {
                this.agp = new AnnotationGridPanel2(this.config.af, this.config.vasari, this.config.gm, this.isp);
                this.agp.set_grid_height(this.isp.getPreferredSize().height);
                this.jsb_v.addAdjustmentListener(this.agp);
                this.jsp_annot = new JScrollPane(this.agp);
                sp = new JSplitPane(1, this.main_panel, this.jsp_annot);
                this.getContentPane().add("Center", sp);
            }
            this.nb = new NavigationBar(this.config);
            JScrollPane jsp_nb = new JScrollPane(this.nb, 21, 31);
            this.getContentPane().add("North", jsp_nb);
            this.nb.addObserver(this);
            int DEFAULT_PANEL_WIDTH = (int)((double)screen.width * 0.99);
            if (gm_columns < screen.width) {
                if (gm_columns < Options.MIN_COLUMNS_TO_SET_FIXED_WIDTH) {
                    FontMetrics fm = this.isp.getFontMetrics(this.isp.getFont());
                    String[] headers = this.config.gm.get_headers();
                    int max_header_width = 0;
                    for (int i = 0; i < headers.length; ++i) {
                        int w = fm.stringWidth(headers[i]);
                        if (w <= max_header_width) continue;
                        max_header_width = w;
                    }
                    DEFAULT_PANEL_WIDTH = (int)((double)(max_header_width * headers.length) * 1.1);
                } else if (gm_columns < DEFAULT_PANEL_WIDTH / 2) {
                    int scale = DEFAULT_PANEL_WIDTH / gm_columns;
                    DEFAULT_PANEL_WIDTH = gm_columns * scale;
                } else {
                    DEFAULT_PANEL_WIDTH = gm_columns;
                }
                if (DEFAULT_PANEL_WIDTH < this.nb.getPreferredSize().width) {
                    DEFAULT_PANEL_WIDTH = this.nb.getPreferredSize().width;
                }
            }
            if (this.config.af != null || this.config.vasari != null) {
                int overflow;
                int anno_width = this.agp.getPreferredSize().width + 20;
                int max_anno_width = screen.width / 3;
                if (anno_width > max_anno_width) {
                    anno_width = max_anno_width;
                }
                if ((overflow = DEFAULT_PANEL_WIDTH + anno_width - screen.width) > 0) {
                    DEFAULT_PANEL_WIDTH -= overflow;
                }
                sp.setDividerLocation(DEFAULT_PANEL_WIDTH);
            }
            if (this.show_total_histogram) {
                this.sp_cnc_any.setPreferredSize(new Dimension(DEFAULT_PANEL_WIDTH, this.sp_cnc_any.get_scaled_size().height));
            }
            for (TrackPanel tp : this.tracks) {
                tp.setPreferredSize(new Dimension(DEFAULT_PANEL_WIDTH, tp.get_scaled_size().height));
            }
            if (this.config.show_up_down_histogram) {
                this.sp_cnc_incr.setPreferredSize(new Dimension(DEFAULT_PANEL_WIDTH, this.sp_cnc_incr.get_scaled_size().height));
            }
            this.csp.setPreferredSize(new Dimension(DEFAULT_PANEL_WIDTH, this.csp.get_scaled_size().height));
            this.isp.setPreferredSize(new Dimension(DEFAULT_PANEL_WIDTH, py));
            if (this.jp_heatmap != null) {
                this.jp_heatmap.revalidate();
            }
            this.main_panel.setPreferredSize(new Dimension(DEFAULT_PANEL_WIDTH, this.main_panel.getPreferredSize().height));
            Dimension pref = this.getPreferredSize();
            int x_max = (int)((double)screen.width * 0.99);
            if (pref.width > x_max) {
                try {
                    this.setPreferredSize(new Dimension(x_max, pref.height));
                }
                catch (NoSuchMethodError e) {
                    System.err.println("can't set pref JFrame size on this JVM");
                }
            }
            JMenuBar mb = new JMenuBar();
            JMenu m = new JMenu("Tools");
            mb.add(m);
            m.setMnemonic(84);
            this.mi_contrast = this.add_menuitem(m, "Color and contrast...", 67, KeyStroke.getKeyStroke(67, 8));
            if (this.config.af != null) {
                this.mi_view_annotations = this.add_menuitem(m, "Annotations...", 79, KeyStroke.getKeyStroke(65, 8));
                this.add_menuitem(m, LABEL_SET_ANNOT_TOOLTIP, 80, KeyStroke.getKeyStroke(80, 8));
            }
            this.mi_contrast.addActionListener(this);
            this.mi_nav = this.add_menuitem(m, "Navigation...", 86, KeyStroke.getKeyStroke(78, 8));
            this.mi_nav.addActionListener(this);
            JMenu sub = new JMenu("Cluster...");
            m.add(sub);
            JMenuItem jmi = new JMenuItem("by Pearson's r...");
            sub.add(jmi);
            jmi.addActionListener(new SetVisible(new PearsonClusterControl(this.config.gm, this.isp)));
            jmi = new JMenuItem("by Euclidean distance...");
            sub.add(jmi);
            jmi.addActionListener(new SetVisible(new EuclideanClusterControl(this.config.gm, this.isp)));
            jmi = new JMenuItem("by variation frequency...");
            sub.add(jmi);
            jmi.addActionListener(new SetVisible(new ClusterControl(this.config.gm, this.config.gs)));
            if (Options.INCLUDE_DEVELOPMENT_CODE) {
                jmi = new JMenuItem("Report frequency...[development]");
                m.add(jmi);
                jmi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FrequencyReporter fr = new FrequencyReporter(Heatmap6.this.config, Heatmap6.this.isp);
                    }
                });
            }
            m = new JMenu("View");
            mb.add(m);
            m.setMnemonic(86);
            SampleSubsets ss = this.config.gm.get_sample_subsets();
            if (!ss.isEmpty()) {
                sub = new JMenu("Display samples for...");
                m.add(sub);
                sub.setMnemonic(68);
                for (String subset : ss.get_subsets_arraylist()) {
                    sub.add(ss.get_checkbox_menuitem(subset));
                }
                sub.add(new JSeparator());
                jmi = new JMenuItem("all");
                sub.add(jmi);
                jmi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        for (JCheckBoxMenuItem cb : ((Heatmap6)Heatmap6.this).config.gm.get_sample_subsets().get_checkboxes()) {
                            if (cb.isSelected()) continue;
                            cb.doClick();
                        }
                    }
                });
                jmi = new JMenuItem("none");
                sub.add(jmi);
                jmi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        for (JCheckBoxMenuItem cb : ((Heatmap6)Heatmap6.this).config.gm.get_sample_subsets().get_checkboxes()) {
                            if (!cb.isSelected()) continue;
                            cb.doClick();
                        }
                    }
                });
            }
            jmi = new JMenuItem("Custom sort order...");
            m.add(jmi);
            jmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new CustomSortControl(((Heatmap6)Heatmap6.this).config.gm);
                }
            });
            if (this.config.gm.get_options().has_gistic() && this.config.show_up_down_histogram) {
                String lower_label;
                ButtonGroup bg = new ButtonGroup();
                String upper_label = this.config.gm.get_options().get("high_label");
                if (upper_label == null) {
                    upper_label = "Increase";
                }
                if ((lower_label = this.config.gm.get_options().get("low_label")) == null) {
                    lower_label = "Decrease";
                }
                String label = upper_label + "/" + lower_label + " display...";
                sub = new JMenu(label);
                m.add(sub);
                JCheckBoxMenuItem jcb_changes = new JCheckBoxMenuItem("Percentage change", false);
                JCheckBoxMenuItem jcb_gistic = new JCheckBoxMenuItem("GISTIC q-values", true);
                bg.add(jcb_changes);
                bg.add(jcb_gistic);
                sub.add(jcb_changes);
                sub.add(jcb_gistic);
                jcb_changes.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Heatmap6.this.sp_cnc_incr.set_gistic_mode(false);
                    }
                });
                jcb_gistic.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Heatmap6.this.sp_cnc_incr.set_gistic_mode(true);
                    }
                });
            }
            m = new JMenu("Zoom");
            m.setMnemonic(90);
            this.add_menuitem(m, LABEL_ZOOM_IN, 73, KeyStroke.getKeyStroke('+'));
            this.add_menuitem(m, LABEL_ZOOM_OUT, 79, KeyStroke.getKeyStroke('-'));
            this.add_menuitem(m, LABEL_ZOOM_OUT_MAX, 88, KeyStroke.getKeyStroke('<'));
            this.add_menuitem(m, LABEL_ZOOM_RESET, 49, KeyStroke.getKeyStroke('='));
            this.add_menuitem(m, LABEL_ZOOM_TO_SELECTION, 83, KeyStroke.getKeyStroke('s'));
            m.add(new JSeparator());
            this.add_menuitem(m, LABEL_SET_Y_SCALING, 76, KeyStroke.getKeyStroke(86, 8));
            m.add(this.generate_checkbox("Enable vertical zooming", this.config.enable_vertical_zoom));
            m.add(this.generate_checkbox("Enable horizontal zooming", this.config.enable_horizontal_zoom));
            m.add(new JSeparator());
            this.mi_show_zoom = new JCheckBoxMenuItem(LABEL_SHOW_ZOOM_INDICATOR, this.show_zoom_level);
            m.add(this.mi_show_zoom);
            this.mi_show_zoom.addActionListener(this);
            m.add(new JSeparator());
            this.mi_help_zoom = new JMenuItem("Help: zooming and scrolling");
            m.add(this.mi_help_zoom);
            this.mi_help_zoom.addActionListener(this);
            mb.add(m);
            m = new JMenu("Links");
            m.setMnemonic(76);
            this.add_menuitem(m, LABEL_LINK_HEATMAPS, 72, null);
            this.add_menuitem(m, LABEL_LINK_CGWB, 67, null);
            mb.add(m);
            m = new JMenu("Help");
            m.setMnemonic(72);
            this.add_menuitem(m, LABEL_HELP, 72, KeyStroke.getKeyStroke(112, 0));
            mb.add(m);
            this.setJMenuBar(mb);
            this.pack();
            this.setVisible(true);
            this.isp.requestFocusInWindow();
            if (this.config.start_bin != null) {
                GenomicBin wanted = null;
                for (GenomicBin gb : this.config.gs.get_bins()) {
                    if (!gb.bin_name.equals(this.config.start_bin)) continue;
                    wanted = gb;
                    break;
                }
                if (wanted == null) {
                    System.err.println("ERROR: no such start bin name " + this.config.start_bin);
                } else {
                    Rectangle selection = this.config.start_pos != null && this.config.end_pos != null ? this.config.gs.get_selection_for_chr_location(wanted.bin_name, (int)this.config.start_pos, (int)this.config.end_pos) : this.config.gm.generate_selection(wanted);
                    SelectionNotifier sn = new SelectionNotifier();
                    sn.addObserver(this);
                    sn.set_pending_selection(selection);
                    SwingUtilities.invokeLater(sn);
                }
            } else if (this.config.start_marker != null) {
                BinIndex bi = new BinIndex(this.config.gm);
                int wanted = bi.find(this.config.start_marker);
                if (wanted == -1) {
                    System.err.println("ERROR: can't find marker " + this.config.start_marker);
                } else {
                    Rectangle selection = this.config.gm.generate_selection(wanted);
                    SelectionNotifier sn = new SelectionNotifier();
                    sn.addObserver(this);
                    sn.set_pending_selection(selection);
                    SwingUtilities.invokeLater(sn);
                }
            }
        }
    }

    private void set_title() {
        String t = "Heatmap";
        if (this.config.title != null) {
            t = t.concat(": " + this.config.title);
        }
        if (this.config.pathway != null) {
            t = t.concat(": " + this.config.pathway.name);
        }
        this.setTitle(t);
    }

    private void setup() {
        new PathwayGenes();
        this.initial_gui_built = false;
        SwingUtilities.invokeLater(this);
    }

    public void layout_all() {
        if (!this.laid_out) {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        if (this.initial_gui_built) {
            this.create_final_gui();
        } else {
            this.create_initial_gui();
        }
    }

    private void create_initial_gui() {
        this.main_panel = new JPanel();
        this.set_title();
        if (this.config.gs != null) {
            this.config.gs.addObserver(this);
        }
        LookAndFeeler.set_native_lookandfeel();
        this.config.gm.addObserver(this);
        for (GenomicMeasurement gm : this.config.gm_supplemental) {
            gm.addObserver(this);
        }
        if (this.config.af != null) {
            this.config.af.addObserver(this);
        }
        if (this.config.vasari != null) {
            this.config.vasari.addObserver(this);
        }
        if (!Options.IS_APPLET && this.config.exit_on_close) {
            this.setDefaultCloseOperation(3);
        }
        if (this.everything_loaded()) {
            this.layout_all();
        } else {
            this.main_panel.setLayout(new BorderLayout());
            this.loading_label = new JLabel("Loading...");
            this.main_panel.add(this.loading_label);
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(this.config.af == null && this.config.vasari == null ? "Center" : "West", this.main_panel);
            this.pack();
        }
        this.setVisible(true);
        this.initial_gui_built = true;
    }

    public static void main(String[] argv) {
        try {
            String gm_file = null;
            String annotation_file = null;
            String genomic_set_file = null;
            String vasari_file = null;
            String url = null;
            String auth = null;
            boolean has_bins = false;
            boolean has_annotations = false;
            boolean has_vasari = false;
            String start_dir = null;
            String url_gm = null;
            String url_annot = null;
            String url_set = null;
            HeatmapConfiguration conf = new HeatmapConfiguration();
            ArrayList<String> dataset_ids = new ArrayList<String>();
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-gm")) {
                    if (gm_file == null) {
                        gm_file = argv[++i];
                        continue;
                    }
                    boolean async = true;
                    conf.gm_supplemental.add(new GenomicMeasurement(argv[++i], async));
                    continue;
                }
                if (argv[i].equals("-help") || argv[i].equals("/?")) {
                    Heatmap6.show_help();
                    System.exit(1);
                    continue;
                }
                if (argv[i].equals("-default")) {
                    gm_file = "Broad_SNP6_GenomicMeasurement.txt";
                    annotation_file = "intgen.org_GBM.biotab.1.0.0.tab";
                    genomic_set_file = "broad_snp6_genomicset.txt";
                    continue;
                }
                if (argv[i].equals("-demo")) {
                    gm_file = "CopyNumbers.tab";
                    annotation_file = "annotations.tab";
                    genomic_set_file = "GenomicSet.tab";
                    continue;
                }
                if (argv[i].equals("-annot")) {
                    annotation_file = argv[++i];
                    continue;
                }
                if (argv[i].equals("-vasari")) {
                    vasari_file = argv[++i];
                    continue;
                }
                if (argv[i].equals("-set")) {
                    genomic_set_file = argv[++i];
                    continue;
                }
                if (argv[i].equals("-enable-acceleration")) {
                    System.err.println("enabling acceleration (look out below!)");
                    Options.DISABLE_ACCELERATION = false;
                    continue;
                }
                if (argv[i].equals("-bright-percent")) {
                    Options.DEFAULT_MIN_COLOR_INTENSITY_PERCENT = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-no-optimize")) {
                    Options.AUTO_OPTIMIZE_GRADIENTS = false;
                    continue;
                }
                if (argv[i].equals("-columns")) {
                    String[] cols = argv[++i].split(",");
                    Options.STARTUP_RESTRICT_COLUMNS = true;
                    Options.RESTRICT_COLUMNS = new HashSet();
                    for (int j = 0; j < cols.length; ++j) {
                        Options.RESTRICT_COLUMNS.add(new String(cols[j]));
                    }
                    continue;
                }
                if (argv[i].equals("-combine-add-columns")) {
                    Options.COMBINE_DATASETS_ADD_ROWS_MODE = false;
                    continue;
                }
                if (argv[i].equals("-combine-add-rows")) {
                    Options.COMBINE_DATASETS_ADD_ROWS_MODE = true;
                    continue;
                }
                if (argv[i].equals("-gradients")) {
                    String[] grads = argv[++i].split(",");
                    int[] gradients = new int[grads.length];
                    for (int j = 0; j < grads.length; ++j) {
                        gradients[j] = Integer.parseInt(grads[j]);
                    }
                    Options.DEFAULT_COPYNUMBER_GRADIENTS = gradients;
                    continue;
                }
                if (argv[i].equals("-quiet")) {
                    Options.VERBOSE_ERRORS = false;
                    continue;
                }
                if (argv[i].equals("-dataset")) {
                    dataset_ids.add(new String(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-auth")) {
                    auth = argv[++i];
                    continue;
                }
                if (argv[i].equals("-title")) {
                    conf.title = argv[++i];
                    continue;
                }
                if (argv[i].equals("-url")) {
                    url = argv[++i];
                    URLLauncher.set_url(url);
                    continue;
                }
                if (argv[i].equals("-url-gz")) {
                    Options.GZIP_URL_STREAMS = Heatmap6.binary_option(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-binary")) {
                    Options.DEFAULT_USE_BINARY_SAMPLE_FILE = Heatmap6.binary_option(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-url-gm")) {
                    url_gm = argv[++i];
                    continue;
                }
                if (argv[i].equals("-url-annot")) {
                    url_annot = argv[++i];
                    continue;
                }
                if (argv[i].equals("-url-set")) {
                    url_set = argv[++i];
                    continue;
                }
                if (argv[i].equals("-dir")) {
                    start_dir = argv[++i];
                    continue;
                }
                if (argv[i].equals("-has-bins")) {
                    has_bins = true;
                    continue;
                }
                if (argv[i].equals("-has-annotations")) {
                    has_annotations = true;
                    continue;
                }
                if (argv[i].equals("-has-vasari")) {
                    has_vasari = true;
                    continue;
                }
                if (argv[i].equals("-start-bin")) {
                    conf.start_bin = argv[++i];
                    continue;
                }
                if (argv[i].equals("-start-marker")) {
                    conf.start_marker = argv[++i];
                    continue;
                }
                if (argv[i].equals("-start-pos")) {
                    conf.start_pos = new Integer(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-end-pos")) {
                    conf.end_pos = new Integer(argv[++i]);
                    continue;
                }
                System.err.println("ERROR: unknown arg " + argv[i]);
                Heatmap6.show_help();
                System.exit(1);
            }
            if (gm_file != null) {
                conf.af = annotation_file == null ? null : new AnnotationFlatfile2(annotation_file);
                conf.vasari = vasari_file == null ? null : new AnnotationFlatfile2(vasari_file);
                conf.gm = new GenomicMeasurement(gm_file, true);
                if (genomic_set_file != null) {
                    conf.gs = new GenomicSet(genomic_set_file);
                }
            } else if (dataset_ids.size() > 0) {
                String dataset_id = (String)dataset_ids.get(0);
                boolean use_binary = Options.DEFAULT_USE_BINARY_SAMPLE_FILE;
                Hashtable<String, String> p = new Hashtable<String, String>();
                if (dataset_ids.size() > 1) {
                    for (int idx = 1; idx < dataset_ids.size(); ++idx) {
                        String dsid = (String)dataset_ids.get(idx);
                        System.err.println("loading supplemental dataset ID " + dsid);
                        p.clear();
                        p.put("ds", dsid);
                        p.put("serve", "data");
                        if (auth != null) {
                            p.put("auth", auth);
                        }
                        if (use_binary) {
                            p.put("binary", "1");
                        }
                        conf.gm_supplemental.add(new GenomicMeasurement(new GZIPInputStream(Heatmap6.open_url(url, p)), true, use_binary));
                    }
                }
                p.clear();
                p.put("ds", dataset_id);
                p.put("serve", "data");
                if (auth != null) {
                    p.put("auth", auth);
                }
                if (use_binary) {
                    p.put("binary", "1");
                }
                conf.gm = new GenomicMeasurement(new GZIPInputStream(Heatmap6.open_url(url, p)), true, use_binary);
                if (has_bins) {
                    p.clear();
                    p.put("ds", dataset_id);
                    p.put("serve", "bin");
                    if (auth != null) {
                        p.put("auth", auth);
                    }
                    conf.gs = new GenomicSet(new GZIPInputStream(Heatmap6.open_url(url, p)));
                }
                if (has_annotations) {
                    p.clear();
                    p.put("ds", dataset_id);
                    p.put("serve", "annotations");
                    if (auth != null) {
                        p.put("auth", auth);
                    }
                    conf.af = new AnnotationFlatfile2(new GZIPInputStream(Heatmap6.open_url(url, p)));
                }
                if (has_vasari) {
                    p.clear();
                    p.put("ds", dataset_id);
                    p.put("serve", "vasari");
                    conf.vasari = new AnnotationFlatfile2(new GZIPInputStream(Heatmap6.open_url(url, p)));
                }
            } else if (url_gm != null) {
                conf.gm = new GenomicMeasurement(Heatmap6.open_simple_url(url_gm), true, Options.DEFAULT_USE_BINARY_SAMPLE_FILE);
                conf.af = url_annot == null ? null : new AnnotationFlatfile2(Heatmap6.open_simple_url(url_annot));
                GenomicSet genomicSet = conf.gs = url_set == null ? null : new GenomicSet(Heatmap6.open_simple_url(url_set));
            }
            if (conf.gm != null) {
                Heatmap6 hm = new Heatmap6(conf);
                if (conf.gs != null) {
                    conf.gs.addObserver(hm);
                }
            } else {
                Heatmap6.show_help();
                LookAndFeeler.set_native_lookandfeel();
                HeatmapLocalFileLauncher fl = new HeatmapLocalFileLauncher();
                if (start_dir != null) {
                    fl.get_chooser().setCurrentDirectory(new File(start_dir));
                }
            }
        }
        catch (Throwable t) {
            Heatmap6.show_help();
            System.out.println("ERROR:" + t);
            t.printStackTrace();
            new ErrorReporter(t);
        }
    }

    private static void show_help() {
        System.out.println("Heatmap viewer command-line parameters:");
        System.err.println("");
        System.err.println("Input options:");
        System.out.println("     -gm [file]: genomic measurement file (copy number data) [REQUIRED]");
        System.out.println("  -annot [file]: annotations file (optional)");
        System.out.println("    -set [file]: genomic set/bin file (optional)");
        System.err.println("");
        System.err.println("Display options:");
        System.out.println("    -gradients [comma-delimited list]: specify copy-number thresholds for brightness gradients (e.g. 1,2,3)");
        System.out.println("    -bright-percent [value]: specify starting color brightness percent (1-100)");
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        float hscale;
        if (this.isp != null && !this.config.initial_max_x_zoom_checked && (hscale = this.isp.get_horizontal_scale_level()) > 1.0f) {
            if (hscale > this.isp.get_max_horizontal_scale_level()) {
                this.isp.set_max_horizontal_scale_level(hscale);
            }
            this.config.initial_max_x_zoom_checked = true;
        }
        this.sync_horizontal_zoom(this.isp, this.sp_cnc_incr);
        for (TrackPanel tp : this.tracks) {
            this.sync_horizontal_zoom(this.isp, tp);
        }
        if (this.show_total_histogram) {
            this.sync_horizontal_zoom(this.isp, this.sp_cnc_any);
        }
        this.sync_horizontal_zoom(this.isp, this.csp);
        this.sync_annotation_zoom();
    }

    private void sync_horizontal_zoom(ScalePanel2 from, ScalePanel2 to) {
        if (from != null) {
            float hscale = from.get_horizontal_scale_level();
            if (to != null && to.get_horizontal_scale_level() != hscale) {
                to.set_horizontal_scale_level(hscale);
            }
        }
    }

    private void sync_viewports(JScrollPane from, JScrollPane to) {
        Point p_from = from.getViewport().getViewPosition();
        JViewport jv_to = to.getViewport();
        jv_to.setViewPosition(new Point(p_from.x, jv_to.getViewPosition().y));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.mi_contrast)) {
            if (this.cc == null) {
                this.cc = new ContrastControl(this.config);
            } else {
                this.cc.setVisible(true);
                this.cc.setState(0);
            }
        } else if (src.equals(this.mi_help_zoom)) {
            HelpLauncher hl = new HelpLauncher("zoom");
            hl.launch_url();
        } else if (src.equals(this.mi_nav)) {
            if (this.nc != null) {
                this.nc.setState(0);
                this.nc.setVisible(true);
            } else {
                this.nc = new NavigationControl(this.config.gm, this.config.gs);
                this.nc.addObserver(this);
            }
        } else if (src.equals(this.mi_view_annotations)) {
            this.av = new AnnotationViewer(this.config.af, this.config.gm, this.isp);
        } else if (src.equals(this.mi_show_zoom)) {
            this.show_zoom_level = this.mi_show_zoom.getState();
            this.isp.set_show_zoom(this.show_zoom_level);
        } else if (src instanceof AbstractButton) {
            String label = ((AbstractButton)src).getText();
            if (label.equals(LABEL_ZOOM_IN)) {
                this.isp.zoom(ChromDecoratorPanel.ZOOM_DIRECTION_IN, this.get_zoom_type(), Options.ZOOM_FACTOR, null);
            } else if (label.equals(LABEL_ZOOM_OUT)) {
                this.isp.zoom(ChromDecoratorPanel.ZOOM_DIRECTION_OUT, this.get_zoom_type(), Options.ZOOM_FACTOR, null);
            } else if (label.equals(LABEL_ZOOM_TO_SELECTION)) {
                this.isp.zoom_to_selection();
            } else if (label.equals(LABEL_ZOOM_RESET)) {
                if (this.horizontal_zoom_enabled()) {
                    this.isp.zoom_reset();
                }
                if (this.vertical_zoom_enabled()) {
                    this.isp.set_vertical_scale_level(this.start_y_scaling);
                }
            } else if (label.equals(LABEL_ZOOM_OUT_MAX)) {
                this.isp.zoom_out_max();
                if (this.vertical_zoom_enabled()) {
                    this.isp.set_vertical_scale_level(this.start_y_scaling);
                }
            } else if (label.equals(LABEL_SET_Y_SCALING)) {
                Integer result;
                int max = (int)this.get_max_vertical_scale_factor();
                int here = Math.round(this.isp.get_vertical_scale_level());
                if (here > max) {
                    max = here;
                }
                Object[] values = new Integer[max];
                Object current = null;
                int j = 0;
                int i = 1;
                while (i <= max) {
                    values[j] = new Integer(i);
                    if (i == here) {
                        current = values[j];
                    }
                    ++i;
                    ++j;
                }
                if (current == null) {
                    current = values[0];
                }
                if ((result = (Integer)JOptionPane.showInputDialog(this, "Sample height in pixels:", "Set vertical magnification", 3, null, values, current)) != null) {
                    float value = result.intValue();
                    this.isp.set_vertical_scale_level(value);
                    if (this.agp != null) {
                        this.agp.set_vertical_scale_level(value);
                    }
                    if (Options.PRESERVE_VERTICAL_SCALING_SETTING) {
                        this.config.enable_vertical_zoom.setValue(false);
                    }
                }
            } else if (label.equals(LABEL_SET_ANNOT_TOOLTIP)) {
                ArrayList columns = this.config.af.get_sorted_keys();
                Object[] cols = new String[columns.size()];
                for (int i = 0; i < cols.length; ++i) {
                    cols[i] = (String)columns.get(i);
                }
                String result = (String)JOptionPane.showInputDialog(this, "Annotation field to show in tooltip:", "Tooltip annotation", 3, null, cols, this.isp.get_tooltip_field());
                if (result != null) {
                    this.isp.set_tooltip_field(result);
                }
            } else if (label.equals(LABEL_LINK_HEATMAPS)) {
                URLLauncher.launch_modified_url("/cgi-bin/heatmap", "heatmaps");
            } else if (label.equals(LABEL_LINK_CGWB)) {
                String url = "https://cgwb.nci.nih.gov/";
                URLLauncher.launch_url(url, "cgwb");
            } else if (label.equals(LABEL_HELP)) {
                URLLauncher.launch_modified_url("/goldenPath/heatmap/documentation/index.html", "heatmap_doc");
            } else {
                System.err.println("UNHANDLED label:" + label);
            }
        } else {
            System.err.println("UNHANDLED action event!");
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if ((e.getModifiers() & 0x1FA) == 0) {
            this.isp.zoom(e.getWheelRotation() < 0 ? ChromDecoratorPanel.ZOOM_DIRECTION_IN : ChromDecoratorPanel.ZOOM_DIRECTION_OUT, this.get_zoom_type(), Options.ZOOM_FACTOR, e.getPoint());
            this.sync_annotation_zoom();
        }
    }

    private JMenuItem add_menuitem(JMenu m, String label, int mnemonic) {
        return this.add_menuitem(m, label, mnemonic, null);
    }

    private JMenuItem add_menuitem(JMenu m, String label, int mnemonic, KeyStroke accelerator) {
        JMenuItem mi = new JMenuItem(label, mnemonic);
        if (accelerator != null) {
            mi.setAccelerator(accelerator);
        }
        m.add(mi);
        mi.addActionListener(this);
        return mi;
    }

    private int guess_y_scaling(int y_used) {
        int y;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int sample_count = this.config.gm.get_row_count();
        int available = (int)((float)screen.height * Options.MAX_Y_WINDOW_SIZE_FRACTION) - y_used;
        int minimum_y_scale = 1;
        if (sample_count * Options.DEFAULT_VERTICAL_PIXELS_PER_SAMPLE < available / 3) {
            y = available / sample_count;
        } else {
            int required;
            for (y = Options.DEFAULT_VERTICAL_PIXELS_PER_SAMPLE; y > minimum_y_scale && (required = sample_count * y) > available; --y) {
            }
        }
        if ((float)y > Options.MAX_VERTICAL_SCALE_FACTOR) {
            y = (int)Options.MAX_VERTICAL_SCALE_FACTOR;
        }
        return y;
    }

    private boolean vertical_zoom_enabled() {
        return this.config.enable_vertical_zoom.booleanValue();
    }

    private boolean horizontal_zoom_enabled() {
        return this.config.enable_horizontal_zoom.booleanValue();
    }

    private int get_zoom_type() {
        boolean v = this.vertical_zoom_enabled();
        boolean h = this.horizontal_zoom_enabled();
        if (v && h) {
            return ChromDecoratorPanel.ZOOM_AXIS_BOTH;
        }
        if (v) {
            return ChromDecoratorPanel.ZOOM_AXIS_VERTICAL;
        }
        if (h) {
            return ChromDecoratorPanel.ZOOM_AXIS_HORIZONTAL;
        }
        return ChromDecoratorPanel.ZOOM_AXIS_NONE;
    }

    public static InputStream open_url(String u, Hashtable params) throws IOException {
        URL url = new URL(u);
        URLConnection urlConn = url.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        int count = 0;
        StringBuffer sb = new StringBuffer();
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)params.get(key);
            if (count++ > 0) {
                sb.append("&");
            }
            sb.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
        }
        System.err.println("POST: " + u + "?" + sb.toString());
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        printout.writeBytes(sb.toString());
        printout.flush();
        printout.close();
        return urlConn.getInputStream();
    }

    private void sync_annotation_zoom() {
        if (this.isp != null && this.agp != null) {
            JScrollBar jsb_v;
            float vscale = this.isp.get_vertical_scale_level();
            if (this.agp.get_vertical_scale_level() != vscale) {
                this.agp.set_vertical_scale_level(vscale);
            }
            if ((jsb_v = this.jsp_annot.getVerticalScrollBar()) != null && jsb_v.getValue() != jsb_v.getMinimum()) {
                jsb_v.setValue(jsb_v.getMinimum());
            }
        }
    }

    private void launch_subwindow(ArrayList<Integer> bin_list, Pathway pathway, ArrayList<CombineInfo> combines) {
        GenomicMeasurement gm2 = this.config.gm.clone();
        gm2.generate_subset(bin_list);
        try {
            HeatmapConfiguration hc = new HeatmapConfiguration(this.config.af, gm2, new GenomicSet(gm2, 2, null));
            hc.vasari = this.config.vasari;
            hc.title = this.config.title;
            hc.exit_on_close = false;
            hc.display_sample_names = true;
            hc.maximum_vertical_scale_factor = new Float(30.0f);
            hc.enable_horizontal_zoom.setValue(false);
            hc.pathway = pathway;
            if (combines != null) {
                Options.INTERACTIVE_RESTRICT_COLUMNS = true;
                for (CombineInfo ci : combines) {
                    String url = ci.get_url();
                    if (url == null) {
                        System.err.println("ERROR: can't combine, no URL");
                        continue;
                    }
                    System.err.println("HEY NOW " + url);
                    boolean binary = Options.DEFAULT_USE_BINARY_SAMPLE_FILE;
                    System.err.println("FIX ME: forcing binary off");
                    binary = false;
                    hc.gm_supplemental.add(new GenomicMeasurement(Heatmap6.open_simple_url(url), true, binary));
                }
            }
            hc.parent_ref = this;
            Heatmap6 sub_map = new Heatmap6(hc);
        }
        catch (Exception e) {
            new ErrorReporter(e);
        }
    }

    private float get_max_vertical_scale_factor() {
        if (this.config.maximum_vertical_scale_factor != null) {
            return this.config.maximum_vertical_scale_factor.floatValue();
        }
        return Options.MAX_VERTICAL_SCALE_FACTOR;
    }

    private void dump_sizes() {
        System.err.println("pref size dump:");
        System.err.println("  jp_heatmap:" + this.jp_heatmap.getPreferredSize());
        System.err.println("  sp_cnc_incr:" + this.sp_cnc_incr.getPreferredSize());
        if (this.sp_cnc_any != null) {
            System.err.println("  sp_cnc_any:" + this.sp_cnc_any.getPreferredSize());
        }
        System.err.println("  csp:" + this.csp.getPreferredSize());
        System.err.println("  jsb_h:" + this.jsb_h.getPreferredSize());
        System.err.println("  isp:" + this.isp.getPreferredSize());
    }

    private JCheckBoxMenuItem generate_checkbox(String label, BooleanOption state) {
        JCheckBoxMenuItem cb = new JCheckBoxMenuItem(label, state.booleanValue());
        state.set_button(cb);
        return cb;
    }

    private void launch_pathway_subwindow(Pathway p) {
        ArrayList<Integer> wanted = new ArrayList<Integer>();
        ArrayList<String> missing = new ArrayList<String>();
        BinIndex bi = new BinIndex(this.config.gm);
        for (String marker : p.genes) {
            int index = bi.find(marker);
            if (index == -1) {
                missing.add(marker);
                continue;
            }
            wanted.add(new Integer(index));
        }
        if (wanted.size() > 0) {
            this.launch_subwindow(wanted, p, null);
        }
    }

    private void launch_selection_subwindow(Rectangle sel) {
        GenomicMeasurement gm2 = this.config.gm.clone();
        gm2.generate_subset(sel);
        try {
            HeatmapConfiguration hc = new HeatmapConfiguration(this.config.af, gm2, new GenomicSet(gm2, 2, null));
            hc.title = this.config.title;
            hc.exit_on_close = false;
            Heatmap6 subwin = new Heatmap6(hc);
        }
        catch (Exception e) {
            new ErrorReporter(e);
        }
    }

    private static InputStream open_simple_url(String u) throws Exception {
        URL url = new URL(u);
        InputStream is = url.openStream();
        if (Options.GZIP_URL_STREAMS) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    private static boolean binary_option(String s) {
        Integer option = Integer.parseInt(s);
        return option > 0;
    }

    public NavigationControl get_nc() {
        return this.nc;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.laid_out && this.isp.isVisible()) {
            int available = this.isp.getSize().height;
            int sample_count = this.config.gm.get_row_count();
            float y_scale = (float)available / (float)sample_count;
            if (y_scale < 1.0f) {
                y_scale = 1.0f;
            }
            if (y_scale > Options.MAX_VERTICAL_SCALE_FACTOR) {
                y_scale = Options.MAX_VERTICAL_SCALE_FACTOR;
            }
            if (this.isp.get_vertical_scale_level() != y_scale) {
                System.err.println("reset Y scale to " + y_scale);
                this.isp.set_min_vertical_scale_level(y_scale);
                this.isp.set_vertical_scale_level(y_scale);
                this.repaint();
            } else {
                System.err.println("Y scale reset not needed");
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

