/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.ChromScaleClicker;
import TCGA.GenomicBin;
import TCGA.GenomicSet;
import TCGA.HelpLauncher;
import TCGA.Options;
import TCGA.PopupListener;
import TCGA.ScalePanel2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;

public class ChromScalePanel2
extends ScalePanel2 {
    private int BOX_HEIGHT;
    private GenomicSet gs;
    private static Color color_background = Color.white;
    private static Color color_text = Color.black;
    private static Color color_box = Color.black;
    private int raw_preferred_height;
    private ChromScaleClicker clicker;
    private static final String LABEL_HELP = "Help: data layout panel";

    public ChromScalePanel2(GenomicSet gs, int raw_width) {
        this.gs = gs;
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        int font_height = fm.getHeight();
        this.BOX_HEIGHT = (int)((double)font_height * 0.8);
        int buffer = 0;
        int preferred_h = this.BOX_HEIGHT + buffer + font_height;
        this.set_raw_size(new Dimension(raw_width, preferred_h));
        this.setToolTipText("");
        this.clicker = new ChromScaleClicker(this);
        JPopupMenu jpm = new JPopupMenu();
        jpm.add(HelpLauncher.generate_jmenuitem(LABEL_HELP, "panel_data_layout"));
        new PopupListener(this, jpm);
    }

    protected void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        int start_x = this.get_unscaled_x_start();
        int end_x = this.get_unscaled_x_end() + 1;
        Rectangle rd = new Rectangle(start_x, 0, end_x - start_x + 1, 1);
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        float x_scale = this.get_horizontal_scale_level();
        g.setColor(color_box);
        g.fillRect(0, 0, d.width, this.BOX_HEIGHT);
        int labels_drawn = 0;
        int X_BUFFER = 2;
        boolean labels_truncated = false;
        if (Options.are_bins_paintable(this.gs, this)) {
            for (GenomicBin gb : this.gs.get_bins()) {
                int len;
                int bin_start_x;
                int lw;
                int x_raw;
                int x;
                g.setColor(color_background);
                float bin_center = gb.center - 1.0f;
                if (gb.end >= start_x && gb.end <= end_x) {
                    x = (int)((float)(gb.end - start_x) * x_scale);
                    g.drawLine(x, 0, x, this.BOX_HEIGHT);
                }
                int y = 0;
                x = 0;
                Rectangle r_bin = gb.get_rectangle();
                if (!rd.intersects(r_bin)) continue;
                String label = gb.bin_name;
                if (labels_drawn++ > 0 && label.length() > 3 && label.substring(0, 3).equals("chr")) {
                    label = label.substring(3);
                }
                if ((x = (x_raw = (int)((gb.center - 1.0f - (float)start_x) * x_scale)) - (lw = fm.stringWidth(label)) / 2) < 0) {
                    x = X_BUFFER;
                    int label_end = x + lw;
                    int bin_end_x = (int)((float)(gb.end - start_x) * x_scale);
                    if (label_end > bin_end_x) {
                        x -= label_end - bin_end_x;
                    }
                } else if (x > d.width && (x = d.width - lw - X_BUFFER) < (bin_start_x = (int)((float)(gb.start - start_x) * x_scale))) {
                    x = bin_start_x;
                }
                int bsx = (int)((float)(gb.start - start_x - 1) * x_scale);
                int bex = (int)((float)(gb.end - start_x) * x_scale);
                boolean first = true;
                while ((x < bsx || x + lw > bex) && (len = label.length()) > 1) {
                    if (first) {
                        label = label + ">";
                        first = false;
                    }
                    label = label.substring(0, len - 2) + ">";
                    labels_truncated = true;
                    lw = fm.stringWidth(label);
                    x = x_raw - lw / 2;
                }
                g.setColor(color_text);
                y = this.BOX_HEIGHT + fm.getAscent();
                g.drawString(label, x, y);
            }
        }
    }

    public static void main(String[] argv) {
        try {
            GenomicSet gs = new GenomicSet("CopyNumberGenomicSet.txt");
            JFrame jf = new JFrame();
            jf.setLayout(new BorderLayout());
            jf.setDefaultCloseOperation(3);
            ChromScalePanel2 csp = new ChromScalePanel2(gs, 15000);
            JScrollBar jsb_h = new JScrollBar(0, 0, 0, 0, 15000);
            csp.set_horizontal_scrollbar(jsb_h);
            csp.setPreferredSize(new Dimension(1024, 30));
            jf.add("Center", csp);
            jf.add("South", jsb_h);
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public String get_chr_label(int chr) {
        String label = Integer.toString(chr);
        if (chr == 23) {
            label = "X";
        }
        if (chr == 24) {
            label = "Y";
        }
        return label;
    }

    public GenomicBin get_mouse_bin(Point p) {
        Point up = this.get_unscaled_point(p);
        GenomicBin result = null;
        for (GenomicBin gb : this.gs.get_bins()) {
            if (up.x < gb.start - 1 || up.x > gb.end - 1) continue;
            result = gb;
            break;
        }
        return result;
    }

    public String getToolTipText(MouseEvent e) {
        GenomicBin gb = this.get_mouse_bin(e.getPoint());
        return gb == null ? null : "double-click to zoom to " + gb.bin_name;
    }

    public ChromScaleClicker get_clicker() {
        return this.clicker;
    }
}

