/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.IsoViewConfig;
import IsoView.RangeDigest;
import IsoView.Transcript;
import IsoView.TranscriptCoordinateDigestToScale;
import IsoView.TranscriptExon;
import IsoView.TranscriptFeature;
import IsoView.TranscriptIntron;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscriptCoordinateDigestOptimizedScale
extends TranscriptCoordinateDigestToScale {
    ArrayList<RangeDigest> filterable;

    public TranscriptCoordinateDigestOptimizedScale(ArrayList<Transcript> transcripts) {
        super(transcripts);
    }

    @Override
    public void digest() {
        super.digest();
        int chunks = 50;
        int chunk_size = this.final_width / chunks;
        this.filterable = new ArrayList();
        block0: for (int i = 0; i < chunks; ++i) {
            int start = i * chunk_size;
            int end = start + chunk_size - 1;
            RangeDigest rangeDigest = new RangeDigest();
            rangeDigest.add_start_and_length(start, chunk_size);
            for (Transcript t : this.transcripts) {
                if (!rangeDigest.intersects(t.screen_position)) continue;
                for (TranscriptExon te : t.exons) {
                    if (!rangeDigest.intersects(te.screen_position)) continue;
                    continue block0;
                }
            }
            this.filterable.add(rangeDigest);
        }
        ArrayList<RangeDigest> filtered = new ArrayList<RangeDigest>();
        RangeDigest rd_last = null;
        for (RangeDigest rangeDigest : this.filterable) {
            if (rd_last == null) {
                rd_last = rangeDigest;
                continue;
            }
            if (rd_last.get_maximum() + 1 == rangeDigest.get_minimum()) {
                rd_last.add(rangeDigest);
                continue;
            }
            filtered.add(rd_last);
            rd_last = rangeDigest;
        }
        if (rd_last != null) {
            filtered.add(rd_last);
        }
        this.filterable = filtered;
        if (IsoViewConfig.DEBUG_PRUNE) {
            System.err.println("debug: not pruning");
        } else {
            for (Transcript t : this.transcripts) {
                for (TranscriptExon transcriptExon : t.exons) {
                    this.prune_coordinates(transcriptExon);
                }
                for (TranscriptIntron transcriptIntron : t.introns) {
                    this.prune_coordinates(transcriptIntron);
                }
            }
        }
        this.generate_summary_info();
    }

    private void prune_coordinates(TranscriptFeature tf) {
        int raw_start = tf.screen_position.x;
        int raw_end = tf.screen_position.x + (tf.screen_position.width - 1);
        for (RangeDigest rd : this.filterable) {
            if (raw_start > rd.get_maximum()) {
                tf.screen_position.x -= rd.get_size();
                continue;
            }
            if (rd.get_minimum() < raw_start || rd.get_maximum() > raw_end) continue;
            tf.screen_position.width -= rd.get_size();
        }
    }
}

