/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.DatabaseAnnotationLoader;
import IsoView.IsoViewConfig;
import IsoView.JDBCQuery;
import IsoView.Transcript;
import IsoView.UCSCRefGene;
import IsoView.UCSCTools;
import java.util.HashSet;
import java.util.Observer;

public class DatabaseAnnotationLoaderDB
extends DatabaseAnnotationLoader
implements Runnable {
    private static final int MAX_GENES_TO_QUERY_INDIVIDUALLY = 100;

    public DatabaseAnnotationLoaderDB(IsoViewConfig config, Observer o) {
        super(config, o);
    }

    public void run() {
        UCSCTools ucsc = new UCSCTools(JDBCQuery.get_stjude_hg19());
        HashSet<String> all_genes = new HashSet<String>();
        for (Transcript t : this.config.all_transcripts) {
            for (String gene : t.get_genes()) {
                all_genes.add(gene);
            }
        }
        long start = System.currentTimeMillis();
        if (all_genes.size() > 100) {
            for (UCSCRefGene rg : ucsc.get_all_refgenes()) {
                this.add_gene(rg);
            }
        } else {
            for (UCSCRefGene rg : ucsc.get_refgenes_for_genes(all_genes)) {
                this.add_gene(rg);
            }
        }
        System.err.println("SQL time: " + (System.currentTimeMillis() - start) + " ms");
        this.setChanged();
        this.notifyObservers();
    }
}

