/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Ace2.ChromosomeDisambiguator;
import IsoView.ExonSpliceFilter;
import IsoView.RangeDigest;
import IsoView.RangeDigestSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.BAMFileWriter;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAMExcerpt {
    SAMFileWriterImpl bfw;
    SAMFileReader sfr;
    ChromosomeDisambiguator cd = null;
    boolean header_set_up = false;
    boolean suppress_duplicate_output = false;
    boolean single_exon_or_intron_mode = false;
    boolean output_presorted = false;
    boolean suppress_duplicate_output_stacked = false;
    int MAX_STACKED_REFERENCES = 250000;
    int MAX_STACKED_BUCKETS = 25;
    ArrayList<SAMRecord> sam_matches;
    HashSet<SAMRecord> wrote = null;
    ArrayList<HashSet<SAMRecord>> wrote_stack = null;

    public BAMExcerpt() {
        this.bfw = null;
        this.sam_matches = new ArrayList();
    }

    public BAMExcerpt(File excerpt_file, boolean output_presorted) {
        this.output_presorted = output_presorted;
        this.set_output_file(excerpt_file);
    }

    public void set_suppress_duplicate_output(boolean v) {
        this.suppress_duplicate_output = true;
        this.wrote = new HashSet();
    }

    public void set_suppress_duplicate_output_stacked(boolean v) {
        this.suppress_duplicate_output_stacked = true;
        this.wrote_stack = new ArrayList();
    }

    public void set_output_file(File excerpt_file) {
        System.err.println("records in RAM: " + BAMFileWriter.getDefaultMaxRecordsInRam());
        this.bfw = new BAMFileWriter(excerpt_file);
        this.sam_matches = null;
    }

    public void set_source_file(String fn) {
        this.set_source_file(new SAMFileReader(new File(fn)));
    }

    public void set_source_file(File f) {
        this.set_source_file(new SAMFileReader(f));
    }

    public SAMFileHeader get_header() {
        return this.sfr.getFileHeader();
    }

    public void set_source_file(SAMFileReader sfr) {
        this.sfr = sfr;
        this.cd = new ChromosomeDisambiguator(sfr);
        if (!this.header_set_up) {
            if (this.bfw != null) {
                SAMFileHeader header_in = sfr.getFileHeader();
                this.bfw.setSortOrder(header_in.getSortOrder(), this.output_presorted);
                this.bfw.setHeader(header_in);
            }
            this.header_set_up = true;
        }
    }

    public void add_overlapping_records(String ref_name, int start, int end, boolean must_true_align) {
        String local_ref = this.cd.find(ref_name);
        SAMRecordIterator sri = this.sfr.queryOverlapping(local_ref, start, end);
        int usable_count = 0;
        int suppressed_duplicates = 0;
        if (this.suppress_duplicate_output_stacked) {
            this.wrote = new HashSet();
            this.wrote_stack.add(this.wrote);
        }
        while (sri.hasNext()) {
            SAMRecord sr = (SAMRecord)sri.next();
            boolean usable = true;
            if (this.suppress_duplicate_output && this.wrote.contains(sr)) {
                usable = false;
                ++suppressed_duplicates;
            }
            if (this.suppress_duplicate_output_stacked) {
                for (HashSet<SAMRecord> tracker : this.wrote_stack) {
                    if (!tracker.contains(sr)) continue;
                    usable = false;
                    ++suppressed_duplicates;
                    break;
                }
            }
            if (usable && must_true_align) {
                usable = false;
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    int block_start = ab.getReferenceStart();
                    int block_end = block_start + ab.getLength() - 1;
                    if (block_end < start || block_start > end) continue;
                    usable = true;
                    break;
                }
            }
            if (!usable) continue;
            ++usable_count;
            if (this.bfw != null) {
                this.bfw.addAlignment(sr);
            } else {
                this.sam_matches.add(sr);
            }
            if (!this.suppress_duplicate_output && !this.suppress_duplicate_output_stacked) continue;
            this.wrote.add(sr);
        }
        sri.close();
        System.err.println("got:" + usable_count + " duplicates_removed:" + suppressed_duplicates);
        if (this.suppress_duplicate_output_stacked) {
            int count = 0;
            for (HashSet<SAMRecord> tracker : this.wrote_stack) {
                count += tracker.size();
            }
            System.err.println("tracker now contains: " + this.wrote_stack.size() + " trackers and " + count + " elements");
            while (this.wrote_stack.size() > 1 && (count > this.MAX_STACKED_REFERENCES || this.wrote_stack.size() > this.MAX_STACKED_BUCKETS)) {
                HashSet<SAMRecord> tracker;
                tracker = this.wrote_stack.get(0);
                this.wrote_stack.remove(0);
                System.err.println("pop tracker of " + tracker.size() + "; left=" + (count -= tracker.size()));
            }
        }
        HashSet<SAMRecord> saw = new HashSet<SAMRecord>();
        ArrayList<SAMRecord> filtered = new ArrayList<SAMRecord>();
        System.err.print("before dup filter:" + this.sam_matches.size());
        for (SAMRecord sr2 : this.sam_matches) {
            if (!saw.contains(sr2)) {
                filtered.add(sr2);
            }
            saw.add(sr2);
        }
        this.sam_matches = filtered;
        System.err.println(" after:" + this.sam_matches.size());
    }

    public void add_contained_records(String ref_name, RangeDigestSet rds_query, RangeDigestSet rds_acceptable, RangeDigestSet rds_fuzzy, RangeDigestSet rds_introns, boolean exclude_unknown_junctions) {
        System.err.println("fuzzy=" + rds_fuzzy);
        String local_ref = this.cd.find(ref_name);
        int usable_count = 0;
        ExonSpliceFilter esf = new ExonSpliceFilter(rds_introns);
        for (RangeDigest rd : rds_query.get_ranges()) {
            SAMRecordIterator sri = this.sfr.queryOverlapping(local_ref, rd.get_minimum(), rd.get_maximum());
            System.err.println("query: " + local_ref + " " + rd.get_minimum() + "-" + rd.get_maximum());
            while (sri.hasNext()) {
                boolean usable;
                int block_end;
                int block_start;
                SAMRecord sr = (SAMRecord)sri.next();
                boolean is_contained = true;
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    block_start = ab.getReferenceStart();
                    if (rds_acceptable.is_contained(block_start, block_end = block_start + ab.getLength() - 1)) continue;
                    is_contained = false;
                    break;
                }
                if (is_contained) {
                    usable = true;
                } else if (rds_fuzzy != null) {
                    boolean fuzzy_hit = false;
                    for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                        block_start = ab.getReferenceStart();
                        if (!rds_fuzzy.intersects(block_start, block_end = block_start + ab.getLength() - 1)) continue;
                        System.err.println("rescue " + sr.getReadName());
                        fuzzy_hit = true;
                        break;
                    }
                    usable = fuzzy_hit;
                } else {
                    System.err.println("flunk " + sr.getReadName());
                    usable = false;
                }
                if (usable && exclude_unknown_junctions && !esf.check(sr, true)) {
                    usable = false;
                }
                if (usable && this.suppress_duplicate_output && this.wrote.contains(sr)) {
                    usable = false;
                }
                if (!usable) continue;
                ++usable_count;
                if (this.bfw != null) {
                    this.bfw.addAlignment(sr);
                } else {
                    this.sam_matches.add(sr);
                }
                if (!this.suppress_duplicate_output) continue;
                this.wrote.add(sr);
            }
            sri.close();
        }
        HashSet<SAMRecord> saw = new HashSet<SAMRecord>();
        ArrayList<SAMRecord> filtered = new ArrayList<SAMRecord>();
        System.err.print("before dup filter:" + this.sam_matches.size());
        for (SAMRecord sr2 : this.sam_matches) {
            if (!saw.contains(sr2)) {
                filtered.add(sr2);
            }
            saw.add(sr2);
        }
        this.sam_matches = filtered;
        System.err.println(" after:" + this.sam_matches.size());
        System.err.println("got: " + usable_count);
    }

    public void add_intron_records(String ref_name, RangeDigestSet rds_introns) {
        String local_ref = this.cd.find(ref_name);
        int usable_count = 0;
        ExonSpliceFilter esf = new ExonSpliceFilter(rds_introns);
        for (RangeDigest rd : rds_introns.get_ranges()) {
            SAMRecordIterator sri = this.sfr.queryOverlapping(local_ref, rd.get_minimum(), rd.get_maximum());
            while (sri.hasNext()) {
                SAMRecord sr = (SAMRecord)sri.next();
                boolean usable = false;
                if (esf.check(sr, false)) {
                    usable = true;
                }
                if (usable && this.suppress_duplicate_output && this.wrote.contains(sr)) {
                    usable = false;
                }
                if (!usable) continue;
                ++usable_count;
                if (this.bfw != null) {
                    this.bfw.addAlignment(sr);
                } else {
                    this.sam_matches.add(sr);
                }
                if (!this.suppress_duplicate_output) continue;
                this.wrote.add(sr);
            }
            sri.close();
        }
        System.err.println("got: " + usable_count);
    }

    public void add(SAMRecord sr) {
        if (this.bfw != null) {
            this.bfw.addAlignment(sr);
        } else {
            this.sam_matches.add(sr);
        }
    }

    public void close() {
        if (this.bfw != null) {
            this.bfw.close();
        }
    }

    public ArrayList<SAMRecord> get_matches() {
        return this.sam_matches;
    }

    public static void main(String[] argv) {
        SAMFileReader sfr = new SAMFileReader(new File("excerpt_SJSUDEM001_G-FAN101.bam"));
        boolean RAM_MODE = true;
        boolean DOUBLE = true;
        boolean SUPPRESS_DUPLICATE_OUTPUT = true;
        BAMExcerpt be = RAM_MODE ? new BAMExcerpt() : new BAMExcerpt(new File("excerpt.bam"), false);
        if (SUPPRESS_DUPLICATE_OUTPUT) {
            be.set_suppress_duplicate_output(true);
        }
        be.set_source_file(sfr);
        int site = 30891489;
        be.add_overlapping_records("chr8", site, site + 1, false);
        if (DOUBLE) {
            be.add_overlapping_records("chr8", site, site + 1, false);
        }
        be.close();
        if (RAM_MODE) {
            ArrayList<SAMRecord> srs = be.get_matches();
            System.err.println("results: " + srs.size());
        }
    }

    public SAMFileReader get_sfr() {
        return this.sfr;
    }
}

