/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Stats {
    private double mean;
    private double median;
    private double variance;
    private double standard_deviation;

    public Stats(int[] set) {
        ArrayList<Integer> al = new ArrayList<Integer>(set.length);
        for (int i = 0; i < set.length; ++i) {
            al.add(new Integer(set[i]));
        }
        this.setup(al);
    }

    public Stats(List l) {
        this.setup(l);
    }

    private void setup(List l) {
        Collections.sort(l);
        int count = l.size();
        double total = 0.0;
        for (int i = 0; i < count; ++i) {
            total += ((Number)l.get(i)).doubleValue();
        }
        this.mean = total / (double)count;
        this.median = ((Number)l.get(count / 2)).doubleValue();
        double squared_diffs = 0.0;
        for (int i = 0; i < count; ++i) {
            squared_diffs += Math.pow(this.mean - ((Number)l.get(i)).doubleValue(), 2.0);
        }
        this.variance = squared_diffs / (double)count;
        this.standard_deviation = Math.sqrt(this.variance);
    }

    public double mean() {
        return this.mean;
    }

    public double median() {
        return this.median;
    }

    public double variance() {
        return this.variance;
    }

    public double standard_deviation() {
        return this.standard_deviation;
    }

    public static void main(String[] argv) {
        int[] values = new int[]{1, 2, 3, 4, 10, 20, 300};
        Stats s = new Stats(values);
    }

    public double get_95_percent_confidence_interval(boolean above) {
        double delta = this.standard_deviation * 1.96;
        if (!above) {
            delta *= -1.0;
        }
        return this.mean + delta;
    }
}

