/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.IndelInfo;
import Ace2.SAMMismatchFilter;
import Ace2.SAMUtils;
import Ace2.SNPConfig;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMIndelFilter {
    private ArrayList<IndelInfo> info = null;
    private ArrayList<IndelInfo> info_broad = null;
    private static boolean VERBOSE = false;
    private SNPConfig config;

    public SAMIndelFilter(SNPConfig config) {
        this.config = config;
    }

    public SAMIndelFilter() {
        this.config = new SNPConfig();
    }

    public boolean filter(SAMRecord sr) throws IOException {
        Cigar c = sr.getCigar();
        byte[] read = sr.getReadBases();
        byte[] qual = sr.getBaseQualities();
        byte[] read_masked = null;
        if (qual.length != read.length) {
            System.err.println("ERROR: read " + sr.getReadName() + " length " + sr.getReadLength() + " does not match quality length " + qual.length);
            return false;
        }
        int read_i = 0;
        int ref_i = sr.getUnclippedStart() - 1;
        this.info_broad = null;
        this.info = null;
        for (CigarElement ce : c.getCigarElements()) {
            CigarOperator co;
            block38: {
                boolean mask_ok;
                boolean broad_quality_ok;
                IndelInfo ii;
                boolean quality_ok;
                int len;
                block40: {
                    int i;
                    int end;
                    block39: {
                        int avg;
                        co = ce.getOperator();
                        len = ce.getLength();
                        if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.SOFT_CLIP) || co.equals((Object)CigarOperator.EQ) || co.equals((Object)CigarOperator.X)) {
                            read_i += len;
                            ref_i += len;
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.HARD_CLIP)) {
                            ref_i += len;
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.DELETION)) {
                            boolean broad_quality_ok2;
                            if (read_masked == null) {
                                read_masked = SAMMismatchFilter.generate_masked_sequence(read, this.config);
                            }
                            if (VERBOSE) {
                                System.err.println("possible deletion at " + (ref_i + 1));
                                System.err.println("     raw=" + new String(read));
                                System.err.println("  masked=" + new String(read_masked));
                            }
                            boolean mask_ok2 = true;
                            boolean bl = quality_ok = qual[read_i - 1] >= this.config.MIN_QUALITY && qual[read_i] >= this.config.MIN_QUALITY;
                            if (this.config.ENABLE_POLY_X_RUN_MASK_INDEL && len <= this.config.POLY_X_RUN_INDEL_MAX_LENGTH && (read_masked[read_i - 1] == SAMMismatchFilter.MASK_CHAR || read_masked[read_i] == SAMMismatchFilter.MASK_CHAR)) {
                                mask_ok2 = false;
                            }
                            IndelInfo ii2 = new IndelInfo(CigarOperator.DELETION, ref_i, ce.getLength(), sr, read_i);
                            boolean bl2 = broad_quality_ok2 = qual[read_i - 1] >= this.config.BROAD_BASE_TRACKING_MIN_QUALITY && qual[read_i] >= this.config.BROAD_BASE_TRACKING_MIN_QUALITY;
                            if (broad_quality_ok2 && mask_ok2) {
                                if (this.info_broad == null) {
                                    this.info_broad = new ArrayList();
                                }
                                this.info_broad.add(ii2);
                            }
                            if (quality_ok && this.config.MIN_FLANKING_QUALITY_WINDOW > 0) {
                                quality_ok = SAMUtils.flanking_quality_check(qual, read_i, 0, this.config.MIN_FLANKING_QUALITY, this.config.MIN_FLANKING_QUALITY_WINDOW, this.config.ILLUMINA_QUALITY_2_RUN_MODE);
                            }
                            if (!quality_ok && this.config.SKIP_NT_QUALITY_CHECKS_FOR_HIGH_MAPQ_INDELS && len >= this.config.HIGH_MAPQ_INDEL_MIN_LENGTH && sr.getMappingQuality() >= this.config.HIGH_MAPQ_INDEL_MIN_MAPQ) {
                                if (VERBOSE) {
                                    System.err.println("forced accepting quality-flunked deletion: " + sr.getReadName() + " len=" + len + " mapq=" + sr.getMappingQuality());
                                }
                                quality_ok = true;
                            }
                            if (quality_ok && mask_ok2) {
                                if (this.info == null) {
                                    this.info = new ArrayList();
                                }
                                this.info.add(ii2);
                            }
                            ref_i += len;
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.PADDING)) continue;
                        if (co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                            ref_i += len;
                            continue;
                        }
                        if (!co.equals((Object)CigarOperator.INSERTION)) break block38;
                        if (read_masked == null) {
                            read_masked = SAMMismatchFilter.generate_masked_sequence(read, this.config);
                        }
                        ii = new IndelInfo(CigarOperator.INSERTION, ref_i, len, sr, read_i);
                        quality_ok = true;
                        broad_quality_ok = true;
                        mask_ok = true;
                        end = read_i + len;
                        ii.sequence = new String(read, read_i, len);
                        if (!this.config.AVERAGE_INSERTION_QUALITY) break block39;
                        int total = 0;
                        for (i = read_i; i < end; ++i) {
                            if (VERBOSE) {
                                System.err.println(sr.getReadName() + " i=" + read_i + " q=" + qual[i] + " mq=" + this.config.MIN_QUALITY);
                            }
                            total += qual[i];
                            if (!this.config.ENABLE_POLY_X_RUN_MASK_INDEL || len > this.config.POLY_X_RUN_INDEL_MAX_LENGTH || read_masked[i] != SAMMismatchFilter.MASK_CHAR) continue;
                            if (VERBOSE) {
                                System.err.println("mask flunk");
                            }
                            mask_ok = false;
                            break;
                        }
                        if ((avg = total / len) < this.config.MIN_QUALITY) {
                            if (VERBOSE) {
                                System.err.println("flunk");
                            }
                            quality_ok = false;
                        }
                        if (avg >= this.config.BROAD_BASE_TRACKING_MIN_QUALITY) break block40;
                        broad_quality_ok = false;
                        break block40;
                    }
                    for (i = read_i; i < end; ++i) {
                        if (VERBOSE) {
                            System.err.println(sr.getReadName() + " i=" + read_i + " q=" + qual[i] + " mq=" + this.config.MIN_QUALITY);
                        }
                        if (qual[i] < this.config.MIN_QUALITY) {
                            quality_ok = false;
                        }
                        if (qual[i] < this.config.BROAD_BASE_TRACKING_MIN_QUALITY) {
                            broad_quality_ok = false;
                        }
                        if (!this.config.ENABLE_POLY_X_RUN_MASK_INDEL || len > this.config.POLY_X_RUN_INDEL_MAX_LENGTH || read_masked[i] != SAMMismatchFilter.MASK_CHAR) continue;
                        if (VERBOSE) {
                            System.err.println("mask flunk");
                        }
                        mask_ok = false;
                        break;
                    }
                }
                if (broad_quality_ok && mask_ok) {
                    if (this.info_broad == null) {
                        this.info_broad = new ArrayList();
                    }
                    this.info_broad.add(ii);
                }
                if (quality_ok && this.config.MIN_FLANKING_QUALITY_WINDOW > 0) {
                    if (VERBOSE) {
                        System.err.println("before flank qual check: " + quality_ok + " mfq=" + this.config.MIN_FLANKING_QUALITY + " win=" + this.config.MIN_FLANKING_QUALITY_WINDOW);
                    }
                    quality_ok = SAMUtils.flanking_quality_check(qual, read_i, len, this.config.MIN_FLANKING_QUALITY, this.config.MIN_FLANKING_QUALITY_WINDOW, this.config.ILLUMINA_QUALITY_2_RUN_MODE);
                    if (VERBOSE) {
                        System.err.println("after flank qual check: " + quality_ok);
                    }
                }
                if (!quality_ok && this.config.SKIP_NT_QUALITY_CHECKS_FOR_HIGH_MAPQ_INDELS && len >= this.config.HIGH_MAPQ_INDEL_MIN_LENGTH && sr.getMappingQuality() >= this.config.HIGH_MAPQ_INDEL_MIN_MAPQ) {
                    if (VERBOSE) {
                        System.err.println("forced accepting quality-flunked insertion: " + sr.getReadName() + " len=" + len + " mapq=" + sr.getMappingQuality());
                    }
                    quality_ok = true;
                }
                if (quality_ok && mask_ok) {
                    if (this.info == null) {
                        this.info = new ArrayList();
                    }
                    this.info.add(ii);
                } else if (VERBOSE) {
                    System.err.println("insertion quality flunk for " + sr.getReadName());
                }
                read_i += len;
                continue;
            }
            throw new IOException("ERROR: unhandled SAM CIGAR operator " + co + " for " + sr.getReadName() + " at " + sr.getReferenceName() + " " + sr.getAlignmentStart());
        }
        return this.info != null;
    }

    public ArrayList<IndelInfo> get_indels() {
        return this.info;
    }

    public ArrayList<IndelInfo> get_broad_indels() {
        return this.info_broad;
    }
}

