/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.WorkingFile;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;

public class SAMFinneyCoverage {
    public static int MIN_QUALITY = 15;
    private static boolean VERBOSE_MODE = false;
    private static boolean WIG_MODE = false;
    private static boolean SKIP_DUPLICATE_READS = true;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private boolean STDOUT_MODE = false;
    public static int CHR_I_START = 0;
    public static int CHR_I_END = 24;
    private int[] chr_sizes = new int[]{247249719, 242951149, 199501827, 191273063, 180857866, 170899992, 158821424, 146274826, 140273252, 135374737, 134452384, 132349534, 114142980, 106368585, 100338915, 88827254, 78774742, 76117153, 63811651, 62435964, 46944323, 49691432, 154913754, 57772954, 16571};
    private String outfile;
    PrintStream ps = System.err;
    private File bam_file = null;

    public void set_outfile(String outfile) {
        this.outfile = outfile;
    }

    public void set_bam_file(File f) {
        this.bam_file = f;
    }

    public void set_verbose(boolean v) {
        VERBOSE_MODE = v;
    }

    public void set_skip_duplicates(boolean v) {
        SKIP_DUPLICATE_READS = v;
    }

    public void set_wig(boolean v) {
        WIG_MODE = v;
    }

    public void set_stdout_mode(boolean v) {
        this.STDOUT_MODE = v;
    }

    public void find_coverage() throws IOException {
        System.err.println("skipping duplicate reads?: " + SKIP_DUPLICATE_READS);
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.bam_file);
        WorkingFile wf = null;
        if (!this.STDOUT_MODE) {
            if (this.outfile == null) {
                this.outfile = this.bam_file.getName() + (WIG_MODE ? ".wig" : ".coverage");
            }
            System.err.println("outfile=" + this.outfile);
            wf = new WorkingFile(this.outfile);
        }
        DataOutputStream dos = null;
        PrintStream ps = null;
        boolean allow_non_hg18 = WIG_MODE;
        if (WIG_MODE) {
            if (this.STDOUT_MODE) {
                FileOutputStream fdout = new FileOutputStream(FileDescriptor.out);
                BufferedOutputStream bos = new BufferedOutputStream(fdout, 4096);
                ps = new PrintStream(bos, false);
            } else {
                FilterOutputStream os = new BufferedOutputStream(new FileOutputStream(wf));
                if (this.outfile.indexOf(".gz") == this.outfile.length() - 3) {
                    System.err.println("generating GZ wig file");
                    os = new GZIPOutputStream(os);
                }
                ps = new PrintStream(os);
            }
        } else {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(wf)));
        }
        Object[] chr_labels = new String[25];
        Chromosome[] chroms = new Chromosome[25];
        Arrays.fill(chr_labels, null);
        SAMFileHeader h = reader.getFileHeader();
        SAMSequenceDictionary dict = h.getSequenceDictionary();
        boolean ref_mismatch = false;
        for (SAMSequenceRecord ssr : dict.getSequences()) {
            int wanted_len;
            String ref_name = ssr.getSequenceName();
            Chromosome c = Chromosome.valueOfString(ref_name);
            if (c == null) continue;
            int c_index = c.toInt() - 1;
            chr_labels[c_index] = ref_name;
            chroms[c_index] = c;
            int ref_len = ssr.getSequenceLength();
            if (ref_len == (wanted_len = this.chr_sizes[c_index])) continue;
            System.err.println("chr=" + (Object)((Object)c) + " bam_ref_len=" + ref_len + " hg18_chr_len=" + wanted_len);
            ref_mismatch = true;
            if (!allow_non_hg18) continue;
            this.chr_sizes[c_index] = ref_len;
        }
        if (ref_mismatch) {
            String tag = allow_non_hg18 ? "NOTE" : "ERROR";
            System.err.print(tag + ": .bam reference sequences don't appear to be hg18");
            if (!allow_non_hg18) {
                System.err.println(", not generating coverage");
                return;
            }
            System.err.println("");
        }
        int null_qual = 0;
        int qual_length_problem = 0;
        int qual_bounds_problem = 0;
        for (int chr_i = CHR_I_START; chr_i <= CHR_I_END; ++chr_i) {
            int i;
            int coverage_len = this.chr_sizes[chr_i];
            int[] coverage = new int[coverage_len];
            Object ref_name = chr_labels[chr_i];
            boolean has_coverage = false;
            long record_count = 0L;
            if (ref_name == null) {
                System.err.println("WTF: no .bam mappings vs. chr index " + chr_i);
            } else {
                System.err.println("CHR " + (String)ref_name);
                if (VERBOSE_MODE) {
                    System.err.println("query=" + (String)ref_name + " size=" + coverage_len);
                }
                SAMRecordIterator iterator = reader.queryOverlapping((String)ref_name, 1, coverage_len);
                while (iterator.hasNext()) {
                    SAMRecord sr = (SAMRecord)iterator.next();
                    ++record_count;
                    if (VERBOSE_MODE) {
                        System.err.print(sr.getReadName() + " unmapped=" + sr.getReadUnmappedFlag() + " dup=" + sr.getDuplicateReadFlag());
                        if (!sr.getReadUnmappedFlag()) {
                            System.err.print(" pos=" + sr.getAlignmentStart() + "-" + sr.getAlignmentEnd());
                        }
                        System.err.println("");
                    }
                    if (sr.getReadUnmappedFlag() || SKIP_DUPLICATE_READS && sr.getDuplicateReadFlag()) continue;
                    has_coverage = true;
                    byte[] read = sr.getReadBases();
                    byte[] quals = sr.getBaseQualities();
                    if (quals.length == 0) {
                        if (null_qual++ != 0) continue;
                        System.err.println("ERROR: 0-length qual array for " + sr.getReadName() + " (only warning, counts at end of run)");
                        continue;
                    }
                    if (read.length != quals.length) {
                        if (qual_length_problem++ != 0) continue;
                        System.err.println("ERROR: base/qual length mismatch for " + sr.getReadName() + "(" + read.length + " vs " + quals.length + "; only warning, counts at end of run)");
                        continue;
                    }
                    for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                        int read_i = ab.getReadStart() - 1;
                        int ref_i = ab.getReferenceStart() - 1;
                        i = read_i;
                        int end = read_i + ab.getLength();
                        while (i < end) {
                            if (i >= quals.length) {
                                if (qual_bounds_problem++ == 0) {
                                    System.err.println("quality index out of range for " + sr.getReadName() + " align_start=" + sr.getAlignmentStart() + " align_end=" + sr.getAlignmentEnd() + " ref_base=" + (ref_i + 1) + " block count:" + sr.getAlignmentBlocks().size() + " block_start=" + ab.getReadStart() + " block_len=" + ab.getLength() + " read_index=" + i + " read_len=" + read.length + " qual_len=" + quals.length);
                                    System.err.println("qual array:");
                                    for (int q = 0; q < quals.length; ++q) {
                                        System.err.println(q + "=" + quals[q]);
                                    }
                                }
                            } else if (quals[i] >= MIN_QUALITY && ref_i >= 0 && ref_i < coverage_len) {
                                int n = ref_i;
                                coverage[n] = coverage[n] + 1;
                            }
                            ++i;
                            ++ref_i;
                        }
                    }
                }
                iterator.close();
            }
            if (VERBOSE_MODE) {
                System.err.println("records returned: " + record_count);
            }
            if (WIG_MODE) {
                if (!has_coverage) continue;
                ps.println("fixedStep chrom=" + chroms[chr_i].toString() + " start=1 step=1");
                for (i = 0; i < coverage_len; ++i) {
                    ps.println(Integer.toString(coverage[i]));
                }
                continue;
            }
            for (i = 0; i < coverage_len; ++i) {
                int c = coverage[i];
                if (c > 65535) {
                    c = 65535;
                }
                dos.write(c);
                dos.write(c >> 8);
            }
        }
        if (null_qual > 0) {
            System.err.println("ERROR: " + null_qual + " reads w/0-length base qualities");
        }
        if (qual_length_problem > 0) {
            System.err.println("ERROR: " + qual_length_problem + " reads w/base/quality array length mismatches");
        }
        if (qual_bounds_problem > 0) {
            System.err.println("ERROR: " + qual_bounds_problem + " instances of AlignmentBlock read index > base quality array size");
        }
        if (dos != null) {
            dos.close();
        }
        if (ps != null) {
            ps.close();
        }
        if (wf != null) {
            wf.finish();
        }
    }

    public static void main(String[] argv) {
        File bam_file = null;
        SAMFinneyCoverage sc = new SAMFinneyCoverage();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-bam")) {
                bam_file = new File(argv[++i]);
                continue;
            }
            if (argv[i].equals("-verbose")) {
                sc.set_verbose(true);
                continue;
            }
            if (argv[i].equals("-wig")) {
                sc.set_wig(true);
                continue;
            }
            if (argv[i].equals("-of")) {
                sc.set_outfile(new String(argv[++i]));
                continue;
            }
            if (argv[i].equals("-stdout")) {
                sc.set_stdout_mode(true);
                continue;
            }
            if (argv[i].equals("-count-duplicates")) {
                sc.set_skip_duplicates(false);
                continue;
            }
            if (argv[i].equals("-chr-i-start")) {
                CHR_I_START = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-chr-i-end")) {
                CHR_I_END = Integer.parseInt(argv[++i]);
                continue;
            }
            System.err.println("error: unknown switch " + argv[i]);
            System.exit(1);
        }
        String error = null;
        if (bam_file == null) {
            error = "specify -bam [file]";
        }
        if (error != null) {
            System.err.println("ERROR: " + error);
        } else if (bam_file != null) {
            try {
                sc.set_bam_file(bam_file);
                sc.find_coverage();
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

