/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.WorkingFile;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;

public class SAMCoverage2 {
    public int MIN_QUALITY = 15;
    PrintStream ps = System.out;
    private String name = null;
    private boolean verbose_mode = false;
    boolean WIG_MODE = true;
    boolean WIG_BASES_MODE = false;
    boolean VERBOSE_MODE = false;
    boolean STDOUT_MODE = false;
    boolean SKIP_DUPLICATE_READS = true;
    private File bam_file = null;
    private String outfile = null;

    public void set_outfile(String outfile) {
        this.outfile = outfile;
    }

    public void set_stdout_mode(boolean v) {
        this.STDOUT_MODE = v;
    }

    public void set_bam_file(File f) {
        this.bam_file = f;
    }

    public void set_verbose(boolean v) {
        this.VERBOSE_MODE = v;
    }

    public void set_skip_duplicates(boolean v) {
        this.SKIP_DUPLICATE_READS = v;
    }

    public void set_wig(boolean v) {
        this.WIG_MODE = v;
    }

    public void set_wig_bases(boolean v) {
        this.WIG_BASES_MODE = v;
    }

    public void find_coverage() throws IOException {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.bam_file);
        WorkingFile wf = null;
        if (!this.STDOUT_MODE) {
            if (this.outfile == null) {
                this.outfile = this.bam_file.getName() + (this.WIG_MODE ? ".wig" : ".coverage");
            }
            System.err.println("outfile=" + this.outfile);
            wf = new WorkingFile(this.outfile);
        }
        if (this.STDOUT_MODE) {
            FileOutputStream fdout = new FileOutputStream(FileDescriptor.out);
            BufferedOutputStream bos = new BufferedOutputStream(fdout, 4096);
            this.ps = new PrintStream(bos, false);
        } else if (this.WIG_MODE) {
            FilterOutputStream os = new BufferedOutputStream(new FileOutputStream(wf));
            if (this.outfile.indexOf(".gz") == this.outfile.length() - 3) {
                System.err.println("generating gzipped wig file");
                os = new GZIPOutputStream(os);
            }
            this.ps = new PrintStream(os);
        } else {
            throw new IOException("unknown output format");
        }
        SAMFileHeader h = reader.getFileHeader();
        SAMSequenceDictionary dict = h.getSequenceDictionary();
        boolean ref_mismatch = false;
        ArrayList<SAMSequenceRecord> references = new ArrayList<SAMSequenceRecord>();
        for (SAMSequenceRecord ssr : dict.getSequences()) {
            references.add(ssr);
        }
        int null_qual = 0;
        int qual_length_problem = 0;
        for (SAMSequenceRecord ssr : references) {
            int i;
            int[] count_t;
            int[] count_g;
            int[] count_c;
            int[] count_a;
            int coverage_len = ssr.getSequenceLength();
            int[] coverage = new int[coverage_len];
            if (this.WIG_BASES_MODE) {
                count_a = new int[coverage_len];
                count_c = new int[coverage_len];
                count_g = new int[coverage_len];
                count_t = new int[coverage_len];
            } else {
                count_t = null;
                count_g = null;
                count_c = null;
                count_a = null;
            }
            String ref_name = ssr.getSequenceName();
            boolean has_coverage = false;
            long record_count = 0L;
            System.err.println("processing " + ref_name);
            if (this.VERBOSE_MODE) {
                System.err.println("query=" + ref_name + " size=" + coverage_len);
            }
            SAMRecordIterator iterator = reader.queryOverlapping(ref_name, 1, coverage_len);
            while (iterator.hasNext()) {
                SAMRecord sr = (SAMRecord)iterator.next();
                ++record_count;
                if (this.VERBOSE_MODE) {
                    System.err.print(sr.getReadName() + " unmapped=" + sr.getReadUnmappedFlag() + " dup=" + sr.getDuplicateReadFlag());
                    if (!sr.getReadUnmappedFlag()) {
                        System.err.print(" pos=" + sr.getAlignmentStart() + "-" + sr.getAlignmentEnd());
                    }
                    System.err.println("");
                }
                if (sr.getReadUnmappedFlag() || this.SKIP_DUPLICATE_READS && sr.getDuplicateReadFlag()) continue;
                has_coverage = true;
                byte[] read = sr.getReadBases();
                byte[] quals = sr.getBaseQualities();
                if (quals.length == 0) {
                    if (null_qual++ != 0) continue;
                    System.err.println("ERROR: 0-length qual array for " + sr.getReadName() + " (only warning, counts at end of run)");
                    continue;
                }
                if (read.length != quals.length) {
                    if (qual_length_problem++ != 0) continue;
                    System.err.println("ERROR: base/qual lenght mismatch for " + sr.getReadName() + "(" + read.length + " vs " + quals.length + "; only warning, counts at end of run)");
                    continue;
                }
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    int read_i = ab.getReadStart() - 1;
                    int ref_i = ab.getReferenceStart() - 1;
                    i = read_i;
                    int end = read_i + ab.getLength();
                    while (i < end) {
                        if (quals[i] >= this.MIN_QUALITY && ref_i >= 0 && ref_i < coverage_len) {
                            int n = ref_i;
                            coverage[n] = coverage[n] + 1;
                            if (this.WIG_BASES_MODE) {
                                if (read[i] == 97 || read[i] == 65) {
                                    int n2 = ref_i;
                                    count_a[n2] = count_a[n2] + 1;
                                } else if (read[i] == 99 || read[i] == 67) {
                                    int n3 = ref_i;
                                    count_c[n3] = count_c[n3] + 1;
                                } else if (read[i] == 103 || read[i] == 71) {
                                    int n4 = ref_i;
                                    count_g[n4] = count_g[n4] + 1;
                                } else if (read[i] == 116 || read[i] == 84) {
                                    int n5 = ref_i;
                                    count_t[n5] = count_t[n5] + 1;
                                } else {
                                    System.err.println("not counting base " + (char)read[i]);
                                }
                            }
                        }
                        ++i;
                        ++ref_i;
                    }
                }
            }
            iterator.close();
            if (this.VERBOSE_MODE) {
                System.err.println("records returned: " + record_count);
            }
            if (this.WIG_MODE) {
                if (!has_coverage) continue;
                String pretty = ref_name;
                if (pretty.indexOf("chr") != 0) {
                    pretty = "chr" + pretty;
                }
                this.ps.println("fixedStep chrom=" + pretty + " start=1 step=1");
                if (this.WIG_BASES_MODE) {
                    for (i = 0; i < coverage_len; ++i) {
                        this.ps.println(Integer.toString(coverage[i]) + "," + Integer.toString(count_a[i]) + "," + Integer.toString(count_c[i]) + "," + Integer.toString(count_g[i]) + "," + Integer.toString(count_t[i]));
                    }
                    continue;
                }
                for (i = 0; i < coverage_len; ++i) {
                    this.ps.println(Integer.toString(coverage[i]));
                }
                continue;
            }
            throw new IOException("ERROR: unknown output format");
        }
        if (null_qual > 0) {
            System.err.println("ERROR: " + null_qual + " reads w/0-length base qualities");
        }
        if (qual_length_problem > 0) {
            System.err.println("ERROR: " + qual_length_problem + " reads w/base/quality array length mismatches");
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (wf != null) {
            wf.finish();
        }
    }

    public static void main(String[] argv) {
        File bam_file = null;
        SAMCoverage2 sc = new SAMCoverage2();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-bam")) {
                bam_file = new File(argv[++i]);
                continue;
            }
            if (argv[i].equals("-verbose")) {
                sc.set_verbose(true);
                continue;
            }
            if (argv[i].equals("-wig-bases")) {
                sc.set_wig(true);
                sc.set_wig_bases(true);
                continue;
            }
            if (argv[i].equals("-wig")) {
                sc.set_wig(true);
                continue;
            }
            if (argv[i].equals("-of")) {
                sc.set_outfile(new String(argv[++i]));
                continue;
            }
            if (argv[i].equals("-count-duplicates")) {
                sc.set_skip_duplicates(false);
                continue;
            }
            if (argv[i].equals("-stdout")) {
                sc.set_stdout_mode(true);
                continue;
            }
            System.err.println("error: unknown switch " + argv[i]);
            System.exit(1);
        }
        String error = null;
        if (bam_file == null) {
            error = "specify -bam [file]";
        }
        if (error != null) {
            System.err.println("ERROR: " + error);
        } else if (bam_file != null) {
            try {
                sc.set_bam_file(bam_file);
                sc.find_coverage();
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

