/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Range;
import Ace2.SAMRegion;
import Ace2.SAMResource;
import Ace2.WorkingFile;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public class SAMCoverage {
    public int MIN_QUALITY = 15;
    private String outfile;
    PrintStream ps = System.out;
    private String name = null;
    private boolean verbose_mode = false;

    public void set_outfile(String outfile) {
        this.outfile = outfile;
    }

    public void set_name(String name) {
        this.name = name;
    }

    public void set_verbose(boolean v) {
        this.verbose_mode = v;
    }

    public void set_min_quality(int q) {
        this.MIN_QUALITY = q;
    }

    public void setPrintStream(PrintStream ps) {
        this.ps = ps;
    }

    public void find_coverage(SAMResource sres) {
        int start_base = sres.region.range.start;
        int end_base = sres.region.range.end;
        int coverage_len = end_base - start_base + 1;
        int[] coverage = new int[coverage_len];
        Arrays.fill(coverage, 0);
        WorkingFile wf = null;
        if (this.outfile != null) {
            try {
                wf = new WorkingFile(this.outfile);
                this.ps = wf.getPrintStream();
            }
            catch (Exception e) {
                System.err.println("I/O error: " + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
        try {
            int i;
            CloseableIterator<SAMRecord> iterator = sres.get_iterator();
            int read_count = 0;
            int ref_min = -1;
            int ref_max = -1;
            while (iterator.hasNext()) {
                SAMRecord sr = (SAMRecord)iterator.next();
                ++read_count;
                if (sr.getReadUnmappedFlag()) continue;
                if (sr.getDuplicateReadFlag()) {
                    if (!this.verbose_mode) continue;
                    System.err.println(sr.getReadName() + "." + (sr.getReadNegativeStrandFlag() ? "R" : "F") + " ignoring, duplicate");
                    continue;
                }
                byte[] read = sr.getReadBases();
                byte[] quals = sr.getBaseQualities();
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    int len = ab.getLength();
                    int read_i = ab.getReadStart() - 1;
                    int ref_i = ab.getReferenceStart() - start_base;
                    if (ref_min == -1 || ref_i < ref_min) {
                        ref_min = ref_i;
                    }
                    i = read_i;
                    int end = read_i + len;
                    while (i < end) {
                        if (ref_i >= 0 && ref_i < coverage_len) {
                            if (quals[i] >= this.MIN_QUALITY) {
                                if (this.verbose_mode) {
                                    System.err.println(sr.getReadName() + "." + (sr.getReadNegativeStrandFlag() ? "R" : "F") + " hit at " + (ref_i + start_base) + " as=" + sr.getAlignmentStart() + " ae=" + sr.getAlignmentEnd());
                                }
                                int n = ref_i;
                                coverage[n] = coverage[n] + 1;
                            } else if (this.verbose_mode) {
                                System.err.println(sr.getReadName() + "." + (sr.getReadNegativeStrandFlag() ? "R" : "F") + " qual_reject at " + (ref_i + start_base) + " as=" + sr.getAlignmentStart() + " ae=" + sr.getAlignmentEnd());
                            }
                        }
                        ++i;
                        ++ref_i;
                    }
                    if (ref_max != -1 && ref_i <= ref_max) continue;
                    ref_max = ref_i;
                }
            }
            sres.close();
            System.err.println("records:" + read_count + " ref_min:" + (ref_min + start_base) + " ref_max:" + (ref_max + start_base));
            for (i = 0; i < coverage.length; ++i) {
                if (this.name != null) {
                    this.ps.print(this.name + ",");
                }
                this.ps.println(i + start_base + "," + coverage[i]);
            }
            if (wf != null) {
                wf.finish();
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        block29: {
            SAMResource sr = null;
            SAMRegion region = new SAMRegion();
            region.range = new Range();
            region.range.start = -1;
            region.range.end = -1;
            String outfile = null;
            String target_file = null;
            SAMCoverage sc = new SAMCoverage();
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-bam")) {
                    sr = new SAMResource();
                    sr.set_file(argv[++i]);
                    sr.detect_sample_id();
                    continue;
                }
                if (argv[i].equals("-targets")) {
                    target_file = argv[++i];
                    continue;
                }
                if (argv[i].equals("-tname")) {
                    region.tname = argv[++i];
                    continue;
                }
                if (argv[i].equals("-verbose")) {
                    sc.set_verbose(true);
                    continue;
                }
                if (argv[i].equals("-tstart")) {
                    region.range.start = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-tend")) {
                    region.range.end = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-of")) {
                    outfile = argv[++i];
                    continue;
                }
                if (argv[i].equals("-min-quality")) {
                    sc.set_min_quality(Integer.parseInt(argv[++i]));
                    continue;
                }
                System.err.println("error: unknown switch " + argv[i]);
                System.exit(1);
            }
            String error = null;
            if (sr == null) {
                error = "specify -bam [file]";
            } else if (target_file == null) {
                if (region.tname == null) {
                    error = "specify -tname";
                } else if (region.range.start == -1) {
                    error = "specify -tstart";
                } else if (region.range.end == -1) {
                    error = "specify -tend";
                }
            }
            try {
                sr.set_region(region);
            }
            catch (Exception e) {
                error = "exception setting region";
            }
            if (error != null) {
                System.err.println("ERROR: " + error);
            } else if (target_file != null) {
                try {
                    File f = new File(target_file);
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    String line = br.readLine();
                    String[] headers = line.split("\t");
                    if (headers[0].equals("Name") && headers[1].equals("Chromosome") && headers[2].equals("Start") && headers[3].equals("End")) {
                        WorkingFile wf = null;
                        if (outfile != null) {
                            wf = new WorkingFile(outfile);
                            sc.setPrintStream(wf.getPrintStream());
                        }
                        while ((line = br.readLine()) != null) {
                            String[] row = line.split("\t");
                            region.tname = row[1];
                            region.range.start = Integer.parseInt(row[2]);
                            region.range.end = Integer.parseInt(row[3]);
                            sc.set_name(new String(row[0]) + "," + new String(row[1]));
                            sc.find_coverage(sr);
                        }
                        if (outfile != null) {
                            wf.finish();
                        }
                        break block29;
                    }
                    throw new IOException("file format error");
                }
                catch (Exception e) {
                    System.err.println("ERROR: " + e);
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                sc.set_outfile(outfile);
                sc.find_coverage(sr);
            }
        }
    }
}

