/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.SAMUtils;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class SAMConsensusBuilder {
    private int start_offset = 0;
    private byte[] reference_sequence;
    private char[] consensus;
    private HashMap<Integer, Integer> gaps = null;
    private ArrayList<SAMRecord[]> all_sams = new ArrayList();
    private boolean need_digest = true;
    private static final boolean VERBOSE = false;
    private boolean REFERENCE_IS_PADDED = false;

    public SAMConsensusBuilder(byte[] reference_sequence) {
        this.reference_sequence = reference_sequence;
    }

    public SAMConsensusBuilder(byte[] reference_sequence, int start_offset) {
        this.reference_sequence = reference_sequence;
        this.start_offset = start_offset;
    }

    public void set_start_offset(int i) {
        this.start_offset = i;
    }

    public char[] get_consensus() {
        return this.consensus;
    }

    public byte[] get_reference_sequence() {
        return this.reference_sequence;
    }

    public void add_samrecords(SAMRecord[] sams) {
        this.all_sams.add(sams);
        this.need_digest = true;
    }

    public void digest_sams() throws IOException {
        block23: {
            int i;
            int len;
            CigarOperator co;
            int ai;
            SAMRecord sr;
            int si = 0;
            HashSet last_gap_positions = null;
            this.gaps = new HashMap();
            for (SAMRecord[] sams : this.all_sams) {
                for (si = 0; si < sams.length; ++si) {
                    sr = sams[si];
                    HashMap<Integer, Integer> local_cumulative_gaps = new HashMap<Integer, Integer>();
                    ai = sr.getUnclippedStart() - this.start_offset;
                    Cigar c = sr.getCigar();
                    for (CigarElement ce : c.getCigarElements()) {
                        co = ce.getOperator();
                        len = ce.getLength();
                        if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.SOFT_CLIP) || co.equals((Object)CigarOperator.EQ) || co.equals((Object)CigarOperator.X)) {
                            ai += len;
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.DELETION) || co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                            if (last_gap_positions != null) {
                                for (i = 0; i < len; ++i) {
                                    if (last_gap_positions.contains(ai)) {
                                        --i;
                                    }
                                    ++ai;
                                }
                                continue;
                            }
                            ai += len;
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.INSERTION)) {
                            Integer og;
                            Integer key = ai;
                            Integer gap_size = len;
                            Integer prev_local_size = (Integer)local_cumulative_gaps.get(key);
                            if (prev_local_size != null) {
                                gap_size = gap_size + prev_local_size;
                            }
                            if ((og = this.gaps.get(key)) == null || gap_size > og) {
                                this.gaps.put(key, gap_size);
                            }
                            local_cumulative_gaps.put(key, gap_size);
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.HARD_CLIP)) {
                            ai += len;
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.PADDING)) continue;
                        throw new IOException("ERROR: unhandled SAM operator " + co + " for " + SAMUtils.get_printable_read_name(sr));
                    }
                }
            }
            boolean indel_contention = false;
            HashSet<Integer> gap_positions = new HashSet<Integer>();
            for (Integer gap_pos : this.gaps.keySet()) {
                len = this.gaps.get(gap_pos);
                for (i = gap_pos + (len - 1); i >= gap_pos; --i) {
                    gap_positions.add(i);
                }
            }
            for (SAMRecord[] sams : this.all_sams) {
                for (si = 0; si < sams.length; ++si) {
                    sr = sams[si];
                    ai = sr.getUnclippedStart() - this.start_offset;
                    Cigar c = sr.getCigar();
                    for (CigarElement ce : c.getCigarElements()) {
                        co = ce.getOperator();
                        len = ce.getLength();
                        if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.SOFT_CLIP) || co.equals((Object)CigarOperator.HARD_CLIP) || co.equals((Object)CigarOperator.EQ) || co.equals((Object)CigarOperator.X)) {
                            ai += len;
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.INSERTION)) {
                            ai += len;
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.DELETION) || co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                            i = 0;
                            while (i < len) {
                                if (gap_positions.contains(ai)) {
                                    indel_contention = true;
                                }
                                ++i;
                                ++ai;
                            }
                            continue;
                        }
                        if (co.equals((Object)CigarOperator.PADDING)) continue;
                        throw new IOException("ERROR: unhandled SAM operator " + co + " for " + SAMUtils.get_printable_read_name(sr));
                    }
                }
            }
            if (!indel_contention) break block23;
            ArrayList<Integer> gp = new ArrayList<Integer>();
            for (Integer pos : gap_positions) {
                gp.add(pos + this.start_offset);
            }
            Collections.sort(gp);
        }
    }

    public void build_consensus() throws IOException {
        int ri;
        this.REFERENCE_IS_PADDED = false;
        for (ri = 0; ri < this.reference_sequence.length; ++ri) {
            if ((char)this.reference_sequence[ri] != '*') continue;
            this.REFERENCE_IS_PADDED = true;
            break;
        }
        if (this.REFERENCE_IS_PADDED) {
            System.err.println("padded reference sequence detected, not postprocessing");
            this.consensus = new char[this.reference_sequence.length];
            for (ri = 0; ri < this.reference_sequence.length; ++ri) {
                this.consensus[ri] = (char)this.reference_sequence[ri];
            }
            return;
        }
        if (this.need_digest) {
            this.digest_sams();
        }
        StringBuffer sb_cons = new StringBuffer();
        ArrayList<Integer> g2 = new ArrayList<Integer>(this.gaps.keySet());
        Collections.sort(g2);
        if (this.reference_sequence == null) {
            System.err.println("ERROR: null reference sequence!  Check and/or re-download your reference sequence file to make sure it is not corrupt.");
            throw new IOException("null reference sequence");
        }
        for (int ri2 = 1; ri2 <= this.reference_sequence.length; ++ri2) {
            Integer gap = this.gaps.get(ri2);
            if (gap != null) {
                for (int gi = 0; gi < gap; ++gi) {
                    sb_cons.append('*');
                }
            }
            sb_cons.append((char)this.reference_sequence[ri2 - 1]);
        }
        this.consensus = sb_cons.toString().toCharArray();
    }

    public static void main(String[] argv) {
    }

    public boolean is_reference_prepadded() {
        return this.REFERENCE_IS_PADDED;
    }
}

