/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ChromosomeDisambiguator;
import Ace2.PairedReadWriter;
import IsoView.RegionParser;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReadMateExtractorUnpaired {
    private File unpaired_bam = null;
    private File paired_bam = null;
    private ArrayList<RegionParser> intervals = new ArrayList();
    private HashSet<String> wanted_ids = new HashSet();
    boolean VERBOSE = false;
    boolean STRIP_SEU_SUFFIX = true;
    private Pattern seu_pattern = Pattern.compile("\\.[FR]\\d+");
    private PrintStream ps_fwd;
    private PrintStream ps_rev;
    boolean QUERY_ALL = false;
    boolean QUERY_ALL_MAPPED = false;
    int READ_REPORT_INTERVAL = 1000000;
    boolean PAIRED_QUERY_ALL = false;

    public void set_unpaired_bam(File bam) {
        this.unpaired_bam = bam;
    }

    public void set_paired_bam(File bam) {
        this.paired_bam = bam;
    }

    public void add_interval(String interval) throws ParseException {
        RegionParser rp = new RegionParser();
        if (!rp.parse(interval)) {
            throw new ParseException("interval not parsable: " + interval, 0);
        }
        this.intervals.add(rp);
    }

    public boolean extract() throws Exception {
        SAMRecordIterator query;
        if (this.unpaired_bam == null) {
            throw new Exception("specify unpaired bam file (e.g. bwasw)");
        }
        if (this.paired_bam == null) {
            throw new Exception("specify paired bam file (e.g. bwa paired)");
        }
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.unpaired_bam);
        if (this.QUERY_ALL) {
            this.intervals = new ArrayList();
            this.intervals.add(new RegionParser());
        } else if (this.QUERY_ALL_MAPPED) {
            this.intervals = new ArrayList();
            SAMFileHeader sfh = reader.getFileHeader();
            SAMSequenceDictionary dict = sfh.getSequenceDictionary();
            for (SAMSequenceRecord ssr : dict.getSequences()) {
                RegionParser rp = new RegionParser();
                rp.reference = ssr.getSequenceName();
                rp.start = 1;
                rp.end = ssr.getSequenceLength();
                this.intervals.add(rp);
                System.err.println("will query " + rp);
            }
        }
        if (this.intervals.size() == 0) {
            throw new Exception("specify interval(s)");
        }
        System.err.println("stripping SEU suffix?: " + this.STRIP_SEU_SUFFIX);
        ChromosomeDisambiguator cd = new ChromosomeDisambiguator(reader);
        for (RegionParser interval : this.intervals) {
            SAMRecordIterator query2;
            if (this.QUERY_ALL) {
                query2 = reader.iterator();
            } else {
                String ref_name_bam = cd.find(interval.reference);
                query2 = reader.queryOverlapping(ref_name_bam, interval.start.intValue(), interval.end.intValue());
            }
            int read = 0;
            while (query2.hasNext()) {
                SAMRecord sr;
                if (++read % this.READ_REPORT_INTERVAL == 0) {
                    System.err.println("read:" + read + " wanted=" + this.wanted_ids.size());
                }
                if ((sr = (SAMRecord)query2.next()).getReadUnmappedFlag()) continue;
                if (sr.getReadPairedFlag()) {
                    throw new IOException("unpaired reads required");
                }
                this.seu_id_strip_check(sr);
                this.wanted_ids.add(sr.getReadName());
            }
            query2.close();
        }
        int count = this.wanted_ids.size();
        if (count == 0) {
            throw new IOException("no mapped reads found, quitting");
        }
        System.err.println("target IDs: " + count);
        String basename = this.unpaired_bam.getName();
        PairedReadWriter prw = new PairedReadWriter(basename, this.wanted_ids);
        reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.paired_bam);
        if (this.PAIRED_QUERY_ALL) {
            System.err.println("paired BAM: querying all");
            query = reader.iterator();
        } else {
            System.err.println("paired BAM: querying unmapped only");
            query = reader.queryUnmapped();
        }
        prw.scan(query);
        return prw.close();
    }

    public static void main(String[] argv) {
        try {
            ReadMateExtractorUnpaired rmeu = new ReadMateExtractorUnpaired();
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-unpaired-bam")) {
                    rmeu.set_unpaired_bam(new File(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-paired-bam")) {
                    rmeu.set_paired_bam(new File(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-interval")) {
                    ++i;
                    while (i < argv.length && argv[i].indexOf("-") != 0) {
                        rmeu.add_interval(argv[i++]);
                    }
                    --i;
                    continue;
                }
                if (argv[i].equals("-all-paired")) {
                    rmeu.PAIRED_QUERY_ALL = true;
                    continue;
                }
                if (argv[i].equals("-all-mapped")) {
                    rmeu.QUERY_ALL_MAPPED = true;
                    continue;
                }
                if (argv[i].equals("-unpaired-no-index")) {
                    rmeu.QUERY_ALL = true;
                    continue;
                }
                if (argv[i].equals("-v")) {
                    rmeu.VERBOSE = true;
                    continue;
                }
                if (argv[i].equals("-ping")) {
                    rmeu.READ_REPORT_INTERVAL = Integer.parseInt(argv[++i]);
                    continue;
                }
                System.err.println("unknown arg " + argv[i]);
                System.exit(1);
            }
            boolean ok = rmeu.extract();
            System.exit(ok ? 0 : 1);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
            ReadMateExtractorUnpaired.usage();
            System.exit(1);
        }
    }

    public static void usage() {
        System.err.println("usage:");
        System.err.println("  -bam whatever.bam");
        System.err.println("  -interval chrX:1234-5678 [-interval ...] ");
    }

    private void seu_id_strip_check(SAMRecord sr) {
        Matcher matcher;
        if (this.STRIP_SEU_SUFFIX && (matcher = this.seu_pattern.matcher(sr.getReadName())).find()) {
            String name = matcher.replaceAll("");
            sr.setReadName(name);
        }
    }
}

