/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AcePanel;
import Ace2.AceViewer;
import Ace2.AceViewerConfig;
import Ace2.PadMap;
import Ace2.Range;
import Ace2.RefGene;
import Ace2.SAMRegion;
import Ace2.SAMResource;
import Ace2.SAMResourceTags;
import Ace2.SNP;
import Ace2.SNPList;
import Ace2.Sample;
import Ace2.dbSNP;
import Ace2.dbSNPSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public class MarkupReader
implements Runnable {
    private BufferedReader br;
    private AceViewer av;
    private AceViewerConfig config = new AceViewerConfig();

    public MarkupReader(BufferedReader br, AceViewer av, boolean async) {
        this.br = br;
        this.av = av;
        if (av != null) {
            this.config = av.get_config();
        }
        this.config.read2sample = new HashMap();
        if (async) {
            Thread t = new Thread(this);
            t.start();
        } else {
            this.run();
        }
    }

    public MarkupReader(BufferedReader br, AceViewerConfig config, boolean async) {
        this.br = br;
        this.av = null;
        this.config = config;
        config.read2sample = new HashMap();
        if (async) {
            Thread t = new Thread(this);
            t.start();
        } else {
            this.run();
        }
    }

    public MarkupReader(String file) throws FileNotFoundException {
        this.br = new BufferedReader(new FileReader(file));
        this.run();
    }

    public void run() {
        Object id = null;
        this.config.refgenes = new ArrayList();
        this.config.dbsnp = new ArrayList();
        try {
            String line;
            boolean need_ruler_rebuild = false;
            boolean need_title = false;
            SAMRegion sr = null;
            block4: while ((line = this.br.readLine()) != null) {
                String[] stuff = line.split("\t");
                if (stuff[0].equals("sample2id")) {
                    Sample sample = Sample.get_sample(stuff[1]);
                    for (int i = 2; i < stuff.length; ++i) {
                        this.config.read2sample.put(new String(stuff[i]), sample);
                    }
                    continue;
                }
                if (stuff[0].equals("consensus_label")) {
                    this.config.CONSENSUS_TAG = new String(stuff[1]);
                    continue;
                }
                if (stuff[0].equals("ruler_start")) {
                    this.config.ruler_start = Integer.parseInt(stuff[1]);
                    need_ruler_rebuild = true;
                    continue;
                }
                if (stuff[0].equals("title")) {
                    this.config.title = stuff[1];
                    need_title = true;
                    continue;
                }
                if (stuff[0].equals("refGene")) {
                    this.config.refgenes.add(new RefGene(stuff));
                    continue;
                }
                if (stuff[0].equals("dbsnp")) {
                    this.config.dbsnp.add(new dbSNP(stuff));
                    continue;
                }
                if (stuff[0].toUpperCase().indexOf("SAM_") == 0) {
                    SAMResourceTags v = SAMResourceTags.valueOf(stuff[0].toUpperCase());
                    if (v.equals((Object)SAMResourceTags.SAM_URL)) {
                        this.config.sams.add(new SAMResource());
                    }
                    this.config.sams.get(this.config.sams.size() - 1).import_data(v, stuff[1]);
                    continue;
                }
                if (stuff[0].equals("reference_sequence")) {
                    StringBuffer target_sequence = new StringBuffer();
                    while (true) {
                        if ((line = this.br.readLine()).equals(">")) {
                            this.config.target_sequence = target_sequence.toString().getBytes();
                            continue block4;
                        }
                        target_sequence.append(line);
                    }
                }
                if (stuff[0].equals("target_region")) {
                    sr = new SAMRegion();
                    sr.tname = new String(stuff[1]);
                    sr.range = new Range(Integer.parseInt(stuff[2]), Integer.parseInt(stuff[3]));
                    continue;
                }
                System.err.println("error, don't recognize tag " + stuff[0]);
            }
            if (this.config.ruler_start > 0) {
                for (dbSNP snp : this.config.dbsnp) {
                    snp.consensus_adjust(this.config.ruler_start);
                }
                for (RefGene rg : this.config.refgenes) {
                    rg.consensus_adjust(this.config.ruler_start);
                }
            }
            if (this.config.dbsnp != null) {
                for (dbSNP snp : this.config.dbsnp) {
                }
                this.config.snp_config.snp_query = new dbSNPSet(this.config.dbsnp);
            }
            for (SAMResource sre : this.config.sams) {
                sre.set_region(sr);
            }
            if (this.av != null) {
                Runnable later;
                while (!this.av.get_acepanel().is_built()) {
                    try {
                        System.err.println("MarkupReader spin...");
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {}
                }
                PadMap pm = this.av.get_acepanel().get_assembly().get_padmap();
                for (RefGene rg : this.config.refgenes) {
                    rg.consensus_setup(pm);
                }
                if (need_title) {
                    later = new Runnable(){

                        public void run() {
                            MarkupReader.this.av.setTitle(((MarkupReader)MarkupReader.this).config.title);
                            MarkupReader.this.av.repaint();
                        }
                    };
                    SwingUtilities.invokeLater(later);
                }
                if (need_ruler_rebuild) {
                    later = new Runnable(){

                        public void run() {
                            if (((MarkupReader)MarkupReader.this).config.start_unpadded_offset != 0) {
                                AcePanel ap = MarkupReader.this.av.get_acepanel();
                                PadMap pm = ap.get_assembly().get_padmap();
                                int upo = ((MarkupReader)MarkupReader.this).config.start_unpadded_offset - ((MarkupReader)MarkupReader.this).config.ruler_start + 1;
                                int po = pm.get_unpadded_to_padded(upo);
                                System.err.println("upo=" + upo + " po=" + po);
                                SNPList sl = new SNPList();
                                sl.addElement(new SNP(po, 0.0));
                                ap.ace.set_snps(sl);
                                ap.get_canvas().center_on(po);
                                ap.get_canvas().repaint();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(later);
                }
                if (this.config.enable_exon_navigation) {
                    this.av.get_acepanel().init_exon_navigation();
                }
                this.av.get_acepanel().get_assembly().build_summary_info();
                later = new Runnable(){

                    public void run() {
                        MarkupReader.this.av.repaint();
                    }
                };
                SwingUtilities.invokeLater(later);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        try {
            URL url = new URL(argv[0]);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            MarkupReader markupReader = new MarkupReader(br, new AceViewerConfig(), false);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public AceViewerConfig get_config() {
        return this.config;
    }
}

