/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.GenomeBuildInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownGenomeBuild {
    private ArrayList<GenomeBuildInfo> known_genomes;

    public KnownGenomeBuild() {
        this.setup();
    }

    private void setup() {
        this.known_genomes = new ArrayList();
        GenomeBuildInfo gbi = new GenomeBuildInfo("hg18");
        this.known_genomes.add(gbi);
        gbi.set("chr1", "247249719");
        gbi.set("chr10", "135374737");
        gbi.set("chr11", "134452384");
        gbi.set("chr12", "132349534");
        gbi.set("chr13", "114142980");
        gbi.set("chr14", "106368585");
        gbi.set("chr15", "100338915");
        gbi.set("chr16", "88827254");
        gbi.set("chr17", "78774742");
        gbi.set("chr18", "76117153");
        gbi.set("chr19", "63811651");
        gbi.set("chr2", "242951149");
        gbi.set("chr20", "62435964");
        gbi.set("chr21", "46944323");
        gbi.set("chr22", "49691432");
        gbi.set("chr3", "199501827");
        gbi.set("chr4", "191273063");
        gbi.set("chr5", "180857866");
        gbi.set("chr6", "170899992");
        gbi.set("chr7", "158821424");
        gbi.set("chr8", "146274826");
        gbi.set("chr9", "140273252");
        gbi.set("chrM", "16571");
        gbi.set("chrX", "154913754");
        gbi.set("chrY", "57772954");
        gbi = new GenomeBuildInfo("hg19");
        this.known_genomes.add(gbi);
        gbi.set("chr1", "249250621");
        gbi.set("chr10", "135534747");
        gbi.set("chr11", "135006516");
        gbi.set("chr12", "133851895");
        gbi.set("chr13", "115169878");
        gbi.set("chr14", "107349540");
        gbi.set("chr15", "102531392");
        gbi.set("chr16", "90354753");
        gbi.set("chr17", "81195210");
        gbi.set("chr18", "78077248");
        gbi.set("chr19", "59128983");
        gbi.set("chr2", "243199373");
        gbi.set("chr20", "63025520");
        gbi.set("chr21", "48129895");
        gbi.set("chr22", "51304566");
        gbi.set("chr3", "198022430");
        gbi.set("chr4", "191154276");
        gbi.set("chr5", "180915260");
        gbi.set("chr6", "171115067");
        gbi.set("chr7", "159138663");
        gbi.set("chr8", "146364022");
        gbi.set("chr9", "141213431");
        gbi.set("chrM", "16571");
        gbi.set("chrX", "155270560");
        gbi.set("chrY", "59373566");
        gbi = new GenomeBuildInfo("hg19_updated_MT");
        this.known_genomes.add(gbi);
        gbi.set("chr1", "249250621");
        gbi.set("chr10", "135534747");
        gbi.set("chr11", "135006516");
        gbi.set("chr12", "133851895");
        gbi.set("chr13", "115169878");
        gbi.set("chr14", "107349540");
        gbi.set("chr15", "102531392");
        gbi.set("chr16", "90354753");
        gbi.set("chr17", "81195210");
        gbi.set("chr18", "78077248");
        gbi.set("chr19", "59128983");
        gbi.set("chr2", "243199373");
        gbi.set("chr20", "63025520");
        gbi.set("chr21", "48129895");
        gbi.set("chr22", "51304566");
        gbi.set("chr3", "198022430");
        gbi.set("chr4", "191154276");
        gbi.set("chr5", "180915260");
        gbi.set("chr6", "171115067");
        gbi.set("chr7", "159138663");
        gbi.set("chr8", "146364022");
        gbi.set("chr9", "141213431");
        gbi.set("chrM", "16569");
        gbi.set("chrX", "155270560");
        gbi.set("chrY", "59373566");
    }

    public String identify_build(HashMap<Chromosome, Integer> lengths) {
        String result = null;
        boolean VERBOSE = false;
        HashMap hit_counts = new HashMap();
        HashSet<String> hits = new HashSet<String>();
        HashSet<String> misses = new HashSet<String>();
        for (GenomeBuildInfo gbi : this.known_genomes) {
            for (Chromosome c : lengths.keySet()) {
                int query_len = lengths.get((Object)c);
                Integer known_len = gbi.chr_lengths.get((Object)c);
                if (known_len == null) continue;
                if (query_len == known_len) {
                    if (VERBOSE) {
                        System.err.println("hit for " + (Object)((Object)c) + " on " + gbi.build_name);
                    }
                    hits.add(gbi.build_name);
                    continue;
                }
                if (VERBOSE) {
                    System.err.println("miss for " + (Object)((Object)c) + " on " + gbi.build_name + " expected:" + known_len + " this:" + query_len);
                }
                misses.add(gbi.build_name);
            }
        }
        ArrayList<String> passed = new ArrayList<String>();
        for (String name : hits) {
            if (misses.contains(name)) continue;
            passed.add(name);
        }
        if (passed.size() == 1) {
            result = (String)passed.get(0);
        }
        return result;
    }

    public GenomeBuildInfo find_build(String name) {
        GenomeBuildInfo result = null;
        for (GenomeBuildInfo gbi : this.known_genomes) {
            if (!gbi.get_name().equals(name)) continue;
            result = gbi;
            break;
        }
        return result;
    }
}

