/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.Assembly;
import Ace2.Base;
import Ace2.BaseCounter3;
import Ace2.CDSChangeInfo;
import Ace2.Codon;
import Ace2.Exon;
import Ace2.RefGene;
import Funk.Str;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDSChangePredictor {
    private Assembly assembly;
    private ArrayList<RefGene> refgenes;
    private boolean in_codon;
    private ArrayList<CDSChangeInfo> changes;
    private String consensus_tag;
    private char cons_nt;

    public CDSChangePredictor(AceViewerConfig config) {
        this.assembly = config.assembly;
        this.refgenes = config.refgenes;
        this.consensus_tag = config.CONSENSUS_TAG;
    }

    public CDSChangePredictor(Assembly assembly, ArrayList<RefGene> refgenes, String consensus_tag) {
        this.assembly = assembly;
        this.refgenes = refgenes;
        this.consensus_tag = consensus_tag;
    }

    public ArrayList<CDSChangeInfo> get_changes() {
        return this.changes;
    }

    public boolean has_mapping_error() {
        boolean error = false;
        for (RefGene rg : this.refgenes) {
            if (!rg.is_broken()) continue;
            error = true;
            break;
        }
        return error;
    }

    public boolean predict_cds_changes(int cpos, char variant_nt) {
        this.changes = new ArrayList();
        char[] cons = this.assembly.get_consensus_sequence();
        this.cons_nt = Character.toUpperCase(cons[cpos - 1]);
        this.in_codon = false;
        for (RefGene rg : this.refgenes) {
            if (!rg.is_initialized()) {
                rg.consensus_setup(this.assembly.get_padmap());
            }
            if (rg.is_broken()) continue;
            for (Exon exon : rg.get_visible_exons(cpos, cpos)) {
                for (Codon codon : exon.get_codons()) {
                    if (codon.c_start_offset() != cpos && codon.c_center_offset() != cpos && codon.c_last_offset() != cpos) continue;
                    this.in_codon = true;
                    CDSChangeInfo info = new CDSChangeInfo();
                    info.cpos = cpos;
                    info.variant_nt = variant_nt;
                    info.codon_orig = codon;
                    info.codon_altered = codon.generate_altered(cpos, variant_nt);
                    info.refgene = rg;
                    this.changes.add(info);
                }
            }
        }
        return this.in_codon;
    }

    public char get_variant_nt(int cpos, Component c) {
        char[] cons = this.assembly.get_consensus_sequence();
        char cons_nt = Character.toUpperCase(cons[cpos - 1]);
        BaseCounter3 bc = new BaseCounter3(this.assembly);
        bc.add_sequences(cpos);
        bc.add_base(cons_nt);
        HashSet<Character> nts = bc.get_bases();
        int nt_count = nts.size();
        char variant_nt = '\u0000';
        if (nt_count == 1) {
            JOptionPane.showMessageDialog(c, "No sequence variation at this position.", "Error", 0);
        } else if (this.refgenes == null) {
            JOptionPane.showMessageDialog(c, "Can't predict protein changes: no reference sequence annotations loaded.", "Error", 0);
        } else if (nt_count == 2) {
            for (Character c2 : nts) {
                if (c2.charValue() == cons_nt) continue;
                variant_nt = c2.charValue();
            }
        } else {
            Object[] others = new Character[nts.size() - 1];
            int oi = 0;
            Base[] by_freq = bc.get_bases_by_frequency();
            for (int j = 0; j < by_freq.length; ++j) {
                if (by_freq[j].equals(cons_nt)) continue;
                others[oi++] = Character.valueOf(by_freq[j].charValue());
            }
            Character response = (Character)JOptionPane.showInputDialog(c, "Specify alternative allele for protein change prediction\n(" + this.consensus_tag + ": " + cons_nt + ")", "SNP protein change prediction", 3, null, others, null);
            if (response != null) {
                variant_nt = response.charValue();
            }
        }
        return variant_nt;
    }

    public char get_consensus_nt() {
        return this.cons_nt;
    }

    public String toString() {
        return Str.join("\n", this.changes);
    }

    public String toString(String delimiter) {
        return Str.join(delimiter, this.changes);
    }

    public String get_any_change() {
        String label;
        if (this.changes.size() == 0) {
            label = "no";
        } else {
            label = "silent";
            for (CDSChangeInfo change : this.changes) {
                if (change.is_silent()) continue;
                label = "yes";
                break;
            }
        }
        return label;
    }

    public int get_any_change_int() {
        int result;
        if (this.changes.size() == 0) {
            result = 0;
        } else {
            result = 1;
            for (CDSChangeInfo change : this.changes) {
                if (change.is_silent()) continue;
                result = 2;
                break;
            }
        }
        return result;
    }
}

