/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class BambinoProperties {
    private static final String PROPERTIES_PATH = "Ace2/bambino.properties";
    private static final String DEFAULT_PROPERTIES_PATH = "c:/me/work/java2/Ace2/bambino.properties";
    private Properties properties;
    private static final String K_BUILD_NUMBER = "build_number";
    private static final String K_BUILD_DATE = "build_date";

    public BambinoProperties() {
        this.load_properties();
    }

    private InputStream get_input_stream() {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream result = null;
        result = cl == null ? ClassLoader.getSystemResourceAsStream(PROPERTIES_PATH) : cl.getResourceAsStream(PROPERTIES_PATH);
        return result;
    }

    public void load_properties() {
        this.properties = new Properties();
        try {
            InputStream is = this.get_input_stream();
            if (is != null) {
                this.properties.load(is);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR loading properties: " + e);
        }
    }

    public void save_properties() {
        URL res = ClassLoader.getSystemResource(PROPERTIES_PATH);
        File output_file = null;
        output_file = res == null ? new File(DEFAULT_PROPERTIES_PATH) : new File(res.getFile());
        try {
            FileOutputStream fos = new FileOutputStream(output_file);
            Enumeration<?> e = this.properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.properties.store(fos, key);
            }
            fos.close();
        }
        catch (Exception ex) {
            System.err.println("ERROR saving properties: " + ex);
        }
    }

    public Object setProperty(String key, String value) {
        return this.properties.setProperty(key, value);
    }

    public void increment_build_number() {
        int bn = Integer.parseInt(this.properties.getProperty(K_BUILD_NUMBER, "0")) + 1;
        this.setProperty(K_BUILD_NUMBER, Integer.toString(bn));
    }

    public void set_build_date() {
        Date d = new Date();
        this.setProperty(K_BUILD_DATE, d.toString());
    }

    public String get_build_date() {
        return this.properties.getProperty(K_BUILD_DATE, "unknown");
    }

    public String get_build_number() {
        return this.properties.getProperty(K_BUILD_NUMBER, "unknown");
    }

    public static void main(String[] argv) {
        BambinoProperties bp = new BambinoProperties();
        boolean save = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-increment-build")) {
                bp.increment_build_number();
                save = true;
                continue;
            }
            if (argv[i].equals("-set-build-date")) {
                bp.set_build_date();
                save = true;
                continue;
            }
            System.err.println("ERROR: unknown param " + argv[i]);
            System.exit(1);
        }
        if (save) {
            bp.save_properties();
        } else {
            System.err.println("nothing to do (not saving)");
        }
    }
}

