/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AcePanel;
import Ace2.AceViewerConfig;
import Ace2.ArrowPainter;
import Ace2.AssemblySequence;
import Ace2.CDSChangePredictor;
import Ace2.ClipboardSetter;
import Ace2.Codon;
import Ace2.ColorIntensifier;
import Ace2.Exon;
import Ace2.Filfre;
import Ace2.FontWidthTracker;
import Ace2.HeteroSummary;
import Ace2.PadMap;
import Ace2.ProgressInfo;
import Ace2.Range;
import Ace2.RefGene;
import Ace2.Ruler;
import Ace2.SAMAlternatePeakAmplitudeRatios;
import Ace2.SAMAssembly;
import Ace2.SAMConsensusMapping;
import Ace2.SAMResource;
import Ace2.SAMTracePeakPositions;
import Ace2.SAMUtils;
import Ace2.SNPList;
import Ace2.Sample;
import Ace2.SequenceViewLock;
import Ace2.TraceViewerCache;
import Ace2.dbSNP;
import Funk.CloseFrame;
import Funk.DoWhatISayObservable;
import Funk.Gr;
import Funk.Str;
import TCGA.PopupListener;
import TCGA.URLLauncher;
import TCGA.WebTools;
import Trace.StreamDelegator;
import Trace.TraceFile;
import Trace.TraceViewer;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import java.applet.AppletContext;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
ActionListener,
Observer {
    private boolean ENABLE_TRACE_VIEWER = false;
    private JScrollBar hscroll;
    private JScrollBar vscroll;
    private ArrowPainter arrow_painter;
    private int line_height;
    private int draw_line;
    private int leftbuffer;
    private int contig_start_offset;
    private int contig_end_view;
    private int contig_end_offset;
    private int contig_chunk_size;
    private int font_width;
    private int font_ascent;
    private int font_descent;
    private int contig_start_view = 1;
    private Hashtable drawn_y = new Hashtable();
    private int font_size = 14;
    private long down_click_time;
    private DoWhatISayObservable notifier;
    private AcePanel ap;
    private Hashtable highlights = null;
    private Hashtable heterozygotes = null;
    private int cons_highlight_start;
    private int cons_highlight_end;
    private Font OUR_FONT = null;
    private Font VAR_FONT = null;
    public static Color COVERAGE_COLOR = new Color(54, 100, 139);
    public static Color BACKGROUND_COLOR = Color.black;
    public static Color SEQUENCE_COLOR = new Color(152, 245, 255);
    public static Color SNP_COLOR = Color.red;
    public static Color NONREF_FREQUENCY_COLOR = Color.yellow;
    public static Color SUMMARY_PANEL_BACKGROUND_COLOR = new Color(25, 25, 25);
    public static Color SEQUENCE_COLOR_QUAL = Color.black;
    static int QUALITY_THRESHOLD_LOWERCASE = 20;
    public static Color SEQID_COLOR = Color.yellow;
    public static Color HIGHLIT_COLOR = Color.white;
    public static Color HETEROZYGOTE_COLOR = Color.green;
    public static Color BORDER_COLOR = new Color(160, 32, 240);
    public static Color CONSENSUS_COLOR = Color.yellow;
    public static Color RULER_COLOR = Color.cyan;
    public static Color TRIMMED_COLOR = Color.gray;
    public static Color HIGHLIGHT_COLOR = new Color(0, 100, 0);
    public static Color SELECTED_COLOR = new Color(0, 0, 139);
    public static Color NORMAL_COLOR = new Color(0, 0, 205);
    public static Color TUMOR_COLOR = Color.red;
    static Color TUMOR_RECURRENT_COLOR = new Color(255, 0, 255);
    public static Color INTRON_SPLICE_COLOR = new Color(255, 70, 0);
    private static final int MAX_INTENSITY_QUALITY = 40;
    private static final int TYPE_BLANK = 0;
    private static final int TYPE_TRIM = 1;
    private static final int TYPE_SEQ_AGREE = 2;
    private static final int TYPE_SEQ_DISAGREE = 3;
    private AceViewerConfig config;
    private static Color[] quality_colors;
    private int wheel_motion_start_center = 0;
    private static final String LABEL_TRACE_VIEWER = "View chromatogram";
    private static final String LABEL_DEBUG_PEAK_AMP_RATIO = "Show alternate peak amplitude ratio";
    private static final String LABEL_PROTEIN_CHANGE = "Check for protein change";
    private static final String LABEL_SHOW_ONLY_ALIGNED = "Show only reads aligned at this site";
    private static final String LABEL_SHOW_ONLY_ALIGNED_NO_SKIPS = "Show only reads aligned at this site (excluding skips)";
    private static final String LABEL_SHOW_ONLY_ALIGNED_NO_SKIPS_BUT_CONTAINING_SKIP = "Show only reads aligned at this site (excluding skips, but containing skip)";
    private static final String LABEL_SHOW_ONLY_ALIGNED_NO_SKIPS_BUT_CONTAINING_SKIP2 = "Show only reads aligned at this site (excluding skips, but containing skip and target end)";
    private static final String LABEL_SHOW_ONLY_NONREFERENCE = "Show only non-reference sequences at this site";
    private static final String LABEL_SHOW_ONLY_INDEL = "Show only reads containing indels (anywhere in alignment)";
    private static final String LABEL_NONREF_FREQUENCY = "non-reference frequency";
    private static final String LABEL_ASSEMBLY_COVERAGE = "overview";
    private static final String LABEL_DBSNP = "dbSNP";
    private JMenuItem jmi_blat;
    private JMenuItem jmi_blat_mate;
    private String BLAT_BADGER_LABEL_UID = "mparker";
    private PopupListener pul;
    private static final String KEY_NONREF_FREQUENCY = "__nonref_freq";
    private static final String KEY_OVERVIEW = "__overview";
    private static final String KEY_RULER = "__ruler";
    private static final String KEY_REFSEQ = "__refseq";
    private HashSet<String> refseq_ids = new HashSet();
    private ProgressInfo info;
    private int sequences_drawn;
    private ArrayList<AssemblySequence> aligned_seqs;
    private ArrayList<AssemblySequence> visible_seqs;
    private JCheckBoxMenuItem cb_show_only_aligned;
    private JCheckBoxMenuItem cb_show_only_aligned_no_skips;
    private JCheckBoxMenuItem cb_show_only_nonreference;
    private JCheckBoxMenuItem cb_show_only_aligned_no_skips_but_containing_skip;
    private JCheckBoxMenuItem cb_show_only_indel;
    private JCheckBoxMenuItem cb_show_only_aligned_no_skips_but_containing_skip2;
    private boolean first_paint;
    private SequenceViewLock svl;
    private HeteroSummary hs = null;
    private FontWidthTracker fwt = null;
    private TraceViewerCache tvc = new TraceViewerCache();

    public AssemblyCanvas(AcePanel ap, AceViewerConfig config, JScrollBar h, JScrollBar v) {
        JMenuItem jmi;
        this.ap = ap;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.set_config(config);
        FontWidthTracker.add_tracked_string(LABEL_NONREF_FREQUENCY);
        FontWidthTracker.add_tracked_string(LABEL_ASSEMBLY_COVERAGE);
        this.svl = new SequenceViewLock(h, v);
        new Filfre(this);
        this.hscroll = h;
        this.vscroll = v;
        AdjustmentListener al = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                AssemblyCanvas.this.scroll_paint();
            }
        };
        h.addAdjustmentListener(al);
        v.addAdjustmentListener(al);
        this.set_font_size(14);
        this.notifier = new DoWhatISayObservable();
        this.addMouseWheelListener(this);
        this.init_quality_colors();
        JPopupMenu jpm = new JPopupMenu();
        if (config.ENABLE_TRACE_VIEWER) {
            jmi = new JMenuItem(LABEL_TRACE_VIEWER);
            jpm.add(jmi);
            jmi.addActionListener(this);
            jmi = new JMenuItem(LABEL_DEBUG_PEAK_AMP_RATIO);
            jpm.add(jmi);
            jmi.addActionListener(this);
        }
        jmi = new JMenuItem(LABEL_PROTEIN_CHANGE);
        jpm.add(jmi);
        jmi.addActionListener(this);
        jmi = new JMenuItem("Display sequence info");
        jpm.add(jmi);
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String id = AssemblyCanvas.this.get_mouse_sequence_id(AssemblyCanvas.this.pul.getMouseEvent());
                AssemblyCanvas.this.display_sam_info(id);
            }
        });
        if (config.LOCAL_FILE_MODE) {
            jmi = new JMenuItem("Copy sequence ID to clipboard");
            jpm.add(jmi);
            jmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String id = AssemblyCanvas.this.get_mouse_sequence_id(AssemblyCanvas.this.pul.getMouseEvent());
                    ClipboardSetter cs = new ClipboardSetter();
                    cs.setClipboardContents(id);
                }
            });
            jmi = new JMenuItem("Copy reference base # to clipboard");
            jpm.add(jmi);
            jmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClipboardSetter cs = new ClipboardSetter();
                    int consensus_pos = AssemblyCanvas.this.get_consensus_pos(AssemblyCanvas.this.pul.getMouseEvent());
                    int ref_base = AssemblyCanvas.this.get_reference_base_number(consensus_pos);
                    cs.setClipboardContents(ref_base);
                }
            });
        }
        jmi = new JMenuItem("NCBI query for this sequence ID");
        jpm.add(jmi);
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String id = AssemblyCanvas.this.get_mouse_sequence_id(AssemblyCanvas.this.pul.getMouseEvent());
                String link = "http://www.ncbi.nlm.nih.gov/gquery/?term=" + id;
                new URLLauncher(link, "ncbi");
            }
        });
        jpm.add(new JSeparator());
        this.cb_show_only_aligned = new JCheckBoxMenuItem(LABEL_SHOW_ONLY_ALIGNED, false);
        jpm.add(this.cb_show_only_aligned);
        this.cb_show_only_aligned.addActionListener(this);
        this.cb_show_only_aligned_no_skips = new JCheckBoxMenuItem(LABEL_SHOW_ONLY_ALIGNED_NO_SKIPS, false);
        jpm.add(this.cb_show_only_aligned_no_skips);
        this.cb_show_only_aligned_no_skips.addActionListener(this);
        this.cb_show_only_aligned_no_skips_but_containing_skip = new JCheckBoxMenuItem(LABEL_SHOW_ONLY_ALIGNED_NO_SKIPS_BUT_CONTAINING_SKIP, false);
        jpm.add(this.cb_show_only_aligned_no_skips_but_containing_skip);
        this.cb_show_only_aligned_no_skips_but_containing_skip.addActionListener(this);
        this.cb_show_only_aligned_no_skips_but_containing_skip2 = new JCheckBoxMenuItem(LABEL_SHOW_ONLY_ALIGNED_NO_SKIPS_BUT_CONTAINING_SKIP2, false);
        jpm.add(this.cb_show_only_aligned_no_skips_but_containing_skip2);
        this.cb_show_only_aligned_no_skips_but_containing_skip2.addActionListener(this);
        this.cb_show_only_nonreference = new JCheckBoxMenuItem(LABEL_SHOW_ONLY_NONREFERENCE, false);
        jpm.add(this.cb_show_only_nonreference);
        this.cb_show_only_nonreference.addActionListener(this);
        this.cb_show_only_indel = new JCheckBoxMenuItem(LABEL_SHOW_ONLY_INDEL, config.DEFAULT_VIEW_INDELS_ONLY);
        jpm.add(this.cb_show_only_indel);
        this.cb_show_only_indel.addActionListener(this);
        jpm.add(new JSeparator());
        String uid = null;
        try {
            uid = System.getProperty("user.name");
        }
        catch (AccessControlException feh) {
            // empty catch block
        }
        Random r = new Random();
        String blat_base_label = uid != null && uid.equals(this.BLAT_BADGER_LABEL_UID) && r.nextDouble() * 10.0 > 9.0 ? "BADGER" : "BLAT";
        this.jmi_blat = new JMenuItem(blat_base_label + " this read");
        this.jmi_blat.addActionListener(this);
        jpm.add(this.jmi_blat);
        this.jmi_blat_mate = new JMenuItem(blat_base_label + " this read's mate");
        this.jmi_blat_mate.addActionListener(this);
        jpm.add(this.jmi_blat_mate);
        this.pul = new PopupListener(this, jpm);
    }

    public void display_sam_info(String id) {
        for (AssemblySequence as : this.config.assembly.get_sequences()) {
            SAMRecord sr;
            if (!as.get_name().equals(id) || (sr = as.get_samrecord()) == null) continue;
            JFrame jf = new JFrame();
            jf.setTitle("SAM info for " + id);
            StringBuffer sb = new StringBuffer();
            sb.append(id + "\n");
            sb.append("               sequence: " + new String(sr.getReadBases()) + "\n");
            sb.append("                  CIGAR: " + SAMUtils.cigar_to_string(sr.getCigar()) + "\n");
            sb.append("         alignmentStart: " + sr.getAlignmentStart() + "\n");
            sb.append("unclippedAlignmentStart: " + sr.getUnclippedStart() + "\n");
            sb.append("           alignmentEnd: " + sr.getAlignmentEnd() + "\n");
            sb.append("        mapping quality: " + sr.getMappingQuality() + "\n");
            int flags = sr.getFlags();
            sb.append("                  flags: " + flags + "\n");
            if (sr.getReadPairedFlag()) {
                sb.append("                         - read is paired\n");
                if (sr.getProperPairFlag()) {
                    sb.append("                         - read is mapped in a proper pair\n");
                }
                sb.append("                         - first read of pair?: " + (sr.getFirstOfPairFlag() ? "yes" : "no") + "\n");
                sb.append("                         - second read of pair?: " + (sr.getSecondOfPairFlag() ? "yes" : "no") + "\n");
                if (sr.getMateUnmappedFlag()) {
                    sb.append("                         - mate is unmapped\n");
                } else {
                    sb.append("                         - mate strand: " + (sr.getMateNegativeStrandFlag() ? "-" : "+") + "\n");
                    sb.append("                         - mate align start: " + sr.getMateAlignmentStart() + "\n");
                }
            } else {
                sb.append("                         - read is not paired\n");
            }
            if (sr.getReadUnmappedFlag()) {
                sb.append("                         - read is unmapped\n");
            }
            sb.append("                         - strand: " + (sr.getReadNegativeStrandFlag() ? "-" : "+") + "\n");
            sb.append("                         - primary alignment?: " + (sr.getNotPrimaryAlignmentFlag() ? "no" : "yes") + "\n");
            sb.append("                         - fails vendor checks: " + (sr.getReadFailsVendorQualityCheckFlag() ? "yes" : "no") + "\n");
            sb.append("                         - PCR/optical duplicate?: " + (sr.getDuplicateReadFlag() ? "yes" : "no") + "\n");
            boolean has_tags = false;
            try {
                for (SAMRecord.SAMTagAndValue tav : sr.getAttributes()) {
                    if (!has_tags) {
                        sb.append("Tags:\n");
                        has_tags = true;
                    }
                    sb.append("  " + tav.tag + ": " + tav.value + "\n");
                }
            }
            catch (NullPointerException e) {
                System.err.println("feh: null ptr for getAttributes");
            }
            jf.add("Center", new JScrollPane(new JTextArea(sb.toString())));
            jf.pack();
            jf.setVisible(true);
        }
    }

    public void set_font_size(int font_size) {
        int wanted = font_size;
        if (font_size < 1) {
            font_size = 1;
        }
        if (font_size > 30) {
            font_size = 30;
        }
        this.OUR_FONT = new Font(this.config.FIXED_FONT_TYPEFACE, 0, font_size);
        this.font_size = font_size;
        if (this.config.ENABLE_VARIABLE_WIDTH_FONTS) {
            this.VAR_FONT = new Font(this.config.VARIABLE_FONT_TYPEFACE, 0, font_size);
            this.fwt = null;
        }
        FontMetrics fm = this.getFontMetrics(this.OUR_FONT);
        this.line_height = fm.getHeight();
        this.font_width = fm.stringWidth("W");
        this.font_ascent = fm.getMaxAscent();
        this.font_descent = fm.getMaxDescent();
        this.arrow_painter = new ArrowPainter(this.font_width, this.line_height, this.font_ascent, this.font_descent, BORDER_COLOR);
        this.leftbuffer = 10 * this.font_width + this.arrow_painter.total_width;
        this.repaint();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof SAMResource) {
            this.info = (ProgressInfo)arg;
        }
        this.repaint();
    }

    public void reset() {
        this.cons_highlight_end = 0;
        this.cons_highlight_start = 0;
        this.heterozygotes = null;
        this.highlights = null;
    }

    public void addObserver(Observer o) {
        this.notifier.addObserver(o);
    }

    @Override
    public void paintComponent(Graphics g) {
        String filename;
        super.paintComponent(g);
        String title = this.config.assembly.get_title();
        String string = filename = title == null ? "assembly file" : Str.basename(title);
        if (this.config.assembly.is_loaded()) {
            if (this.config.assembly.has_error()) {
                Gr.centerText(this, g, this.config.assembly.get_error_message());
            } else if (this.config.assembly.alignment_is_built()) {
                if (this.config.assembly.is_empty()) {
                    Gr.centerText(this, g, "No sequences available in this region.");
                } else {
                    if (this.first_paint) {
                        if (this.contig_start_view == 1) {
                            this.contig_start_view = this.config.assembly.get_leftmost();
                        }
                        this.first_paint = false;
                    }
                    this.buffer_paint(g);
                }
            } else {
                String msg = this.info == null ? "Building alignment..." : "Building gapped alignment: " + this.info.total_processed + " reads (" + this.info.get_percent() + "%)";
                Gr.centerText(this, g, msg);
                this.repaint();
            }
        } else {
            Gr.centerText(this, g, "Loading...");
        }
    }

    void scroll_paint() {
        this.contig_start_view = this.hscroll.getValue();
        this.repaint();
    }

    public void move_to(int i) {
        while (!this.isValid()) {
            try {
                System.err.println("AssemblyCanvas spin...");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.contig_start_view = i;
        if (this.contig_start_view < this.config.assembly.get_leftmost()) {
            this.contig_start_view = this.config.assembly.get_leftmost();
        }
        this.repaint();
    }

    public int get_start_for_center(int pos) {
        return pos - this.contig_chunk_size() / 2;
    }

    public void center_on(int i) {
        this.move_to(i - this.contig_chunk_size() / 2);
    }

    int contig_chunk_size() {
        return (this.getSize().width - this.leftbuffer) / this.font_width + 1;
    }

    int contig_start_view() {
        return this.contig_start_view;
    }

    int contig_end_view() {
        return this.contig_end_view;
    }

    public void buffer_paint(Graphics gr) {
        Rectangle r2;
        Rectangle r1;
        ArrayList<AssemblySequence> filtered;
        int current_snp_pos;
        SAMRecord sr;
        int csv2;
        int right_border;
        int left_border;
        Graphics2D g = (Graphics2D)gr;
        if (this.config.ENABLE_VARIABLE_WIDTH_FONTS) {
            FontWidthTracker.add_tracked_string(this.config.CONSENSUS_TAG);
            if (this.fwt == null) {
                this.fwt = new FontWidthTracker(this.getFontMetrics(this.VAR_FONT), this.config.assembly);
            }
        }
        this.set_leftbuffer();
        Dimension d = this.getSize();
        this.draw_line = 1;
        this.drawn_y.clear();
        char[] cons = this.config.assembly.get_consensus_sequence();
        int leftmost = this.config.assembly.get_leftmost();
        if (this.config.LOCK_VIEW_TO_ALIGNED_SEQUENCES) {
            left_border = this.config.assembly.get_leftmost();
            right_border = this.config.assembly.get_rightmost();
        } else {
            left_border = 0;
            right_border = cons.length;
        }
        if (this.contig_start_view < left_border) {
            this.contig_start_view = left_border;
        }
        this.contig_start_offset = this.contig_start_view - leftmost;
        this.contig_chunk_size = this.contig_chunk_size();
        this.contig_end_view = this.contig_start_view + this.contig_chunk_size;
        this.contig_end_offset = this.contig_start_offset + this.contig_chunk_size;
        int too_far = this.contig_end_view - right_border;
        if (too_far > 0 && (csv2 = this.contig_start_view - too_far) > leftmost) {
            this.contig_start_view -= too_far;
            this.contig_end_view -= too_far;
            this.contig_start_offset -= too_far;
            this.contig_end_offset -= too_far;
        }
        this.aligned_seqs = this.config.assembly.get_visible_sequences(this.contig_start_view, this.contig_end_view);
        if (this.config.HIDE_OPTICAL_PCR_DUPLICATES) {
            ArrayList<AssemblySequence> filtered2 = new ArrayList<AssemblySequence>();
            for (AssemblySequence as : this.aligned_seqs) {
                sr = as.get_samrecord();
                if (sr == null) {
                    filtered2.add(as);
                    continue;
                }
                if (sr.getDuplicateReadFlag()) continue;
                filtered2.add(as);
            }
            this.aligned_seqs = filtered2;
        }
        if (this.config.MINIMUM_MAPQ_FOR_DISPLAY > 0) {
            ArrayList<AssemblySequence> filtered3 = new ArrayList<AssemblySequence>();
            for (AssemblySequence as : this.aligned_seqs) {
                sr = as.get_samrecord();
                if (sr == null) {
                    filtered3.add(as);
                    continue;
                }
                if (sr.getMappingQuality() < this.config.MINIMUM_MAPQ_FOR_DISPLAY) continue;
                filtered3.add(as);
            }
            this.aligned_seqs = filtered3;
        }
        if (this.config.sam_tag_filter != null) {
            ArrayList<AssemblySequence> filtered4 = new ArrayList<AssemblySequence>();
            for (AssemblySequence as : this.aligned_seqs) {
                sr = as.get_samrecord();
                if (sr == null) {
                    filtered4.add(as);
                    continue;
                }
                if (!this.config.sam_tag_filter.check(sr, null)) continue;
                filtered4.add(as);
            }
            this.aligned_seqs = filtered4;
        }
        if (this.cb_show_only_indel.isSelected()) {
            ArrayList<AssemblySequence> filtered5 = new ArrayList<AssemblySequence>();
            for (AssemblySequence as : this.aligned_seqs) {
                sr = as.get_samrecord();
                if (sr == null) {
                    filtered5.add(as);
                    continue;
                }
                boolean usable = false;
                Cigar c = sr.getCigar();
                for (CigarElement ce : c.getCigarElements()) {
                    CigarOperator co = ce.getOperator();
                    if (!co.equals((Object)CigarOperator.INSERTION) && !co.equals((Object)CigarOperator.DELETION)) continue;
                    usable = true;
                    break;
                }
                if (!usable) continue;
                filtered5.add(as);
            }
            this.aligned_seqs = filtered5;
        }
        SNPList snps = this.config.assembly.get_snps();
        if ((this.config.CLAMP_SNP_VIEW || this.config.CLAMP_SNP_VIEW_NONREFERENCE) && snps != null && this.contig_start_view == this.config.clamp_cons_start && (current_snp_pos = snps.current_position()) >= this.contig_start_view && current_snp_pos <= this.contig_end_view) {
            filtered = new ArrayList<AssemblySequence>();
            String str = this.get_consensus_for(current_snp_pos, 1).toUpperCase();
            char cbase = str.charAt(0);
            for (AssemblySequence as : this.aligned_seqs) {
                if (as.get_asm_start() > current_snp_pos || as.get_asm_end() < current_snp_pos) continue;
                if (this.config.CLAMP_SNP_VIEW_NONREFERENCE) {
                    char base = Character.toUpperCase(as.get_base(current_snp_pos));
                    if (base == cbase) continue;
                    filtered.add(as);
                    continue;
                }
                filtered.add(as);
            }
            this.aligned_seqs = filtered;
        }
        if (this.config.CLAMP_MANUAL_VIEW && this.cb_show_only_aligned.isSelected() && this.contig_start_view == this.config.manual_clamp_cons_start && this.config.manual_clamp_cons_pos >= this.contig_start_view && this.config.manual_clamp_cons_pos <= this.contig_end_view) {
            ArrayList<AssemblySequence> filtered6 = new ArrayList<AssemblySequence>();
            for (AssemblySequence as : this.aligned_seqs) {
                if (as.get_asm_start() > this.config.manual_clamp_cons_pos || as.get_asm_end() < this.config.manual_clamp_cons_pos) continue;
                filtered6.add(as);
            }
            this.aligned_seqs = filtered6;
        } else {
            this.cb_show_only_aligned.setSelected(false);
        }
        if (this.config.CLAMP_MANUAL_NONREFERENCE && this.cb_show_only_nonreference.isSelected() && this.contig_start_view == this.config.clamp_nonref_cons_start && this.config.clamp_nonref_cons_pos >= this.contig_start_view && this.config.clamp_nonref_cons_pos <= this.contig_end_view) {
            ArrayList<AssemblySequence> filtered7 = new ArrayList<AssemblySequence>();
            String str = this.get_consensus_for(this.config.clamp_nonref_cons_pos, 1).toUpperCase();
            char cbase = str.charAt(0);
            for (AssemblySequence as : this.aligned_seqs) {
                char base;
                if (as.get_asm_start() > this.config.clamp_nonref_cons_pos || as.get_asm_end() < this.config.clamp_nonref_cons_pos || (base = Character.toUpperCase(as.get_base(this.config.clamp_nonref_cons_pos))) == cbase) continue;
                filtered7.add(as);
            }
            this.aligned_seqs = filtered7;
        } else {
            this.cb_show_only_nonreference.setSelected(false);
        }
        if ((this.cb_show_only_aligned_no_skips.isSelected() || this.cb_show_only_aligned_no_skips_but_containing_skip.isSelected() || this.cb_show_only_aligned_no_skips_but_containing_skip2.isSelected()) && this.contig_start_view == this.config.manual_clamp_cons_start && this.config.manual_clamp_cons_pos >= this.contig_start_view && this.config.manual_clamp_cons_pos <= this.contig_end_view) {
            ArrayList<AssemblySequence> filtered8 = new ArrayList<AssemblySequence>();
            for (AssemblySequence as : this.aligned_seqs) {
                boolean usable;
                char base;
                if (as.get_asm_start() > this.config.manual_clamp_cons_pos || as.get_asm_end() < this.config.manual_clamp_cons_pos || (base = Character.toUpperCase(as.get_base(this.config.manual_clamp_cons_pos))) == ' ' || base == '>' || base == '<') continue;
                if (this.cb_show_only_aligned_no_skips_but_containing_skip.isSelected() || this.cb_show_only_aligned_no_skips_but_containing_skip2.isSelected()) {
                    usable = false;
                    SAMRecord sr2 = as.get_samrecord();
                    if (sr2 != null) {
                        Cigar c = sr2.getCigar();
                        for (CigarElement ce : c.getCigarElements()) {
                            if (!ce.getOperator().equals((Object)CigarOperator.SKIPPED_REGION)) continue;
                            if (this.cb_show_only_aligned_no_skips_but_containing_skip2.isSelected()) {
                                int last_base_before_skip = this.get_reference_base_number(this.config.manual_clamp_cons_pos);
                                int skip_len = this.config.SKIP_END_BASENUM - last_base_before_skip - 1;
                                System.err.println("desired skip=" + skip_len);
                                if (ce.getLength() == skip_len) {
                                    usable = true;
                                }
                            } else {
                                usable = true;
                            }
                            break;
                        }
                    } else {
                        System.err.println("need SAMRecord");
                    }
                } else {
                    usable = true;
                }
                if (!usable) continue;
                filtered8.add(as);
            }
            this.aligned_seqs = filtered8;
        } else {
            this.cb_show_only_aligned_no_skips.setSelected(false);
            this.cb_show_only_aligned_no_skips_but_containing_skip.setSelected(false);
        }
        if (this.config.HIDE_SKIP_ONLY_ALIGNMENTS) {
            char[] buf = new char[this.contig_chunk_size];
            filtered = new ArrayList();
            for (AssemblySequence as : this.aligned_seqs) {
                as.get_visible_sequence(buf, this.contig_start_view);
                boolean usable = false;
                for (int i = 0; i < buf.length; ++i) {
                    if (buf[i] == ' ' || buf[i] == '>' || buf[i] == '<') continue;
                    usable = true;
                    break;
                }
                if (!usable) continue;
                filtered.add(as);
            }
            this.aligned_seqs = filtered;
        }
        this.svl.auto_lock(this.aligned_seqs);
        g.setFont(this.OUR_FONT);
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, d.width, d.height);
        int lines_needed = this.aligned_seqs.size() + 4;
        int lines_available = d.height / this.line_height;
        this.highlight_snps(g, lines_needed);
        PadMap pm = this.config.assembly.get_padmap();
        if (this.config.ENABLE_OVERVIEW && this.hs != null && this.hs.is_loaded()) {
            this.draw_overview(g);
            int i = 0;
            while (i < this.config.OVERVIEW_LINES) {
                this.drawn_y.put("__overview_" + this.draw_line, this.draw_line * this.line_height);
                ++i;
                ++this.draw_line;
                ++lines_needed;
            }
        }
        g.setColor(RULER_COLOR);
        int y = this.draw_line * this.line_height;
        this.drawn_y.put(KEY_RULER, y);
        if (this.config.ENABLE_VARIABLE_WIDTH_FONTS && this.config.ENABLE_VARIABLE_WIDTH_RULER) {
            this.draw_variable_ruler(g, this.draw_line);
        } else {
            Ruler ruler = new Ruler(this.config);
            String ruler_chunk = ruler.get_ruler_for(this.contig_start_view, this.contig_chunk_size, pm);
            g.drawString(ruler_chunk, this.leftbuffer, y);
        }
        this.draw_multiline_indicator(g, this.config.CONSENSUS_TAG, this.draw_line, 2);
        ++this.draw_line;
        int reference_line = this.draw_line;
        y = this.draw_line++ * this.line_height;
        if ((this.cons_highlight_start > 0 || this.cons_highlight_end > 0) && (r1 = new Rectangle(this.contig_start_view, 1, this.contig_end_view - this.contig_start_view, 1)).intersects(r2 = new Rectangle(this.cons_highlight_start + 1, 1, this.cons_highlight_end - this.cons_highlight_start, 1))) {
            Rectangle intersect = r1.intersection(r2);
            int o1 = intersect.x - this.contig_start_view;
            int x1 = this.leftbuffer + o1 * this.font_width;
            int draw_width = (intersect.width + 1) * this.font_width;
            g.setColor(Color.green);
            g.fillRect(x1, y - this.font_ascent, draw_width, this.font_ascent + this.font_descent);
        }
        g.setColor(SEQID_COLOR);
        this.draw_fonted_string(g, this.config.CONSENSUS_TAG, 0, y);
        this.drawn_y.put(this.config.CONSENSUS_TAG, y);
        g.setColor(CONSENSUS_COLOR);
        g.drawString(this.get_consensus_for(this.contig_start_view, this.contig_chunk_size), this.leftbuffer, y);
        if (this.config.ENABLE_HETERO_SUMMARY && this.hs != null && this.hs.is_loaded()) {
            this.draw_hetero_summary(g);
            int i = 0;
            while (i < this.config.HETERO_SUMMARY_LINES) {
                this.drawn_y.put("__nonref_freq_" + this.draw_line, this.draw_line * this.line_height);
                ++i;
                ++this.draw_line;
                ++lines_needed;
            }
        }
        if (this.config.dbsnp != null) {
            boolean track_painted = false;
            int csv_unpadded = pm.get_padded_to_unpadded(this.contig_start_view);
            int cev_unpadded = pm.get_padded_to_unpadded(this.contig_end_view);
            for (dbSNP snp : this.config.dbsnp) {
                if (snp.start < csv_unpadded || snp.end > cev_unpadded) continue;
                if (!track_painted) {
                    y = this.draw_line++ * this.line_height;
                    this.drawn_y.put(LABEL_DBSNP, new Integer(y));
                    g.setColor(CONSENSUS_COLOR);
                    this.draw_fonted_string(g, LABEL_DBSNP, 0, y);
                    track_painted = true;
                    ++lines_needed;
                }
                int snp_padded_x = pm.get_unpadded_to_padded(snp.start);
                g.drawString("$", this.leftbuffer + (snp_padded_x - this.contig_start_view) * this.font_width, y);
            }
        }
        if (this.config.refgenes != null) {
            for (RefGene rg : this.config.refgenes) {
                ArrayList<Exon> exons;
                if (!rg.is_initialized() || rg.is_broken() || (exons = rg.get_exons()).size() <= 0) continue;
                boolean accession_painted = false;
                for (Exon exon : exons) {
                    for (Codon codon : exon.get_codons()) {
                        int center = codon.c_center_offset();
                        if (center < this.contig_start_view || center > this.contig_end_view) continue;
                        if (!accession_painted) {
                            String accession = rg.get_accession();
                            y = this.draw_line++ * this.line_height;
                            this.refseq_ids.add(accession);
                            g.setColor(CONSENSUS_COLOR);
                            String label = this.config.REFSEQ_LABEL_GENE_SYMBOL_FIRST ? rg.get_symbol() + " / " + accession : accession + " / " + rg.get_symbol();
                            this.drawn_y.put("__refseq," + label, new Integer(y));
                            this.draw_fonted_string(g, label, 0, y);
                            accession_painted = true;
                            ++lines_needed;
                            this.arrow_painter.draw(g, rg.is_rc(), y, false);
                        }
                        String label = codon.is_unmappable() ? (codon.get_valid_base_count() > 0 ? "?" : " ") : Character.toString(codon.to_code());
                        g.drawString(label, this.leftbuffer + (center - this.contig_start_view) * this.font_width, y);
                    }
                }
            }
        }
        int sequence_start_line = this.draw_line;
        boolean drew_separator = this.draw_seqs(g, this.aligned_seqs, this.vscroll.getValue(), lines_available);
        if (!drew_separator) {
            --lines_needed;
        }
        this.intron_splice_check(g, reference_line * this.line_height);
        this.hscroll.setValues(this.contig_start_view, this.contig_chunk_size, left_border, right_border);
        this.hscroll.setBlockIncrement(this.contig_chunk_size);
        this.hscroll.setUnitIncrement(1);
        int aligned_count = this.aligned_seqs.size();
        int max_value = lines_available >= lines_needed ? aligned_count : lines_needed;
        int vv = this.vscroll.getValue();
        int max_allowable = max_value - lines_available;
        if (max_allowable < 0) {
            max_allowable = 0;
        }
        if (vv > max_allowable) {
            vv = max_allowable;
        }
        this.vscroll.setValues(vv, lines_available, 0, max_value);
        this.vscroll.setUnitIncrement(1);
        this.notifier.setChanged();
        this.notifier.notifyObservers(this);
    }

    void highlight_snps(Graphics g, int lines_needed) {
        SNPList snps = this.config.assembly.get_snps();
        if (snps != null) {
            for (int i = 0; i < snps.size(); ++i) {
                if (snps.is_current(i)) {
                    g.setColor(SELECTED_COLOR);
                } else {
                    g.setColor(HIGHLIGHT_COLOR);
                }
                int loc = snps.position_of(i);
                if (loc < this.contig_start_view || loc > this.contig_end_view) continue;
                int x = this.leftbuffer + (loc - this.contig_start_view) * this.font_width;
                g.fillRect(x, this.line_height * 2 - this.font_ascent, this.font_width, (lines_needed - 1) * this.line_height);
            }
        }
    }

    boolean draw_seqs(Graphics gr, ArrayList<AssemblySequence> v, int start_index, int lines_available) {
        Graphics2D g = (Graphics2D)gr;
        int drawn_forward = 0;
        int drawn_reverse = 0;
        int index = start_index;
        boolean drew_separator = false;
        this.sequences_drawn = 0;
        char[] newbuf = new char[this.contig_chunk_size];
        ++lines_available;
        char[] cseq = this.config.assembly.get_consensus_sequence();
        boolean paint_quality = this.config.ENABLE_QUALITY_PAINT;
        int end_index = v.size();
        this.visible_seqs = new ArrayList();
        ColorIntensifier ci = new ColorIntensifier();
        ci.set_max_intensity_value(99);
        while (index < end_index && this.draw_line <= lines_available) {
            SAMResource sr;
            int y;
            AssemblySequence as;
            if ((as = v.get(index++)).get_asm_start() >= this.contig_end_view || as.get_asm_end() < this.contig_start_view) {
                System.err.println("WTF: " + as.get_name() + " out of visible range");
                continue;
            }
            if (as.is_complemented()) {
                if (drawn_reverse++ == 0 && drawn_forward > 0) {
                    g.setColor(BORDER_COLOR);
                    y = this.draw_line * this.line_height - this.font_ascent + (this.font_ascent + this.font_descent) / 2;
                    g.drawLine(this.leftbuffer, y, this.getSize().width, y);
                    ++this.draw_line;
                    drew_separator = true;
                }
            } else {
                ++drawn_forward;
            }
            y = this.draw_line * this.line_height;
            String id = as.get_name();
            this.drawn_y.put(id, new Integer(y));
            ++this.sequences_drawn;
            this.visible_seqs.add(as);
            Sample sample = this.config.assembly.get_sample_for(id);
            boolean shadeable = false;
            if (this.heterozygotes != null && this.heterozygotes.containsKey(id)) {
                g.setColor(HETEROZYGOTE_COLOR);
            } else if (this.highlights != null && this.highlights.containsKey(id)) {
                g.setColor(HIGHLIT_COLOR);
            } else if (this.svl.contains(id)) {
                g.setColor(HIGHLIT_COLOR);
            } else if (sample != null) {
                shadeable = true;
                if (sample.is_tumor()) {
                    g.setColor(sample.is_recurrent() ? TUMOR_RECURRENT_COLOR : TUMOR_COLOR);
                } else if (sample.is_normal()) {
                    g.setColor(NORMAL_COLOR);
                } else {
                    g.setColor(SEQID_COLOR);
                }
            } else {
                g.setColor(SEQID_COLOR);
                shadeable = true;
            }
            if (this.config.assembly instanceof SAMAssembly) {
                sr = ((SAMAssembly)this.config.assembly).get_sr_for(id);
                if (sr.custom_color != null) {
                    g.setColor(sr.custom_color);
                }
            }
            if (shadeable && this.config.SHADE_SEQUENCE_IDENTIFIERS_BY_MAPQ) {
                sr = as.get_samrecord();
                g.setColor(ci.get_shaded_color(g.getColor(), sr.getMappingQuality()));
            }
            this.draw_fonted_string(g, id, 0, y);
            sr = as.get_samrecord();
            boolean cancel_mode = sr != null && sr.getDuplicateReadFlag();
            this.arrow_painter.draw(g, as.is_complemented(), y, cancel_mode);
            as.get_visible_sequence(newbuf, this.contig_start_view);
            int cs = as.get_clip_start();
            int ce = as.get_clip_end();
            int co = this.contig_start_view;
            int last_type = -1;
            int last_index = 0;
            int last_qual = -1;
            int i = 0;
            while (i < this.contig_chunk_size) {
                int this_type;
                if (newbuf[i] == ' ') {
                    this_type = 0;
                } else if (co < cs || co > ce) {
                    this_type = 1;
                } else if (co < 1 || co > cseq.length) {
                    this_type = 2;
                } else {
                    char cb = cseq[co - 1];
                    char b = newbuf[i];
                    if (cb == b) {
                        this_type = 2;
                    } else if (b == '>' || b == '<') {
                        this_type = 1;
                    } else {
                        boolean exception = true;
                        switch (b) {
                            case 'A': 
                            case 'a': {
                                if (cb != 'a' && cb != 'A') break;
                                exception = false;
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                if (cb != 'c' && cb != 'C') break;
                                exception = false;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                if (cb != 'g' && cb != 'G') break;
                                exception = false;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                if (cb != 't' && cb != 'T') break;
                                exception = false;
                            }
                        }
                        int n = this_type = exception ? 3 : 2;
                    }
                }
                if (paint_quality) {
                    int qual = as.get_quality(co);
                    this.flush_it(g, newbuf, last_index, last_type, i, y, paint_quality, last_qual);
                    last_index = i;
                    last_type = this_type;
                    last_qual = qual;
                } else if (i == 0) {
                    last_type = this_type;
                } else if (this_type != last_type) {
                    this.flush_it(g, newbuf, last_index, last_type, i, y, false, 0);
                    last_index = i;
                    last_type = this_type;
                }
                ++i;
                ++co;
            }
            this.flush_it(g, newbuf, last_index, last_type, i, y, paint_quality, 0);
            ++this.draw_line;
        }
        return drew_separator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mouse_up(MouseEvent e) {
        boolean long_click = System.currentTimeMillis() - this.down_click_time > 500L;
        boolean right_click = false;
        Point root_point = null;
        String id = null;
        Enumeration en = this.drawn_y.keys();
        int y = e.getY();
        int x = e.getX();
        while (en.hasMoreElements()) {
            String id2 = (String)en.nextElement();
            int i = (Integer)this.drawn_y.get(id2);
            if (y <= i - this.font_ascent || y >= i + this.font_descent) continue;
            id = id2;
            Point p = Gr.get_frame_border(this, "s");
            root_point = Gr.get_root_xy(this, x, i + this.font_descent);
            root_point.y = p.y;
            break;
        }
        if (id == null) return;
        if (id.equals(this.config.CONSENSUS_TAG)) {
            String seq = "";
            SNPList snps = this.config.assembly.get_snps();
            String info = "";
            if (x > this.leftbuffer && snps != null) {
                info = "SNPs marked in brackets (click on \"Consensus\" label for raw sequence)";
                char[] cons = this.config.assembly.get_consensus_sequence();
                Hashtable positions = snps.position_hash();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < cons.length; ++i) {
                    char c = cons[i];
                    if (c == '*' || c == '-') continue;
                    int cpos = i + 1;
                    if (positions.containsKey(Integer.toString(cpos))) {
                        buf.append("[FIX/ME]");
                        continue;
                    }
                    buf.append(c);
                }
                seq = buf.toString();
            } else {
                info = "raw sequence (click in consensus sequence to show SNPs)";
                seq = this.get_consensus_sequence_unpadded().toUpperCase();
            }
            CloseFrame f = new CloseFrame();
            f.setLayout(new BorderLayout());
            TextArea ta = new TextArea(30, 70);
            ta.append(">Consensus; ");
            ta.append(info);
            for (int i = 0; i < seq.length(); ++i) {
                if (i % 60 == 0) {
                    ta.append("\n");
                }
                ta.append("" + seq.charAt(i));
            }
            ta.setEditable(false);
            f.add("Center", ta);
            f.pack();
            f.setVisible(true);
            return;
        } else {
            if (x > this.leftbuffer) {
                int consensus_pos = this.get_consensus_pos(e);
                if (this.ENABLE_TRACE_VIEWER && e.getModifiers() != 8) return;
            }
            System.out.println("clicked on id " + id);
            this.get_entrez_report(id);
        }
    }

    protected void finalize() {
    }

    private void get_entrez_report(String id) {
        AppletContext ac = null;
        if (ac == null) {
            System.out.println("eek, no applet context.");
        } else {
            try {
                String url = "http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=6&dopt=g&uid=" + id;
                ac.showDocument(new URL(url), "Entrez report");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void set_highlights(Hashtable highlights) {
        this.highlights = highlights;
    }

    public void set_heterozygotes(Hashtable heterozygotes) {
        this.heterozygotes = heterozygotes;
    }

    public void set_consensus_highlight(int start, int end) {
        this.cons_highlight_start = start;
        this.cons_highlight_end = end;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.update_tooltip(e);
        this.wheel_motion_start_center = 0;
    }

    private boolean in_consensus_y(MouseEvent e) {
        String id = this.get_mouse_sequence_id(e);
        return id != null && (id.equals(this.config.CONSENSUS_TAG) || id.equals(KEY_RULER));
    }

    private boolean in_overview(MouseEvent e) {
        String id = this.get_mouse_sequence_id(e);
        return id != null && id.indexOf(KEY_OVERVIEW) == 0;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.down_click_time = System.currentTimeMillis();
    }

    private String[] decode_gene_and_refseq(String label) {
        String chunk = label.substring(label.indexOf(",") + 1);
        String[] fields = chunk.split(" / ");
        String[] results = new String[2];
        if (this.config.REFSEQ_LABEL_GENE_SYMBOL_FIRST) {
            results[0] = fields[0];
            results[1] = fields[1];
        } else {
            results[0] = fields[1];
            results[1] = fields[0];
        }
        return results;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            String id = this.get_mouse_sequence_id(e);
            if (id != null) {
                int mx = e.getX();
                if (id.indexOf(KEY_REFSEQ) == 0 && mx < this.leftbuffer) {
                    String gene = null;
                    String refseq = null;
                    String chunk = id.substring(id.indexOf(",") + 1);
                    System.err.println("id=" + id + " chunk=" + chunk);
                    String[] fields = chunk.split(" / ");
                    if (this.config.REFSEQ_LABEL_GENE_SYMBOL_FIRST) {
                        gene = fields[0];
                        refseq = fields[1];
                    } else {
                        gene = fields[1];
                        refseq = fields[0];
                    }
                    String url = null;
                    String target = null;
                    if (mx < this.font_width * (fields[0].length() + 1)) {
                        if (this.config.REFSEQ_LABEL_GENE_SYMBOL_FIRST) {
                            url = WebTools.entrez_gene_link(fields[0]);
                            target = "eg";
                        } else {
                            url = WebTools.entrez_genbank_link(fields[0]);
                            target = "gb";
                        }
                    } else if (this.config.REFSEQ_LABEL_GENE_SYMBOL_FIRST) {
                        url = WebTools.entrez_genbank_link(fields[1]);
                        target = "gb";
                    } else {
                        url = WebTools.entrez_gene_link(fields[1]);
                        target = "eg";
                    }
                    new URLLauncher(url, target);
                } else if (id.indexOf(KEY_OVERVIEW) == 0) {
                    int avail_x = this.font_width * (this.contig_end_view - this.contig_start_view);
                    int mouse_x = e.getX() - this.leftbuffer;
                    char[] cons = this.config.assembly.get_consensus_sequence();
                    int new_cpos = (int)((float)cons.length * ((float)mouse_x / (float)avail_x));
                    this.center_on(new_cpos);
                } else if (id.equals(LABEL_DBSNP)) {
                    dbSNP snp = this.get_dbsnp_snp(e);
                    if (snp != null) {
                        String url = "http://www.ncbi.nlm.nih.gov/projects/SNP/snp_ref.cgi?rs=" + snp.name.substring(2);
                        new URLLauncher(url, "dbsnp");
                    }
                } else {
                    this.svl.toggle_id(id);
                    this.repaint();
                }
            }
        } else if (this.in_consensus_y(e)) {
            String pos = JOptionPane.showInputDialog("Jump to " + this.config.CONSENSUS_TAG + " nucleotide position:");
            try {
                int p = Integer.parseInt(Str.trim_whitespace(pos));
                if (this.config.intron_compressor != null) {
                    int offset = this.config.intron_compressor.get_start_shift(p - this.config.ruler_start, false);
                    p -= offset;
                }
                if (this.config.ruler_start != 0) {
                    p -= this.config.ruler_start;
                }
                if (this.config.COUNTER_UNPADDED) {
                    p = this.config.assembly.get_padmap().get_unpadded_to_padded(p);
                }
                this.center_on(p);
            }
            catch (Exception exception) {}
        } else if (!this.in_overview(e)) {
            this.center_on(this.get_consensus_pos(e));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.ENABLE_TRACE_VIEWER) {
            this.mouse_up(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void flush_it(Graphics g, char[] newbuf, int last_index, int last_type, int i, int y, boolean paint_quality, int q) {
        if (last_type != 0) {
            if (paint_quality && q >= 0) {
                if (last_type == 1) {
                    g.setColor(quality_colors[0]);
                } else if (q >= 0) {
                    if (q >= 40) {
                        g.setColor(Color.white);
                    } else {
                        g.setColor(quality_colors[q]);
                    }
                }
                g.fillRect(this.leftbuffer + last_index * this.font_width, y - this.font_ascent, this.font_width, this.line_height);
            }
            switch (last_type) {
                case 1: {
                    g.setColor(TRIMMED_COLOR);
                    break;
                }
                case 2: {
                    g.setColor(paint_quality && q >= 0 ? SEQUENCE_COLOR_QUAL : SEQUENCE_COLOR);
                    break;
                }
                case 3: {
                    g.setColor(SNP_COLOR);
                }
            }
            String text = new String(newbuf, last_index, i - last_index);
            if (paint_quality && q >= 0) {
                text = q < QUALITY_THRESHOLD_LOWERCASE ? text.toLowerCase() : text.toUpperCase();
            }
            g.drawString(text, this.leftbuffer + last_index * this.font_width, y);
        }
    }

    private void init_quality_colors() {
        if (quality_colors == null) {
            quality_colors = new Color[40];
            int MAX_VALUE = 255;
            int MIN_VALUE = 50;
            int range = MAX_VALUE - MIN_VALUE;
            for (int q = 0; q < 40; ++q) {
                float fraction = (float)q / 40.0f;
                int level = MIN_VALUE + (int)((float)range * fraction);
                AssemblyCanvas.quality_colors[q] = new Color(level, level, level);
            }
        }
    }

    private String get_mouse_sequence_id(MouseEvent me) {
        String id = null;
        Enumeration en = this.drawn_y.keys();
        int y = me.getY();
        while (en.hasMoreElements()) {
            String id2 = (String)en.nextElement();
            int i = (Integer)this.drawn_y.get(id2);
            if (y < i - this.font_ascent || y > i + this.font_descent) continue;
            id = id2;
            break;
        }
        return id;
    }

    private void update_tooltip(MouseEvent me) {
        int x = me.getX();
        String id = this.get_mouse_sequence_id(me);
        String text = id == null || id.indexOf(KEY_NONREF_FREQUENCY) == 0 || id.indexOf(KEY_OVERVIEW) == 0 || id.indexOf(KEY_REFSEQ) == 0 || id.indexOf(KEY_RULER) == 0 ? "" : id;
        if (!this.config.assembly.alignment_is_built()) {
            return;
        }
        PadMap pm = this.config.assembly.get_padmap();
        if (x > this.leftbuffer) {
            int unpadded;
            int consensus_pos = this.get_consensus_pos(me);
            if (id != null && id.equals(LABEL_DBSNP) && this.config.dbsnp != null) {
                unpadded = pm.get_padded_to_unpadded(consensus_pos);
                for (dbSNP snp : this.config.dbsnp) {
                    if (snp.start != unpadded) continue;
                    text = "dbSNP:" + snp.name + " bases:" + snp.get_normalized_observed_bases();
                }
            }
            if (id != null && this.hs != null) {
                if (id.indexOf(KEY_NONREF_FREQUENCY) == 0) {
                    unpadded = pm.get_padded_to_unpadded(consensus_pos);
                    text = this.hs.get_tooltip_text(unpadded);
                } else if (id.indexOf(KEY_OVERVIEW) == 0) {
                    short[] coverage;
                    text = "global assembly coverage";
                    if (this.hs != null && (coverage = this.hs.get_coverage()) != null) {
                        int avail_x = this.font_width * (this.contig_end_view - this.contig_start_view);
                        int mouse_x = x - this.leftbuffer;
                        char[] cons = this.config.assembly.get_consensus_sequence();
                        int cpos = (int)((float)cons.length * ((float)mouse_x / (float)avail_x));
                        if (cpos >= 0 && cpos < cons.length) {
                            int unpadded2 = pm.get_padded_to_unpadded(cpos);
                            text = text + ": " + coverage[unpadded2] + " read" + (coverage[unpadded2] == 1 ? "" : "s") + " at " + this.get_reference_base_number(cpos);
                        }
                    }
                    text = text + " (click to move)";
                    this.setToolTipText(text);
                    return;
                }
            }
            text = text.concat(" base#:" + this.get_reference_base_number(consensus_pos));
        }
        if (this.in_consensus_y(me)) {
            text = text.concat(" (double-click to jump to a position)");
        } else {
            Sample s = this.config.assembly.get_sample_for(id);
            if (s != null && s.get_sample_name() != null) {
                text = text.concat(" sample:" + s.get_sample_name());
                String desc = s.get_description();
                if (desc != null) {
                    text = text.concat(" tissue:" + desc);
                }
            }
            if (x > this.leftbuffer) {
                String[] gar;
                String refseq;
                int consensus_pos = this.get_consensus_pos(me);
                AssemblySequence as = this.config.assembly.get_sequence(id);
                if (as != null) {
                    int qual = as.get_quality(consensus_pos);
                    if (qual != -1) {
                        text = text.concat(" quality:" + qual);
                    }
                    if (as instanceof SAMConsensusMapping) {
                        SAMConsensusMapping scm = (SAMConsensusMapping)as;
                        SAMRecord sr = scm.get_samrecord();
                        text = text.concat(" MapQ:" + sr.getMappingQuality());
                        HashMap<String, String> tags = new HashMap<String, String>();
                        for (SAMRecord.SAMTagAndValue tav : sr.getAttributes()) {
                            String value = tav.value.toString();
                            if (value.length() > 10) {
                                value = value.substring(0, 10) + "...";
                            }
                            tags.put(tav.tag, value);
                        }
                        ArrayList keys = new ArrayList(tags.keySet());
                        Collections.sort(keys);
                        for (String key : keys) {
                            text = text.concat(" " + key + ":" + (String)tags.get(key));
                        }
                    }
                } else if (id != null && id.indexOf(KEY_REFSEQ) == 0 && this.refseq_ids.contains(refseq = (gar = this.decode_gene_and_refseq(id))[1]) && this.config.refgenes != null) {
                    block3: for (RefGene rg : this.config.refgenes) {
                        if (!rg.get_accession().equals(refseq)) continue;
                        ArrayList<Exon> exons = rg.get_exons();
                        boolean done = false;
                        for (Exon exon : exons) {
                            for (Codon codon : exon.get_codons()) {
                                if (!codon.intersects_padded_consensus(consensus_pos)) continue;
                                text = text.concat(" (" + rg.get_symbol() + " exon " + exon.get_id() + ")");
                                text = text.concat(", codon " + Integer.toString(codon.get_id()));
                                if (codon.is_unmappable()) {
                                    text = "<html>" + text.concat("<br><b>NOTE</b>: codon can't be completely mapped; all required exonic regions may not be loaded in viewer</html>");
                                }
                                done = true;
                                break;
                            }
                            if (!done) continue;
                            continue block3;
                        }
                    }
                }
            }
        }
        this.setToolTipText(text);
    }

    private void set_leftbuffer() {
        if (this.config.ENABLE_VARIABLE_WIDTH_FONTS) {
            int max_len;
            this.leftbuffer = this.fwt == null || this.VAR_FONT == null ? 0 : (max_len = this.fwt.get_max_width());
        } else {
            int max_len = this.config.assembly.get_max_id_length();
            if (LABEL_NONREF_FREQUENCY.length() > max_len) {
                max_len = LABEL_NONREF_FREQUENCY.length();
            }
            if (this.config.CONSENSUS_TAG.length() > max_len) {
                max_len = this.config.CONSENSUS_TAG.length();
            }
            this.leftbuffer = max_len * this.font_width;
        }
        this.arrow_painter.left_margin = this.leftbuffer;
        this.leftbuffer += this.arrow_painter.total_width;
    }

    public void zoom(boolean zoom_in) {
        int paintable_nt = this.contig_end_view - this.contig_start_view;
        int center_x = this.contig_start_view + paintable_nt / 2;
        this.font_size += zoom_in ? 1 : -1;
        this.set_font_size(this.font_size);
        this.set_leftbuffer();
        this.center_on(center_x);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if ((e.getModifiers() & 0x1FA) == 0) {
            int paintable_nt = this.contig_end_view - this.contig_start_view;
            int half_paintable = paintable_nt / 2;
            if (this.wheel_motion_start_center == 0) {
                this.wheel_motion_start_center = this.contig_start_view + half_paintable;
            }
            this.font_size += e.getWheelRotation() < 0 ? 1 : -1;
            this.set_font_size(this.font_size);
            this.set_leftbuffer();
            int center_x = this.wheel_motion_start_center;
            if (e.getWheelRotation() < 0) {
                int mp_x = e.getPoint().x - this.leftbuffer;
                int total = this.getSize().width - this.leftbuffer;
                float frac = (float)mp_x / (float)total;
                if (frac < 0.0f) {
                    frac = 0.0f;
                }
                float dilution_factor = 0.4f;
                int offset = (int)((float)paintable_nt * dilution_factor * (frac -= 0.5f));
                center_x += offset;
            }
            this.center_on(center_x);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        char c = ke.getKeyChar();
        if (c == '+') {
            this.zoom(true);
        } else if (c == '-') {
            this.zoom(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem src = (JMenuItem)e.getSource();
        String label = src.getText();
        if (label.equals(LABEL_TRACE_VIEWER)) {
            AssemblySequence as;
            MouseEvent me = this.pul.getMouseEvent();
            String id = this.get_mouse_sequence_id(me);
            int consensus_pos = this.get_consensus_pos(me);
            if (id != null && (as = this.config.assembly.get_sequence(id)) instanceof SAMConsensusMapping) {
                SAMConsensusMapping scm = (SAMConsensusMapping)as;
                SAMRecord sr = scm.get_samrecord();
                SAMTracePeakPositions stpp = new SAMTracePeakPositions(sr);
                int peak_pos = stpp.get_peak_position_for_consensus(scm, consensus_pos);
                StreamDelegator.set_local(true);
                if (this.config.CHROMAT_DIR == null) {
                    JOptionPane.showMessageDialog(this, "Error: no trace directory specified (use -trace-dir on command line)", "Error", 0);
                    return;
                }
                String trace_name = this.config.CHROMAT_DIR + File.separator + sr.getReadName();
                if (trace_name.indexOf("_alternate") == trace_name.length() - 10) {
                    trace_name = trace_name.substring(0, trace_name.length() - 10);
                }
                boolean rc = sr.getReadNegativeStrandFlag();
                TraceViewer tv = this.tvc.get_traceviewer(trace_name, rc);
                TraceFile tf = tv.get_trace();
                if (rc) {
                    while (true) {
                        if (tf.loaded()) {
                            peak_pos = tf.num_samples - peak_pos;
                            System.err.println("flipped pos=" + peak_pos);
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                tv.center_on(peak_pos);
                tv.setVisible(true);
            }
        } else if (label.equals(LABEL_DEBUG_PEAK_AMP_RATIO)) {
            AssemblySequence as;
            MouseEvent me = this.pul.getMouseEvent();
            String id = this.get_mouse_sequence_id(me);
            int consensus_pos = this.get_consensus_pos(me);
            if (id != null && (as = this.config.assembly.get_sequence(id)) instanceof SAMConsensusMapping) {
                SAMConsensusMapping scm = (SAMConsensusMapping)as;
                SAMRecord sr = scm.get_samrecord();
                SAMAlternatePeakAmplitudeRatios apar = new SAMAlternatePeakAmplitudeRatios(sr);
                byte ratio = apar.get_alternate_peak_amplitude_ratio_for_consensus(scm, consensus_pos);
                String msg = Integer.toString(ratio) + "%";
                JOptionPane.showMessageDialog(this, msg, "Alternate basecall amplitude ratio", 1);
            }
        } else if (label.equals(LABEL_PROTEIN_CHANGE)) {
            int cpos;
            CDSChangePredictor cdp;
            char variant_nt;
            Object msg = this.config.refgenes == null || this.config.refgenes.size() == 0 ? "No reference gene coding sequences have been loaded." : ((variant_nt = (cdp = new CDSChangePredictor(this.config)).get_variant_nt(cpos = this.get_consensus_pos(this.pul.getMouseEvent()), this)) == '\u0000' ? null : (cdp.predict_cds_changes(cpos, variant_nt) ? this.config.CONSENSUS_TAG + " allele:" + cdp.get_consensus_nt() + " variant:" + variant_nt + "\n" + cdp.toString() : "This SNP does not fall within any loaded coding sequences."));
            if (msg != null) {
                JOptionPane.showMessageDialog(this, msg, "Protein change", 1);
            }
        } else if (label.equals(LABEL_SHOW_ONLY_ALIGNED)) {
            this.config.manual_clamp_cons_pos = this.get_consensus_pos(this.pul.getMouseEvent());
            this.config.manual_clamp_cons_start = this.contig_start_view;
            this.repaint();
        } else if (label.equals(LABEL_SHOW_ONLY_ALIGNED_NO_SKIPS)) {
            this.config.manual_clamp_cons_pos = this.get_consensus_pos(this.pul.getMouseEvent());
            this.config.manual_clamp_cons_start = this.contig_start_view;
            this.repaint();
        } else if (label.equals(LABEL_SHOW_ONLY_ALIGNED_NO_SKIPS_BUT_CONTAINING_SKIP)) {
            this.config.manual_clamp_cons_pos = this.get_consensus_pos(this.pul.getMouseEvent());
            this.config.manual_clamp_cons_start = this.contig_start_view;
            this.repaint();
        } else if (label.equals(LABEL_SHOW_ONLY_ALIGNED_NO_SKIPS_BUT_CONTAINING_SKIP2)) {
            String pos = JOptionPane.showInputDialog("Skip ending at what base number?: ");
            try {
                this.config.SKIP_END_BASENUM = Integer.parseInt(pos);
                this.config.manual_clamp_cons_pos = this.get_consensus_pos(this.pul.getMouseEvent());
                this.config.manual_clamp_cons_start = this.contig_start_view;
            }
            catch (Exception x) {
                // empty catch block
            }
            this.repaint();
        } else if (label.equals(LABEL_SHOW_ONLY_NONREFERENCE)) {
            this.config.clamp_nonref_cons_pos = this.get_consensus_pos(this.pul.getMouseEvent());
            this.config.clamp_nonref_cons_start = this.contig_start_view;
            this.repaint();
        } else if (src.equals(this.jmi_blat)) {
            this.run_blat(false);
        } else if (src.equals(this.jmi_blat_mate)) {
            this.run_blat(true);
        } else if (label.equals(LABEL_SHOW_ONLY_INDEL)) {
            this.repaint();
        } else {
            System.err.println("unhandled event");
        }
    }

    public int get_consensus_pos(MouseEvent e) {
        return this.contig_start_view + (e.getX() - this.leftbuffer) / this.font_width;
    }

    public dbSNP get_dbsnp_snp(MouseEvent me) {
        int consensus_pos = this.get_consensus_pos(me);
        int unpadded = this.config.assembly.get_padmap().get_padded_to_unpadded(consensus_pos);
        dbSNP result = null;
        for (dbSNP snp : this.config.dbsnp) {
            if (snp.start != unpadded) continue;
            result = snp;
            break;
        }
        return result;
    }

    private String get_consensus_for(int csv, int size) {
        int si = csv - 1;
        StringBuffer result = new StringBuffer();
        int copy = size;
        while (si < 0) {
            ++si;
            result.append(" ");
            --copy;
        }
        char[] cons = this.config.assembly.get_consensus_sequence();
        while (copy > 0 && si < cons.length) {
            result.append(cons[si]);
            --copy;
            ++si;
        }
        String res = result.toString();
        if (this.config.UPPERCASE_REFERENCE_SEQUENCE) {
            res = res.toUpperCase();
        }
        return res;
    }

    private String get_consensus_sequence_unpadded() {
        StringBuffer unpadded = new StringBuffer();
        char[] cons = this.config.assembly.get_consensus_sequence();
        for (int i = 0; i < cons.length; ++i) {
            char c = cons[i];
            if (c == '*' || c == '-') continue;
            unpadded.append(c);
        }
        return unpadded.toString();
    }

    public ArrayList<AssemblySequence> get_aligned_sequences() {
        return this.aligned_seqs;
    }

    public ArrayList<AssemblySequence> get_visible_sequences() {
        return this.visible_seqs;
    }

    public void set_config(AceViewerConfig config) {
        this.config = config;
        this.fwt = null;
        this.contig_start_view = 1;
        config.assembly.addObserver(this);
        this.first_paint = true;
        this.repaint();
    }

    public void set_hetero_summary(HeteroSummary hs) {
        this.hs = hs;
        hs.addObserver(this);
        this.repaint();
    }

    private void draw_hetero_summary(Graphics2D g) {
        this.draw_multiline_indicator(g, LABEL_NONREF_FREQUENCY, this.draw_line, this.config.HETERO_SUMMARY_LINES);
        g.setColor(NONREF_FREQUENCY_COLOR);
        int csv = this.contig_start_view;
        byte[] global_nonref_freq = this.hs.get_global_nonreference_frequency();
        byte[] normal_nonref_freq = this.hs.get_normal_nonreference_frequency();
        byte[] tumor_nonref_freq = this.hs.get_tumor_nonreference_frequency();
        int max_line_thickness = 1;
        int buffer = max_line_thickness + 1;
        int top_y = this.draw_line * this.line_height - this.font_ascent + buffer;
        int bottom_y = (this.draw_line + (this.config.HETERO_SUMMARY_LINES - 1)) * this.line_height + this.font_descent - buffer;
        int headroom = bottom_y - top_y;
        ArrayList x_points = new ArrayList();
        ArrayList y_points = new ArrayList();
        int x = this.leftbuffer;
        int y = (this.draw_line + (this.config.HETERO_SUMMARY_LINES - 1)) * this.line_height;
        g.setColor(SEQID_COLOR);
        this.draw_fonted_string(g, LABEL_NONREF_FREQUENCY, 0, y);
        PadMap pm = this.config.assembly.get_padmap();
        int half_font_width = this.font_width / 2;
        g.setColor(SUMMARY_PANEL_BACKGROUND_COLOR);
        g.fillRect(x, top_y, x + this.font_width * (this.contig_end_view - this.contig_start_view), headroom + 1);
        Color tumor_color = new Color(225, 0, 0);
        int i = this.contig_start_view - 1;
        while (i < this.contig_end_view) {
            int ui;
            if (i >= 0 && (ui = this.config.REFERENCE_SEQUENCE_PREPADDED ? i : pm.get_padded_to_unpadded(i)) >= 0) {
                int height;
                byte freq;
                if (this.hs.is_tumor_normal_trackable()) {
                    if (normal_nonref_freq != null && ui < normal_nonref_freq.length) {
                        freq = normal_nonref_freq[ui];
                        if (freq > 0) {
                            height = (int)((float)headroom * ((float)freq / 100.0f));
                            g.setColor(NORMAL_COLOR);
                            g.fillRect(x, bottom_y - height, this.font_width, height);
                        }
                        if ((freq = tumor_nonref_freq[ui]) > 0) {
                            height = (int)((float)headroom * ((float)freq / 100.0f));
                            g.setColor(tumor_color);
                            g.fillRect(x + 2, bottom_y - height, this.font_width - 4, height);
                        }
                    }
                } else if (global_nonref_freq != null && ui < global_nonref_freq.length && ui >= 0 && (freq = global_nonref_freq[ui]) > 0) {
                    height = (int)((float)headroom * ((float)freq / 100.0f));
                    if (this.hs.is_all_normal()) {
                        g.setColor(NORMAL_COLOR);
                    } else if (this.hs.is_all_tumor()) {
                        g.setColor(tumor_color);
                    } else {
                        g.setColor(SEQUENCE_COLOR);
                    }
                    g.fillRect(x, bottom_y - height, this.font_width, height);
                }
            }
            ++i;
            x += this.font_width;
        }
    }

    private void draw_multiline_indicator(Graphics g, String label, int top_line, int total_lines) {
        int buffer = 2;
        int top_y = this.get_top_y_for_line(top_line) + buffer;
        int bottom_y = this.get_bottom_y_for_line(top_line + total_lines) - buffer;
        FontMetrics fm = this.config.ENABLE_VARIABLE_WIDTH_FONTS ? this.getFontMetrics(this.VAR_FONT) : this.getFontMetrics(this.OUR_FONT);
        int intensity = 70;
        g.setColor(new Color(intensity, intensity, intensity));
        int buf = (int)((float)this.font_width * 0.75f);
        int x = fm.stringWidth(label) + this.font_width;
        int rx1 = this.leftbuffer - this.font_width * 2;
        int rx2 = this.leftbuffer - buf;
        int center_y = bottom_y - (fm.getDescent() + fm.getAscent() / 3);
        g.drawLine(x, center_y, rx1, center_y);
        g.drawLine(rx1, bottom_y, rx2, bottom_y);
        g.drawLine(rx1, top_y, rx2, top_y);
        g.drawLine(rx1, bottom_y, rx1, top_y);
    }

    private int get_top_y_for_line(int line) {
        int buffer = 0;
        return line * this.line_height - this.font_ascent + buffer;
    }

    private int get_bottom_y_for_line(int line) {
        int buffer = 0;
        return (line - 1) * this.line_height + this.font_descent - buffer;
    }

    private void draw_overview(Graphics g) {
        int i;
        int x = this.leftbuffer;
        int y = (this.draw_line + (this.config.OVERVIEW_LINES - 1)) * this.line_height;
        g.setColor(SEQID_COLOR);
        this.draw_fonted_string((Graphics2D)g, LABEL_ASSEMBLY_COVERAGE, 0, y);
        this.draw_multiline_indicator(g, LABEL_ASSEMBLY_COVERAGE, this.draw_line, this.config.OVERVIEW_LINES);
        boolean buffer = false;
        int top_y = this.get_top_y_for_line(this.draw_line);
        int bottom_y = this.get_bottom_y_for_line(this.draw_line + this.config.OVERVIEW_LINES);
        int headroom = bottom_y - top_y + 1;
        int avail_x = this.font_width * (this.contig_end_view - this.contig_start_view);
        char[] cons = this.config.assembly.get_consensus_sequence();
        int clen = cons.length;
        g.setColor(SUMMARY_PANEL_BACKGROUND_COLOR);
        g.fillRect(x, top_y, avail_x, headroom + 1);
        float x_scaler = (float)avail_x / (float)clen;
        int max_coverage = this.hs.get_max_coverage();
        float y_scaler = (float)headroom / (float)max_coverage;
        short[] coverage = this.hs.get_coverage();
        g.setColor(COVERAGE_COLOR);
        int[] x_points = new int[coverage.length + 1];
        int[] y_points = new int[coverage.length + 1];
        x_points[coverage.length] = this.leftbuffer + avail_x;
        if (this.config.OVERVIEW_INVERTED) {
            Arrays.fill(y_points, bottom_y);
            y_points[coverage.length] = top_y;
        } else {
            Arrays.fill(y_points, top_y);
            y_points[coverage.length] = bottom_y;
        }
        PadMap pm = this.config.assembly.get_padmap();
        for (i = 0; i < coverage.length; ++i) {
            int basenum = pm.get_unpadded_to_padded(i + 1);
            x_points[i] = this.leftbuffer + (int)((float)basenum * x_scaler);
            float cov_scaled = (float)coverage[i] * y_scaler;
            if (cov_scaled > 0.0f && cov_scaled < 1.0f) {
                cov_scaled = 1.0f;
            }
            if (this.config.OVERVIEW_INVERTED) {
                y = top_y + (int)cov_scaled;
                if (y >= y_points[i]) continue;
                y_points[i] = y;
                continue;
            }
            y = bottom_y - (int)cov_scaled;
            if (y <= y_points[i]) continue;
            y_points[i] = y;
        }
        Graphics2D g2 = (Graphics2D)g;
        int y_origin = this.config.OVERVIEW_INVERTED ? top_y : bottom_y;
        ArrayList<Range> ranges = new ArrayList<Range>();
        Range r = null;
        for (i = 0; i < coverage.length; ++i) {
            if (y_points[i] == y_origin) {
                r = null;
                continue;
            }
            if (r == null) {
                r = new Range();
                ranges.add(r);
                r.start = i;
            }
            r.end = i;
        }
        for (Range r2 : ranges) {
            int len = r2.size();
            int[] xs = new int[len + 2];
            int[] ys = new int[len + 2];
            System.arraycopy(x_points, r2.start, xs, 1, len);
            System.arraycopy(y_points, r2.start, ys, 1, len);
            xs[0] = xs[1];
            ys[0] = y_origin;
            xs[len + 1] = xs[len];
            ys[len + 1] = y_origin;
            g2.fillPolygon(xs, ys, len + 2);
        }
        Composite c_orig = g2.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.4f);
        g2.setComposite(ac);
        int intensity = 255;
        g.setColor(new Color(intensity, intensity, intensity));
        int sx = this.leftbuffer + (int)((float)avail_x * ((float)this.contig_start_view / (float)clen));
        int width = (int)((float)(this.contig_end_view - this.contig_start_view) * ((float)avail_x / (float)clen));
        int ex = sx + width;
        g.fillRect(sx, top_y, ex - sx + 1, headroom);
        g2.setComposite(c_orig);
        if (this.config.refgenes != null) {
            g2.setColor(CONSENSUS_COLOR);
            for (RefGene rg : this.config.refgenes) {
                if (!rg.is_initialized() || rg.is_broken()) continue;
                for (Exon exon : rg.get_exons()) {
                    int min;
                    int exs = exon.get_first_start();
                    int exe = exon.get_last_end();
                    ArrayList<Integer> points = new ArrayList<Integer>();
                    for (Codon codon : exon.get_codons()) {
                        if (codon.is_unmappable()) continue;
                        if (codon.is_spliced()) {
                            for (i = 0; i < 3; ++i) {
                                x = this.leftbuffer + (int)((float)codon.consensus_pos[i] * x_scaler);
                                g2.drawLine(x, top_y, x, top_y);
                            }
                            continue;
                        }
                        points.add(codon.consensus_pos[0]);
                        points.add(codon.consensus_pos[2]);
                    }
                    if (points.size() <= 0) continue;
                    int max = min = ((Integer)points.get(0)).intValue();
                    for (Integer p : points) {
                        if (p < min) {
                            min = p;
                        }
                        if (p <= max) continue;
                        max = p;
                    }
                    g2.drawLine(this.leftbuffer + (int)((float)min * x_scaler), top_y, this.leftbuffer + (int)((float)max * x_scaler), top_y);
                }
            }
        }
        if (this.hs.is_tumor_normal_trackable()) {
            byte[] nf = new byte[avail_x];
            byte[] tf = new byte[avail_x];
            this.scale_array(this.hs.get_normal_nonreference_frequency(), nf, x_scaler);
            this.scale_array(this.hs.get_tumor_nonreference_frequency(), tf, x_scaler);
            byte MIN_FREQ = (byte)(this.config.snp_config.MIN_MINOR_ALLELE_FREQUENCY * 100.0f);
            Composite orig_composite = g2.getComposite();
            Stroke orig_stroke = g2.getStroke();
            g2.setStroke(new BasicStroke(1.5f));
            g.setColor(Color.blue);
            for (i = 0; i < nf.length; ++i) {
                int amp;
                byte freq = nf[i];
                if (freq < MIN_FREQ || (amp = (int)((float)headroom * ((float)freq / 100.0f))) <= 0) continue;
                g2.drawLine(this.leftbuffer + i, bottom_y, this.leftbuffer + i, bottom_y - amp);
            }
            g2.setStroke(new BasicStroke(0.5f));
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g.setColor(Color.red);
            for (i = 0; i < tf.length; ++i) {
                int amp;
                byte freq = tf[i];
                if (freq < MIN_FREQ || (amp = (int)((float)headroom * ((float)freq / 100.0f))) <= 0) continue;
                g2.drawLine(this.leftbuffer + i, bottom_y, this.leftbuffer + i, bottom_y - amp);
            }
            g2.setStroke(orig_stroke);
            g2.setComposite(orig_composite);
        }
    }

    private void scale_array(byte[] in, byte[] out, float scale_factor) {
        PadMap pm = this.config.assembly.get_padmap();
        for (int i = 0; i < in.length; ++i) {
            int j;
            int pi = pm.get_unpadded_to_padded(i);
            if (pi < 0) {
                pi = 0;
            }
            if (in[i] <= out[j = (int)((float)pi * scale_factor)]) continue;
            out[j] = in[i];
        }
    }

    private void draw_fonted_string(Graphics2D g, String string, int x, int y) {
        if (this.config.ENABLE_VARIABLE_WIDTH_FONTS) {
            g.setFont(this.VAR_FONT);
        }
        g.drawString(string, x, y);
        if (this.config.ENABLE_VARIABLE_WIDTH_FONTS) {
            g.setFont(this.OUR_FONT);
        }
    }

    private void draw_variable_ruler(Graphics2D g, int line) {
        int y = line * this.line_height;
        int flank = 20;
        int csv = this.contig_start_view - flank;
        int end = this.contig_end_view + flank;
        int x = this.leftbuffer - flank * this.font_width;
        int offset = 0;
        if (this.config.intron_trim_sites != null) {
            for (int i : this.config.intron_trim_sites.keySet()) {
                if (i >= csv) continue;
                offset += this.config.intron_trim_sites.get(i).intValue();
            }
        }
        PadMap pm = this.config.assembly.get_padmap();
        g.setFont(this.VAR_FONT);
        FontMetrics fm = this.getFontMetrics(this.OUR_FONT);
        int half_period = fm.stringWidth(".") / 2;
        int half_width = this.font_width / 2;
        int mod = 10;
        int dot_spacing = 5;
        int lsize = Integer.valueOf(csv + this.config.ruler_start).toString().length();
        if (lsize >= 7) {
            mod = 20;
            dot_spacing = 10;
        }
        HashSet<String> drew = new HashSet<String>();
        int descent_y = y + this.font_descent;
        int bn = csv;
        while (bn < end) {
            int unpadded = bn < 0 ? 0 : pm.get_padded_to_unpadded(bn);
            int label = this.config.ruler_start + unpadded + offset;
            String lb = Integer.toString(label);
            if (!drew.contains(lb)) {
                int w;
                drew.add(lb);
                if (label % mod == 0) {
                    w = fm.stringWidth(lb);
                    g.setColor(RULER_COLOR);
                    g.drawString(lb, x + half_width - w / 2, y);
                }
                if (label % 10 == 0) {
                    g.setColor(RULER_COLOR);
                    g.drawLine(x + half_width, descent_y, x + half_width, descent_y);
                } else if (label % 5 == 0) {
                    g.setColor(Color.gray);
                    g.drawLine(x + half_width, descent_y, x + half_width, descent_y);
                }
                if (this.config.intron_trim_sites != null && this.config.intron_trim_sites.containsKey(bn)) {
                    g.setColor(BACKGROUND_COLOR);
                    w = fm.stringWidth(">");
                    g.fillRect(x - w, y - fm.getAscent() + 2, w * 10, fm.getHeight());
                    g.setColor(INTRON_SPLICE_COLOR);
                    g.drawString(">", x - w, y);
                    int skip = this.config.intron_trim_sites.get(bn);
                    offset += skip;
                }
            }
            ++bn;
            x += this.font_width;
        }
        g.setColor(BACKGROUND_COLOR);
        int ty = this.get_top_y_for_line(line) + 1;
        int by = this.get_bottom_y_for_line(line);
        g.fillRect(0, ty, this.leftbuffer, by);
        g.setFont(this.OUR_FONT);
    }

    private void intron_splice_check(Graphics2D g, int start_y) {
        if (this.config.intron_trim_sites != null) {
            g.setColor(INTRON_SPLICE_COLOR);
            Stroke s_orig = g.getStroke();
            Composite c_orig = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            for (Integer splice_pos : this.config.intron_trim_sites.keySet()) {
                int sp = splice_pos;
                if (sp < this.contig_start_view || sp > this.contig_end_view) continue;
                int x = this.leftbuffer + (sp - this.contig_start_view) * this.font_width;
                g.drawLine(x, start_y, x, 1000);
            }
            g.setStroke(s_orig);
            g.setComposite(c_orig);
        }
    }

    public int get_reference_base_number(int consensus_pos) {
        int offset = 0;
        if (this.config.intron_compressor != null) {
            offset = this.config.intron_compressor.get_trimmed_to_untrimmed_shift(consensus_pos);
        }
        int mapped_pos = this.config.assembly.get_padmap().get_padded_to_unpadded(consensus_pos);
        if (this.config.ruler_start > 0) {
            mapped_pos += this.config.ruler_start;
        }
        return mapped_pos += offset;
    }

    private void run_blat(boolean blat_mate) {
        MouseEvent me = this.pul.getMouseEvent();
        String id = this.get_mouse_sequence_id(me);
        int consensus_pos = this.get_consensus_pos(me);
        System.err.println("id=" + id);
        AssemblySequence as = this.config.assembly.get_sequence(id);
        if (id != null) {
            as = this.config.assembly.get_sequence(id);
        }
        if (id == null || as == null || !(as instanceof SAMConsensusMapping)) {
            JOptionPane.showMessageDialog(this, "Error: mouse must be pointed at an assembled SAM/BAM read", "Error", 0);
        } else {
            SAMConsensusMapping scm = (SAMConsensusMapping)as;
            SAMRecord sr = scm.get_samrecord();
            String query = new String(sr.getReadBases());
            if (blat_mate) {
                SAMRecord mate = null;
                try {
                    SAMResource sres;
                    SamReader sfr;
                    Iterator<SAMResource> i$ = this.config.sams.iterator();
                    while (i$.hasNext() && ((sfr = (sres = i$.next()).getSamReader()) == null || (mate = sfr.queryMate(sr)) == null)) {
                    }
                }
                catch (IOException ex) {
                    System.err.println("ERROR: " + ex);
                }
                if (mate == null) {
                    JOptionPane.showMessageDialog(this, "Sorry, can't retreive mate read.", "Error", 0);
                    return;
                }
                query = new String(mate.getReadBases());
            }
            String url = "http://genome.ucsc.edu/cgi-bin/hgBlat?org=Human&db=" + this.config.BLAT_GENOME + "&type=DNA&userSeq=" + query;
            new URLLauncher(url, "blat");
        }
    }
}

