/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.Chromosome;
import Ace2.JDBCCache;
import Ace2.PadMap;
import Ace2.RefGene;
import Ace2.dbSNP;
import Funk.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;

public class AnnotationLoader
extends Observable
implements Runnable {
    AceViewerConfig config;
    private boolean is_loaded;

    public AnnotationLoader(AceViewerConfig config, boolean async) {
        this.config = config;
        this.is_loaded = false;
        if (async) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    public void run() {
        String chr_name = null;
        boolean broken = false;
        if (this.config.region.tname == null) {
            broken = true;
        } else {
            chr_name = Chromosome.standardize_name(this.config.region.tname);
        }
        if (broken) {
            this.is_loaded = true;
            this.config.refgenes = null;
            this.config.set_dbsnp(null);
            return;
        }
        Timer tm = new Timer("db annotation setup");
        JDBCCache ucsc = this.config.get_ucsc_genome_client();
        Exception exception = null;
        String cmd = this.config.region.gene_name != null ? "select * from refGene where name2=\"" + this.config.region.gene_name + "\"" : "select * from refGene where chrom=\"" + this.config.region.get_ucsc_chromosome() + "\"" + " and not(txEnd < " + this.config.region.range.start + " or txStart > " + this.config.region.range.end + ") order by name";
        System.err.println("refGene query: " + cmd);
        ArrayList<HashMap<String, String>> results = null;
        try {
            results = ucsc.query(cmd);
            if (results.size() > 0) {
                ArrayList<RefGene> refgenes = new ArrayList<RefGene>();
                PadMap pm = this.config.intron_compressor == null ? this.config.assembly.get_padmap() : this.config.intron_compressor.get_raw_padmap();
                for (HashMap<String, String> row : results) {
                    RefGene rg = new RefGene(row);
                    rg.consensus_adjust(this.config.ruler_start);
                    rg.consensus_setup(pm);
                    rg.intron_splice_adjust(this.config);
                    refgenes.add(rg);
                }
                this.config.refgenes = refgenes;
            }
        }
        catch (Exception e) {
            System.err.println("database error: " + e);
            e.printStackTrace();
            exception = e;
        }
        String snp_table = JDBCCache.UCSC_SNP_TABLE;
        System.err.println("default SNP table: " + snp_table);
        if (this.config.DETECT_SNP_TABLE_NAME && !this.config.DETECTED_SNP_TABLE_NAME) {
            String schema_table = "Tables_in_" + JDBCCache.UCSC_DB_DATABASE;
            cmd = "show tables where " + schema_table + " like 'snp1%' and length(" + schema_table + ") = 6";
            try {
                int highest = 0;
                for (HashMap<String, String> row : ucsc.query(cmd)) {
                    String tname = row.get("TABLE_NAME");
                    int build_num = Integer.parseInt(tname.substring(3));
                    if (build_num <= highest) continue;
                    highest = build_num;
                }
                if (highest > 0) {
                    snp_table = "snp" + highest;
                    System.err.println("autodetected SNP table " + snp_table);
                    JDBCCache.UCSC_SNP_TABLE = snp_table;
                }
                this.config.DETECTED_SNP_TABLE_NAME = true;
            }
            catch (Exception e) {
                System.err.println("ERROR detecting SNP table");
                e.printStackTrace();
            }
        }
        System.err.println("SNP query: refname=" + chr_name);
        cmd = "select * from " + snp_table + " where chrom=\"" + chr_name + "\" and chromStart >= " + this.config.region.range.start + " and chromEnd <= " + this.config.region.range.end + " and class=\"single\"";
        System.err.println("SNP query: " + cmd);
        try {
            ArrayList<dbSNP> dbsnp = new ArrayList<dbSNP>();
            for (HashMap<String, String> row : ucsc.query(cmd)) {
                dbSNP snp = new dbSNP(row);
                snp.consensus_adjust(this.config.ruler_start);
                boolean usable = true;
                if (this.config.intron_compressor != null) {
                    if (this.config.intron_compressor.is_completely_trimmed(snp.start, snp.end, false)) {
                        usable = false;
                    } else {
                        int offset = this.config.intron_compressor.get_start_shift(snp.start, false);
                        snp.start -= offset;
                        snp.end -= offset;
                    }
                }
                if (!usable) continue;
                dbsnp.add(snp);
            }
            this.config.set_dbsnp(dbsnp);
        }
        catch (Exception e) {
            System.err.println("database error: " + e);
            e.printStackTrace();
            exception = e;
        }
        tm.finish();
        this.is_loaded = true;
        this.setChanged();
        this.notifyObservers();
    }
}

