import { Stack, CustomResource, aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties of the RemoteOutputs.
 *
 * @stability stable
 */
export interface RemoteOutputsProps {
    /**
     * The remote CDK stack to get the outputs from.
     *
     * @stability stable
     */
    readonly stack: Stack;
    /**
     * Indicate whether always update the custom resource to get the new stack output.
     *
     * @default true
     * @stability stable
     */
    readonly alwaysUpdate?: boolean;
}
/**
 * Represents the RemoteOutputs of the remote CDK stack.
 *
 * @stability stable
 */
export declare class RemoteOutputs extends Construct {
    /**
     * The outputs from the remote stack.
     *
     * @stability stable
     */
    readonly outputs: CustomResource;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: RemoteOutputsProps);
    /**
     * Get the attribute value from the outputs.
     *
     * @param key output key.
     * @stability stable
     */
    get(key: string): string;
}
/**
 * Properties of the RemoteParameters.
 *
 * @stability stable
 */
export interface RemoteParametersProps {
    /**
     * The region code of the remote stack.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The assumed role used to get remote parameters.
     *
     * @stability stable
     */
    readonly role?: iam.IRole;
    /**
     * The parameter path.
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Indicate whether always update the custom resource to get the new stack output.
     *
     * @default true
     * @stability stable
     */
    readonly alwaysUpdate?: boolean;
}
/**
 * Represents the RemoteParameters of the remote CDK stack.
 *
 * @stability stable
 */
export declare class RemoteParameters extends Construct {
    /**
     * The parameters in the SSM parameter store for the remote stack.
     *
     * @stability stable
     */
    readonly parameters: CustomResource;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: RemoteParametersProps);
    /**
     * Get the parameter.
     *
     * @param key output key.
     * @stability stable
     */
    get(key: string): string;
}
