import logging
from datalab.libs.cmreslogging.handlers import CMRESHandler

DATALAB_LOGGER_FORMAT = '%(asctime)s, %(name)-12s, %(levelname)-8s, %(processName)s, %(process)d,  %(pathname)s, %(filename)s, %(module)s, %(funcName)s, %(lineno)d , %(message)s'
class datalab_logger:
    def __init__(self, my_format, name=__name__, index_es="datalab_logger", es_host=[{'host': '134.171.189.10', 'port': 9200}]):  # '%(asctime)s, %(name)-12s, %(levelname)-8s, %(processName)s, %(process)d,  %(pathname)s, %(filename)s, %(module)s, %(funcName)s, %(lineno)d , %(message)s'
        """
        Logger Constructor
        :param my_format: format of log line
        :param name: name of object datalab logger
        :param index_es: index in elascticsearch where to insert logs line generated by this logger
        :param es_host: host of elasticsearch where log lines generated by this logger are going to be inserted
        """
        logging.basicConfig(level=logging.INFO)
        self.datalab_logger = logging.getLogger(name)
        # self.datalab_logger.setLevel(logging.INFO)
        ch = logging.StreamHandler()
        formatter = logging.Formatter(my_format)
        ch.setFormatter(formatter)
        self.datalab_logger.addHandler(ch)

        handler = CMRESHandler(hosts=es_host,
                               auth_type=CMRESHandler.AuthType.NO_AUTH,
                               index_name_frequency=CMRESHandler.IndexNameFrequency.NONE,
                               es_index_name=index_es) #We Add ES Hander
        self.datalab_logger.addHandler(handler)

    def set_log(self, your_logger):
        """
        Set your logging propierties

        :param your_logger: object logger with your logging fancy propierties
        :type your_logger: logger
        """
        self.datalab_logger = your_logger

if __name__ == "__main__":
    pass;
