"""
setup.py

The latest version of this package is available at:
<https://github.com/jantman/awslimitchecker>

##################################################################################
Copyright 2015-2017 Jason Antman <jason@jasonantman.com>

    This file is part of awslimitchecker, also known as awslimitchecker.

    awslimitchecker is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    awslimitchecker is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with awslimitchecker.  If not, see <http://www.gnu.org/licenses/>.

The Copyright and Authors attributions contained herein may not be removed or
otherwise altered, except to add the Author attribution of a contributor to
this work. (Additional Terms pursuant to Section 7b of the AGPL v3)
##################################################################################
While not legally required, I sincerely request that anyone who finds
bugs please submit them at <https://github.com/jantman/awslimitchecker> or
to me via email, and that you send any contributions or improvements
either as a pull request on GitHub, or to me via email.
##################################################################################

AUTHORS:
Jason Antman <jason@jasonantman.com> <http://www.jasonantman.com>
##################################################################################
"""

from setuptools import setup, find_packages
from awslimitchecker.version import _VERSION, _PROJECT_URL

with open('README.rst') as file:
    long_description = file.read()

requires = [
    'boto3>=1.9.175',
    'botocore',
    'termcolor>=1.1.0',
    'python-dateutil',
    'versionfinder>=0.1.1',
    'pytz',
    'urllib3'
]

classifiers = [
    'Development Status :: 6 - Mature',
    'Environment :: Console',
    'Intended Audience :: Developers',
    'Intended Audience :: Information Technology',
    'Intended Audience :: System Administrators',
    'License :: OSI Approved :: GNU Affero General Public License v3 or later (AGPLv3+)',
    'Natural Language :: English',
    'Operating System :: OS Independent',
    'Programming Language :: Python',
    'Programming Language :: Python :: 3',
    'Programming Language :: Python :: 3.5',
    'Programming Language :: Python :: 3.6',
    'Programming Language :: Python :: 3.7',
    'Programming Language :: Python :: 3.8',
    'Topic :: Internet',
    'Topic :: System :: Monitoring',
]

setup(
    name='awslimitchecker',
    version=_VERSION,
    author='Jason Antman',
    author_email='jason@jasonantman.com',
    packages=find_packages(),
    entry_points="""
    [console_scripts]
    awslimitchecker = awslimitchecker.runner:console_entry_point
    """,
    url=_PROJECT_URL,
    description='A script and python module to check your AWS service limits and usage, and warn when usage approaches limits.',
    long_description=long_description,
    install_requires=requires,
    keywords="AWS EC2 Amazon boto boto3 limits cloud",
    classifiers=classifiers
)
