/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], "2.3.0-dev.13");
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
414: function _(t,e,i,o,r){o();const s=t(1).__importStar(t(415));i.Widgets=s;t(7).register_models(s)},
415: function _(t,e,o,r,u){r(),u("AbstractButton",t(416).AbstractButton),u("AbstractIcon",t(419).AbstractIcon),u("AutocompleteInput",t(420).AutocompleteInput),u("Button",t(425).Button),u("CheckboxButtonGroup",t(426).CheckboxButtonGroup),u("CheckboxGroup",t(428).CheckboxGroup),u("ColorPicker",t(430).ColorPicker),u("DatePicker",t(431).DatePicker),u("DateRangeSlider",t(434).DateRangeSlider),u("DateSlider",t(439).DateSlider),u("Div",t(440).Div),u("Dropdown",t(443).Dropdown),u("FileInput",t(444).FileInput),u("InputWidget",t(423).InputWidget),u("Markup",t(441).Markup),u("MultiSelect",t(445).MultiSelect),u("Paragraph",t(446).Paragraph),u("PasswordInput",t(447).PasswordInput),u("MultiChoice",t(448).MultiChoice),u("NumericInput",t(451).NumericInput),u("PreText",t(452).PreText),u("RadioButtonGroup",t(453).RadioButtonGroup),u("RadioGroup",t(454).RadioGroup),u("RangeSlider",t(455).RangeSlider),u("Select",t(456).Select),u("Slider",t(457).Slider),u("Spinner",t(458).Spinner),u("TextInput",t(421).TextInput),u("TextAreaInput",t(459).TextAreaInput),u("Toggle",t(460).Toggle),u("Widget",t(485).Widget)},
416: function _(t,e,n,i,s){i();const l=t(1),o=t(20),r=t(43),c=t(122),u=t(417),_=t(419),a=l.__importStar(t(326)),b=a;class d extends u.ControlView{*controls(){yield this.button_el}async lazy_initialize(){await super.lazy_initialize();const{icon:t}=this.model;null!=t&&(this.icon_view=await c.build_view(t,{parent:this}))}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render()))}remove(){null!=this.icon_view&&this.icon_view.remove(),super.remove()}styles(){return[...super.styles(),a.default]}_render_button(...t){return r.button({type:"button",disabled:this.model.disabled,class:[b.btn,b[`btn_${this.model.button_type}`]]},...t)}render(){super.render(),this.button_el=this._render_button(this.model.label),this.button_el.addEventListener("click",(()=>this.click())),null!=this.icon_view&&(""!=this.model.label?r.prepend(this.button_el,this.icon_view.el,r.nbsp()):r.prepend(this.button_el,this.icon_view.el),this.icon_view.render()),this.group_el=r.div({class:b.btn_group},this.button_el),this.el.appendChild(this.group_el)}click(){}}n.AbstractButtonView=d,d.__name__="AbstractButtonView";class h extends u.Control{constructor(t){super(t)}static init_AbstractButton(){this.define((({String:t,Ref:e,Nullable:n})=>({label:[t,"Button"],icon:[n(e(_.AbstractIcon)),null],button_type:[o.ButtonType,"default"]})))}}n.AbstractButton=h,h.__name__="AbstractButton",h.init_AbstractButton()},
417: function _(t,e,o,s,n){s();const i=t(485),l=t(43);class c extends i.WidgetView{connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.disabled,(()=>{for(const t of this.controls())l.toggle_attribute(t,"disabled",this.model.disabled)}))}}o.ControlView=c,c.__name__="ControlView";class r extends i.Widget{constructor(t){super(t)}}o.Control=r,r.__name__="Control"},
485: function _(i,t,e,o,n){o();const s=i(320),r=i(20);class d extends s.HTMLBoxView{_width_policy(){return"horizontal"==this.model.orientation?super._width_policy():"fixed"}_height_policy(){return"horizontal"==this.model.orientation?"fixed":super._height_policy()}box_sizing(){const i=super.box_sizing();return"horizontal"==this.model.orientation?null==i.width&&(i.width=this.model.default_size):null==i.height&&(i.height=this.model.default_size),i}}e.WidgetView=d,d.__name__="WidgetView";class _ extends s.HTMLBox{constructor(i){super(i)}static init_Widget(){this.define((({Number:i})=>({orientation:[r.Orientation,"horizontal"],default_size:[i,300]}))),this.override({margin:[5,5,5,5]})}}e.Widget=_,_.__name__="Widget",_.init_Widget()},
419: function _(c,t,s,n,e){n();const o=c(53),_=c(237);class a extends _.DOMView{}s.AbstractIconView=a,a.__name__="AbstractIconView";class r extends o.Model{constructor(c){super(c)}}s.AbstractIcon=r,r.__name__="AbstractIcon"},
420: function _(e,t,n,i,s){i();const h=e(1),o=e(421),_=e(43),u=e(10),r=h.__importStar(e(240)),c=r;class l extends o.TextInputView{constructor(){super(...arguments),this._open=!1,this._last_value="",this._hover_index=0}styles(){return[...super.styles(),r.default]}render(){super.render(),this.input_el.addEventListener("keydown",(e=>this._keydown(e))),this.input_el.addEventListener("keyup",(e=>this._keyup(e))),this.menu=_.div({class:[c.menu,c.below]}),this.menu.addEventListener("click",(e=>this._menu_click(e))),this.menu.addEventListener("mouseover",(e=>this._menu_hover(e))),this.el.appendChild(this.menu),_.undisplay(this.menu)}change_input(){this._open&&this.menu.children.length>0&&(this.model.value=this.menu.children[this._hover_index].textContent,this.input_el.focus(),this._hide_menu()),this.model.restrict||super.change_input()}_update_completions(e){_.empty(this.menu);for(const t of e){const e=_.div({},t);this.menu.appendChild(e)}e.length>0&&this.menu.children[0].classList.add(c.active)}_show_menu(){if(!this._open){this._open=!0,this._hover_index=0,this._last_value=this.model.value,_.display(this.menu);const e=t=>{const{target:n}=t;n instanceof HTMLElement&&!this.el.contains(n)&&(document.removeEventListener("click",e),this._hide_menu())};document.addEventListener("click",e)}}_hide_menu(){this._open&&(this._open=!1,_.undisplay(this.menu))}_menu_click(e){e.target!=e.currentTarget&&e.target instanceof Element&&(this.model.value=e.target.textContent,this.input_el.focus(),this._hide_menu())}_menu_hover(e){if(e.target!=e.currentTarget&&e.target instanceof Element){let t=0;for(t=0;t<this.menu.children.length&&this.menu.children[t].textContent!=e.target.textContent;t++);this._bump_hover(t)}}_bump_hover(e){const t=this.menu.children.length;this._open&&t>0&&(this.menu.children[this._hover_index].classList.remove(c.active),this._hover_index=u.clamp(e,0,t-1),this.menu.children[this._hover_index].classList.add(c.active))}_keydown(e){}_keyup(e){switch(e.keyCode){case _.Keys.Enter:this.change_input();break;case _.Keys.Esc:this._hide_menu();break;case _.Keys.Up:this._bump_hover(this._hover_index-1);break;case _.Keys.Down:this._bump_hover(this._hover_index+1);break;default:{const e=this.input_el.value;if(e.length<this.model.min_characters)return void this._hide_menu();const t=[],{case_sensitive:n}=this.model;let i;i=n?e=>e:e=>e.toLowerCase();for(const n of this.model.completions)i(n).startsWith(i(e))&&t.push(n);this._update_completions(t),0==t.length?this._hide_menu():this._show_menu()}}}}n.AutocompleteInputView=l,l.__name__="AutocompleteInputView";class a extends o.TextInput{constructor(e){super(e)}static init_AutocompleteInput(){this.prototype.default_view=l,this.define((({Boolean:e,Int:t,String:n,Array:i})=>({completions:[i(n),[]],min_characters:[t,2],case_sensitive:[e,!0],restrict:[e,!0]})))}}n.AutocompleteInput=a,a.__name__="AutocompleteInput",a.init_AutocompleteInput()},
421: function _(t,e,n,i,p){i();const _=t(1),u=t(422),s=t(43),x=_.__importStar(t(424));class a extends u.TextLikeInputView{_render_input(){this.input_el=s.input({type:"text",class:x.input})}}n.TextInputView=a,a.__name__="TextInputView";class c extends u.TextLikeInput{constructor(t){super(t)}static init_TextInput(){this.prototype.default_view=a}}n.TextInput=c,c.__name__="TextInput",c.init_TextInput()},
422: function _(e,t,n,i,l){i();const s=e(423);class h extends s.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(()=>this.input_el.value=this.model.value)),this.connect(this.model.properties.value_input.change,(()=>this.input_el.value=this.model.value_input)),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled)),this.connect(this.model.properties.placeholder.change,(()=>this.input_el.placeholder=this.model.placeholder)),this.connect(this.model.properties.max_length.change,(()=>{const{max_length:e}=this.model;null!=e?this.input_el.maxLength=e:this.input_el.removeAttribute("maxLength")}))}render(){var e;super.render(),this._render_input();const{input_el:t}=this;t.name=null!==(e=this.model.name)&&void 0!==e?e:"",t.value=this.model.value,t.disabled=this.model.disabled,t.placeholder=this.model.placeholder,null!=this.model.max_length&&(t.maxLength=this.model.max_length),t.addEventListener("change",(()=>this.change_input())),t.addEventListener("input",(()=>this.change_input_value())),this.group_el.appendChild(t)}change_input(){this.model.value=this.input_el.value,super.change_input()}change_input_value(){this.model.value_input=this.input_el.value,super.change_input()}}n.TextLikeInputView=h,h.__name__="TextLikeInputView";class a extends s.InputWidget{constructor(e){super(e)}static init_TextLikeInput(){this.define((({Int:e,String:t,Nullable:n})=>({value:[t,""],value_input:[t,""],placeholder:[t,""],max_length:[n(e),null]})))}}n.TextLikeInput=a,a.__name__="TextLikeInput",a.init_TextLikeInput()},
423: function _(t,e,i,n,s){n();const l=t(1),o=t(417),r=t(43),_=l.__importStar(t(424)),p=_;class d extends o.ControlView{*controls(){yield this.input_el}connect_signals(){super.connect_signals(),this.connect(this.model.properties.title.change,(()=>{this.label_el.textContent=this.model.title}))}styles(){return[...super.styles(),_.default]}render(){super.render();const{title:t}=this.model;this.label_el=r.label({style:{display:0==t.length?"none":""}},t),this.group_el=r.div({class:p.input_group},this.label_el),this.el.appendChild(this.group_el)}change_input(){}}i.InputWidgetView=d,d.__name__="InputWidgetView";class u extends o.Control{constructor(t){super(t)}static init_InputWidget(){this.define((({String:t})=>({title:[t,""]})))}}i.InputWidget=u,u.__name__="InputWidget",u.init_InputWidget()},
424: function _(o,i,t,n,p){n(),t.root="bk-root",t.input="bk-input",t.input_group="bk-input-group",t.inline="bk-inline",t.spin_wrapper="bk-spin-wrapper",t.spin_btn="bk-spin-btn",t.spin_btn_up="bk-spin-btn-up",t.spin_btn_down="bk-spin-btn-down",t.default='.bk-root .bk-input{display:inline-block;width:100%;flex-grow:1;-webkit-flex-grow:1;min-height:31px;padding:0 12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;}.bk-root .bk-input:focus{border-color:#66afe9;outline:0;box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 8px rgba(102, 175, 233, 0.6);}.bk-root .bk-input::placeholder,.bk-root .bk-input:-ms-input-placeholder,.bk-root .bk-input::-moz-placeholder,.bk-root .bk-input::-webkit-input-placeholder{color:#999;opacity:1;}.bk-root .bk-input[disabled]{cursor:not-allowed;background-color:#eee;opacity:1;}.bk-root select:not([multiple]).bk-input,.bk-root select:not([size]).bk-input{height:auto;appearance:none;-webkit-appearance:none;background-image:url(\'data:image/svg+xml;utf8,<svg version="1.1" viewBox="0 0 25 20" xmlns="http://www.w3.org/2000/svg"><path d="M 0,0 25,0 12.5,20 Z" fill="black" /></svg>\');background-position:right 0.5em center;background-size:8px 6px;background-repeat:no-repeat;}.bk-root select[multiple].bk-input,.bk-root select[size].bk-input,.bk-root textarea.bk-input{height:auto;}.bk-root .bk-input-group{width:100%;height:100%;display:inline-flex;display:-webkit-inline-flex;flex-wrap:nowrap;-webkit-flex-wrap:nowrap;align-items:start;-webkit-align-items:start;flex-direction:column;-webkit-flex-direction:column;white-space:nowrap;}.bk-root .bk-input-group.bk-inline{flex-direction:row;-webkit-flex-direction:row;}.bk-root .bk-input-group.bk-inline > *:not(:first-child){margin-left:5px;}.bk-root .bk-input-group input[type="checkbox"] + span,.bk-root .bk-input-group input[type="radio"] + span{position:relative;top:-2px;margin-left:3px;}.bk-root .bk-input-group > .bk-spin-wrapper{display:inherit;width:inherit;height:inherit;position:relative;overflow:hidden;padding:0;vertical-align:middle;}.bk-root .bk-input-group > .bk-spin-wrapper input{padding-right:20px;}.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn{position:absolute;display:block;height:50%;min-height:0;min-width:0;width:30px;padding:0;margin:0;right:0;border:none;background:none;cursor:pointer;}.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn:before{content:"";display:inline-block;transform:translateY(-50%);border-left:5px solid transparent;border-right:5px solid transparent;}.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up{top:0;}.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up:before{border-bottom:5px solid black;}.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up:disabled:before{border-bottom-color:grey;}.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down{bottom:0;}.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down:before{border-top:5px solid black;}.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down:disabled:before{border-top-color:grey;}'},
425: function _(t,e,n,i,o){i();const s=t(416),u=t(262);class c extends s.AbstractButtonView{click(){this.model.trigger_event(new u.ButtonClick),super.click()}}n.ButtonView=c,c.__name__="ButtonView";class _ extends s.AbstractButton{constructor(t){super(t)}static init_Button(){this.prototype.default_view=c,this.override({label:"Button"})}}n.Button=_,_.__name__="Button",_.init_Button()},
426: function _(t,e,o,i,c){i();const n=t(1),s=t(427),a=t(43),u=n.__importStar(t(326));class r extends s.ButtonGroupView{get active(){return new Set(this.model.active)}change_active(t){const{active:e}=this;e.has(t)?e.delete(t):e.add(t),this.model.active=[...e].sort()}_update_active(){const{active:t}=this;this._buttons.forEach(((e,o)=>{a.classes(e).toggle(u.active,t.has(o))}))}}o.CheckboxButtonGroupView=r,r.__name__="CheckboxButtonGroupView";class _ extends s.ButtonGroup{constructor(t){super(t)}static init_CheckboxButtonGroup(){this.prototype.default_view=r,this.define((({Int:t,Array:e})=>({active:[e(t),[]]})))}}o.CheckboxButtonGroup=_,_.__name__="CheckboxButtonGroup",_.init_CheckboxButtonGroup()},
427: function _(t,e,n,s,i){s();const o=t(1),r=t(417),u=t(20),a=t(43),_=o.__importStar(t(326)),l=_;class c extends r.ControlView{*controls(){yield*this._buttons}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.button_type,(()=>this.render())),this.on_change(t.labels,(()=>this.render())),this.on_change(t.active,(()=>this._update_active()))}styles(){return[...super.styles(),_.default]}render(){super.render(),this._buttons=this.model.labels.map(((t,e)=>{const n=a.div({class:[l.btn,l[`btn_${this.model.button_type}`]],disabled:this.model.disabled},t);return n.addEventListener("click",(()=>this.change_active(e))),n})),this._update_active();const t=a.div({class:l.btn_group},this._buttons);this.el.appendChild(t)}}n.ButtonGroupView=c,c.__name__="ButtonGroupView";class d extends r.Control{constructor(t){super(t)}static init_ButtonGroup(){this.define((({String:t,Array:e})=>({labels:[e(t),[]],button_type:[u.ButtonType,"default"]})))}}n.ButtonGroup=d,d.__name__="ButtonGroup",d.init_ButtonGroup()},
428: function _(e,t,i,n,s){n();const o=e(1),c=e(429),a=e(43),l=e(9),d=o.__importStar(e(424));class h extends c.InputGroupView{render(){super.render();const e=a.div({class:[d.input_group,this.model.inline?d.inline:null]});this.el.appendChild(e);const{active:t,labels:i}=this.model;this._inputs=[];for(let n=0;n<i.length;n++){const s=a.input({type:"checkbox",value:`${n}`});s.addEventListener("change",(()=>this.change_active(n))),this._inputs.push(s),this.model.disabled&&(s.disabled=!0),l.includes(t,n)&&(s.checked=!0);const o=a.label({},s,a.span({},i[n]));e.appendChild(o)}}change_active(e){const t=new Set(this.model.active);t.has(e)?t.delete(e):t.add(e),this.model.active=[...t].sort()}}i.CheckboxGroupView=h,h.__name__="CheckboxGroupView";class p extends c.InputGroup{constructor(e){super(e)}static init_CheckboxGroup(){this.prototype.default_view=h,this.define((({Boolean:e,Int:t,String:i,Array:n})=>({active:[n(t),[]],labels:[n(i),[]],inline:[e,!1]})))}}i.CheckboxGroup=p,p.__name__="CheckboxGroup",p.init_CheckboxGroup()},
429: function _(n,t,e,s,o){s();const r=n(1),u=n(417),c=r.__importDefault(n(424));class _ extends u.ControlView{*controls(){yield*this._inputs}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render()))}styles(){return[...super.styles(),c.default]}}e.InputGroupView=_,_.__name__="InputGroupView";class i extends u.Control{constructor(n){super(n)}}e.InputGroup=i,i.__name__="InputGroup"},
430: function _(e,i,t,n,o){n();const s=e(1),l=e(423),r=e(43),c=e(22),a=s.__importStar(e(424));class d extends l.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.color.change,(()=>this.input_el.value=c.color2css(this.model.color))),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled))}render(){super.render(),this.input_el=r.input({type:"color",class:a.input,name:this.model.name,value:this.model.color,disabled:this.model.disabled}),this.input_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.input_el)}change_input(){this.model.color=this.input_el.value,super.change_input()}}t.ColorPickerView=d,d.__name__="ColorPickerView";class h extends l.InputWidget{constructor(e){super(e)}static init_ColorPicker(){this.prototype.default_view=d,this.define((({Color:e})=>({color:[e,"#000000"]})))}}t.ColorPicker=h,h.__name__="ColorPicker",h.init_ColorPicker()},
431: function _(e,t,i,n,s){n();const a=e(1),l=a.__importDefault(e(432)),o=e(423),d=e(43),r=e(20),c=e(8),h=a.__importStar(e(424)),u=a.__importDefault(e(433));function _(e){const t=[];for(const i of e)if(c.isString(i))t.push(i);else{const[e,n]=i;t.push({from:e,to:n})}return t}class p extends o.InputWidgetView{connect_signals(){super.connect_signals();const{value:e,min_date:t,max_date:i,disabled_dates:n,enabled_dates:s,position:a,inline:l}=this.model.properties;this.connect(e.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.setDate(this.model.value)})),this.connect(t.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("minDate",this.model.min_date)})),this.connect(i.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("maxDate",this.model.max_date)})),this.connect(n.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("disable",this.model.disabled_dates)})),this.connect(s.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("enable",this.model.enabled_dates)})),this.connect(a.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("position",this.model.position)})),this.connect(l.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("inline",this.model.inline)}))}remove(){var e;null===(e=this._picker)||void 0===e||e.destroy(),super.remove()}styles(){return[...super.styles(),u.default]}render(){var e,t;null==this._picker&&(super.render(),this.input_el=d.input({type:"text",class:h.input,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el),this._picker=l.default(this.input_el,{defaultDate:this.model.value,minDate:null!==(e=this.model.min_date)&&void 0!==e?e:void 0,maxDate:null!==(t=this.model.max_date)&&void 0!==t?t:void 0,inline:this.model.inline,position:this.model.position,disable:_(this.model.disabled_dates),enable:_(this.model.enabled_dates),onChange:(e,t,i)=>this._on_change(e,t,i)}))}_on_change(e,t,i){this.model.value=t,this.change_input()}}i.DatePickerView=p,p.__name__="DatePickerView";class m extends o.InputWidget{constructor(e){super(e)}static init_DatePicker(){this.prototype.default_view=p,this.define((({Boolean:e,String:t,Array:i,Tuple:n,Or:s,Nullable:a})=>{const l=i(s(t,n(t,t)));return{value:[t],min_date:[a(t),null],max_date:[a(t),null],disabled_dates:[l,[]],enabled_dates:[l,[]],position:[r.CalendarPosition,"auto"],inline:[e,!1]}}))}}i.DatePicker=m,m.__name__="DatePicker",m.init_DatePicker()},
432: function _(e,n,t,a,i){
/* flatpickr v4.6.6, @license MIT */var o,r;o=this,r=function(){"use strict";
/*! *****************************************************************************
        Copyright (c) Microsoft Corporation.
    
        Permission to use, copy, modify, and/or distribute this software for any
        purpose with or without fee is hereby granted.
    
        THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
        REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
        AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
        INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
        LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
        OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
        PERFORMANCE OF THIS SOFTWARE.
        ***************************************************************************** */var e=function(){return(e=Object.assign||function(e){for(var n,t=1,a=arguments.length;t<a;t++)for(var i in n=arguments[t])Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i]);return e}).apply(this,arguments)};function n(){for(var e=0,n=0,t=arguments.length;n<t;n++)e+=arguments[n].length;var a=Array(e),i=0;for(n=0;n<t;n++)for(var o=arguments[n],r=0,l=o.length;r<l;r++,i++)a[i]=o[r];return a}var t=["onChange","onClose","onDayCreate","onDestroy","onKeyDown","onMonthChange","onOpen","onParseConfig","onReady","onValueUpdate","onYearChange","onPreCalendarPosition"],a={_disable:[],_enable:[],allowInput:!1,allowInvalidPreload:!1,altFormat:"F j, Y",altInput:!1,altInputClass:"form-control input",animate:"object"==typeof window&&-1===window.navigator.userAgent.indexOf("MSIE"),ariaDateFormat:"F j, Y",autoFillDefaultTime:!0,clickOpens:!0,closeOnSelect:!0,conjunction:", ",dateFormat:"Y-m-d",defaultHour:12,defaultMinute:0,defaultSeconds:0,disable:[],disableMobile:!1,enable:[],enableSeconds:!1,enableTime:!1,errorHandler:function(e){return"undefined"!=typeof console&&console.warn(e)},getWeek:function(e){var n=new Date(e.getTime());n.setHours(0,0,0,0),n.setDate(n.getDate()+3-(n.getDay()+6)%7);var t=new Date(n.getFullYear(),0,4);return 1+Math.round(((n.getTime()-t.getTime())/864e5-3+(t.getDay()+6)%7)/7)},hourIncrement:1,ignoredFocusElements:[],inline:!1,locale:"default",minuteIncrement:5,mode:"single",monthSelectorType:"dropdown",nextArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",noCalendar:!1,now:new Date,onChange:[],onClose:[],onDayCreate:[],onDestroy:[],onKeyDown:[],onMonthChange:[],onOpen:[],onParseConfig:[],onReady:[],onValueUpdate:[],onYearChange:[],onPreCalendarPosition:[],plugins:[],position:"auto",positionElement:void 0,prevArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",shorthandCurrentMonth:!1,showMonths:1,static:!1,time_24hr:!1,weekNumbers:!1,wrap:!1},i={weekdays:{shorthand:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],longhand:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},months:{shorthand:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],longhand:["January","February","March","April","May","June","July","August","September","October","November","December"]},daysInMonth:[31,28,31,30,31,30,31,31,30,31,30,31],firstDayOfWeek:0,ordinal:function(e){var n=e%100;if(n>3&&n<21)return"th";switch(n%10){case 1:return"st";case 2:return"nd";case 3:return"rd";default:return"th"}},rangeSeparator:" to ",weekAbbreviation:"Wk",scrollTitle:"Scroll to increment",toggleTitle:"Click to toggle",amPM:["AM","PM"],yearAriaLabel:"Year",monthAriaLabel:"Month",hourAriaLabel:"Hour",minuteAriaLabel:"Minute",time_24hr:!1},o=function(e,n){return void 0===n&&(n=2),("000"+e).slice(-1*n)},r=function(e){return!0===e?1:0};function l(e,n,t){var a;return void 0===t&&(t=!1),function(){var i=this,o=arguments;null!==a&&clearTimeout(a),a=window.setTimeout((function(){a=null,t||e.apply(i,o)}),n),t&&!a&&e.apply(i,o)}}var c=function(e){return e instanceof Array?e:[e]};function d(e,n,t){if(!0===t)return e.classList.add(n);e.classList.remove(n)}function s(e,n,t){var a=window.document.createElement(e);return n=n||"",t=t||"",a.className=n,void 0!==t&&(a.textContent=t),a}function u(e){for(;e.firstChild;)e.removeChild(e.firstChild)}function f(e,n){return n(e)?e:e.parentNode?f(e.parentNode,n):void 0}function m(e,n){var t=s("div","numInputWrapper"),a=s("input","numInput "+e),i=s("span","arrowUp"),o=s("span","arrowDown");if(-1===navigator.userAgent.indexOf("MSIE 9.0")?a.type="number":(a.type="text",a.pattern="\\d*"),void 0!==n)for(var r in n)a.setAttribute(r,n[r]);return t.appendChild(a),t.appendChild(i),t.appendChild(o),t}function g(e){try{return"function"==typeof e.composedPath?e.composedPath()[0]:e.target}catch(n){return e.target}}var p=function(){},h=function(e,n,t){return t.months[n?"shorthand":"longhand"][e]},v={D:p,F:function(e,n,t){e.setMonth(t.months.longhand.indexOf(n))},G:function(e,n){e.setHours(parseFloat(n))},H:function(e,n){e.setHours(parseFloat(n))},J:function(e,n){e.setDate(parseFloat(n))},K:function(e,n,t){e.setHours(e.getHours()%12+12*r(new RegExp(t.amPM[1],"i").test(n)))},M:function(e,n,t){e.setMonth(t.months.shorthand.indexOf(n))},S:function(e,n){e.setSeconds(parseFloat(n))},U:function(e,n){return new Date(1e3*parseFloat(n))},W:function(e,n,t){var a=parseInt(n),i=new Date(e.getFullYear(),0,2+7*(a-1),0,0,0,0);return i.setDate(i.getDate()-i.getDay()+t.firstDayOfWeek),i},Y:function(e,n){e.setFullYear(parseFloat(n))},Z:function(e,n){return new Date(n)},d:function(e,n){e.setDate(parseFloat(n))},h:function(e,n){e.setHours(parseFloat(n))},i:function(e,n){e.setMinutes(parseFloat(n))},j:function(e,n){e.setDate(parseFloat(n))},l:p,m:function(e,n){e.setMonth(parseFloat(n)-1)},n:function(e,n){e.setMonth(parseFloat(n)-1)},s:function(e,n){e.setSeconds(parseFloat(n))},u:function(e,n){return new Date(parseFloat(n))},w:p,y:function(e,n){e.setFullYear(2e3+parseFloat(n))}},D={D:"(\\w+)",F:"(\\w+)",G:"(\\d\\d|\\d)",H:"(\\d\\d|\\d)",J:"(\\d\\d|\\d)\\w+",K:"",M:"(\\w+)",S:"(\\d\\d|\\d)",U:"(.+)",W:"(\\d\\d|\\d)",Y:"(\\d{4})",Z:"(.+)",d:"(\\d\\d|\\d)",h:"(\\d\\d|\\d)",i:"(\\d\\d|\\d)",j:"(\\d\\d|\\d)",l:"(\\w+)",m:"(\\d\\d|\\d)",n:"(\\d\\d|\\d)",s:"(\\d\\d|\\d)",u:"(.+)",w:"(\\d\\d|\\d)",y:"(\\d{2})"},w={Z:function(e){return e.toISOString()},D:function(e,n,t){return n.weekdays.shorthand[w.w(e,n,t)]},F:function(e,n,t){return h(w.n(e,n,t)-1,!1,n)},G:function(e,n,t){return o(w.h(e,n,t))},H:function(e){return o(e.getHours())},J:function(e,n){return void 0!==n.ordinal?e.getDate()+n.ordinal(e.getDate()):e.getDate()},K:function(e,n){return n.amPM[r(e.getHours()>11)]},M:function(e,n){return h(e.getMonth(),!0,n)},S:function(e){return o(e.getSeconds())},U:function(e){return e.getTime()/1e3},W:function(e,n,t){return t.getWeek(e)},Y:function(e){return o(e.getFullYear(),4)},d:function(e){return o(e.getDate())},h:function(e){return e.getHours()%12?e.getHours()%12:12},i:function(e){return o(e.getMinutes())},j:function(e){return e.getDate()},l:function(e,n){return n.weekdays.longhand[e.getDay()]},m:function(e){return o(e.getMonth()+1)},n:function(e){return e.getMonth()+1},s:function(e){return e.getSeconds()},u:function(e){return e.getTime()},w:function(e){return e.getDay()},y:function(e){return String(e.getFullYear()).substring(2)}},b=function(e){var n=e.config,t=void 0===n?a:n,o=e.l10n,r=void 0===o?i:o,l=e.isMobile,c=void 0!==l&&l;return function(e,n,a){var i=a||r;return void 0===t.formatDate||c?n.split("").map((function(n,a,o){return w[n]&&"\\"!==o[a-1]?w[n](e,i,t):"\\"!==n?n:""})).join(""):t.formatDate(e,n,i)}},C=function(e){var n=e.config,t=void 0===n?a:n,o=e.l10n,r=void 0===o?i:o;return function(e,n,i,o){if(0===e||e){var l,c=o||r,d=e;if(e instanceof Date)l=new Date(e.getTime());else if("string"!=typeof e&&void 0!==e.toFixed)l=new Date(e);else if("string"==typeof e){var s=n||(t||a).dateFormat,u=String(e).trim();if("today"===u)l=new Date,i=!0;else if(/Z$/.test(u)||/GMT$/.test(u))l=new Date(e);else if(t&&t.parseDate)l=t.parseDate(e,s);else{l=t&&t.noCalendar?new Date((new Date).setHours(0,0,0,0)):new Date((new Date).getFullYear(),0,1,0,0,0,0);for(var f=void 0,m=[],g=0,p=0,h="";g<s.length;g++){var w=s[g],b="\\"===w,C="\\"===s[g-1]||b;if(D[w]&&!C){h+=D[w];var M=new RegExp(h).exec(e);M&&(f=!0)&&m["Y"!==w?"push":"unshift"]({fn:v[w],val:M[++p]})}else b||(h+=".");m.forEach((function(e){var n=e.fn,t=e.val;return l=n(l,t,c)||l}))}l=f?l:void 0}}if(l instanceof Date&&!isNaN(l.getTime()))return!0===i&&l.setHours(0,0,0,0),l;t.errorHandler(new Error("Invalid date provided: "+d))}}};function M(e,n,t){return void 0===t&&(t=!0),!1!==t?new Date(e.getTime()).setHours(0,0,0,0)-new Date(n.getTime()).setHours(0,0,0,0):e.getTime()-n.getTime()}var y=864e5;function x(p,v){var w={config:e(e({},a),k.defaultConfig),l10n:i};function x(e){return e.bind(w)}function E(){var e=w.config;!1===e.weekNumbers&&1===e.showMonths||!0!==e.noCalendar&&window.requestAnimationFrame((function(){if(void 0!==w.calendarContainer&&(w.calendarContainer.style.visibility="hidden",w.calendarContainer.style.display="block"),void 0!==w.daysContainer){var n=(w.days.offsetWidth+1)*e.showMonths;w.daysContainer.style.width=n+"px",w.calendarContainer.style.width=n+(void 0!==w.weekWrapper?w.weekWrapper.offsetWidth:0)+"px",w.calendarContainer.style.removeProperty("visibility"),w.calendarContainer.style.removeProperty("display")}}))}function T(e){if(0===w.selectedDates.length){var n=void 0!==w.config.minDate?new Date(w.config.minDate.getTime()):new Date,t=_(),a=t.hours,i=t.minutes,l=t.seconds;n.setHours(a,i,l,0),w.setDate(n,!1)}void 0!==e&&"blur"!==e.type&&function(e){e.preventDefault();var n="keydown"===e.type,t=g(e),a=t;void 0!==w.amPM&&t===w.amPM&&(w.amPM.textContent=w.l10n.amPM[r(w.amPM.textContent===w.l10n.amPM[0])]);var i=parseFloat(a.getAttribute("min")),l=parseFloat(a.getAttribute("max")),c=parseFloat(a.getAttribute("step")),d=parseInt(a.value,10),s=e.delta||(n?38===e.which?1:-1:0),u=d+c*s;if(void 0!==a.value&&2===a.value.length){var f=a===w.hourElement,m=a===w.minuteElement;u<i?(u=l+u+r(!f)+(r(f)&&r(!w.amPM)),m&&H(void 0,-1,w.hourElement)):u>l&&(u=a===w.hourElement?u-l-r(!w.amPM):i,m&&H(void 0,1,w.hourElement)),w.amPM&&f&&(1===c?u+d===23:Math.abs(u-d)>c)&&(w.amPM.textContent=w.l10n.amPM[r(w.amPM.textContent===w.l10n.amPM[0])]),a.value=o(u)}}(e);var c=w._input.value;I(),be(),w._input.value!==c&&w._debouncedChange()}function I(){if(void 0!==w.hourElement&&void 0!==w.minuteElement){var e,n,t=(parseInt(w.hourElement.value.slice(-2),10)||0)%24,a=(parseInt(w.minuteElement.value,10)||0)%60,i=void 0!==w.secondElement?(parseInt(w.secondElement.value,10)||0)%60:0;void 0!==w.amPM&&(e=t,n=w.amPM.textContent,t=e%12+12*r(n===w.l10n.amPM[1]));var o=void 0!==w.config.minTime||w.config.minDate&&w.minDateHasTime&&w.latestSelectedDateObj&&0===M(w.latestSelectedDateObj,w.config.minDate,!0);if(void 0!==w.config.maxTime||w.config.maxDate&&w.maxDateHasTime&&w.latestSelectedDateObj&&0===M(w.latestSelectedDateObj,w.config.maxDate,!0)){var l=void 0!==w.config.maxTime?w.config.maxTime:w.config.maxDate;(t=Math.min(t,l.getHours()))===l.getHours()&&(a=Math.min(a,l.getMinutes())),a===l.getMinutes()&&(i=Math.min(i,l.getSeconds()))}if(o){var c=void 0!==w.config.minTime?w.config.minTime:w.config.minDate;(t=Math.max(t,c.getHours()))===c.getHours()&&(a=Math.max(a,c.getMinutes())),a===c.getMinutes()&&(i=Math.max(i,c.getSeconds()))}O(t,a,i)}}function S(e){var n=e||w.latestSelectedDateObj;n&&O(n.getHours(),n.getMinutes(),n.getSeconds())}function _(){var e=w.config.defaultHour,n=w.config.defaultMinute,t=w.config.defaultSeconds;if(void 0!==w.config.minDate){var a=w.config.minDate.getHours(),i=w.config.minDate.getMinutes();(e=Math.max(e,a))===a&&(n=Math.max(i,n)),e===a&&n===i&&(t=w.config.minDate.getSeconds())}if(void 0!==w.config.maxDate){var o=w.config.maxDate.getHours(),r=w.config.maxDate.getMinutes();(e=Math.min(e,o))===o&&(n=Math.min(r,n)),e===o&&n===r&&(t=w.config.maxDate.getSeconds())}return{hours:e,minutes:n,seconds:t}}function O(e,n,t){void 0!==w.latestSelectedDateObj&&w.latestSelectedDateObj.setHours(e%24,n,t||0,0),w.hourElement&&w.minuteElement&&!w.isMobile&&(w.hourElement.value=o(w.config.time_24hr?e:(12+e)%12+12*r(e%12==0)),w.minuteElement.value=o(n),void 0!==w.amPM&&(w.amPM.textContent=w.l10n.amPM[r(e>=12)]),void 0!==w.secondElement&&(w.secondElement.value=o(t)))}function F(e){var n=g(e),t=parseInt(n.value)+(e.delta||0);(t/1e3>1||"Enter"===e.key&&!/[^\d]/.test(t.toString()))&&Q(t)}function N(e,n,t,a){return n instanceof Array?n.forEach((function(n){return N(e,n,t,a)})):e instanceof Array?e.forEach((function(e){return N(e,n,t,a)})):(e.addEventListener(n,t,a),void w._handlers.push({element:e,event:n,handler:t,options:a}))}function A(){pe("onChange")}function P(e,n){var t=void 0!==e?w.parseDate(e):w.latestSelectedDateObj||(w.config.minDate&&w.config.minDate>w.now?w.config.minDate:w.config.maxDate&&w.config.maxDate<w.now?w.config.maxDate:w.now),a=w.currentYear,i=w.currentMonth;try{void 0!==t&&(w.currentYear=t.getFullYear(),w.currentMonth=t.getMonth())}catch(e){e.message="Invalid date supplied: "+t,w.config.errorHandler(e)}n&&w.currentYear!==a&&(pe("onYearChange"),K()),!n||w.currentYear===a&&w.currentMonth===i||pe("onMonthChange"),w.redraw()}function Y(e){var n=g(e);~n.className.indexOf("arrow")&&H(e,n.classList.contains("arrowUp")?1:-1)}function H(e,n,t){var a=e&&g(e),i=t||a&&a.parentNode&&a.parentNode.firstChild,o=he("increment");o.delta=n,i&&i.dispatchEvent(o)}function j(e,n,t,a){var i=X(n,!0),o=s("span","flatpickr-day "+e,n.getDate().toString());return o.dateObj=n,o.$i=a,o.setAttribute("aria-label",w.formatDate(n,w.config.ariaDateFormat)),-1===e.indexOf("hidden")&&0===M(n,w.now)&&(w.todayDateElem=o,o.classList.add("today"),o.setAttribute("aria-current","date")),i?(o.tabIndex=-1,ve(n)&&(o.classList.add("selected"),w.selectedDateElem=o,"range"===w.config.mode&&(d(o,"startRange",w.selectedDates[0]&&0===M(n,w.selectedDates[0],!0)),d(o,"endRange",w.selectedDates[1]&&0===M(n,w.selectedDates[1],!0)),"nextMonthDay"===e&&o.classList.add("inRange")))):o.classList.add("flatpickr-disabled"),"range"===w.config.mode&&function(e){return!("range"!==w.config.mode||w.selectedDates.length<2)&&M(e,w.selectedDates[0])>=0&&M(e,w.selectedDates[1])<=0}(n)&&!ve(n)&&o.classList.add("inRange"),w.weekNumbers&&1===w.config.showMonths&&"prevMonthDay"!==e&&t%7==1&&w.weekNumbers.insertAdjacentHTML("beforeend","<span class='flatpickr-day'>"+w.config.getWeek(n)+"</span>"),pe("onDayCreate",o),o}function L(e){e.focus(),"range"===w.config.mode&&ae(e)}function W(e){for(var n=e>0?0:w.config.showMonths-1,t=e>0?w.config.showMonths:-1,a=n;a!=t;a+=e)for(var i=w.daysContainer.children[a],o=e>0?0:i.children.length-1,r=e>0?i.children.length:-1,l=o;l!=r;l+=e){var c=i.children[l];if(-1===c.className.indexOf("hidden")&&X(c.dateObj))return c}}function R(e,n){var t=ee(document.activeElement||document.body),a=void 0!==e?e:t?document.activeElement:void 0!==w.selectedDateElem&&ee(w.selectedDateElem)?w.selectedDateElem:void 0!==w.todayDateElem&&ee(w.todayDateElem)?w.todayDateElem:W(n>0?1:-1);void 0===a?w._input.focus():t?function(e,n){for(var t=-1===e.className.indexOf("Month")?e.dateObj.getMonth():w.currentMonth,a=n>0?w.config.showMonths:-1,i=n>0?1:-1,o=t-w.currentMonth;o!=a;o+=i)for(var r=w.daysContainer.children[o],l=t-w.currentMonth===o?e.$i+n:n<0?r.children.length-1:0,c=r.children.length,d=l;d>=0&&d<c&&d!=(n>0?c:-1);d+=i){var s=r.children[d];if(-1===s.className.indexOf("hidden")&&X(s.dateObj)&&Math.abs(e.$i-d)>=Math.abs(n))return L(s)}w.changeMonth(i),R(W(i),0)}(a,n):L(a)}function B(e,n){for(var t=(new Date(e,n,1).getDay()-w.l10n.firstDayOfWeek+7)%7,a=w.utils.getDaysInMonth((n-1+12)%12,e),i=w.utils.getDaysInMonth(n,e),o=window.document.createDocumentFragment(),r=w.config.showMonths>1,l=r?"prevMonthDay hidden":"prevMonthDay",c=r?"nextMonthDay hidden":"nextMonthDay",d=a+1-t,u=0;d<=a;d++,u++)o.appendChild(j(l,new Date(e,n-1,d),d,u));for(d=1;d<=i;d++,u++)o.appendChild(j("",new Date(e,n,d),d,u));for(var f=i+1;f<=42-t&&(1===w.config.showMonths||u%7!=0);f++,u++)o.appendChild(j(c,new Date(e,n+1,f%i),f,u));var m=s("div","dayContainer");return m.appendChild(o),m}function J(){if(void 0!==w.daysContainer){u(w.daysContainer),w.weekNumbers&&u(w.weekNumbers);for(var e=document.createDocumentFragment(),n=0;n<w.config.showMonths;n++){var t=new Date(w.currentYear,w.currentMonth,1);t.setMonth(w.currentMonth+n),e.appendChild(B(t.getFullYear(),t.getMonth()))}w.daysContainer.appendChild(e),w.days=w.daysContainer.firstChild,"range"===w.config.mode&&1===w.selectedDates.length&&ae()}}function K(){if(!(w.config.showMonths>1||"dropdown"!==w.config.monthSelectorType)){var e=function(e){return!(void 0!==w.config.minDate&&w.currentYear===w.config.minDate.getFullYear()&&e<w.config.minDate.getMonth()||void 0!==w.config.maxDate&&w.currentYear===w.config.maxDate.getFullYear()&&e>w.config.maxDate.getMonth())};w.monthsDropdownContainer.tabIndex=-1,w.monthsDropdownContainer.innerHTML="";for(var n=0;n<12;n++)if(e(n)){var t=s("option","flatpickr-monthDropdown-month");t.value=new Date(w.currentYear,n).getMonth().toString(),t.textContent=h(n,w.config.shorthandCurrentMonth,w.l10n),t.tabIndex=-1,w.currentMonth===n&&(t.selected=!0),w.monthsDropdownContainer.appendChild(t)}}}function U(){var e,n=s("div","flatpickr-month"),t=window.document.createDocumentFragment();w.config.showMonths>1||"static"===w.config.monthSelectorType?e=s("span","cur-month"):(w.monthsDropdownContainer=s("select","flatpickr-monthDropdown-months"),w.monthsDropdownContainer.setAttribute("aria-label",w.l10n.monthAriaLabel),N(w.monthsDropdownContainer,"change",(function(e){var n=g(e),t=parseInt(n.value,10);w.changeMonth(t-w.currentMonth),pe("onMonthChange")})),K(),e=w.monthsDropdownContainer);var a=m("cur-year",{tabindex:"-1"}),i=a.getElementsByTagName("input")[0];i.setAttribute("aria-label",w.l10n.yearAriaLabel),w.config.minDate&&i.setAttribute("min",w.config.minDate.getFullYear().toString()),w.config.maxDate&&(i.setAttribute("max",w.config.maxDate.getFullYear().toString()),i.disabled=!!w.config.minDate&&w.config.minDate.getFullYear()===w.config.maxDate.getFullYear());var o=s("div","flatpickr-current-month");return o.appendChild(e),o.appendChild(a),t.appendChild(o),n.appendChild(t),{container:n,yearElement:i,monthElement:e}}function q(){u(w.monthNav),w.monthNav.appendChild(w.prevMonthNav),w.config.showMonths&&(w.yearElements=[],w.monthElements=[]);for(var e=w.config.showMonths;e--;){var n=U();w.yearElements.push(n.yearElement),w.monthElements.push(n.monthElement),w.monthNav.appendChild(n.container)}w.monthNav.appendChild(w.nextMonthNav)}function $(){w.weekdayContainer?u(w.weekdayContainer):w.weekdayContainer=s("div","flatpickr-weekdays");for(var e=w.config.showMonths;e--;){var n=s("div","flatpickr-weekdaycontainer");w.weekdayContainer.appendChild(n)}return z(),w.weekdayContainer}function z(){if(w.weekdayContainer){var e=w.l10n.firstDayOfWeek,t=n(w.l10n.weekdays.shorthand);e>0&&e<t.length&&(t=n(t.splice(e,t.length),t.splice(0,e)));for(var a=w.config.showMonths;a--;)w.weekdayContainer.children[a].innerHTML="\n      <span class='flatpickr-weekday'>\n        "+t.join("</span><span class='flatpickr-weekday'>")+"\n      </span>\n      "}}function G(e,n){void 0===n&&(n=!0);var t=n?e:e-w.currentMonth;t<0&&!0===w._hidePrevMonthArrow||t>0&&!0===w._hideNextMonthArrow||(w.currentMonth+=t,(w.currentMonth<0||w.currentMonth>11)&&(w.currentYear+=w.currentMonth>11?1:-1,w.currentMonth=(w.currentMonth+12)%12,pe("onYearChange"),K()),J(),pe("onMonthChange"),De())}function V(e){return!(!w.config.appendTo||!w.config.appendTo.contains(e))||w.calendarContainer.contains(e)}function Z(e){if(w.isOpen&&!w.config.inline){var n=g(e),t=V(n),a=n===w.input||n===w.altInput||w.element.contains(n)||e.path&&e.path.indexOf&&(~e.path.indexOf(w.input)||~e.path.indexOf(w.altInput)),i="blur"===e.type?a&&e.relatedTarget&&!V(e.relatedTarget):!a&&!t&&!V(e.relatedTarget),o=!w.config.ignoredFocusElements.some((function(e){return e.contains(n)}));i&&o&&(void 0!==w.timeContainer&&void 0!==w.minuteElement&&void 0!==w.hourElement&&""!==w.input.value&&void 0!==w.input.value&&T(),w.close(),w.config&&"range"===w.config.mode&&1===w.selectedDates.length&&(w.clear(!1),w.redraw()))}}function Q(e){if(!(!e||w.config.minDate&&e<w.config.minDate.getFullYear()||w.config.maxDate&&e>w.config.maxDate.getFullYear())){var n=e,t=w.currentYear!==n;w.currentYear=n||w.currentYear,w.config.maxDate&&w.currentYear===w.config.maxDate.getFullYear()?w.currentMonth=Math.min(w.config.maxDate.getMonth(),w.currentMonth):w.config.minDate&&w.currentYear===w.config.minDate.getFullYear()&&(w.currentMonth=Math.max(w.config.minDate.getMonth(),w.currentMonth)),t&&(w.redraw(),pe("onYearChange"),K())}}function X(e,n){void 0===n&&(n=!0);var t=w.parseDate(e,void 0,n);if(w.config.minDate&&t&&M(t,w.config.minDate,void 0!==n?n:!w.minDateHasTime)<0||w.config.maxDate&&t&&M(t,w.config.maxDate,void 0!==n?n:!w.maxDateHasTime)>0)return!1;if(0===w.config.enable.length&&0===w.config.disable.length)return!0;if(void 0===t)return!1;for(var a=w.config.enable.length>0,i=a?w.config.enable:w.config.disable,o=0,r=void 0;o<i.length;o++){if("function"==typeof(r=i[o])&&r(t))return a;if(r instanceof Date&&void 0!==t&&r.getTime()===t.getTime())return a;if("string"==typeof r&&void 0!==t){var l=w.parseDate(r,void 0,!0);return l&&l.getTime()===t.getTime()?a:!a}if("object"==typeof r&&void 0!==t&&r.from&&r.to&&t.getTime()>=r.from.getTime()&&t.getTime()<=r.to.getTime())return a}return!a}function ee(e){return void 0!==w.daysContainer&&-1===e.className.indexOf("hidden")&&-1===e.className.indexOf("flatpickr-disabled")&&w.daysContainer.contains(e)}function ne(e){e.target!==w._input||e.relatedTarget&&V(e.relatedTarget)||w.setDate(w._input.value,!0,e.target===w.altInput?w.config.altFormat:w.config.dateFormat)}function te(e){var n=g(e),t=w.config.wrap?p.contains(n):n===w._input,a=w.config.allowInput,i=w.isOpen&&(!a||!t),o=w.config.inline&&t&&!a;if(13===e.keyCode&&t){if(a)return w.setDate(w._input.value,!0,n===w.altInput?w.config.altFormat:w.config.dateFormat),n.blur();w.open()}else if(V(n)||i||o){var r=!!w.timeContainer&&w.timeContainer.contains(n);switch(e.keyCode){case 13:r?(e.preventDefault(),T(),se()):ue(e);break;case 27:e.preventDefault(),se();break;case 8:case 46:t&&!w.config.allowInput&&(e.preventDefault(),w.clear());break;case 37:case 39:if(r||t)w.hourElement&&w.hourElement.focus();else if(e.preventDefault(),void 0!==w.daysContainer&&(!1===a||document.activeElement&&ee(document.activeElement))){var l=39===e.keyCode?1:-1;e.ctrlKey?(e.stopPropagation(),G(l),R(W(1),0)):R(void 0,l)}break;case 38:case 40:e.preventDefault();var c=40===e.keyCode?1:-1;w.daysContainer&&void 0!==n.$i||n===w.input||n===w.altInput?e.ctrlKey?(e.stopPropagation(),Q(w.currentYear-c),R(W(1),0)):r||R(void 0,7*c):n===w.currentYearElement?Q(w.currentYear-c):w.config.enableTime&&(!r&&w.hourElement&&w.hourElement.focus(),T(e),w._debouncedChange());break;case 9:if(r){var d=[w.hourElement,w.minuteElement,w.secondElement,w.amPM].concat(w.pluginElements).filter((function(e){return e})),s=d.indexOf(n);if(-1!==s){var u=d[s+(e.shiftKey?-1:1)];e.preventDefault(),(u||w._input).focus()}}else!w.config.noCalendar&&w.daysContainer&&w.daysContainer.contains(n)&&e.shiftKey&&(e.preventDefault(),w._input.focus())}}if(void 0!==w.amPM&&n===w.amPM)switch(e.key){case w.l10n.amPM[0].charAt(0):case w.l10n.amPM[0].charAt(0).toLowerCase():w.amPM.textContent=w.l10n.amPM[0],I(),be();break;case w.l10n.amPM[1].charAt(0):case w.l10n.amPM[1].charAt(0).toLowerCase():w.amPM.textContent=w.l10n.amPM[1],I(),be()}(t||V(n))&&pe("onKeyDown",e)}function ae(e){if(1===w.selectedDates.length&&(!e||e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled"))){for(var n=e?e.dateObj.getTime():w.days.firstElementChild.dateObj.getTime(),t=w.parseDate(w.selectedDates[0],void 0,!0).getTime(),a=Math.min(n,w.selectedDates[0].getTime()),i=Math.max(n,w.selectedDates[0].getTime()),o=!1,r=0,l=0,c=a;c<i;c+=y)X(new Date(c),!0)||(o=o||c>a&&c<i,c<t&&(!r||c>r)?r=c:c>t&&(!l||c<l)&&(l=c));for(var d=0;d<w.config.showMonths;d++)for(var s=w.daysContainer.children[d],u=function(a,i){var c,d,u,f=s.children[a],m=f.dateObj.getTime(),g=r>0&&m<r||l>0&&m>l;return g?(f.classList.add("notAllowed"),["inRange","startRange","endRange"].forEach((function(e){f.classList.remove(e)})),"continue"):o&&!g?"continue":(["startRange","inRange","endRange","notAllowed"].forEach((function(e){f.classList.remove(e)})),void(void 0!==e&&(e.classList.add(n<=w.selectedDates[0].getTime()?"startRange":"endRange"),t<n&&m===t?f.classList.add("startRange"):t>n&&m===t&&f.classList.add("endRange"),m>=r&&(0===l||m<=l)&&(d=t,u=n,(c=m)>Math.min(d,u)&&c<Math.max(d,u))&&f.classList.add("inRange"))))},f=0,m=s.children.length;f<m;f++)u(f)}}function ie(){!w.isOpen||w.config.static||w.config.inline||ce()}function oe(e){return function(n){var t=w.config["_"+e+"Date"]=w.parseDate(n,w.config.dateFormat),a=w.config["_"+("min"===e?"max":"min")+"Date"];void 0!==t&&(w["min"===e?"minDateHasTime":"maxDateHasTime"]=t.getHours()>0||t.getMinutes()>0||t.getSeconds()>0),w.selectedDates&&(w.selectedDates=w.selectedDates.filter((function(e){return X(e)})),w.selectedDates.length||"min"!==e||S(t),be()),w.daysContainer&&(de(),void 0!==t?w.currentYearElement[e]=t.getFullYear().toString():w.currentYearElement.removeAttribute(e),w.currentYearElement.disabled=!!a&&void 0!==t&&a.getFullYear()===t.getFullYear())}}function re(){return w.config.wrap?p.querySelector("[data-input]"):p}function le(){"object"!=typeof w.config.locale&&void 0===k.l10ns[w.config.locale]&&w.config.errorHandler(new Error("flatpickr: invalid locale "+w.config.locale)),w.l10n=e(e({},k.l10ns.default),"object"==typeof w.config.locale?w.config.locale:"default"!==w.config.locale?k.l10ns[w.config.locale]:void 0),D.K="("+w.l10n.amPM[0]+"|"+w.l10n.amPM[1]+"|"+w.l10n.amPM[0].toLowerCase()+"|"+w.l10n.amPM[1].toLowerCase()+")",void 0===e(e({},v),JSON.parse(JSON.stringify(p.dataset||{}))).time_24hr&&void 0===k.defaultConfig.time_24hr&&(w.config.time_24hr=w.l10n.time_24hr),w.formatDate=b(w),w.parseDate=C({config:w.config,l10n:w.l10n})}function ce(e){if(void 0!==w.calendarContainer){pe("onPreCalendarPosition");var n=e||w._positionElement,t=Array.prototype.reduce.call(w.calendarContainer.children,(function(e,n){return e+n.offsetHeight}),0),a=w.calendarContainer.offsetWidth,i=w.config.position.split(" "),o=i[0],r=i.length>1?i[1]:null,l=n.getBoundingClientRect(),c=window.innerHeight-l.bottom,s="above"===o||"below"!==o&&c<t&&l.top>t,u=window.pageYOffset+l.top+(s?-t-2:n.offsetHeight+2);if(d(w.calendarContainer,"arrowTop",!s),d(w.calendarContainer,"arrowBottom",s),!w.config.inline){var f=window.pageXOffset+l.left,m=!1,g=!1;"center"===r?(f-=(a-l.width)/2,m=!0):"right"===r&&(f-=a-l.width,g=!0),d(w.calendarContainer,"arrowLeft",!m&&!g),d(w.calendarContainer,"arrowCenter",m),d(w.calendarContainer,"arrowRight",g);var p=window.document.body.offsetWidth-(window.pageXOffset+l.right),h=f+a>window.document.body.offsetWidth,v=p+a>window.document.body.offsetWidth;if(d(w.calendarContainer,"rightMost",h),!w.config.static)if(w.calendarContainer.style.top=u+"px",h)if(v){var D=function(){for(var e=null,n=0;n<document.styleSheets.length;n++){var t=document.styleSheets[n];try{t.cssRules}catch(e){continue}e=t;break}return null!=e?e:(a=document.createElement("style"),document.head.appendChild(a),a.sheet);var a}();if(void 0===D)return;var b=window.document.body.offsetWidth,C=Math.max(0,b/2-a/2),M=D.cssRules.length,y="{left:"+l.left+"px;right:auto;}";d(w.calendarContainer,"rightMost",!1),d(w.calendarContainer,"centerMost",!0),D.insertRule(".flatpickr-calendar.centerMost:before,.flatpickr-calendar.centerMost:after"+y,M),w.calendarContainer.style.left=C+"px",w.calendarContainer.style.right="auto"}else w.calendarContainer.style.left="auto",w.calendarContainer.style.right=p+"px";else w.calendarContainer.style.left=f+"px",w.calendarContainer.style.right="auto"}}}function de(){w.config.noCalendar||w.isMobile||(K(),De(),J())}function se(){w._input.focus(),-1!==window.navigator.userAgent.indexOf("MSIE")||void 0!==navigator.msMaxTouchPoints?setTimeout(w.close,0):w.close()}function ue(e){e.preventDefault(),e.stopPropagation();var n=f(g(e),(function(e){return e.classList&&e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled")&&!e.classList.contains("notAllowed")}));if(void 0!==n){var t=n,a=w.latestSelectedDateObj=new Date(t.dateObj.getTime()),i=(a.getMonth()<w.currentMonth||a.getMonth()>w.currentMonth+w.config.showMonths-1)&&"range"!==w.config.mode;if(w.selectedDateElem=t,"single"===w.config.mode)w.selectedDates=[a];else if("multiple"===w.config.mode){var o=ve(a);o?w.selectedDates.splice(parseInt(o),1):w.selectedDates.push(a)}else"range"===w.config.mode&&(2===w.selectedDates.length&&w.clear(!1,!1),w.latestSelectedDateObj=a,w.selectedDates.push(a),0!==M(a,w.selectedDates[0],!0)&&w.selectedDates.sort((function(e,n){return e.getTime()-n.getTime()})));if(I(),i){var r=w.currentYear!==a.getFullYear();w.currentYear=a.getFullYear(),w.currentMonth=a.getMonth(),r&&(pe("onYearChange"),K()),pe("onMonthChange")}if(De(),J(),be(),i||"range"===w.config.mode||1!==w.config.showMonths?void 0!==w.selectedDateElem&&void 0===w.hourElement&&w.selectedDateElem&&w.selectedDateElem.focus():L(t),void 0!==w.hourElement&&void 0!==w.hourElement&&w.hourElement.focus(),w.config.closeOnSelect){var l="single"===w.config.mode&&!w.config.enableTime,c="range"===w.config.mode&&2===w.selectedDates.length&&!w.config.enableTime;(l||c)&&se()}A()}}w.parseDate=C({config:w.config,l10n:w.l10n}),w._handlers=[],w.pluginElements=[],w.loadedPlugins=[],w._bind=N,w._setHoursFromDate=S,w._positionCalendar=ce,w.changeMonth=G,w.changeYear=Q,w.clear=function(e,n){if(void 0===e&&(e=!0),void 0===n&&(n=!0),w.input.value="",void 0!==w.altInput&&(w.altInput.value=""),void 0!==w.mobileInput&&(w.mobileInput.value=""),w.selectedDates=[],w.latestSelectedDateObj=void 0,!0===n&&(w.currentYear=w._initialDate.getFullYear(),w.currentMonth=w._initialDate.getMonth()),!0===w.config.enableTime){var t=_(),a=t.hours,i=t.minutes,o=t.seconds;O(a,i,o)}w.redraw(),e&&pe("onChange")},w.close=function(){w.isOpen=!1,w.isMobile||(void 0!==w.calendarContainer&&w.calendarContainer.classList.remove("open"),void 0!==w._input&&w._input.classList.remove("active")),pe("onClose")},w._createElement=s,w.destroy=function(){void 0!==w.config&&pe("onDestroy");for(var e=w._handlers.length;e--;){var n=w._handlers[e];n.element.removeEventListener(n.event,n.handler,n.options)}if(w._handlers=[],w.mobileInput)w.mobileInput.parentNode&&w.mobileInput.parentNode.removeChild(w.mobileInput),w.mobileInput=void 0;else if(w.calendarContainer&&w.calendarContainer.parentNode)if(w.config.static&&w.calendarContainer.parentNode){var t=w.calendarContainer.parentNode;if(t.lastChild&&t.removeChild(t.lastChild),t.parentNode){for(;t.firstChild;)t.parentNode.insertBefore(t.firstChild,t);t.parentNode.removeChild(t)}}else w.calendarContainer.parentNode.removeChild(w.calendarContainer);w.altInput&&(w.input.type="text",w.altInput.parentNode&&w.altInput.parentNode.removeChild(w.altInput),delete w.altInput),w.input&&(w.input.type=w.input._type,w.input.classList.remove("flatpickr-input"),w.input.removeAttribute("readonly")),["_showTimeInput","latestSelectedDateObj","_hideNextMonthArrow","_hidePrevMonthArrow","__hideNextMonthArrow","__hidePrevMonthArrow","isMobile","isOpen","selectedDateElem","minDateHasTime","maxDateHasTime","days","daysContainer","_input","_positionElement","innerContainer","rContainer","monthNav","todayDateElem","calendarContainer","weekdayContainer","prevMonthNav","nextMonthNav","monthsDropdownContainer","currentMonthElement","currentYearElement","navigationCurrentMonth","selectedDateElem","config"].forEach((function(e){try{delete w[e]}catch(e){}}))},w.isEnabled=X,w.jumpToDate=P,w.open=function(e,n){if(void 0===n&&(n=w._positionElement),!0===w.isMobile){if(e){e.preventDefault();var t=g(e);t&&t.blur()}return void 0!==w.mobileInput&&(w.mobileInput.focus(),w.mobileInput.click()),void pe("onOpen")}if(!w._input.disabled&&!w.config.inline){var a=w.isOpen;w.isOpen=!0,a||(w.calendarContainer.classList.add("open"),w._input.classList.add("active"),pe("onOpen"),ce(n)),!0===w.config.enableTime&&!0===w.config.noCalendar&&(!1!==w.config.allowInput||void 0!==e&&w.timeContainer.contains(e.relatedTarget)||setTimeout((function(){return w.hourElement.select()}),50))}},w.redraw=de,w.set=function(e,n){if(null!==e&&"object"==typeof e)for(var a in Object.assign(w.config,e),e)void 0!==fe[a]&&fe[a].forEach((function(e){return e()}));else w.config[e]=n,void 0!==fe[e]?fe[e].forEach((function(e){return e()})):t.indexOf(e)>-1&&(w.config[e]=c(n));w.redraw(),be(!0)},w.setDate=function(e,n,t){if(void 0===n&&(n=!1),void 0===t&&(t=w.config.dateFormat),0!==e&&!e||e instanceof Array&&0===e.length)return w.clear(n);me(e,t),w.latestSelectedDateObj=w.selectedDates[w.selectedDates.length-1],w.redraw(),P(void 0,n),S(),0===w.selectedDates.length&&w.clear(!1),be(n),n&&pe("onChange")},w.toggle=function(e){if(!0===w.isOpen)return w.close();w.open(e)};var fe={locale:[le,z],showMonths:[q,E,$],minDate:[P],maxDate:[P]};function me(e,n){var t=[];if(e instanceof Array)t=e.map((function(e){return w.parseDate(e,n)}));else if(e instanceof Date||"number"==typeof e)t=[w.parseDate(e,n)];else if("string"==typeof e)switch(w.config.mode){case"single":case"time":t=[w.parseDate(e,n)];break;case"multiple":t=e.split(w.config.conjunction).map((function(e){return w.parseDate(e,n)}));break;case"range":t=e.split(w.l10n.rangeSeparator).map((function(e){return w.parseDate(e,n)}))}else w.config.errorHandler(new Error("Invalid date supplied: "+JSON.stringify(e)));w.selectedDates=w.config.allowInvalidPreload?t:t.filter((function(e){return e instanceof Date&&X(e,!1)})),"range"===w.config.mode&&w.selectedDates.sort((function(e,n){return e.getTime()-n.getTime()}))}function ge(e){return e.slice().map((function(e){return"string"==typeof e||"number"==typeof e||e instanceof Date?w.parseDate(e,void 0,!0):e&&"object"==typeof e&&e.from&&e.to?{from:w.parseDate(e.from,void 0),to:w.parseDate(e.to,void 0)}:e})).filter((function(e){return e}))}function pe(e,n){if(void 0!==w.config){var t=w.config[e];if(void 0!==t&&t.length>0)for(var a=0;t[a]&&a<t.length;a++)t[a](w.selectedDates,w.input.value,w,n);"onChange"===e&&(w.input.dispatchEvent(he("change")),w.input.dispatchEvent(he("input")))}}function he(e){var n=document.createEvent("Event");return n.initEvent(e,!0,!0),n}function ve(e){for(var n=0;n<w.selectedDates.length;n++)if(0===M(w.selectedDates[n],e))return""+n;return!1}function De(){w.config.noCalendar||w.isMobile||!w.monthNav||(w.yearElements.forEach((function(e,n){var t=new Date(w.currentYear,w.currentMonth,1);t.setMonth(w.currentMonth+n),w.config.showMonths>1||"static"===w.config.monthSelectorType?w.monthElements[n].textContent=h(t.getMonth(),w.config.shorthandCurrentMonth,w.l10n)+" ":w.monthsDropdownContainer.value=t.getMonth().toString(),e.value=t.getFullYear().toString()})),w._hidePrevMonthArrow=void 0!==w.config.minDate&&(w.currentYear===w.config.minDate.getFullYear()?w.currentMonth<=w.config.minDate.getMonth():w.currentYear<w.config.minDate.getFullYear()),w._hideNextMonthArrow=void 0!==w.config.maxDate&&(w.currentYear===w.config.maxDate.getFullYear()?w.currentMonth+1>w.config.maxDate.getMonth():w.currentYear>w.config.maxDate.getFullYear()))}function we(e){return w.selectedDates.map((function(n){return w.formatDate(n,e)})).filter((function(e,n,t){return"range"!==w.config.mode||w.config.enableTime||t.indexOf(e)===n})).join("range"!==w.config.mode?w.config.conjunction:w.l10n.rangeSeparator)}function be(e){void 0===e&&(e=!0),void 0!==w.mobileInput&&w.mobileFormatStr&&(w.mobileInput.value=void 0!==w.latestSelectedDateObj?w.formatDate(w.latestSelectedDateObj,w.mobileFormatStr):""),w.input.value=we(w.config.dateFormat),void 0!==w.altInput&&(w.altInput.value=we(w.config.altFormat)),!1!==e&&pe("onValueUpdate")}function Ce(e){var n=g(e),t=w.prevMonthNav.contains(n),a=w.nextMonthNav.contains(n);t||a?G(t?-1:1):w.yearElements.indexOf(n)>=0?n.select():n.classList.contains("arrowUp")?w.changeYear(w.currentYear+1):n.classList.contains("arrowDown")&&w.changeYear(w.currentYear-1)}return function(){w.element=w.input=p,w.isOpen=!1,function(){var n=["wrap","weekNumbers","allowInput","allowInvalidPreload","clickOpens","time_24hr","enableTime","noCalendar","altInput","shorthandCurrentMonth","inline","static","enableSeconds","disableMobile"],i=e(e({},JSON.parse(JSON.stringify(p.dataset||{}))),v),o={};w.config.parseDate=i.parseDate,w.config.formatDate=i.formatDate,Object.defineProperty(w.config,"enable",{get:function(){return w.config._enable},set:function(e){w.config._enable=ge(e)}}),Object.defineProperty(w.config,"disable",{get:function(){return w.config._disable},set:function(e){w.config._disable=ge(e)}});var r="time"===i.mode;if(!i.dateFormat&&(i.enableTime||r)){var l=k.defaultConfig.dateFormat||a.dateFormat;o.dateFormat=i.noCalendar||r?"H:i"+(i.enableSeconds?":S":""):l+" H:i"+(i.enableSeconds?":S":"")}if(i.altInput&&(i.enableTime||r)&&!i.altFormat){var d=k.defaultConfig.altFormat||a.altFormat;o.altFormat=i.noCalendar||r?"h:i"+(i.enableSeconds?":S K":" K"):d+" h:i"+(i.enableSeconds?":S":"")+" K"}Object.defineProperty(w.config,"minDate",{get:function(){return w.config._minDate},set:oe("min")}),Object.defineProperty(w.config,"maxDate",{get:function(){return w.config._maxDate},set:oe("max")});var s=function(e){return function(n){w.config["min"===e?"_minTime":"_maxTime"]=w.parseDate(n,"H:i:S")}};Object.defineProperty(w.config,"minTime",{get:function(){return w.config._minTime},set:s("min")}),Object.defineProperty(w.config,"maxTime",{get:function(){return w.config._maxTime},set:s("max")}),"time"===i.mode&&(w.config.noCalendar=!0,w.config.enableTime=!0),Object.assign(w.config,o,i);for(var u=0;u<n.length;u++)w.config[n[u]]=!0===w.config[n[u]]||"true"===w.config[n[u]];for(t.filter((function(e){return void 0!==w.config[e]})).forEach((function(e){w.config[e]=c(w.config[e]||[]).map(x)})),w.isMobile=!w.config.disableMobile&&!w.config.inline&&"single"===w.config.mode&&!w.config.disable.length&&!w.config.enable.length&&!w.config.weekNumbers&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),u=0;u<w.config.plugins.length;u++){var f=w.config.plugins[u](w)||{};for(var m in f)t.indexOf(m)>-1?w.config[m]=c(f[m]).map(x).concat(w.config[m]):void 0===i[m]&&(w.config[m]=f[m])}i.altInputClass||(w.config.altInputClass=re().className+" "+w.config.altInputClass),pe("onParseConfig")}(),le(),w.input=re(),w.input?(w.input._type=w.input.type,w.input.type="text",w.input.classList.add("flatpickr-input"),w._input=w.input,w.config.altInput&&(w.altInput=s(w.input.nodeName,w.config.altInputClass),w._input=w.altInput,w.altInput.placeholder=w.input.placeholder,w.altInput.disabled=w.input.disabled,w.altInput.required=w.input.required,w.altInput.tabIndex=w.input.tabIndex,w.altInput.type="text",w.input.setAttribute("type","hidden"),!w.config.static&&w.input.parentNode&&w.input.parentNode.insertBefore(w.altInput,w.input.nextSibling)),w.config.allowInput||w._input.setAttribute("readonly","readonly"),w._positionElement=w.config.positionElement||w._input):w.config.errorHandler(new Error("Invalid input element specified")),function(){w.selectedDates=[],w.now=w.parseDate(w.config.now)||new Date;var e=w.config.defaultDate||("INPUT"!==w.input.nodeName&&"TEXTAREA"!==w.input.nodeName||!w.input.placeholder||w.input.value!==w.input.placeholder?w.input.value:null);e&&me(e,w.config.dateFormat),w._initialDate=w.selectedDates.length>0?w.selectedDates[0]:w.config.minDate&&w.config.minDate.getTime()>w.now.getTime()?w.config.minDate:w.config.maxDate&&w.config.maxDate.getTime()<w.now.getTime()?w.config.maxDate:w.now,w.currentYear=w._initialDate.getFullYear(),w.currentMonth=w._initialDate.getMonth(),w.selectedDates.length>0&&(w.latestSelectedDateObj=w.selectedDates[0]),void 0!==w.config.minTime&&(w.config.minTime=w.parseDate(w.config.minTime,"H:i")),void 0!==w.config.maxTime&&(w.config.maxTime=w.parseDate(w.config.maxTime,"H:i")),w.minDateHasTime=!!w.config.minDate&&(w.config.minDate.getHours()>0||w.config.minDate.getMinutes()>0||w.config.minDate.getSeconds()>0),w.maxDateHasTime=!!w.config.maxDate&&(w.config.maxDate.getHours()>0||w.config.maxDate.getMinutes()>0||w.config.maxDate.getSeconds()>0)}(),w.utils={getDaysInMonth:function(e,n){return void 0===e&&(e=w.currentMonth),void 0===n&&(n=w.currentYear),1===e&&(n%4==0&&n%100!=0||n%400==0)?29:w.l10n.daysInMonth[e]}},w.isMobile||function(){var e=window.document.createDocumentFragment();if(w.calendarContainer=s("div","flatpickr-calendar"),w.calendarContainer.tabIndex=-1,!w.config.noCalendar){if(e.appendChild((w.monthNav=s("div","flatpickr-months"),w.yearElements=[],w.monthElements=[],w.prevMonthNav=s("span","flatpickr-prev-month"),w.prevMonthNav.innerHTML=w.config.prevArrow,w.nextMonthNav=s("span","flatpickr-next-month"),w.nextMonthNav.innerHTML=w.config.nextArrow,q(),Object.defineProperty(w,"_hidePrevMonthArrow",{get:function(){return w.__hidePrevMonthArrow},set:function(e){w.__hidePrevMonthArrow!==e&&(d(w.prevMonthNav,"flatpickr-disabled",e),w.__hidePrevMonthArrow=e)}}),Object.defineProperty(w,"_hideNextMonthArrow",{get:function(){return w.__hideNextMonthArrow},set:function(e){w.__hideNextMonthArrow!==e&&(d(w.nextMonthNav,"flatpickr-disabled",e),w.__hideNextMonthArrow=e)}}),w.currentYearElement=w.yearElements[0],De(),w.monthNav)),w.innerContainer=s("div","flatpickr-innerContainer"),w.config.weekNumbers){var n=function(){w.calendarContainer.classList.add("hasWeeks");var e=s("div","flatpickr-weekwrapper");e.appendChild(s("span","flatpickr-weekday",w.l10n.weekAbbreviation));var n=s("div","flatpickr-weeks");return e.appendChild(n),{weekWrapper:e,weekNumbers:n}}(),t=n.weekWrapper,a=n.weekNumbers;w.innerContainer.appendChild(t),w.weekNumbers=a,w.weekWrapper=t}w.rContainer=s("div","flatpickr-rContainer"),w.rContainer.appendChild($()),w.daysContainer||(w.daysContainer=s("div","flatpickr-days"),w.daysContainer.tabIndex=-1),J(),w.rContainer.appendChild(w.daysContainer),w.innerContainer.appendChild(w.rContainer),e.appendChild(w.innerContainer)}w.config.enableTime&&e.appendChild(function(){w.calendarContainer.classList.add("hasTime"),w.config.noCalendar&&w.calendarContainer.classList.add("noCalendar"),w.timeContainer=s("div","flatpickr-time"),w.timeContainer.tabIndex=-1;var e=s("span","flatpickr-time-separator",":"),n=m("flatpickr-hour",{"aria-label":w.l10n.hourAriaLabel});w.hourElement=n.getElementsByTagName("input")[0];var t=m("flatpickr-minute",{"aria-label":w.l10n.minuteAriaLabel});if(w.minuteElement=t.getElementsByTagName("input")[0],w.hourElement.tabIndex=w.minuteElement.tabIndex=-1,w.hourElement.value=o(w.latestSelectedDateObj?w.latestSelectedDateObj.getHours():w.config.time_24hr?w.config.defaultHour:function(e){switch(e%24){case 0:case 12:return 12;default:return e%12}}(w.config.defaultHour)),w.minuteElement.value=o(w.latestSelectedDateObj?w.latestSelectedDateObj.getMinutes():w.config.defaultMinute),w.hourElement.setAttribute("step",w.config.hourIncrement.toString()),w.minuteElement.setAttribute("step",w.config.minuteIncrement.toString()),w.hourElement.setAttribute("min",w.config.time_24hr?"0":"1"),w.hourElement.setAttribute("max",w.config.time_24hr?"23":"12"),w.minuteElement.setAttribute("min","0"),w.minuteElement.setAttribute("max","59"),w.timeContainer.appendChild(n),w.timeContainer.appendChild(e),w.timeContainer.appendChild(t),w.config.time_24hr&&w.timeContainer.classList.add("time24hr"),w.config.enableSeconds){w.timeContainer.classList.add("hasSeconds");var a=m("flatpickr-second");w.secondElement=a.getElementsByTagName("input")[0],w.secondElement.value=o(w.latestSelectedDateObj?w.latestSelectedDateObj.getSeconds():w.config.defaultSeconds),w.secondElement.setAttribute("step",w.minuteElement.getAttribute("step")),w.secondElement.setAttribute("min","0"),w.secondElement.setAttribute("max","59"),w.timeContainer.appendChild(s("span","flatpickr-time-separator",":")),w.timeContainer.appendChild(a)}return w.config.time_24hr||(w.amPM=s("span","flatpickr-am-pm",w.l10n.amPM[r((w.latestSelectedDateObj?w.hourElement.value:w.config.defaultHour)>11)]),w.amPM.title=w.l10n.toggleTitle,w.amPM.tabIndex=-1,w.timeContainer.appendChild(w.amPM)),w.timeContainer}()),d(w.calendarContainer,"rangeMode","range"===w.config.mode),d(w.calendarContainer,"animate",!0===w.config.animate),d(w.calendarContainer,"multiMonth",w.config.showMonths>1),w.calendarContainer.appendChild(e);var i=void 0!==w.config.appendTo&&void 0!==w.config.appendTo.nodeType;if((w.config.inline||w.config.static)&&(w.calendarContainer.classList.add(w.config.inline?"inline":"static"),w.config.inline&&(!i&&w.element.parentNode?w.element.parentNode.insertBefore(w.calendarContainer,w._input.nextSibling):void 0!==w.config.appendTo&&w.config.appendTo.appendChild(w.calendarContainer)),w.config.static)){var l=s("div","flatpickr-wrapper");w.element.parentNode&&w.element.parentNode.insertBefore(l,w.element),l.appendChild(w.element),w.altInput&&l.appendChild(w.altInput),l.appendChild(w.calendarContainer)}w.config.static||w.config.inline||(void 0!==w.config.appendTo?w.config.appendTo:window.document.body).appendChild(w.calendarContainer)}(),function(){if(w.config.wrap&&["open","close","toggle","clear"].forEach((function(e){Array.prototype.forEach.call(w.element.querySelectorAll("[data-"+e+"]"),(function(n){return N(n,"click",w[e])}))})),w.isMobile)!function(){var e=w.config.enableTime?w.config.noCalendar?"time":"datetime-local":"date";w.mobileInput=s("input",w.input.className+" flatpickr-mobile"),w.mobileInput.tabIndex=1,w.mobileInput.type=e,w.mobileInput.disabled=w.input.disabled,w.mobileInput.required=w.input.required,w.mobileInput.placeholder=w.input.placeholder,w.mobileFormatStr="datetime-local"===e?"Y-m-d\\TH:i:S":"date"===e?"Y-m-d":"H:i:S",w.selectedDates.length>0&&(w.mobileInput.defaultValue=w.mobileInput.value=w.formatDate(w.selectedDates[0],w.mobileFormatStr)),w.config.minDate&&(w.mobileInput.min=w.formatDate(w.config.minDate,"Y-m-d")),w.config.maxDate&&(w.mobileInput.max=w.formatDate(w.config.maxDate,"Y-m-d")),w.input.getAttribute("step")&&(w.mobileInput.step=String(w.input.getAttribute("step"))),w.input.type="hidden",void 0!==w.altInput&&(w.altInput.type="hidden");try{w.input.parentNode&&w.input.parentNode.insertBefore(w.mobileInput,w.input.nextSibling)}catch(e){}N(w.mobileInput,"change",(function(e){w.setDate(g(e).value,!1,w.mobileFormatStr),pe("onChange"),pe("onClose")}))}();else{var e=l(ie,50);if(w._debouncedChange=l(A,300),w.daysContainer&&!/iPhone|iPad|iPod/i.test(navigator.userAgent)&&N(w.daysContainer,"mouseover",(function(e){"range"===w.config.mode&&ae(g(e))})),N(window.document.body,"keydown",te),w.config.inline||w.config.static||N(window,"resize",e),void 0!==window.ontouchstart?N(window.document,"touchstart",Z):N(window.document,"click",Z),N(window.document,"focus",Z,{capture:!0}),!0===w.config.clickOpens&&(N(w._input,"focus",w.open),N(w._input,"click",w.open)),void 0!==w.daysContainer&&(N(w.monthNav,"click",Ce),N(w.monthNav,["keyup","increment"],F),N(w.daysContainer,"click",ue)),void 0!==w.timeContainer&&void 0!==w.minuteElement&&void 0!==w.hourElement){var n=function(e){return g(e).select()};N(w.timeContainer,["increment"],T),N(w.timeContainer,"blur",T,{capture:!0}),N(w.timeContainer,"click",Y),N([w.hourElement,w.minuteElement],["focus","click"],n),void 0!==w.secondElement&&N(w.secondElement,"focus",(function(){return w.secondElement&&w.secondElement.select()})),void 0!==w.amPM&&N(w.amPM,"click",(function(e){T(e),A()}))}w.config.allowInput&&N(w._input,"blur",ne)}}(),(w.selectedDates.length||w.config.noCalendar)&&(w.config.enableTime&&S(w.config.noCalendar?w.latestSelectedDateObj||w.config.minDate:void 0),be(!1)),E();var n=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);!w.isMobile&&n&&ce(),pe("onReady")}(),w}function E(e,n){for(var t=Array.prototype.slice.call(e).filter((function(e){return e instanceof HTMLElement})),a=[],i=0;i<t.length;i++){var o=t[i];try{if(null!==o.getAttribute("data-fp-omit"))continue;void 0!==o._flatpickr&&(o._flatpickr.destroy(),o._flatpickr=void 0),o._flatpickr=x(o,n||{}),a.push(o._flatpickr)}catch(e){console.error(e)}}return 1===a.length?a[0]:a}"function"!=typeof Object.assign&&(Object.assign=function(e){for(var n=[],t=1;t<arguments.length;t++)n[t-1]=arguments[t];if(!e)throw TypeError("Cannot convert undefined or null to object");for(var a=function(n){n&&Object.keys(n).forEach((function(t){return e[t]=n[t]}))},i=0,o=n;i<o.length;i++){var r=o[i];a(r)}return e}),"undefined"!=typeof HTMLElement&&"undefined"!=typeof HTMLCollection&&"undefined"!=typeof NodeList&&(HTMLCollection.prototype.flatpickr=NodeList.prototype.flatpickr=function(e){return E(this,e)},HTMLElement.prototype.flatpickr=function(e){return E([this],e)});var k=function(e,n){return"string"==typeof e?E(window.document.querySelectorAll(e),n):e instanceof Node?E([e],n):E(e,n)};return k.defaultConfig={},k.l10ns={en:e({},i),default:e({},i)},k.localize=function(n){k.l10ns.default=e(e({},k.l10ns.default),n)},k.setDefaults=function(n){k.defaultConfig=e(e({},k.defaultConfig),n)},k.parseDate=C({}),k.formatDate=b({}),k.compareDates=M,"undefined"!=typeof jQuery&&void 0!==jQuery.fn&&(jQuery.fn.flatpickr=function(e){return E(this,e)}),Date.prototype.fp_incr=function(e){return new Date(this.getFullYear(),this.getMonth(),this.getDate()+("string"==typeof e?parseInt(e,10):e))},"undefined"!=typeof window&&(window.flatpickr=k),k},"object"==typeof t&&void 0!==n?n.exports=r():"function"==typeof define&&define.amd?define(r):(o=o||self).flatpickr=r()},
433: function _(t,e,a,r,i){r(),a.default='.flatpickr-calendar{background:transparent;opacity:0;display:none;text-align:center;visibility:hidden;padding:0;-webkit-animation:none;animation:none;direction:ltr;border:0;font-size:14px;line-height:24px;border-radius:5px;position:absolute;width:307.875px;-webkit-box-sizing:border-box;box-sizing:border-box;-ms-touch-action:manipulation;touch-action:manipulation;background:#fff;-webkit-box-shadow:1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, 0.08);box-shadow:1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, 0.08);}.flatpickr-calendar.open,.flatpickr-calendar.inline{opacity:1;max-height:640px;visibility:visible;}.flatpickr-calendar.open{display:inline-block;z-index:99999;}.flatpickr-calendar.animate.open{-webkit-animation:fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);animation:fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);}.flatpickr-calendar.inline{display:block;position:relative;top:2px;}.flatpickr-calendar.static{position:absolute;top:calc(100% + 2px);}.flatpickr-calendar.static.open{z-index:999;display:block;}.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+1) .flatpickr-day.inRange:nth-child(7n+7){-webkit-box-shadow:none !important;box-shadow:none !important;}.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+2) .flatpickr-day.inRange:nth-child(7n+1){-webkit-box-shadow:-2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;box-shadow:-2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;}.flatpickr-calendar .hasWeeks .dayContainer,.flatpickr-calendar .hasTime .dayContainer{border-bottom:0;border-bottom-right-radius:0;border-bottom-left-radius:0;}.flatpickr-calendar .hasWeeks .dayContainer{border-left:0;}.flatpickr-calendar.hasTime .flatpickr-time{height:40px;border-top:1px solid #e6e6e6;}.flatpickr-calendar.noCalendar.hasTime .flatpickr-time{height:auto;}.flatpickr-calendar:before,.flatpickr-calendar:after{position:absolute;display:block;pointer-events:none;border:solid transparent;content:\'\';height:0;width:0;left:22px;}.flatpickr-calendar.rightMost:before,.flatpickr-calendar.arrowRight:before,.flatpickr-calendar.rightMost:after,.flatpickr-calendar.arrowRight:after{left:auto;right:22px;}.flatpickr-calendar.arrowCenter:before,.flatpickr-calendar.arrowCenter:after{left:50%;right:50%;}.flatpickr-calendar:before{border-width:5px;margin:0 -5px;}.flatpickr-calendar:after{border-width:4px;margin:0 -4px;}.flatpickr-calendar.arrowTop:before,.flatpickr-calendar.arrowTop:after{bottom:100%;}.flatpickr-calendar.arrowTop:before{border-bottom-color:#e6e6e6;}.flatpickr-calendar.arrowTop:after{border-bottom-color:#fff;}.flatpickr-calendar.arrowBottom:before,.flatpickr-calendar.arrowBottom:after{top:100%;}.flatpickr-calendar.arrowBottom:before{border-top-color:#e6e6e6;}.flatpickr-calendar.arrowBottom:after{border-top-color:#fff;}.flatpickr-calendar:focus{outline:0;}.flatpickr-wrapper{position:relative;display:inline-block;}.flatpickr-months{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;}.flatpickr-months .flatpickr-month{background:transparent;color:rgba(0, 0, 0, 0.9);fill:rgba(0, 0, 0, 0.9);height:34px;line-height:1;text-align:center;position:relative;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;overflow:hidden;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;}.flatpickr-months .flatpickr-prev-month,.flatpickr-months .flatpickr-next-month{text-decoration:none;cursor:pointer;position:absolute;top:0;height:34px;padding:10px;z-index:3;color:rgba(0, 0, 0, 0.9);fill:rgba(0, 0, 0, 0.9);}.flatpickr-months .flatpickr-prev-month.flatpickr-disabled,.flatpickr-months .flatpickr-next-month.flatpickr-disabled{display:none;}.flatpickr-months .flatpickr-prev-month i,.flatpickr-months .flatpickr-next-month i{position:relative;}.flatpickr-months .flatpickr-prev-month.flatpickr-prev-month,.flatpickr-months .flatpickr-next-month.flatpickr-prev-month{left:0;}.flatpickr-months .flatpickr-prev-month.flatpickr-next-month,.flatpickr-months .flatpickr-next-month.flatpickr-next-month{right:0;}.flatpickr-months .flatpickr-prev-month:hover,.flatpickr-months .flatpickr-next-month:hover{color:#959ea9;}.flatpickr-months .flatpickr-prev-month:hover svg,.flatpickr-months .flatpickr-next-month:hover svg{fill:#f64747;}.flatpickr-months .flatpickr-prev-month svg,.flatpickr-months .flatpickr-next-month svg{width:14px;height:14px;}.flatpickr-months .flatpickr-prev-month svg path,.flatpickr-months .flatpickr-next-month svg path{-webkit-transition:fill 0.1s;transition:fill 0.1s;fill:inherit;}.numInputWrapper{position:relative;height:auto;}.numInputWrapper input,.numInputWrapper span{display:inline-block;}.numInputWrapper input{width:100%;}.numInputWrapper input::-ms-clear{display:none;}.numInputWrapper input::-webkit-outer-spin-button,.numInputWrapper input::-webkit-inner-spin-button{margin:0;-webkit-appearance:none;}.numInputWrapper span{position:absolute;right:0;width:14px;padding:0 4px 0 2px;height:50%;line-height:50%;opacity:0;cursor:pointer;border:1px solid rgba(57, 57, 57, 0.15);-webkit-box-sizing:border-box;box-sizing:border-box;}.numInputWrapper span:hover{background:rgba(0, 0, 0, 0.1);}.numInputWrapper span:active{background:rgba(0, 0, 0, 0.2);}.numInputWrapper span:after{display:block;content:"";position:absolute;}.numInputWrapper span.arrowUp{top:0;border-bottom:0;}.numInputWrapper span.arrowUp:after{border-left:4px solid transparent;border-right:4px solid transparent;border-bottom:4px solid rgba(57, 57, 57, 0.6);top:26%;}.numInputWrapper span.arrowDown{top:50%;}.numInputWrapper span.arrowDown:after{border-left:4px solid transparent;border-right:4px solid transparent;border-top:4px solid rgba(57, 57, 57, 0.6);top:40%;}.numInputWrapper span svg{width:inherit;height:auto;}.numInputWrapper span svg path{fill:rgba(0, 0, 0, 0.5);}.numInputWrapper:hover{background:rgba(0, 0, 0, 0.05);}.numInputWrapper:hover span{opacity:1;}.flatpickr-current-month{font-size:135%;line-height:inherit;font-weight:300;color:inherit;position:absolute;width:75%;left:12.5%;padding:7.48px 0 0 0;line-height:1;height:34px;display:inline-block;text-align:center;-webkit-transform:translate3d(0px, 0px, 0px);transform:translate3d(0px, 0px, 0px);}.flatpickr-current-month span.cur-month{font-family:inherit;font-weight:700;color:inherit;display:inline-block;margin-left:0.5ch;padding:0;}.flatpickr-current-month span.cur-month:hover{background:rgba(0, 0, 0, 0.05);}.flatpickr-current-month .numInputWrapper{width:6ch;width:7ch\0;display:inline-block;}.flatpickr-current-month .numInputWrapper span.arrowUp:after{border-bottom-color:rgba(0, 0, 0, 0.9);}.flatpickr-current-month .numInputWrapper span.arrowDown:after{border-top-color:rgba(0, 0, 0, 0.9);}.flatpickr-current-month input.cur-year{background:transparent;-webkit-box-sizing:border-box;box-sizing:border-box;color:inherit;cursor:text;padding:0 0 0 0.5ch;margin:0;display:inline-block;font-size:inherit;font-family:inherit;font-weight:300;line-height:inherit;height:auto;border:0;border-radius:0;vertical-align:initial;-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;}.flatpickr-current-month input.cur-year:focus{outline:0;}.flatpickr-current-month input.cur-year[disabled],.flatpickr-current-month input.cur-year[disabled]:hover{font-size:100%;color:rgba(0, 0, 0, 0.5);background:transparent;pointer-events:none;}.flatpickr-current-month .flatpickr-monthDropdown-months{appearance:menulist;background:transparent;border:none;border-radius:0;box-sizing:border-box;color:inherit;cursor:pointer;font-size:inherit;font-family:inherit;font-weight:300;height:auto;line-height:inherit;margin:-1px 0 0 0;outline:none;padding:0 0 0 0.5ch;position:relative;vertical-align:initial;-webkit-box-sizing:border-box;-webkit-appearance:menulist;-moz-appearance:menulist;width:auto;}.flatpickr-current-month .flatpickr-monthDropdown-months:focus,.flatpickr-current-month .flatpickr-monthDropdown-months:active{outline:none;}.flatpickr-current-month .flatpickr-monthDropdown-months:hover{background:rgba(0, 0, 0, 0.05);}.flatpickr-current-month .flatpickr-monthDropdown-months .flatpickr-monthDropdown-month{background-color:transparent;outline:none;padding:0;}.flatpickr-weekdays{background:transparent;text-align:center;overflow:hidden;width:100%;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;height:28px;}.flatpickr-weekdays .flatpickr-weekdaycontainer{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;}span.flatpickr-weekday{cursor:default;font-size:90%;background:transparent;color:rgba(0, 0, 0, 0.54);line-height:1;margin:0;text-align:center;display:block;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;font-weight:bolder;}.dayContainer,.flatpickr-weeks{padding:1px 0 0 0;}.flatpickr-days{position:relative;overflow:hidden;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:start;-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start;width:307.875px;}.flatpickr-days:focus{outline:0;}.dayContainer{padding:0;outline:0;text-align:left;width:307.875px;min-width:307.875px;max-width:307.875px;-webkit-box-sizing:border-box;box-sizing:border-box;display:inline-block;display:-ms-flexbox;display:-webkit-box;display:-webkit-flex;display:flex;-webkit-flex-wrap:wrap;flex-wrap:wrap;-ms-flex-wrap:wrap;-ms-flex-pack:justify;-webkit-justify-content:space-around;justify-content:space-around;-webkit-transform:translate3d(0px, 0px, 0px);transform:translate3d(0px, 0px, 0px);opacity:1;}.dayContainer + .dayContainer{-webkit-box-shadow:-1px 0 0 #e6e6e6;box-shadow:-1px 0 0 #e6e6e6;}.flatpickr-day{background:none;border:1px solid transparent;border-radius:150px;-webkit-box-sizing:border-box;box-sizing:border-box;color:#393939;cursor:pointer;font-weight:400;width:14.2857143%;-webkit-flex-basis:14.2857143%;-ms-flex-preferred-size:14.2857143%;flex-basis:14.2857143%;max-width:39px;height:39px;line-height:39px;margin:0;display:inline-block;position:relative;-webkit-box-pack:center;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;text-align:center;}.flatpickr-day.inRange,.flatpickr-day.prevMonthDay.inRange,.flatpickr-day.nextMonthDay.inRange,.flatpickr-day.today.inRange,.flatpickr-day.prevMonthDay.today.inRange,.flatpickr-day.nextMonthDay.today.inRange,.flatpickr-day:hover,.flatpickr-day.prevMonthDay:hover,.flatpickr-day.nextMonthDay:hover,.flatpickr-day:focus,.flatpickr-day.prevMonthDay:focus,.flatpickr-day.nextMonthDay:focus{cursor:pointer;outline:0;background:#e6e6e6;border-color:#e6e6e6;}.flatpickr-day.today{border-color:#959ea9;}.flatpickr-day.today:hover,.flatpickr-day.today:focus{border-color:#959ea9;background:#959ea9;color:#fff;}.flatpickr-day.selected,.flatpickr-day.startRange,.flatpickr-day.endRange,.flatpickr-day.selected.inRange,.flatpickr-day.startRange.inRange,.flatpickr-day.endRange.inRange,.flatpickr-day.selected:focus,.flatpickr-day.startRange:focus,.flatpickr-day.endRange:focus,.flatpickr-day.selected:hover,.flatpickr-day.startRange:hover,.flatpickr-day.endRange:hover,.flatpickr-day.selected.prevMonthDay,.flatpickr-day.startRange.prevMonthDay,.flatpickr-day.endRange.prevMonthDay,.flatpickr-day.selected.nextMonthDay,.flatpickr-day.startRange.nextMonthDay,.flatpickr-day.endRange.nextMonthDay{background:#569ff7;-webkit-box-shadow:none;box-shadow:none;color:#fff;border-color:#569ff7;}.flatpickr-day.selected.startRange,.flatpickr-day.startRange.startRange,.flatpickr-day.endRange.startRange{border-radius:50px 0 0 50px;}.flatpickr-day.selected.endRange,.flatpickr-day.startRange.endRange,.flatpickr-day.endRange.endRange{border-radius:0 50px 50px 0;}.flatpickr-day.selected.startRange + .endRange:not(:nth-child(7n+1)),.flatpickr-day.startRange.startRange + .endRange:not(:nth-child(7n+1)),.flatpickr-day.endRange.startRange + .endRange:not(:nth-child(7n+1)){-webkit-box-shadow:-10px 0 0 #569ff7;box-shadow:-10px 0 0 #569ff7;}.flatpickr-day.selected.startRange.endRange,.flatpickr-day.startRange.startRange.endRange,.flatpickr-day.endRange.startRange.endRange{border-radius:50px;}.flatpickr-day.inRange{border-radius:0;-webkit-box-shadow:-5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;box-shadow:-5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;}.flatpickr-day.flatpickr-disabled,.flatpickr-day.flatpickr-disabled:hover,.flatpickr-day.prevMonthDay,.flatpickr-day.nextMonthDay,.flatpickr-day.notAllowed,.flatpickr-day.notAllowed.prevMonthDay,.flatpickr-day.notAllowed.nextMonthDay{color:rgba(57, 57, 57, 0.3);background:transparent;border-color:transparent;cursor:default;}.flatpickr-day.flatpickr-disabled,.flatpickr-day.flatpickr-disabled:hover{cursor:not-allowed;color:rgba(57, 57, 57, 0.1);}.flatpickr-day.week.selected{border-radius:0;-webkit-box-shadow:-5px 0 0 #569ff7, 5px 0 0 #569ff7;box-shadow:-5px 0 0 #569ff7, 5px 0 0 #569ff7;}.flatpickr-day.hidden{visibility:hidden;}.rangeMode .flatpickr-day{margin-top:1px;}.flatpickr-weekwrapper{float:left;}.flatpickr-weekwrapper .flatpickr-weeks{padding:0 12px;-webkit-box-shadow:1px 0 0 #e6e6e6;box-shadow:1px 0 0 #e6e6e6;}.flatpickr-weekwrapper .flatpickr-weekday{float:none;width:100%;line-height:28px;}.flatpickr-weekwrapper span.flatpickr-day,.flatpickr-weekwrapper span.flatpickr-day:hover{display:block;width:100%;max-width:none;color:rgba(57, 57, 57, 0.3);background:transparent;cursor:default;border:none;}.flatpickr-innerContainer{display:block;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-sizing:border-box;box-sizing:border-box;overflow:hidden;}.flatpickr-rContainer{display:inline-block;padding:0;-webkit-box-sizing:border-box;box-sizing:border-box;}.flatpickr-time{text-align:center;outline:0;display:block;height:0;line-height:40px;max-height:40px;-webkit-box-sizing:border-box;box-sizing:border-box;overflow:hidden;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;}.flatpickr-time:after{content:"";display:table;clear:both;}.flatpickr-time .numInputWrapper{-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;width:40%;height:40px;float:left;}.flatpickr-time .numInputWrapper span.arrowUp:after{border-bottom-color:#393939;}.flatpickr-time .numInputWrapper span.arrowDown:after{border-top-color:#393939;}.flatpickr-time.hasSeconds .numInputWrapper{width:26%;}.flatpickr-time.time24hr .numInputWrapper{width:49%;}.flatpickr-time input{background:transparent;-webkit-box-shadow:none;box-shadow:none;border:0;border-radius:0;text-align:center;margin:0;padding:0;height:inherit;line-height:inherit;color:#393939;font-size:14px;position:relative;-webkit-box-sizing:border-box;box-sizing:border-box;-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;}.flatpickr-time input.flatpickr-hour{font-weight:bold;}.flatpickr-time input.flatpickr-minute,.flatpickr-time input.flatpickr-second{font-weight:400;}.flatpickr-time input:focus{outline:0;border:0;}.flatpickr-time .flatpickr-time-separator,.flatpickr-time .flatpickr-am-pm{height:inherit;float:left;line-height:inherit;color:#393939;font-weight:bold;width:2%;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;-webkit-align-self:center;-ms-flex-item-align:center;align-self:center;}.flatpickr-time .flatpickr-am-pm{outline:0;width:18%;cursor:pointer;text-align:center;font-weight:400;}.flatpickr-time input:hover,.flatpickr-time .flatpickr-am-pm:hover,.flatpickr-time input:focus,.flatpickr-time .flatpickr-am-pm:focus{background:#eee;}.flatpickr-input[readonly]{cursor:pointer;}@-webkit-keyframes fpFadeInDown{from{opacity:0;-webkit-transform:translate3d(0, -20px, 0);transform:translate3d(0, -20px, 0);}to{opacity:1;-webkit-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);}}@keyframes fpFadeInDown{from{opacity:0;-webkit-transform:translate3d(0, -20px, 0);transform:translate3d(0, -20px, 0);}to{opacity:1;-webkit-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);}}.flatpickr-calendar{background:transparent;opacity:0;display:none;text-align:center;visibility:hidden;padding:0;-webkit-animation:none;animation:none;direction:ltr;border:0;font-size:14px;line-height:24px;border-radius:5px;position:absolute;width:307.875px;-webkit-box-sizing:border-box;box-sizing:border-box;-ms-touch-action:manipulation;touch-action:manipulation;-webkit-box-shadow:0 3px 13px rgba(0, 0, 0, 0.08);box-shadow:0 3px 13px rgba(0, 0, 0, 0.08);}.flatpickr-calendar.open,.flatpickr-calendar.inline{opacity:1;max-height:640px;visibility:visible;}.flatpickr-calendar.open{display:inline-block;z-index:99999;}.flatpickr-calendar.animate.open{-webkit-animation:fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);animation:fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);}.flatpickr-calendar.inline{display:block;position:relative;top:2px;}.flatpickr-calendar.static{position:absolute;top:calc(100% + 2px);}.flatpickr-calendar.static.open{z-index:999;display:block;}.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+1) .flatpickr-day.inRange:nth-child(7n+7){-webkit-box-shadow:none !important;box-shadow:none !important;}.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+2) .flatpickr-day.inRange:nth-child(7n+1){-webkit-box-shadow:-2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;box-shadow:-2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;}.flatpickr-calendar .hasWeeks .dayContainer,.flatpickr-calendar .hasTime .dayContainer{border-bottom:0;border-bottom-right-radius:0;border-bottom-left-radius:0;}.flatpickr-calendar .hasWeeks .dayContainer{border-left:0;}.flatpickr-calendar.hasTime .flatpickr-time{height:40px;border-top:1px solid #eceef1;}.flatpickr-calendar.hasTime .flatpickr-innerContainer{border-bottom:0;}.flatpickr-calendar.hasTime .flatpickr-time{border:1px solid #eceef1;}.flatpickr-calendar.noCalendar.hasTime .flatpickr-time{height:auto;}.flatpickr-calendar:before,.flatpickr-calendar:after{position:absolute;display:block;pointer-events:none;border:solid transparent;content:\'\';height:0;width:0;left:22px;}.flatpickr-calendar.rightMost:before,.flatpickr-calendar.arrowRight:before,.flatpickr-calendar.rightMost:after,.flatpickr-calendar.arrowRight:after{left:auto;right:22px;}.flatpickr-calendar.arrowCenter:before,.flatpickr-calendar.arrowCenter:after{left:50%;right:50%;}.flatpickr-calendar:before{border-width:5px;margin:0 -5px;}.flatpickr-calendar:after{border-width:4px;margin:0 -4px;}.flatpickr-calendar.arrowTop:before,.flatpickr-calendar.arrowTop:after{bottom:100%;}.flatpickr-calendar.arrowTop:before{border-bottom-color:#eceef1;}.flatpickr-calendar.arrowTop:after{border-bottom-color:#eceef1;}.flatpickr-calendar.arrowBottom:before,.flatpickr-calendar.arrowBottom:after{top:100%;}.flatpickr-calendar.arrowBottom:before{border-top-color:#eceef1;}.flatpickr-calendar.arrowBottom:after{border-top-color:#eceef1;}.flatpickr-calendar:focus{outline:0;}.flatpickr-wrapper{position:relative;display:inline-block;}.flatpickr-months{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;}.flatpickr-months .flatpickr-month{border-radius:5px 5px 0 0;background:#eceef1;color:#5a6171;fill:#5a6171;height:34px;line-height:1;text-align:center;position:relative;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;overflow:hidden;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;}.flatpickr-months .flatpickr-prev-month,.flatpickr-months .flatpickr-next-month{text-decoration:none;cursor:pointer;position:absolute;top:0;height:34px;padding:10px;z-index:3;color:#5a6171;fill:#5a6171;}.flatpickr-months .flatpickr-prev-month.flatpickr-disabled,.flatpickr-months .flatpickr-next-month.flatpickr-disabled{display:none;}.flatpickr-months .flatpickr-prev-month i,.flatpickr-months .flatpickr-next-month i{position:relative;}.flatpickr-months .flatpickr-prev-month.flatpickr-prev-month,.flatpickr-months .flatpickr-next-month.flatpickr-prev-month{left:0;}.flatpickr-months .flatpickr-prev-month.flatpickr-next-month,.flatpickr-months .flatpickr-next-month.flatpickr-next-month{right:0;}.flatpickr-months .flatpickr-prev-month:hover,.flatpickr-months .flatpickr-next-month:hover{color:#bbb;}.flatpickr-months .flatpickr-prev-month:hover svg,.flatpickr-months .flatpickr-next-month:hover svg{fill:#f64747;}.flatpickr-months .flatpickr-prev-month svg,.flatpickr-months .flatpickr-next-month svg{width:14px;height:14px;}.flatpickr-months .flatpickr-prev-month svg path,.flatpickr-months .flatpickr-next-month svg path{-webkit-transition:fill 0.1s;transition:fill 0.1s;fill:inherit;}.numInputWrapper{position:relative;height:auto;}.numInputWrapper input,.numInputWrapper span{display:inline-block;}.numInputWrapper input{width:100%;}.numInputWrapper input::-ms-clear{display:none;}.numInputWrapper input::-webkit-outer-spin-button,.numInputWrapper input::-webkit-inner-spin-button{margin:0;-webkit-appearance:none;}.numInputWrapper span{position:absolute;right:0;width:14px;padding:0 4px 0 2px;height:50%;line-height:50%;opacity:0;cursor:pointer;border:1px solid rgba(72, 72, 72, 0.15);-webkit-box-sizing:border-box;box-sizing:border-box;}.numInputWrapper span:hover{background:rgba(0, 0, 0, 0.1);}.numInputWrapper span:active{background:rgba(0, 0, 0, 0.2);}.numInputWrapper span:after{display:block;content:"";position:absolute;}.numInputWrapper span.arrowUp{top:0;border-bottom:0;}.numInputWrapper span.arrowUp:after{border-left:4px solid transparent;border-right:4px solid transparent;border-bottom:4px solid rgba(72, 72, 72, 0.6);top:26%;}.numInputWrapper span.arrowDown{top:50%;}.numInputWrapper span.arrowDown:after{border-left:4px solid transparent;border-right:4px solid transparent;border-top:4px solid rgba(72, 72, 72, 0.6);top:40%;}.numInputWrapper span svg{width:inherit;height:auto;}.numInputWrapper span svg path{fill:rgba(90, 97, 113, 0.5);}.numInputWrapper:hover{background:rgba(0, 0, 0, 0.05);}.numInputWrapper:hover span{opacity:1;}.flatpickr-current-month{font-size:135%;line-height:inherit;font-weight:300;color:inherit;position:absolute;width:75%;left:12.5%;padding:7.48px 0 0 0;line-height:1;height:34px;display:inline-block;text-align:center;-webkit-transform:translate3d(0px, 0px, 0px);transform:translate3d(0px, 0px, 0px);}.flatpickr-current-month span.cur-month{font-family:inherit;font-weight:700;color:inherit;display:inline-block;margin-left:0.5ch;padding:0;}.flatpickr-current-month span.cur-month:hover{background:rgba(0, 0, 0, 0.05);}.flatpickr-current-month .numInputWrapper{width:6ch;width:7ch\0;display:inline-block;}.flatpickr-current-month .numInputWrapper span.arrowUp:after{border-bottom-color:#5a6171;}.flatpickr-current-month .numInputWrapper span.arrowDown:after{border-top-color:#5a6171;}.flatpickr-current-month input.cur-year{background:transparent;-webkit-box-sizing:border-box;box-sizing:border-box;color:inherit;cursor:text;padding:0 0 0 0.5ch;margin:0;display:inline-block;font-size:inherit;font-family:inherit;font-weight:300;line-height:inherit;height:auto;border:0;border-radius:0;vertical-align:initial;-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;}.flatpickr-current-month input.cur-year:focus{outline:0;}.flatpickr-current-month input.cur-year[disabled],.flatpickr-current-month input.cur-year[disabled]:hover{font-size:100%;color:rgba(90, 97, 113, 0.5);background:transparent;pointer-events:none;}.flatpickr-current-month .flatpickr-monthDropdown-months{appearance:menulist;background:#eceef1;border:none;border-radius:0;box-sizing:border-box;color:inherit;cursor:pointer;font-size:inherit;font-family:inherit;font-weight:300;height:auto;line-height:inherit;margin:-1px 0 0 0;outline:none;padding:0 0 0 0.5ch;position:relative;vertical-align:initial;-webkit-box-sizing:border-box;-webkit-appearance:menulist;-moz-appearance:menulist;width:auto;}.flatpickr-current-month .flatpickr-monthDropdown-months:focus,.flatpickr-current-month .flatpickr-monthDropdown-months:active{outline:none;}.flatpickr-current-month .flatpickr-monthDropdown-months:hover{background:rgba(0, 0, 0, 0.05);}.flatpickr-current-month .flatpickr-monthDropdown-months .flatpickr-monthDropdown-month{background-color:#eceef1;outline:none;padding:0;}.flatpickr-weekdays{background:#eceef1;text-align:center;overflow:hidden;width:100%;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;height:28px;}.flatpickr-weekdays .flatpickr-weekdaycontainer{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;}span.flatpickr-weekday{cursor:default;font-size:90%;background:#eceef1;color:#5a6171;line-height:1;margin:0;text-align:center;display:block;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;font-weight:bolder;}.dayContainer,.flatpickr-weeks{padding:1px 0 0 0;}.flatpickr-days{position:relative;overflow:hidden;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:start;-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start;width:307.875px;border-left:1px solid #eceef1;border-right:1px solid #eceef1;}.flatpickr-days:focus{outline:0;}.dayContainer{padding:0;outline:0;text-align:left;width:307.875px;min-width:307.875px;max-width:307.875px;-webkit-box-sizing:border-box;box-sizing:border-box;display:inline-block;display:-ms-flexbox;display:-webkit-box;display:-webkit-flex;display:flex;-webkit-flex-wrap:wrap;flex-wrap:wrap;-ms-flex-wrap:wrap;-ms-flex-pack:justify;-webkit-justify-content:space-around;justify-content:space-around;-webkit-transform:translate3d(0px, 0px, 0px);transform:translate3d(0px, 0px, 0px);opacity:1;}.dayContainer + .dayContainer{-webkit-box-shadow:-1px 0 0 #eceef1;box-shadow:-1px 0 0 #eceef1;}.flatpickr-day{background:none;border:1px solid transparent;border-radius:150px;-webkit-box-sizing:border-box;box-sizing:border-box;color:#484848;cursor:pointer;font-weight:400;width:14.2857143%;-webkit-flex-basis:14.2857143%;-ms-flex-preferred-size:14.2857143%;flex-basis:14.2857143%;max-width:39px;height:39px;line-height:39px;margin:0;display:inline-block;position:relative;-webkit-box-pack:center;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;text-align:center;}.flatpickr-day.inRange,.flatpickr-day.prevMonthDay.inRange,.flatpickr-day.nextMonthDay.inRange,.flatpickr-day.today.inRange,.flatpickr-day.prevMonthDay.today.inRange,.flatpickr-day.nextMonthDay.today.inRange,.flatpickr-day:hover,.flatpickr-day.prevMonthDay:hover,.flatpickr-day.nextMonthDay:hover,.flatpickr-day:focus,.flatpickr-day.prevMonthDay:focus,.flatpickr-day.nextMonthDay:focus{cursor:pointer;outline:0;background:#e2e2e2;border-color:#e2e2e2;}.flatpickr-day.today{border-color:#bbb;}.flatpickr-day.today:hover,.flatpickr-day.today:focus{border-color:#bbb;background:#bbb;color:#fff;}.flatpickr-day.selected,.flatpickr-day.startRange,.flatpickr-day.endRange,.flatpickr-day.selected.inRange,.flatpickr-day.startRange.inRange,.flatpickr-day.endRange.inRange,.flatpickr-day.selected:focus,.flatpickr-day.startRange:focus,.flatpickr-day.endRange:focus,.flatpickr-day.selected:hover,.flatpickr-day.startRange:hover,.flatpickr-day.endRange:hover,.flatpickr-day.selected.prevMonthDay,.flatpickr-day.startRange.prevMonthDay,.flatpickr-day.endRange.prevMonthDay,.flatpickr-day.selected.nextMonthDay,.flatpickr-day.startRange.nextMonthDay,.flatpickr-day.endRange.nextMonthDay{background:#ff5a5f;-webkit-box-shadow:none;box-shadow:none;color:#fff;border-color:#ff5a5f;}.flatpickr-day.selected.startRange,.flatpickr-day.startRange.startRange,.flatpickr-day.endRange.startRange{border-radius:50px 0 0 50px;}.flatpickr-day.selected.endRange,.flatpickr-day.startRange.endRange,.flatpickr-day.endRange.endRange{border-radius:0 50px 50px 0;}.flatpickr-day.selected.startRange + .endRange:not(:nth-child(7n+1)),.flatpickr-day.startRange.startRange + .endRange:not(:nth-child(7n+1)),.flatpickr-day.endRange.startRange + .endRange:not(:nth-child(7n+1)){-webkit-box-shadow:-10px 0 0 #ff5a5f;box-shadow:-10px 0 0 #ff5a5f;}.flatpickr-day.selected.startRange.endRange,.flatpickr-day.startRange.startRange.endRange,.flatpickr-day.endRange.startRange.endRange{border-radius:50px;}.flatpickr-day.inRange{border-radius:0;-webkit-box-shadow:-5px 0 0 #e2e2e2, 5px 0 0 #e2e2e2;box-shadow:-5px 0 0 #e2e2e2, 5px 0 0 #e2e2e2;}.flatpickr-day.flatpickr-disabled,.flatpickr-day.flatpickr-disabled:hover,.flatpickr-day.prevMonthDay,.flatpickr-day.nextMonthDay,.flatpickr-day.notAllowed,.flatpickr-day.notAllowed.prevMonthDay,.flatpickr-day.notAllowed.nextMonthDay{color:rgba(72, 72, 72, 0.3);background:transparent;border-color:transparent;cursor:default;}.flatpickr-day.flatpickr-disabled,.flatpickr-day.flatpickr-disabled:hover{cursor:not-allowed;color:rgba(72, 72, 72, 0.1);}.flatpickr-day.week.selected{border-radius:0;-webkit-box-shadow:-5px 0 0 #ff5a5f, 5px 0 0 #ff5a5f;box-shadow:-5px 0 0 #ff5a5f, 5px 0 0 #ff5a5f;}.flatpickr-day.hidden{visibility:hidden;}.rangeMode .flatpickr-day{margin-top:1px;}.flatpickr-weekwrapper{float:left;}.flatpickr-weekwrapper .flatpickr-weeks{padding:0 12px;border-left:1px solid #eceef1;}.flatpickr-weekwrapper .flatpickr-weekday{float:none;width:100%;line-height:28px;}.flatpickr-weekwrapper span.flatpickr-day,.flatpickr-weekwrapper span.flatpickr-day:hover{display:block;width:100%;max-width:none;color:rgba(72, 72, 72, 0.3);background:transparent;cursor:default;border:none;}.flatpickr-innerContainer{display:block;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-sizing:border-box;box-sizing:border-box;overflow:hidden;background:#fff;border-bottom:1px solid #eceef1;}.flatpickr-rContainer{display:inline-block;padding:0;-webkit-box-sizing:border-box;box-sizing:border-box;}.flatpickr-time{text-align:center;outline:0;display:block;height:0;line-height:40px;max-height:40px;-webkit-box-sizing:border-box;box-sizing:border-box;overflow:hidden;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;background:#fff;border-radius:0 0 5px 5px;}.flatpickr-time:after{content:"";display:table;clear:both;}.flatpickr-time .numInputWrapper{-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;width:40%;height:40px;float:left;}.flatpickr-time .numInputWrapper span.arrowUp:after{border-bottom-color:#484848;}.flatpickr-time .numInputWrapper span.arrowDown:after{border-top-color:#484848;}.flatpickr-time.hasSeconds .numInputWrapper{width:26%;}.flatpickr-time.time24hr .numInputWrapper{width:49%;}.flatpickr-time input{background:transparent;-webkit-box-shadow:none;box-shadow:none;border:0;border-radius:0;text-align:center;margin:0;padding:0;height:inherit;line-height:inherit;color:#484848;font-size:14px;position:relative;-webkit-box-sizing:border-box;box-sizing:border-box;-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;}.flatpickr-time input.flatpickr-hour{font-weight:bold;}.flatpickr-time input.flatpickr-minute,.flatpickr-time input.flatpickr-second{font-weight:400;}.flatpickr-time input:focus{outline:0;border:0;}.flatpickr-time .flatpickr-time-separator,.flatpickr-time .flatpickr-am-pm{height:inherit;float:left;line-height:inherit;color:#484848;font-weight:bold;width:2%;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;-webkit-align-self:center;-ms-flex-item-align:center;align-self:center;}.flatpickr-time .flatpickr-am-pm{outline:0;width:18%;cursor:pointer;text-align:center;font-weight:400;}.flatpickr-time input:hover,.flatpickr-time .flatpickr-am-pm:hover,.flatpickr-time input:focus,.flatpickr-time .flatpickr-am-pm:focus{background:#eaeaea;}.flatpickr-input[readonly]{cursor:pointer;}@-webkit-keyframes fpFadeInDown{from{opacity:0;-webkit-transform:translate3d(0, -20px, 0);transform:translate3d(0, -20px, 0);}to{opacity:1;-webkit-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);}}@keyframes fpFadeInDown{from{opacity:0;-webkit-transform:translate3d(0, -20px, 0);transform:translate3d(0, -20px, 0);}to{opacity:1;-webkit-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);}}span.flatpickr-day.selected{font-weight:bold;}'},
434: function _(e,t,a,i,r){i();const n=e(1).__importDefault(e(178)),s=e(435),d=e(8);class _ extends s.AbstractRangeSliderView{}a.DateRangeSliderView=_,_.__name__="DateRangeSliderView";class l extends s.AbstractSlider{constructor(e){super(e),this.behaviour="drag",this.connected=[!1,!0,!1]}static init_DateRangeSlider(){this.prototype.default_view=_,this.override({format:"%d %b %Y"})}_formatter(e,t){return d.isString(t)?n.default(e,t):t.compute(e)}}a.DateRangeSlider=l,l.__name__="DateRangeSlider",l.init_DateRangeSlider()},
435: function _(t,e,i,s,l){s();const r=t(1),o=r.__importStar(t(436)),n=t(43),a=t(9),d=t(22),_=t(417),h=t(166),c=r.__importStar(t(437)),m=c,u=r.__importDefault(t(438)),p=r.__importStar(t(424));class b extends _.ControlView{*controls(){yield this.slider_el}get noUiSlider(){return this.slider_el.noUiSlider}connect_signals(){super.connect_signals();const{direction:t,orientation:e,tooltips:i}=this.model.properties;this.on_change([t,e,i],(()=>this.render()));const{start:s,end:l,value:r,step:o,title:n}=this.model.properties;this.on_change([s,l,r,o],(()=>{const{start:t,end:e,value:i,step:s}=this._calc_to();this.noUiSlider.updateOptions({range:{min:t,max:e},start:i,step:s})}));const{bar_color:a}=this.model.properties;this.on_change(a,(()=>{this._set_bar_color()}));const{show_value:d}=this.model.properties;this.on_change([r,n,d],(()=>this._update_title()))}styles(){return[...super.styles(),u.default,c.default]}_update_title(){var t;n.empty(this.title_el);const e=null==this.model.title||0==this.model.title.length&&!this.model.show_value;if(this.title_el.style.display=e?"none":"",!e&&(0!=(null===(t=this.model.title)||void 0===t?void 0:t.length)&&(this.title_el.textContent=`${this.model.title}: `),this.model.show_value)){const{value:t}=this._calc_to(),e=t.map((t=>this.model.pretty(t))).join(" .. ");this.title_el.appendChild(n.span({class:m.slider_value},e))}}_set_bar_color(){if(!this.model.disabled){this.slider_el.querySelector(".noUi-connect").style.backgroundColor=d.color2css(this.model.bar_color)}}render(){super.render();const{start:t,end:e,value:i,step:s}=this._calc_to();let l;if(this.model.tooltips){const t={to:t=>this.model.pretty(t)};l=a.repeat(t,i.length)}else l=!1;if(null==this.slider_el){this.slider_el=n.div(),o.create(this.slider_el,{range:{min:t,max:e},start:i,step:s,behaviour:this.model.behaviour,connect:this.model.connected,tooltips:l,orientation:this.model.orientation,direction:this.model.direction}),this.noUiSlider.on("slide",((t,e,i)=>this._slide(i))),this.noUiSlider.on("change",((t,e,i)=>this._change(i)));const r=(t,e)=>{if(!l)return;this.slider_el.querySelectorAll(".noUi-handle")[t].querySelector(".noUi-tooltip").style.display=e?"block":""};this.noUiSlider.on("start",((t,e)=>r(e,!0))),this.noUiSlider.on("end",((t,e)=>r(e,!1)))}else this.noUiSlider.updateOptions({range:{min:t,max:e},start:i,step:s});this._set_bar_color(),this.model.disabled?this.slider_el.setAttribute("disabled","true"):this.slider_el.removeAttribute("disabled"),this.title_el=n.div({class:m.slider_title}),this._update_title(),this.group_el=n.div({class:p.input_group},this.title_el,this.slider_el),this.el.appendChild(this.group_el)}_slide(t){this.model.value=this._calc_from(t)}_change(t){const e=this._calc_from(t);this.model.setv({value:e,value_throttled:e})}}b.__name__="AbstractBaseSliderView";class v extends b{_calc_to(){return{start:this.model.start,end:this.model.end,value:[this.model.value],step:this.model.step}}_calc_from([t]){return Number.isInteger(this.model.start)&&Number.isInteger(this.model.end)&&Number.isInteger(this.model.step)?Math.round(t):t}}i.AbstractSliderView=v,v.__name__="AbstractSliderView";class g extends b{_calc_to(){return{start:this.model.start,end:this.model.end,value:this.model.value,step:this.model.step}}_calc_from(t){return t}}i.AbstractRangeSliderView=g,g.__name__="AbstractRangeSliderView";class S extends _.Control{constructor(t){super(t),this.connected=!1}static init_AbstractSlider(){this.define((({Any:t,Boolean:e,Number:i,String:s,Color:l,Or:r,Enum:o,Ref:n,Nullable:a})=>({title:[a(s),""],show_value:[e,!0],start:[t],end:[t],value:[t],value_throttled:[t],step:[i,1],format:[r(s,n(h.TickFormatter))],direction:[o("ltr","rtl"),"ltr"],tooltips:[e,!0],bar_color:[l,"#e6e6e6"]})))}pretty(t){return this._formatter(t,this.format)}}i.AbstractSlider=S,S.__name__="AbstractSlider",S.init_AbstractSlider()},
436: function _(t,e,r,n,i){
/*! nouislider - 14.6.3 - 11/19/2020 */
var o;o=function(){"use strict";var t="14.6.3";function e(t){t.parentElement.removeChild(t)}function r(t){return null!=t}function n(t){t.preventDefault()}function i(t){return"number"==typeof t&&!isNaN(t)&&isFinite(t)}function o(t,e,r){r>0&&(u(t,e),setTimeout((function(){c(t,e)}),r))}function s(t){return Math.max(Math.min(t,100),0)}function a(t){return Array.isArray(t)?t:[t]}function l(t){var e=(t=String(t)).split(".");return e.length>1?e[1].length:0}function u(t,e){t.classList&&!/\s/.test(e)?t.classList.add(e):t.className+=" "+e}function c(t,e){t.classList&&!/\s/.test(e)?t.classList.remove(e):t.className=t.className.replace(new RegExp("(^|\\b)"+e.split(" ").join("|")+"(\\b|$)","gi")," ")}function p(t){var e=void 0!==window.pageXOffset,r="CSS1Compat"===(t.compatMode||"");return{x:e?window.pageXOffset:r?t.documentElement.scrollLeft:t.body.scrollLeft,y:e?window.pageYOffset:r?t.documentElement.scrollTop:t.body.scrollTop}}function f(t,e){return 100/(e-t)}function d(t,e,r){return 100*e/(t[r+1]-t[r])}function h(t,e){for(var r=1;t>=e[r];)r+=1;return r}function m(t,e,r){if(r>=t.slice(-1)[0])return 100;var n=h(r,t),i=t[n-1],o=t[n],s=e[n-1],a=e[n];return s+function(t,e){return d(t,t[0]<0?e+Math.abs(t[0]):e-t[0],0)}([i,o],r)/f(s,a)}function g(t,e,r,n){if(100===n)return n;var i=h(n,t),o=t[i-1],s=t[i];return r?n-o>(s-o)/2?s:o:e[i-1]?t[i-1]+function(t,e){return Math.round(t/e)*e}(n-t[i-1],e[i-1]):n}function v(t,e,r){var n;if("number"==typeof e&&(e=[e]),!Array.isArray(e))throw new Error("noUiSlider (14.6.3): 'range' contains invalid value.");if(!i(n="min"===t?0:"max"===t?100:parseFloat(t))||!i(e[0]))throw new Error("noUiSlider (14.6.3): 'range' value isn't numeric.");r.xPct.push(n),r.xVal.push(e[0]),n?r.xSteps.push(!isNaN(e[1])&&e[1]):isNaN(e[1])||(r.xSteps[0]=e[1]),r.xHighestCompleteStep.push(0)}function b(t,e,r){if(e)if(r.xVal[t]!==r.xVal[t+1]){r.xSteps[t]=d([r.xVal[t],r.xVal[t+1]],e,0)/f(r.xPct[t],r.xPct[t+1]);var n=(r.xVal[t+1]-r.xVal[t])/r.xNumSteps[t],i=Math.ceil(Number(n.toFixed(3))-1),o=r.xVal[t]+r.xNumSteps[t]*i;r.xHighestCompleteStep[t]=o}else r.xSteps[t]=r.xHighestCompleteStep[t]=r.xVal[t]}function x(t,e,r){var n;this.xPct=[],this.xVal=[],this.xSteps=[r||!1],this.xNumSteps=[!1],this.xHighestCompleteStep=[],this.snap=e;var i=[];for(n in t)t.hasOwnProperty(n)&&i.push([t[n],n]);for(i.length&&"object"==typeof i[0][0]?i.sort((function(t,e){return t[0][0]-e[0][0]})):i.sort((function(t,e){return t[0]-e[0]})),n=0;n<i.length;n++)v(i[n][1],i[n][0],this);for(this.xNumSteps=this.xSteps.slice(0),n=0;n<this.xNumSteps.length;n++)b(n,this.xNumSteps[n],this)}x.prototype.getDistance=function(t){var e,r=[];for(e=0;e<this.xNumSteps.length-1;e++){var n=this.xNumSteps[e];if(n&&t/n%1!=0)throw new Error("noUiSlider (14.6.3): 'limit', 'margin' and 'padding' of "+this.xPct[e]+"% range must be divisible by step.");r[e]=d(this.xVal,t,e)}return r},x.prototype.getAbsoluteDistance=function(t,e,r){var n,i=0;if(t<this.xPct[this.xPct.length-1])for(;t>this.xPct[i+1];)i++;else t===this.xPct[this.xPct.length-1]&&(i=this.xPct.length-2);r||t!==this.xPct[i+1]||i++;var o=1,s=e[i],a=0,l=0,u=0,c=0;for(n=r?(t-this.xPct[i])/(this.xPct[i+1]-this.xPct[i]):(this.xPct[i+1]-t)/(this.xPct[i+1]-this.xPct[i]);s>0;)a=this.xPct[i+1+c]-this.xPct[i+c],e[i+c]*o+100-100*n>100?(l=a*n,o=(s-100*n)/e[i+c],n=1):(l=e[i+c]*a/100*o,o=0),r?(u-=l,this.xPct.length+c>=1&&c--):(u+=l,this.xPct.length-c>=1&&c++),s=e[i+c]*o;return t+u},x.prototype.toStepping=function(t){return t=m(this.xVal,this.xPct,t)},x.prototype.fromStepping=function(t){return function(t,e,r){if(r>=100)return t.slice(-1)[0];var n=h(r,e),i=t[n-1],o=t[n],s=e[n-1];return function(t,e){return e*(t[1]-t[0])/100+t[0]}([i,o],(r-s)*f(s,e[n]))}(this.xVal,this.xPct,t)},x.prototype.getStep=function(t){return t=g(this.xPct,this.xSteps,this.snap,t)},x.prototype.getDefaultStep=function(t,e,r){var n=h(t,this.xPct);return(100===t||e&&t===this.xPct[n-1])&&(n=Math.max(n-1,1)),(this.xVal[n]-this.xVal[n-1])/r},x.prototype.getNearbySteps=function(t){var e=h(t,this.xPct);return{stepBefore:{startValue:this.xVal[e-2],step:this.xNumSteps[e-2],highestStep:this.xHighestCompleteStep[e-2]},thisStep:{startValue:this.xVal[e-1],step:this.xNumSteps[e-1],highestStep:this.xHighestCompleteStep[e-1]},stepAfter:{startValue:this.xVal[e],step:this.xNumSteps[e],highestStep:this.xHighestCompleteStep[e]}}},x.prototype.countStepDecimals=function(){var t=this.xNumSteps.map(l);return Math.max.apply(null,t)},x.prototype.convert=function(t){return this.getStep(this.toStepping(t))};var S={to:function(t){return void 0!==t&&t.toFixed(2)},from:Number},w={target:"target",base:"base",origin:"origin",handle:"handle",handleLower:"handle-lower",handleUpper:"handle-upper",touchArea:"touch-area",horizontal:"horizontal",vertical:"vertical",background:"background",connect:"connect",connects:"connects",ltr:"ltr",rtl:"rtl",textDirectionLtr:"txt-dir-ltr",textDirectionRtl:"txt-dir-rtl",draggable:"draggable",drag:"state-drag",tap:"state-tap",active:"active",tooltip:"tooltip",pips:"pips",pipsHorizontal:"pips-horizontal",pipsVertical:"pips-vertical",marker:"marker",markerHorizontal:"marker-horizontal",markerVertical:"marker-vertical",markerNormal:"marker-normal",markerLarge:"marker-large",markerSub:"marker-sub",value:"value",valueHorizontal:"value-horizontal",valueVertical:"value-vertical",valueNormal:"value-normal",valueLarge:"value-large",valueSub:"value-sub"},y=".__tooltips",E=".__aria";function C(t){if(function(t){return"object"==typeof t&&"function"==typeof t.to&&"function"==typeof t.from}(t))return!0;throw new Error("noUiSlider (14.6.3): 'format' requires 'to' and 'from' methods.")}function P(t,e){if(!i(e))throw new Error("noUiSlider (14.6.3): 'step' is not numeric.");t.singleStep=e}function N(t,e){if(!i(e))throw new Error("noUiSlider (14.6.3): 'keyboardPageMultiplier' is not numeric.");t.keyboardPageMultiplier=e}function k(t,e){if(!i(e))throw new Error("noUiSlider (14.6.3): 'keyboardDefaultStep' is not numeric.");t.keyboardDefaultStep=e}function U(t,e){if("object"!=typeof e||Array.isArray(e))throw new Error("noUiSlider (14.6.3): 'range' is not an object.");if(void 0===e.min||void 0===e.max)throw new Error("noUiSlider (14.6.3): Missing 'min' or 'max' in 'range'.");if(e.min===e.max)throw new Error("noUiSlider (14.6.3): 'range' 'min' and 'max' cannot be equal.");t.spectrum=new x(e,t.snap,t.singleStep)}function A(t,e){if(e=a(e),!Array.isArray(e)||!e.length)throw new Error("noUiSlider (14.6.3): 'start' option is incorrect.");t.handles=e.length,t.start=e}function V(t,e){if(t.snap=e,"boolean"!=typeof e)throw new Error("noUiSlider (14.6.3): 'snap' option must be a boolean.")}function D(t,e){if(t.animate=e,"boolean"!=typeof e)throw new Error("noUiSlider (14.6.3): 'animate' option must be a boolean.")}function M(t,e){if(t.animationDuration=e,"number"!=typeof e)throw new Error("noUiSlider (14.6.3): 'animationDuration' option must be a number.")}function O(t,e){var r,n=[!1];if("lower"===e?e=[!0,!1]:"upper"===e&&(e=[!1,!0]),!0===e||!1===e){for(r=1;r<t.handles;r++)n.push(e);n.push(!1)}else{if(!Array.isArray(e)||!e.length||e.length!==t.handles+1)throw new Error("noUiSlider (14.6.3): 'connect' option doesn't match handle count.");n=e}t.connect=n}function L(t,e){switch(e){case"horizontal":t.ort=0;break;case"vertical":t.ort=1;break;default:throw new Error("noUiSlider (14.6.3): 'orientation' option is invalid.")}}function z(t,e){if(!i(e))throw new Error("noUiSlider (14.6.3): 'margin' option must be numeric.");0!==e&&(t.margin=t.spectrum.getDistance(e))}function H(t,e){if(!i(e))throw new Error("noUiSlider (14.6.3): 'limit' option must be numeric.");if(t.limit=t.spectrum.getDistance(e),!t.limit||t.handles<2)throw new Error("noUiSlider (14.6.3): 'limit' option is only supported on linear sliders with 2 or more handles.")}function j(t,e){var r;if(!i(e)&&!Array.isArray(e))throw new Error("noUiSlider (14.6.3): 'padding' option must be numeric or array of exactly 2 numbers.");if(Array.isArray(e)&&2!==e.length&&!i(e[0])&&!i(e[1]))throw new Error("noUiSlider (14.6.3): 'padding' option must be numeric or array of exactly 2 numbers.");if(0!==e){for(Array.isArray(e)||(e=[e,e]),t.padding=[t.spectrum.getDistance(e[0]),t.spectrum.getDistance(e[1])],r=0;r<t.spectrum.xNumSteps.length-1;r++)if(t.padding[0][r]<0||t.padding[1][r]<0)throw new Error("noUiSlider (14.6.3): 'padding' option must be a positive number(s).");var n=e[0]+e[1],o=t.spectrum.xVal[0];if(n/(t.spectrum.xVal[t.spectrum.xVal.length-1]-o)>1)throw new Error("noUiSlider (14.6.3): 'padding' option must not exceed 100% of the range.")}}function F(t,e){switch(e){case"ltr":t.dir=0;break;case"rtl":t.dir=1;break;default:throw new Error("noUiSlider (14.6.3): 'direction' option was not recognized.")}}function R(t,e){if("string"!=typeof e)throw new Error("noUiSlider (14.6.3): 'behaviour' must be a string containing options.");var r=e.indexOf("tap")>=0,n=e.indexOf("drag")>=0,i=e.indexOf("fixed")>=0,o=e.indexOf("snap")>=0,s=e.indexOf("hover")>=0,a=e.indexOf("unconstrained")>=0;if(i){if(2!==t.handles)throw new Error("noUiSlider (14.6.3): 'fixed' behaviour must be used with 2 handles");z(t,t.start[1]-t.start[0])}if(a&&(t.margin||t.limit))throw new Error("noUiSlider (14.6.3): 'unconstrained' behaviour cannot be used with margin or limit");t.events={tap:r||o,drag:n,fixed:i,snap:o,hover:s,unconstrained:a}}function T(t,e){if(!1!==e)if(!0===e){t.tooltips=[];for(var r=0;r<t.handles;r++)t.tooltips.push(!0)}else{if(t.tooltips=a(e),t.tooltips.length!==t.handles)throw new Error("noUiSlider (14.6.3): must pass a formatter for all handles.");t.tooltips.forEach((function(t){if("boolean"!=typeof t&&("object"!=typeof t||"function"!=typeof t.to))throw new Error("noUiSlider (14.6.3): 'tooltips' must be passed a formatter or 'false'.")}))}}function _(t,e){t.ariaFormat=e,C(e)}function B(t,e){t.format=e,C(e)}function q(t,e){if(t.keyboardSupport=e,"boolean"!=typeof e)throw new Error("noUiSlider (14.6.3): 'keyboardSupport' option must be a boolean.")}function X(t,e){t.documentElement=e}function Y(t,e){if("string"!=typeof e&&!1!==e)throw new Error("noUiSlider (14.6.3): 'cssPrefix' must be a string or `false`.");t.cssPrefix=e}function I(t,e){if("object"!=typeof e)throw new Error("noUiSlider (14.6.3): 'cssClasses' must be an object.");if("string"==typeof t.cssPrefix)for(var r in t.cssClasses={},e)e.hasOwnProperty(r)&&(t.cssClasses[r]=t.cssPrefix+e[r]);else t.cssClasses=e}function W(t){var e={margin:0,limit:0,padding:0,animate:!0,animationDuration:300,ariaFormat:S,format:S},n={step:{r:!1,t:P},keyboardPageMultiplier:{r:!1,t:N},keyboardDefaultStep:{r:!1,t:k},start:{r:!0,t:A},connect:{r:!0,t:O},direction:{r:!0,t:F},snap:{r:!1,t:V},animate:{r:!1,t:D},animationDuration:{r:!1,t:M},range:{r:!0,t:U},orientation:{r:!1,t:L},margin:{r:!1,t:z},limit:{r:!1,t:H},padding:{r:!1,t:j},behaviour:{r:!0,t:R},ariaFormat:{r:!1,t:_},format:{r:!1,t:B},tooltips:{r:!1,t:T},keyboardSupport:{r:!0,t:q},documentElement:{r:!1,t:X},cssPrefix:{r:!0,t:Y},cssClasses:{r:!0,t:I}},i={connect:!1,direction:"ltr",behaviour:"tap",orientation:"horizontal",keyboardSupport:!0,cssPrefix:"noUi-",cssClasses:w,keyboardPageMultiplier:5,keyboardDefaultStep:10};t.format&&!t.ariaFormat&&(t.ariaFormat=t.format),Object.keys(n).forEach((function(o){if(!r(t[o])&&void 0===i[o]){if(n[o].r)throw new Error("noUiSlider (14.6.3): '"+o+"' is required.");return!0}n[o].t(e,r(t[o])?t[o]:i[o])})),e.pips=t.pips;var o=document.createElement("div"),s=void 0!==o.style.msTransform,a=void 0!==o.style.transform;return e.transformRule=a?"transform":s?"msTransform":"webkitTransform",e.style=[["left","top"],["right","bottom"]][e.dir][e.ort],e}function $(t,r,i){var l,f,d,h,m,g,v,b,x=window.navigator.pointerEnabled?{start:"pointerdown",move:"pointermove",end:"pointerup"}:window.navigator.msPointerEnabled?{start:"MSPointerDown",move:"MSPointerMove",end:"MSPointerUp"}:{start:"mousedown touchstart",move:"mousemove touchmove",end:"mouseup touchend"},S=window.CSS&&CSS.supports&&CSS.supports("touch-action","none")&&function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",null,e)}catch(t){}return t}(),w=t,C=r.spectrum,P=[],N=[],k=[],U=0,A={},V=t.ownerDocument,D=r.documentElement||V.documentElement,M=V.body,O="rtl"===V.dir||1===r.ort?0:100;function L(t,e){var r=V.createElement("div");return e&&u(r,e),t.appendChild(r),r}function z(t,e){var n=L(t,r.cssClasses.origin),i=L(n,r.cssClasses.handle);return L(i,r.cssClasses.touchArea),i.setAttribute("data-handle",e),r.keyboardSupport&&(i.setAttribute("tabindex","0"),i.addEventListener("keydown",(function(t){return function(t,e){if(F()||R(e))return!1;var n=["Left","Right"],i=["Down","Up"],o=["PageDown","PageUp"],s=["Home","End"];r.dir&&!r.ort?n.reverse():r.ort&&!r.dir&&(i.reverse(),o.reverse());var a,l=t.key.replace("Arrow",""),u=l===o[0],c=l===o[1],p=l===i[0]||l===n[0]||u,f=l===i[1]||l===n[1]||c,d=l===s[0],h=l===s[1];if(!(p||f||d||h))return!0;if(t.preventDefault(),f||p){var m=r.keyboardPageMultiplier,g=p?0:1,v=ht(e)[g];if(null===v)return!1;!1===v&&(v=C.getDefaultStep(N[e],p,r.keyboardDefaultStep)),(c||u)&&(v*=m),v=Math.max(v,1e-7),v*=p?-1:1,a=P[e]+v}else a=h?r.spectrum.xVal[r.spectrum.xVal.length-1]:r.spectrum.xVal[0];return ut(e,C.toStepping(a),!0,!0),nt("slide",e),nt("update",e),nt("change",e),nt("set",e),!1}(t,e)}))),i.setAttribute("role","slider"),i.setAttribute("aria-orientation",r.ort?"vertical":"horizontal"),0===e?u(i,r.cssClasses.handleLower):e===r.handles-1&&u(i,r.cssClasses.handleUpper),n}function H(t,e){return!!e&&L(t,r.cssClasses.connect)}function j(t,e){return!!r.tooltips[e]&&L(t.firstChild,r.cssClasses.tooltip)}function F(){return w.hasAttribute("disabled")}function R(t){return f[t].hasAttribute("disabled")}function T(){m&&(rt("update"+y),m.forEach((function(t){t&&e(t)})),m=null)}function _(){T(),m=f.map(j),et("update"+y,(function(t,e,n){if(m[e]){var i=t[e];!0!==r.tooltips[e]&&(i=r.tooltips[e].to(n[e])),m[e].innerHTML=i}}))}function B(t,e,n){var i=V.createElement("div"),o=[];o[0]=r.cssClasses.valueNormal,o[1]=r.cssClasses.valueLarge,o[2]=r.cssClasses.valueSub;var s=[];s[0]=r.cssClasses.markerNormal,s[1]=r.cssClasses.markerLarge,s[2]=r.cssClasses.markerSub;var a=[r.cssClasses.valueHorizontal,r.cssClasses.valueVertical],l=[r.cssClasses.markerHorizontal,r.cssClasses.markerVertical];function c(t,e){var n=e===r.cssClasses.value,i=n?o:s;return e+" "+(n?a:l)[r.ort]+" "+i[t]}return u(i,r.cssClasses.pips),u(i,0===r.ort?r.cssClasses.pipsHorizontal:r.cssClasses.pipsVertical),Object.keys(t).forEach((function(o){!function(t,o,s){if(-1!==(s=e?e(o,s):s)){var a=L(i,!1);a.className=c(s,r.cssClasses.marker),a.style[r.style]=t+"%",s>0&&((a=L(i,!1)).className=c(s,r.cssClasses.value),a.setAttribute("data-value",o),a.style[r.style]=t+"%",a.innerHTML=n.to(o))}}(o,t[o][0],t[o][1])})),i}function q(){h&&(e(h),h=null)}function X(t){q();var e=t.mode,r=t.density||1,n=t.filter||!1,i=function(t,e,r){if("range"===t||"steps"===t)return C.xVal;if("count"===t){if(e<2)throw new Error("noUiSlider (14.6.3): 'values' (>= 2) required for mode 'count'.");var n=e-1,i=100/n;for(e=[];n--;)e[n]=n*i;e.push(100),t="positions"}return"positions"===t?e.map((function(t){return C.fromStepping(r?C.getStep(t):t)})):"values"===t?r?e.map((function(t){return C.fromStepping(C.getStep(C.toStepping(t)))})):e:void 0}(e,t.values||!1,t.stepped||!1),o=function(t,e,r){var n,i={},o=C.xVal[0],s=C.xVal[C.xVal.length-1],a=!1,l=!1,u=0;return n=r.slice().sort((function(t,e){return t-e})),(r=n.filter((function(t){return!this[t]&&(this[t]=!0)}),{}))[0]!==o&&(r.unshift(o),a=!0),r[r.length-1]!==s&&(r.push(s),l=!0),r.forEach((function(n,o){var s,c,p,f,d,h,m,g,v,b,x=n,S=r[o+1],w="steps"===e;if(w&&(s=C.xNumSteps[o]),s||(s=S-x),!1!==x)for(void 0===S&&(S=x),s=Math.max(s,1e-7),c=x;c<=S;c=(c+s).toFixed(7)/1){for(g=(d=(f=C.toStepping(c))-u)/t,b=d/(v=Math.round(g)),p=1;p<=v;p+=1)i[(h=u+p*b).toFixed(5)]=[C.fromStepping(h),0];m=r.indexOf(c)>-1?1:w?2:0,!o&&a&&c!==S&&(m=0),c===S&&l||(i[f.toFixed(5)]=[c,m]),u=f}})),i}(r,e,i),s=t.format||{to:Math.round};return h=w.appendChild(B(o,n,s))}function Y(){var t=l.getBoundingClientRect(),e="offset"+["Width","Height"][r.ort];return 0===r.ort?t.width||l[e]:t.height||l[e]}function I(t,e,n,i){var o=function(o){return!!(o=function(t,e,r){var n,i,o=0===t.type.indexOf("touch"),s=0===t.type.indexOf("mouse"),a=0===t.type.indexOf("pointer");if(0===t.type.indexOf("MSPointer")&&(a=!0),"mousedown"===t.type&&!t.buttons&&!t.touches)return!1;if(o){var l=function(t){return t.target===r||r.contains(t.target)||t.target.shadowRoot&&t.target.shadowRoot.contains(r)};if("touchstart"===t.type){var u=Array.prototype.filter.call(t.touches,l);if(u.length>1)return!1;n=u[0].pageX,i=u[0].pageY}else{var c=Array.prototype.find.call(t.changedTouches,l);if(!c)return!1;n=c.pageX,i=c.pageY}}return e=e||p(V),(s||a)&&(n=t.clientX+e.x,i=t.clientY+e.y),t.pageOffset=e,t.points=[n,i],t.cursor=s||a,t}(o,i.pageOffset,i.target||e))&&!(F()&&!i.doNotReject)&&(s=w,a=r.cssClasses.tap,!((s.classList?s.classList.contains(a):new RegExp("\\b"+a+"\\b").test(s.className))&&!i.doNotReject)&&!(t===x.start&&void 0!==o.buttons&&o.buttons>1)&&(!i.hover||!o.buttons)&&(S||o.preventDefault(),o.calcPoint=o.points[r.ort],void n(o,i)));var s,a},s=[];return t.split(" ").forEach((function(t){e.addEventListener(t,o,!!S&&{passive:!0}),s.push([t,o])})),s}function $(t){var e,n,i,o,a,u,c=100*(t-(e=l,n=r.ort,i=e.getBoundingClientRect(),o=e.ownerDocument,a=o.documentElement,u=p(o),/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(u.x=0),n?i.top+u.y-a.clientTop:i.left+u.x-a.clientLeft))/Y();return c=s(c),r.dir?100-c:c}function G(t,e){"mouseout"===t.type&&"HTML"===t.target.nodeName&&null===t.relatedTarget&&K(t,e)}function J(t,e){if(-1===navigator.appVersion.indexOf("MSIE 9")&&0===t.buttons&&0!==e.buttonsProperty)return K(t,e);var n=(r.dir?-1:1)*(t.calcPoint-e.startCalcPoint);st(n>0,100*n/e.baseSize,e.locations,e.handleNumbers)}function K(t,e){e.handle&&(c(e.handle,r.cssClasses.active),U-=1),e.listeners.forEach((function(t){D.removeEventListener(t[0],t[1])})),0===U&&(c(w,r.cssClasses.drag),lt(),t.cursor&&(M.style.cursor="",M.removeEventListener("selectstart",n))),e.handleNumbers.forEach((function(t){nt("change",t),nt("set",t),nt("end",t)}))}function Q(t,e){if(e.handleNumbers.some(R))return!1;var i;1===e.handleNumbers.length&&(i=f[e.handleNumbers[0]].children[0],U+=1,u(i,r.cssClasses.active)),t.stopPropagation();var o=[],s=I(x.move,D,J,{target:t.target,handle:i,listeners:o,startCalcPoint:t.calcPoint,baseSize:Y(),pageOffset:t.pageOffset,handleNumbers:e.handleNumbers,buttonsProperty:t.buttons,locations:N.slice()}),a=I(x.end,D,K,{target:t.target,handle:i,listeners:o,doNotReject:!0,handleNumbers:e.handleNumbers}),l=I("mouseout",D,G,{target:t.target,handle:i,listeners:o,doNotReject:!0,handleNumbers:e.handleNumbers});o.push.apply(o,s.concat(a,l)),t.cursor&&(M.style.cursor=getComputedStyle(t.target).cursor,f.length>1&&u(w,r.cssClasses.drag),M.addEventListener("selectstart",n,!1)),e.handleNumbers.forEach((function(t){nt("start",t)}))}function Z(t){t.stopPropagation();var e=$(t.calcPoint),n=function(t){var e=100,r=!1;return f.forEach((function(n,i){if(!R(i)){var o=N[i],s=Math.abs(o-t);(s<e||s<=e&&t>o||100===s&&100===e)&&(r=i,e=s)}})),r}(e);if(!1===n)return!1;r.events.snap||o(w,r.cssClasses.tap,r.animationDuration),ut(n,e,!0,!0),lt(),nt("slide",n,!0),nt("update",n,!0),nt("change",n,!0),nt("set",n,!0),r.events.snap&&Q(t,{handleNumbers:[n]})}function tt(t){var e=$(t.calcPoint),r=C.getStep(e),n=C.fromStepping(r);Object.keys(A).forEach((function(t){"hover"===t.split(".")[0]&&A[t].forEach((function(t){t.call(g,n)}))}))}function et(t,e){A[t]=A[t]||[],A[t].push(e),"update"===t.split(".")[0]&&f.forEach((function(t,e){nt("update",e)}))}function rt(t){var e=t&&t.split(".")[0],r=e?t.substring(e.length):t;Object.keys(A).forEach((function(t){var n=t.split(".")[0],i=t.substring(n.length);e&&e!==n||r&&r!==i||function(t){return t===E||t===y}(i)&&r!==i||delete A[t]}))}function nt(t,e,n){Object.keys(A).forEach((function(i){var o=i.split(".")[0];t===o&&A[i].forEach((function(t){t.call(g,P.map(r.format.to),e,P.slice(),n||!1,N.slice(),g)}))}))}function it(t,e,n,i,o,a){var l;return f.length>1&&!r.events.unconstrained&&(i&&e>0&&(l=C.getAbsoluteDistance(t[e-1],r.margin,0),n=Math.max(n,l)),o&&e<f.length-1&&(l=C.getAbsoluteDistance(t[e+1],r.margin,1),n=Math.min(n,l))),f.length>1&&r.limit&&(i&&e>0&&(l=C.getAbsoluteDistance(t[e-1],r.limit,0),n=Math.min(n,l)),o&&e<f.length-1&&(l=C.getAbsoluteDistance(t[e+1],r.limit,1),n=Math.max(n,l))),r.padding&&(0===e&&(l=C.getAbsoluteDistance(0,r.padding[0],0),n=Math.max(n,l)),e===f.length-1&&(l=C.getAbsoluteDistance(100,r.padding[1],1),n=Math.min(n,l))),!((n=s(n=C.getStep(n)))===t[e]&&!a)&&n}function ot(t,e){var n=r.ort;return(n?e:t)+", "+(n?t:e)}function st(t,e,r,n){var i=r.slice(),o=[!t,t],s=[t,!t];n=n.slice(),t&&n.reverse(),n.length>1?n.forEach((function(t,r){var n=it(i,t,i[t]+e,o[r],s[r],!1);!1===n?e=0:(e=n-i[t],i[t]=n)})):o=s=[!0];var a=!1;n.forEach((function(t,n){a=ut(t,r[t]+e,o[n],s[n])||a})),a&&n.forEach((function(t){nt("update",t),nt("slide",t)}))}function at(t,e){return r.dir?100-t-e:t}function lt(){k.forEach((function(t){var e=N[t]>50?-1:1,r=3+(f.length+e*t);f[t].style.zIndex=r}))}function ut(t,e,n,i,o){return o||(e=it(N,t,e,n,i,!1)),!1!==e&&(function(t,e){N[t]=e,P[t]=C.fromStepping(e);var n="translate("+ot(10*(at(e,0)-O)+"%","0")+")";f[t].style[r.transformRule]=n,ct(t),ct(t+1)}(t,e),!0)}function ct(t){if(d[t]){var e=0,n=100;0!==t&&(e=N[t-1]),t!==d.length-1&&(n=N[t]);var i=n-e,o="translate("+ot(at(e,i)+"%","0")+")",s="scale("+ot(i/100,"1")+")";d[t].style[r.transformRule]=o+" "+s}}function pt(t,e){return null===t||!1===t||void 0===t?N[e]:("number"==typeof t&&(t=String(t)),t=r.format.from(t),!1===(t=C.toStepping(t))||isNaN(t)?N[e]:t)}function ft(t,e,n){var i=a(t),s=void 0===N[0];e=void 0===e||!!e,r.animate&&!s&&o(w,r.cssClasses.tap,r.animationDuration),k.forEach((function(t){ut(t,pt(i[t],t),!0,!1,n)}));for(var l=1===k.length?0:1;l<k.length;++l)k.forEach((function(t){ut(t,N[t],!0,!0,n)}));lt(),k.forEach((function(t){nt("update",t),null!==i[t]&&e&&nt("set",t)}))}function dt(){var t=P.map(r.format.to);return 1===t.length?t[0]:t}function ht(t){var e=N[t],n=C.getNearbySteps(e),i=P[t],o=n.thisStep.step,s=null;if(r.snap)return[i-n.stepBefore.startValue||null,n.stepAfter.startValue-i||null];!1!==o&&i+o>n.stepAfter.startValue&&(o=n.stepAfter.startValue-i),s=i>n.thisStep.startValue?n.thisStep.step:!1!==n.stepBefore.step&&i-n.stepBefore.highestStep,100===e?o=null:0===e&&(s=null);var a=C.countStepDecimals();return null!==o&&!1!==o&&(o=Number(o.toFixed(a))),null!==s&&!1!==s&&(s=Number(s.toFixed(a))),[s,o]}return u(v=w,r.cssClasses.target),0===r.dir?u(v,r.cssClasses.ltr):u(v,r.cssClasses.rtl),0===r.ort?u(v,r.cssClasses.horizontal):u(v,r.cssClasses.vertical),u(v,"rtl"===getComputedStyle(v).direction?r.cssClasses.textDirectionRtl:r.cssClasses.textDirectionLtr),l=L(v,r.cssClasses.base),function(t,e){var n=L(e,r.cssClasses.connects);f=[],(d=[]).push(H(n,t[0]));for(var i=0;i<r.handles;i++)f.push(z(e,i)),k[i]=i,d.push(H(n,t[i+1]))}(r.connect,l),(b=r.events).fixed||f.forEach((function(t,e){I(x.start,t.children[0],Q,{handleNumbers:[e]})})),b.tap&&I(x.start,l,Z,{}),b.hover&&I(x.move,l,tt,{hover:!0}),b.drag&&d.forEach((function(t,e){if(!1!==t&&0!==e&&e!==d.length-1){var n=f[e-1],i=f[e],o=[t];u(t,r.cssClasses.draggable),b.fixed&&(o.push(n.children[0]),o.push(i.children[0])),o.forEach((function(t){I(x.start,t,Q,{handles:[n,i],handleNumbers:[e-1,e]})}))}})),ft(r.start),r.pips&&X(r.pips),r.tooltips&&_(),rt("update"+E),et("update"+E,(function(t,e,n,i,o){k.forEach((function(t){var e=f[t],i=it(N,t,0,!0,!0,!0),s=it(N,t,100,!0,!0,!0),a=o[t],l=r.ariaFormat.to(n[t]);i=C.fromStepping(i).toFixed(1),s=C.fromStepping(s).toFixed(1),a=C.fromStepping(a).toFixed(1),e.children[0].setAttribute("aria-valuemin",i),e.children[0].setAttribute("aria-valuemax",s),e.children[0].setAttribute("aria-valuenow",a),e.children[0].setAttribute("aria-valuetext",l)}))})),g={destroy:function(){for(var t in rt(E),rt(y),r.cssClasses)r.cssClasses.hasOwnProperty(t)&&c(w,r.cssClasses[t]);for(;w.firstChild;)w.removeChild(w.firstChild);delete w.noUiSlider},steps:function(){return k.map(ht)},on:et,off:rt,get:dt,set:ft,setHandle:function(t,e,r,n){if(!((t=Number(t))>=0&&t<k.length))throw new Error("noUiSlider (14.6.3): invalid handle number, got: "+t);ut(t,pt(e,t),!0,!0,n),nt("update",t),r&&nt("set",t)},reset:function(t){ft(r.start,t)},__moveHandles:function(t,e,r){st(t,e,N,r)},options:i,updateOptions:function(t,e){var n=dt(),o=["margin","limit","padding","range","animate","snap","step","format","pips","tooltips"];o.forEach((function(e){void 0!==t[e]&&(i[e]=t[e])}));var s=W(i);o.forEach((function(e){void 0!==t[e]&&(r[e]=s[e])})),C=s.spectrum,r.margin=s.margin,r.limit=s.limit,r.padding=s.padding,r.pips?X(r.pips):q(),r.tooltips?_():T(),N=[],ft(t.start||n,e)},target:w,removePips:q,removeTooltips:T,getTooltips:function(){return m},getOrigins:function(){return f},pips:X}}return{__spectrum:x,version:t,cssClasses:w,create:function(t,e){if(!t||!t.nodeName)throw new Error("noUiSlider (14.6.3): create requires a single element, got: "+t);if(t.noUiSlider)throw new Error("noUiSlider (14.6.3): Slider was already initialized.");var r=$(t,W(e),e);return t.noUiSlider=r,r}}},"function"==typeof define&&define.amd?define([],o):"object"==typeof r?e.exports=o():window.noUiSlider=o()},
437: function _(e,t,l,i,o){i(),l.root="bk-root",l.slider_title="bk-slider-title",l.slider_value="bk-slider-value",l.default=".bk-root .bk-slider-title{white-space:nowrap;}.bk-root .bk-slider-value{font-weight:600;}"},
438: function _(o,t,r,i,n){i(),r.root="bk-root",r.default='.bk-root{}.bk-root .noUi-target,.bk-root .noUi-target *{-webkit-touch-callout:none;-webkit-tap-highlight-color:rgba(0, 0, 0, 0);-webkit-user-select:none;-ms-touch-action:none;touch-action:none;-ms-user-select:none;-moz-user-select:none;user-select:none;-moz-box-sizing:border-box;box-sizing:border-box;}.bk-root .noUi-target{position:relative;}.bk-root .noUi-base,.bk-root .noUi-connects{width:100%;height:100%;position:relative;z-index:1;}.bk-root .noUi-connects{overflow:hidden;z-index:0;}.bk-root .noUi-connect,.bk-root .noUi-origin{will-change:transform;position:absolute;z-index:1;top:0;right:0;-ms-transform-origin:0 0;-webkit-transform-origin:0 0;-webkit-transform-style:preserve-3d;transform-origin:0 0;transform-style:flat;}.bk-root .noUi-connect{height:100%;width:100%;}.bk-root .noUi-origin{height:10%;width:10%;}.bk-root .noUi-txt-dir-rtl.noUi-horizontal .noUi-origin{left:0;right:auto;}.bk-root .noUi-vertical .noUi-origin{width:0;}.bk-root .noUi-horizontal .noUi-origin{height:0;}.bk-root .noUi-handle{-webkit-backface-visibility:hidden;backface-visibility:hidden;position:absolute;}.bk-root .noUi-touch-area{height:100%;width:100%;}.bk-root .noUi-state-tap .noUi-connect,.bk-root .noUi-state-tap .noUi-origin{-webkit-transition:transform 0.3s;transition:transform 0.3s;}.bk-root .noUi-state-drag *{cursor:inherit !important;}.bk-root .noUi-horizontal{height:18px;}.bk-root .noUi-horizontal .noUi-handle{width:34px;height:28px;right:-17px;top:-6px;}.bk-root .noUi-vertical{width:18px;}.bk-root .noUi-vertical .noUi-handle{width:28px;height:34px;right:-6px;top:-17px;}.bk-root .noUi-txt-dir-rtl.noUi-horizontal .noUi-handle{left:-17px;right:auto;}.bk-root .noUi-target{background:#FAFAFA;border-radius:4px;border:1px solid #D3D3D3;box-shadow:inset 0 1px 1px #F0F0F0, 0 3px 6px -5px #BBB;}.bk-root .noUi-connects{border-radius:3px;}.bk-root .noUi-connect{background:#3FB8AF;}.bk-root .noUi-draggable{cursor:ew-resize;}.bk-root .noUi-vertical .noUi-draggable{cursor:ns-resize;}.bk-root .noUi-handle{border:1px solid #D9D9D9;border-radius:3px;background:#FFF;cursor:default;box-shadow:inset 0 0 1px #FFF, inset 0 1px 7px #EBEBEB, 0 3px 6px -3px #BBB;}.bk-root .noUi-active{box-shadow:inset 0 0 1px #FFF, inset 0 1px 7px #DDD, 0 3px 6px -3px #BBB;}.bk-root .noUi-handle:before,.bk-root .noUi-handle:after{content:"";display:block;position:absolute;height:14px;width:1px;background:#E8E7E6;left:14px;top:6px;}.bk-root .noUi-handle:after{left:17px;}.bk-root .noUi-vertical .noUi-handle:before,.bk-root .noUi-vertical .noUi-handle:after{width:14px;height:1px;left:6px;top:14px;}.bk-root .noUi-vertical .noUi-handle:after{top:17px;}.bk-root [disabled] .noUi-connect{background:#B8B8B8;}.bk-root [disabled].noUi-target,.bk-root [disabled].noUi-handle,.bk-root [disabled] .noUi-handle{cursor:not-allowed;}.bk-root .noUi-pips,.bk-root .noUi-pips *{-moz-box-sizing:border-box;box-sizing:border-box;}.bk-root .noUi-pips{position:absolute;color:#999;}.bk-root .noUi-value{position:absolute;white-space:nowrap;text-align:center;}.bk-root .noUi-value-sub{color:#ccc;font-size:10px;}.bk-root .noUi-marker{position:absolute;background:#CCC;}.bk-root .noUi-marker-sub{background:#AAA;}.bk-root .noUi-marker-large{background:#AAA;}.bk-root .noUi-pips-horizontal{padding:10px 0;height:80px;top:100%;left:0;width:100%;}.bk-root .noUi-value-horizontal{-webkit-transform:translate(-50%, 50%);transform:translate(-50%, 50%);}.bk-root .noUi-rtl .noUi-value-horizontal{-webkit-transform:translate(50%, 50%);transform:translate(50%, 50%);}.bk-root .noUi-marker-horizontal.noUi-marker{margin-left:-1px;width:2px;height:5px;}.bk-root .noUi-marker-horizontal.noUi-marker-sub{height:10px;}.bk-root .noUi-marker-horizontal.noUi-marker-large{height:15px;}.bk-root .noUi-pips-vertical{padding:0 10px;height:100%;top:0;left:100%;}.bk-root .noUi-value-vertical{-webkit-transform:translate(0, -50%);transform:translate(0, -50%);padding-left:25px;}.bk-root .noUi-rtl .noUi-value-vertical{-webkit-transform:translate(0, 50%);transform:translate(0, 50%);}.bk-root .noUi-marker-vertical.noUi-marker{width:5px;height:2px;margin-top:-1px;}.bk-root .noUi-marker-vertical.noUi-marker-sub{width:10px;}.bk-root .noUi-marker-vertical.noUi-marker-large{width:15px;}.bk-root .noUi-tooltip{display:block;position:absolute;border:1px solid #D9D9D9;border-radius:3px;background:#fff;color:#000;padding:5px;text-align:center;white-space:nowrap;}.bk-root .noUi-horizontal .noUi-tooltip{-webkit-transform:translate(-50%, 0);transform:translate(-50%, 0);left:50%;bottom:120%;}.bk-root .noUi-vertical .noUi-tooltip{-webkit-transform:translate(0, -50%);transform:translate(0, -50%);top:50%;right:120%;}.bk-root .noUi-horizontal .noUi-origin > .noUi-tooltip{-webkit-transform:translate(50%, 0);transform:translate(50%, 0);left:auto;bottom:10px;}.bk-root .noUi-vertical .noUi-origin > .noUi-tooltip{-webkit-transform:translate(0, -18px);transform:translate(0, -18px);top:auto;right:28px;}.bk-root .noUi-handle{cursor:grab;cursor:-webkit-grab;}.bk-root .noUi-handle.noUi-active{cursor:grabbing;cursor:-webkit-grabbing;}.bk-root .noUi-handle:after,.bk-root .noUi-handle:before{display:none;}.bk-root .noUi-tooltip{display:none;white-space:nowrap;}.bk-root .noUi-handle:hover .noUi-tooltip{display:block;}.bk-root .noUi-horizontal{width:100%;height:10px;}.bk-root .noUi-vertical{width:10px;height:100%;}.bk-root .noUi-horizontal .noUi-handle{width:14px;height:18px;right:-7px;top:-5px;}.bk-root .noUi-vertical .noUi-handle{width:18px;height:14px;right:-5px;top:-7px;}.bk-root .noUi-target.noUi-horizontal{margin:5px 0px;}.bk-root .noUi-target.noUi-vertical{margin:0px 5px;}'},
439: function _(t,e,i,r,a){r();const s=t(1).__importDefault(t(178)),d=t(435),_=t(8);class n extends d.AbstractSliderView{}i.DateSliderView=n,n.__name__="DateSliderView";class l extends d.AbstractSlider{constructor(t){super(t),this.behaviour="tap",this.connected=[!0,!1]}static init_DateSlider(){this.prototype.default_view=n,this.override({format:"%d %b %Y"})}_formatter(t,e){return _.isString(e)?s.default(t,e):e.compute(t)}}i.DateSlider=l,l.__name__="DateSlider",l.init_DateSlider()},
440: function _(e,t,i,n,s){n();const r=e(441);class _ extends r.MarkupView{render(){super.render(),this.model.render_as_text?this.markup_el.textContent=this.model.text:this.markup_el.innerHTML=this.model.text}}i.DivView=_,_.__name__="DivView";class a extends r.Markup{constructor(e){super(e)}static init_Div(){this.prototype.default_view=_,this.define((({Boolean:e})=>({render_as_text:[e,!1]})))}}i.Div=a,a.__name__="Div",a.init_Div()},
441: function _(t,e,s,i,a){i();const n=t(1),l=t(221),r=t(43),c=t(485),u=n.__importStar(t(442));class _ extends c.WidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>{this.layout.invalidate_cache(),this.render(),this.root.compute_layout()}))}styles(){return[...super.styles(),u.default]}_update_layout(){this.layout=new l.CachedVariadicBox(this.el),this.layout.set_sizing(this.box_sizing())}render(){super.render();const t=Object.assign(Object.assign({},this.model.style),{display:"inline-block"});this.markup_el=r.div({class:u.clearfix,style:t}),this.el.appendChild(this.markup_el)}}s.MarkupView=_,_.__name__="MarkupView";class o extends c.Widget{constructor(t){super(t)}static init_Markup(){this.define((({String:t,Dict:e})=>({text:[t,""],style:[e(t),{}]})))}}s.Markup=o,o.__name__="Markup",o.init_Markup()},
442: function _(o,r,e,t,a){t(),e.root="bk-root",e.clearfix="bk-clearfix",e.default='.bk-root .bk-clearfix:before,.bk-root .bk-clearfix:after{content:"";display:table;}.bk-root .bk-clearfix:after{clear:both;}'},
443: function _(e,t,i,n,s){n();const o=e(1),r=e(416),l=e(262),d=e(43),_=e(8),u=o.__importStar(e(326)),c=o.__importStar(e(240)),h=c;class p extends r.AbstractButtonView{constructor(){super(...arguments),this._open=!1}styles(){return[...super.styles(),c.default]}render(){super.render();const e=d.div({class:[h.caret,h.down]});if(this.model.is_split){const t=this._render_button(e);t.classList.add(u.dropdown_toggle),t.addEventListener("click",(()=>this._toggle_menu())),this.group_el.appendChild(t)}else this.button_el.appendChild(e);const t=this.model.menu.map(((e,t)=>{if(null==e)return d.div({class:h.divider});{const i=_.isString(e)?e:e[0],n=d.div({},i);return n.addEventListener("click",(()=>this._item_click(t))),n}}));this.menu=d.div({class:[h.menu,h.below]},t),this.el.appendChild(this.menu),d.undisplay(this.menu)}_show_menu(){if(!this._open){this._open=!0,d.display(this.menu);const e=t=>{const{target:i}=t;i instanceof HTMLElement&&!this.el.contains(i)&&(document.removeEventListener("click",e),this._hide_menu())};document.addEventListener("click",e)}}_hide_menu(){this._open&&(this._open=!1,d.undisplay(this.menu))}_toggle_menu(){this._open?this._hide_menu():this._show_menu()}click(){this.model.is_split?(this._hide_menu(),this.model.trigger_event(new l.ButtonClick),super.click()):this._toggle_menu()}_item_click(e){this._hide_menu();const t=this.model.menu[e];if(null!=t){const i=_.isString(t)?t:t[1];_.isString(i)?this.model.trigger_event(new l.MenuItemClick(i)):i.execute(this.model,{index:e})}}}i.DropdownView=p,p.__name__="DropdownView";class m extends r.AbstractButton{constructor(e){super(e)}static init_Dropdown(){this.prototype.default_view=p,this.define((({Null:e,Boolean:t,String:i,Array:n,Tuple:s,Or:o})=>({split:[t,!1],menu:[n(o(i,s(i,o(i)),e)),[]]}))),this.override({label:"Dropdown"})}get is_split(){return this.split}}i.Dropdown=m,m.__name__="Dropdown",m.init_Dropdown()},
444: function _(e,i,t,l,s){l();const n=e(485);class a extends n.WidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render())),this.connect(this.model.properties.width.change,(()=>this.render()))}render(){null==this.dialogEl&&(this.dialogEl=document.createElement("input"),this.dialogEl.type="file",this.dialogEl.multiple=this.model.multiple,this.dialogEl.onchange=()=>{const{files:e}=this.dialogEl;null!=e&&this.load_files(e)},this.el.appendChild(this.dialogEl)),null!=this.model.accept&&""!=this.model.accept&&(this.dialogEl.accept=this.model.accept),this.dialogEl.style.width="{this.model.width}px",this.dialogEl.disabled=this.model.disabled}async load_files(e){const i=[],t=[],l=[];let s;for(s=0;s<e.length;s++){t.push(e[s].name);const n=await this.readfile(e[s]),[,a,,o]=n.split(/[:;,]/,4);i.push(o),l.push(a)}this.model.multiple?(this.model.filename=t,this.model.mime_type=l,this.model.value=i):(this.model.filename=t[0],this.model.mime_type=l[0],this.model.value=i[0])}readfile(e){return new Promise(((i,t)=>{const l=new FileReader;l.onload=()=>{var s;const{result:n}=l;null!=n?i(n):t(null!==(s=l.error)&&void 0!==s?s:new Error(`unable to read '${e.name}'`))},l.readAsDataURL(e)}))}}t.FileInputView=a,a.__name__="FileInputView";class o extends n.Widget{constructor(e){super(e)}static init_FileInput(){this.prototype.default_view=a,this.define((({Boolean:e,String:i,Array:t,Or:l})=>({value:[l(i,t(i)),""],mime_type:[l(i,t(i)),""],filename:[l(i,t(i)),""],accept:[i,""],multiple:[e,!1]})))}}t.FileInput=o,o.__name__="FileInput",o.init_FileInput()},
445: function _(e,t,i,s,n){s();const l=e(1),o=e(43),r=e(8),c=e(423),h=l.__importStar(e(424));class p extends c.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.value.change,(()=>this.render_selection())),this.connect(this.model.properties.options.change,(()=>this.render())),this.connect(this.model.properties.name.change,(()=>this.render())),this.connect(this.model.properties.title.change,(()=>this.render())),this.connect(this.model.properties.size.change,(()=>this.render())),this.connect(this.model.properties.disabled.change,(()=>this.render()))}render(){super.render();const e=this.model.options.map((e=>{let t,i;return r.isString(e)?t=i=e:[t,i]=e,o.option({value:t},i)}));this.input_el=o.select({multiple:!0,class:h.input,name:this.model.name,disabled:this.model.disabled},e),this.input_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.input_el),this.render_selection()}render_selection(){const e=new Set(this.model.value);for(const t of this.el.querySelectorAll("option"))t.selected=e.has(t.value);this.input_el.size=this.model.size}change_input(){const e=null!=this.el.querySelector("select:focus"),t=[];for(const e of this.el.querySelectorAll("option"))e.selected&&t.push(e.value);this.model.value=t,super.change_input(),e&&this.input_el.focus()}}i.MultiSelectView=p,p.__name__="MultiSelectView";class u extends c.InputWidget{constructor(e){super(e)}static init_MultiSelect(){this.prototype.default_view=p,this.define((({Int:e,String:t,Array:i,Tuple:s,Or:n})=>({value:[i(t),[]],options:[i(n(t,s(t,t))),[]],size:[e,4]})))}}i.MultiSelect=u,u.__name__="MultiSelect",u.init_MultiSelect()},
446: function _(a,r,e,t,p){t();const s=a(441),i=a(43);class n extends s.MarkupView{render(){super.render();const a=i.p({style:{margin:0}},this.model.text);this.markup_el.appendChild(a)}}e.ParagraphView=n,n.__name__="ParagraphView";class _ extends s.Markup{constructor(a){super(a)}static init_Paragraph(){this.prototype.default_view=n}}e.Paragraph=_,_.__name__="Paragraph",_.init_Paragraph()},
447: function _(s,t,e,n,r){n();const p=s(421);class u extends p.TextInputView{render(){super.render(),this.input_el.type="password"}}e.PasswordInputView=u,u.__name__="PasswordInputView";class a extends p.TextInput{constructor(s){super(s)}static init_PasswordInput(){this.prototype.default_view=u}}e.PasswordInput=a,a.__name__="PasswordInput",a.init_PasswordInput()},
448: function _(e,t,i,l,s){l();const o=e(1),n=o.__importDefault(e(449)),h=e(43),a=e(8),u=e(221),c=o.__importStar(e(424)),d=o.__importDefault(e(450)),_=e(423);class r extends _.InputWidgetView{constructor(){super(...arguments),this._last_height=null}connect_signals(){super.connect_signals(),this.connect(this.model.properties.disabled.change,(()=>this.set_disabled()));const{value:e,max_items:t,option_limit:i,delete_button:l,placeholder:s,options:o,name:n,title:h}=this.model.properties;this.on_change([e,t,i,l,s,o,n,h],(()=>this.render()))}styles(){return[...super.styles(),d.default]}_update_layout(){this.layout=new u.CachedVariadicBox(this.el),this.layout.set_sizing(this.box_sizing())}render(){super.render(),this.input_el=h.select({multiple:!0,class:c.input,name:this.model.name,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el);const e=new Set(this.model.value),t=this.model.options.map((t=>{let i,l;return a.isString(t)?i=l=t:[i,l]=t,{value:i,label:l,selected:e.has(i)}})),i=this.model.solid?"solid":"light",l=`choices__item ${i}`,s=`choices__button ${i}`,o={choices:t,duplicateItemsAllowed:!1,removeItemButton:this.model.delete_button,classNames:{item:l,button:s}};null!=this.model.placeholder&&(o.placeholderValue=this.model.placeholder),null!=this.model.max_items&&(o.maxItemCount=this.model.max_items),null!=this.model.option_limit&&(o.renderChoiceLimit=this.model.option_limit),this.choice_el=new n.default(this.input_el,o);const u=()=>this.choice_el.containerOuter.element.getBoundingClientRect().height;null!=this._last_height&&this._last_height!=u()&&this.root.invalidate_layout(),this._last_height=u(),this.input_el.addEventListener("change",(()=>this.change_input()))}set_disabled(){this.model.disabled?this.choice_el.disable():this.choice_el.enable()}change_input(){const e=null!=this.el.querySelector("select:focus"),t=[];for(const e of this.el.querySelectorAll("option"))e.selected&&t.push(e.value);this.model.value=t,super.change_input(),e&&this.input_el.focus()}}i.MultiChoiceView=r,r.__name__="MultiChoiceView";class m extends _.InputWidget{constructor(e){super(e)}static init_MultiChoice(){this.prototype.default_view=r,this.define((({Boolean:e,Int:t,String:i,Array:l,Tuple:s,Or:o,Nullable:n})=>({value:[l(i),[]],options:[l(o(i,s(i,i))),[]],max_items:[n(t),null],delete_button:[e,!0],placeholder:[n(i),null],option_limit:[n(t),null],solid:[e,!0]})))}}i.MultiChoice=m,m.__name__="MultiChoice",m.init_MultiChoice()},
449: function _(e,t,i,n,s){
/*! choices.js v9.0.1 | © 2019 Josh Johnson | https://github.com/jshjohnson/Choices#readme */
var r,o;r=window,o=function(){return function(e){var t={};function i(n){if(t[n])return t[n].exports;var s=t[n]={i:n,l:!1,exports:{}};return e[n].call(s.exports,s,s.exports,i),s.l=!0,s.exports}return i.m=e,i.c=t,i.d=function(e,t,n){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i.t=function(e,t){if(1&t&&(e=i(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var s in e)i.d(n,s,function(t){return e[t]}.bind(null,s));return n},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="/public/assets/scripts/",i(i.s=4)}([function(e,t,i){"use strict";var n=function(e){return function(e){return!!e&&"object"==typeof e}(e)&&!function(e){var t=Object.prototype.toString.call(e);return"[object RegExp]"===t||"[object Date]"===t||function(e){return e.$$typeof===s}(e)}(e)},s="function"==typeof Symbol&&Symbol.for?Symbol.for("react.element"):60103;function r(e,t){return!1!==t.clone&&t.isMergeableObject(e)?l((i=e,Array.isArray(i)?[]:{}),e,t):e;var i}function o(e,t,i){return e.concat(t).map((function(e){return r(e,i)}))}function a(e){return Object.keys(e).concat(function(e){return Object.getOwnPropertySymbols?Object.getOwnPropertySymbols(e).filter((function(t){return e.propertyIsEnumerable(t)})):[]}(e))}function c(e,t,i){var n={};return i.isMergeableObject(e)&&a(e).forEach((function(t){n[t]=r(e[t],i)})),a(t).forEach((function(s){(function(e,t){try{return t in e&&!(Object.hasOwnProperty.call(e,t)&&Object.propertyIsEnumerable.call(e,t))}catch(e){return!1}})(e,s)||(i.isMergeableObject(t[s])&&e[s]?n[s]=function(e,t){if(!t.customMerge)return l;var i=t.customMerge(e);return"function"==typeof i?i:l}(s,i)(e[s],t[s],i):n[s]=r(t[s],i))})),n}function l(e,t,i){(i=i||{}).arrayMerge=i.arrayMerge||o,i.isMergeableObject=i.isMergeableObject||n,i.cloneUnlessOtherwiseSpecified=r;var s=Array.isArray(t);return s===Array.isArray(e)?s?i.arrayMerge(e,t,i):c(e,t,i):r(t,i)}l.all=function(e,t){if(!Array.isArray(e))throw new Error("first argument should be an array");return e.reduce((function(e,i){return l(e,i,t)}),{})};var h=l;e.exports=h},function(e,t,i){"use strict";(function(e,n){var s,r=i(3);s="undefined"!=typeof self?self:"undefined"!=typeof window?window:void 0!==e?e:n;var o=Object(r.a)(s);t.a=o}).call(this,i(5),i(6)(e))},function(e,t,i){
/*!
                 * Fuse.js v3.4.5 - Lightweight fuzzy-search (http://fusejs.io)
                 *
                 * Copyright (c) 2012-2017 Kirollos Risk (http://kiro.me)
                 * All Rights Reserved. Apache Software License 2.0
                 *
                 * http://www.apache.org/licenses/LICENSE-2.0
                 */
e.exports=function(e){var t={};function i(n){if(t[n])return t[n].exports;var s=t[n]={i:n,l:!1,exports:{}};return e[n].call(s.exports,s,s.exports,i),s.l=!0,s.exports}return i.m=e,i.c=t,i.d=function(e,t,n){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i.t=function(e,t){if(1&t&&(e=i(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var s in e)i.d(n,s,function(t){return e[t]}.bind(null,s));return n},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="",i(i.s=1)}([function(e,t){e.exports=function(e){return Array.isArray?Array.isArray(e):"[object Array]"===Object.prototype.toString.call(e)}},function(e,t,i){function n(e){return(n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function s(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var r=i(2),o=i(8),a=i(0),c=function(){function e(t,i){var n=i.location,s=void 0===n?0:n,r=i.distance,a=void 0===r?100:r,c=i.threshold,l=void 0===c?.6:c,h=i.maxPatternLength,u=void 0===h?32:h,d=i.caseSensitive,p=void 0!==d&&d,m=i.tokenSeparator,f=void 0===m?/ +/g:m,v=i.findAllMatches,g=void 0!==v&&v,_=i.minMatchCharLength,b=void 0===_?1:_,y=i.id,E=void 0===y?null:y,I=i.keys,S=void 0===I?[]:I,w=i.shouldSort,O=void 0===w||w,C=i.getFn,A=void 0===C?o:C,L=i.sortFn,T=void 0===L?function(e,t){return e.score-t.score}:L,x=i.tokenize,k=void 0!==x&&x,P=i.matchAllTokens,D=void 0!==P&&P,M=i.includeMatches,N=void 0!==M&&M,F=i.includeScore,j=void 0!==F&&F,K=i.verbose,R=void 0!==K&&K;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.options={location:s,distance:a,threshold:l,maxPatternLength:u,isCaseSensitive:p,tokenSeparator:f,findAllMatches:g,minMatchCharLength:b,id:E,keys:S,includeMatches:N,includeScore:j,shouldSort:O,getFn:A,sortFn:T,verbose:R,tokenize:k,matchAllTokens:D},this.setCollection(t)}var t,i,c;return t=e,(i=[{key:"setCollection",value:function(e){return this.list=e,e}},{key:"search",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{limit:!1};this._log('---------\nSearch pattern: "'.concat(e,'"'));var i=this._prepareSearchers(e),n=i.tokenSearchers,s=i.fullSearcher,r=this._search(n,s),o=r.weights,a=r.results;return this._computeScore(o,a),this.options.shouldSort&&this._sort(a),t.limit&&"number"==typeof t.limit&&(a=a.slice(0,t.limit)),this._format(a)}},{key:"_prepareSearchers",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",t=[];if(this.options.tokenize)for(var i=e.split(this.options.tokenSeparator),n=0,s=i.length;n<s;n+=1)t.push(new r(i[n],this.options));return{tokenSearchers:t,fullSearcher:new r(e,this.options)}}},{key:"_search",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1?arguments[1]:void 0,i=this.list,n={},s=[];if("string"==typeof i[0]){for(var r=0,o=i.length;r<o;r+=1)this._analyze({key:"",value:i[r],record:r,index:r},{resultMap:n,results:s,tokenSearchers:e,fullSearcher:t});return{weights:null,results:s}}for(var a={},c=0,l=i.length;c<l;c+=1)for(var h=i[c],u=0,d=this.options.keys.length;u<d;u+=1){var p=this.options.keys[u];if("string"!=typeof p){if(a[p.name]={weight:1-p.weight||1},p.weight<=0||p.weight>1)throw new Error("Key weight has to be > 0 and <= 1");p=p.name}else a[p]={weight:1};this._analyze({key:p,value:this.options.getFn(h,p),record:h,index:c},{resultMap:n,results:s,tokenSearchers:e,fullSearcher:t})}return{weights:a,results:s}}},{key:"_analyze",value:function(e,t){var i=e.key,n=e.arrayIndex,s=void 0===n?-1:n,r=e.value,o=e.record,c=e.index,l=t.tokenSearchers,h=void 0===l?[]:l,u=t.fullSearcher,d=void 0===u?[]:u,p=t.resultMap,m=void 0===p?{}:p,f=t.results,v=void 0===f?[]:f;if(null!=r){var g=!1,_=-1,b=0;if("string"==typeof r){this._log("\nKey: ".concat(""===i?"-":i));var y=d.search(r);if(this._log('Full text: "'.concat(r,'", score: ').concat(y.score)),this.options.tokenize){for(var E=r.split(this.options.tokenSeparator),I=[],S=0;S<h.length;S+=1){var w=h[S];this._log('\nPattern: "'.concat(w.pattern,'"'));for(var O=!1,C=0;C<E.length;C+=1){var A=E[C],L=w.search(A),T={};L.isMatch?(T[A]=L.score,g=!0,O=!0,I.push(L.score)):(T[A]=1,this.options.matchAllTokens||I.push(1)),this._log('Token: "'.concat(A,'", score: ').concat(T[A]))}O&&(b+=1)}_=I[0];for(var x=I.length,k=1;k<x;k+=1)_+=I[k];_/=x,this._log("Token score average:",_)}var P=y.score;_>-1&&(P=(P+_)/2),this._log("Score average:",P);var D=!this.options.tokenize||!this.options.matchAllTokens||b>=h.length;if(this._log("\nCheck Matches: ".concat(D)),(g||y.isMatch)&&D){var M=m[c];M?M.output.push({key:i,arrayIndex:s,value:r,score:P,matchedIndices:y.matchedIndices}):(m[c]={item:o,output:[{key:i,arrayIndex:s,value:r,score:P,matchedIndices:y.matchedIndices}]},v.push(m[c]))}}else if(a(r))for(var N=0,F=r.length;N<F;N+=1)this._analyze({key:i,arrayIndex:N,value:r[N],record:o,index:c},{resultMap:m,results:v,tokenSearchers:h,fullSearcher:d})}}},{key:"_computeScore",value:function(e,t){this._log("\n\nComputing score:\n");for(var i=0,n=t.length;i<n;i+=1){for(var s=t[i].output,r=s.length,o=1,a=1,c=0;c<r;c+=1){var l=e?e[s[c].key].weight:1,h=(1===l?s[c].score:s[c].score||.001)*l;1!==l?a=Math.min(a,h):(s[c].nScore=h,o*=h)}t[i].score=1===a?o:a,this._log(t[i])}}},{key:"_sort",value:function(e){this._log("\n\nSorting...."),e.sort(this.options.sortFn)}},{key:"_format",value:function(e){var t=[];if(this.options.verbose){var i=[];this._log("\n\nOutput:\n\n",JSON.stringify(e,(function(e,t){if("object"===n(t)&&null!==t){if(-1!==i.indexOf(t))return;i.push(t)}return t}))),i=null}var s=[];this.options.includeMatches&&s.push((function(e,t){var i=e.output;t.matches=[];for(var n=0,s=i.length;n<s;n+=1){var r=i[n];if(0!==r.matchedIndices.length){var o={indices:r.matchedIndices,value:r.value};r.key&&(o.key=r.key),r.hasOwnProperty("arrayIndex")&&r.arrayIndex>-1&&(o.arrayIndex=r.arrayIndex),t.matches.push(o)}}})),this.options.includeScore&&s.push((function(e,t){t.score=e.score}));for(var r=0,o=e.length;r<o;r+=1){var a=e[r];if(this.options.id&&(a.item=this.options.getFn(a.item,this.options.id)[0]),s.length){for(var c={item:a.item},l=0,h=s.length;l<h;l+=1)s[l](a,c);t.push(c)}else t.push(a.item)}return t}},{key:"_log",value:function(){var e;this.options.verbose&&(e=console).log.apply(e,arguments)}}])&&s(t.prototype,i),c&&s(t,c),e}();e.exports=c},function(e,t,i){function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var s=i(3),r=i(4),o=i(7),a=function(){function e(t,i){var n=i.location,s=void 0===n?0:n,r=i.distance,a=void 0===r?100:r,c=i.threshold,l=void 0===c?.6:c,h=i.maxPatternLength,u=void 0===h?32:h,d=i.isCaseSensitive,p=void 0!==d&&d,m=i.tokenSeparator,f=void 0===m?/ +/g:m,v=i.findAllMatches,g=void 0!==v&&v,_=i.minMatchCharLength,b=void 0===_?1:_;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.options={location:s,distance:a,threshold:l,maxPatternLength:u,isCaseSensitive:p,tokenSeparator:f,findAllMatches:g,minMatchCharLength:b},this.pattern=this.options.isCaseSensitive?t:t.toLowerCase(),this.pattern.length<=u&&(this.patternAlphabet=o(this.pattern))}var t,i,a;return t=e,(i=[{key:"search",value:function(e){if(this.options.isCaseSensitive||(e=e.toLowerCase()),this.pattern===e)return{isMatch:!0,score:0,matchedIndices:[[0,e.length-1]]};var t=this.options,i=t.maxPatternLength,n=t.tokenSeparator;if(this.pattern.length>i)return s(e,this.pattern,n);var o=this.options,a=o.location,c=o.distance,l=o.threshold,h=o.findAllMatches,u=o.minMatchCharLength;return r(e,this.pattern,this.patternAlphabet,{location:a,distance:c,threshold:l,findAllMatches:h,minMatchCharLength:u})}}])&&n(t.prototype,i),a&&n(t,a),e}();e.exports=a},function(e,t){var i=/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g;e.exports=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:/ +/g,s=new RegExp(t.replace(i,"\\$&").replace(n,"|")),r=e.match(s),o=!!r,a=[];if(o)for(var c=0,l=r.length;c<l;c+=1){var h=r[c];a.push([e.indexOf(h),h.length-1])}return{score:o?.5:1,isMatch:o,matchedIndices:a}}},function(e,t,i){var n=i(5),s=i(6);e.exports=function(e,t,i,r){for(var o=r.location,a=void 0===o?0:o,c=r.distance,l=void 0===c?100:c,h=r.threshold,u=void 0===h?.6:h,d=r.findAllMatches,p=void 0!==d&&d,m=r.minMatchCharLength,f=void 0===m?1:m,v=a,g=e.length,_=u,b=e.indexOf(t,v),y=t.length,E=[],I=0;I<g;I+=1)E[I]=0;if(-1!==b){var S=n(t,{errors:0,currentLocation:b,expectedLocation:v,distance:l});if(_=Math.min(S,_),-1!==(b=e.lastIndexOf(t,v+y))){var w=n(t,{errors:0,currentLocation:b,expectedLocation:v,distance:l});_=Math.min(w,_)}}b=-1;for(var O=[],C=1,A=y+g,L=1<<y-1,T=0;T<y;T+=1){for(var x=0,k=A;x<k;)n(t,{errors:T,currentLocation:v+k,expectedLocation:v,distance:l})<=_?x=k:A=k,k=Math.floor((A-x)/2+x);A=k;var P=Math.max(1,v-k+1),D=p?g:Math.min(v+k,g)+y,M=Array(D+2);M[D+1]=(1<<T)-1;for(var N=D;N>=P;N-=1){var F=N-1,j=i[e.charAt(F)];if(j&&(E[F]=1),M[N]=(M[N+1]<<1|1)&j,0!==T&&(M[N]|=(O[N+1]|O[N])<<1|1|O[N+1]),M[N]&L&&(C=n(t,{errors:T,currentLocation:F,expectedLocation:v,distance:l}))<=_){if(_=C,(b=F)<=v)break;P=Math.max(1,2*v-b)}}if(n(t,{errors:T+1,currentLocation:v,expectedLocation:v,distance:l})>_)break;O=M}return{isMatch:b>=0,score:0===C?.001:C,matchedIndices:s(E,f)}}},function(e,t){e.exports=function(e,t){var i=t.errors,n=void 0===i?0:i,s=t.currentLocation,r=void 0===s?0:s,o=t.expectedLocation,a=void 0===o?0:o,c=t.distance,l=void 0===c?100:c,h=n/e.length,u=Math.abs(a-r);return l?h+u/l:u?1:h}},function(e,t){e.exports=function(){for(var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,i=[],n=-1,s=-1,r=0,o=e.length;r<o;r+=1){var a=e[r];a&&-1===n?n=r:a||-1===n||((s=r-1)-n+1>=t&&i.push([n,s]),n=-1)}return e[r-1]&&r-n>=t&&i.push([n,r-1]),i}},function(e,t){e.exports=function(e){for(var t={},i=e.length,n=0;n<i;n+=1)t[e.charAt(n)]=0;for(var s=0;s<i;s+=1)t[e.charAt(s)]|=1<<i-s-1;return t}},function(e,t,i){var n=i(0);e.exports=function(e,t){return function e(t,i,s){if(i){var r=i.indexOf("."),o=i,a=null;-1!==r&&(o=i.slice(0,r),a=i.slice(r+1));var c=t[o];if(null!=c)if(a||"string"!=typeof c&&"number"!=typeof c)if(n(c))for(var l=0,h=c.length;l<h;l+=1)e(c[l],a,s);else a&&e(c,a,s);else s.push(c.toString())}else s.push(t);return s}(e,t,[])}}])},function(e,t,i){"use strict";function n(e){var t,i=e.Symbol;return"function"==typeof i?i.observable?t=i.observable:(t=i("observable"),i.observable=t):t="@@observable",t}i.d(t,"a",(function(){return n}))},function(e,t,i){e.exports=i(7)},function(e,t){var i;i=function(){return this}();try{i=i||new Function("return this")()}catch(e){"object"==typeof window&&(i=window)}e.exports=i},function(e,t){e.exports=function(e){if(!e.webpackPolyfill){var t=Object.create(e);t.children||(t.children=[]),Object.defineProperty(t,"loaded",{enumerable:!0,get:function(){return t.l}}),Object.defineProperty(t,"id",{enumerable:!0,get:function(){return t.i}}),Object.defineProperty(t,"exports",{enumerable:!0}),t.webpackPolyfill=1}return t}},function(e,t,i){"use strict";i.r(t);var n=i(2),s=i.n(n),r=i(0),o=i.n(r),a=i(1),c=function(){return Math.random().toString(36).substring(7).split("").join(".")},l={INIT:"@@redux/INIT"+c(),REPLACE:"@@redux/REPLACE"+c(),PROBE_UNKNOWN_ACTION:function(){return"@@redux/PROBE_UNKNOWN_ACTION"+c()}};function h(e){if("object"!=typeof e||null===e)return!1;for(var t=e;null!==Object.getPrototypeOf(t);)t=Object.getPrototypeOf(t);return Object.getPrototypeOf(e)===t}function u(e,t,i){var n;if("function"==typeof t&&"function"==typeof i||"function"==typeof i&&"function"==typeof arguments[3])throw new Error("It looks like you are passing several store enhancers to createStore(). This is not supported. Instead, compose them together to a single function.");if("function"==typeof t&&void 0===i&&(i=t,t=void 0),void 0!==i){if("function"!=typeof i)throw new Error("Expected the enhancer to be a function.");return i(u)(e,t)}if("function"!=typeof e)throw new Error("Expected the reducer to be a function.");var s=e,r=t,o=[],c=o,d=!1;function p(){c===o&&(c=o.slice())}function m(){if(d)throw new Error("You may not call store.getState() while the reducer is executing. The reducer has already received the state as an argument. Pass it down from the top reducer instead of reading it from the store.");return r}function f(e){if("function"!=typeof e)throw new Error("Expected the listener to be a function.");if(d)throw new Error("You may not call store.subscribe() while the reducer is executing. If you would like to be notified after the store has been updated, subscribe from a component and invoke store.getState() in the callback to access the latest state. See https://redux.js.org/api-reference/store#subscribe(listener) for more details.");var t=!0;return p(),c.push(e),function(){if(t){if(d)throw new Error("You may not unsubscribe from a store listener while the reducer is executing. See https://redux.js.org/api-reference/store#subscribe(listener) for more details.");t=!1,p();var i=c.indexOf(e);c.splice(i,1)}}}function v(e){if(!h(e))throw new Error("Actions must be plain objects. Use custom middleware for async actions.");if(void 0===e.type)throw new Error('Actions may not have an undefined "type" property. Have you misspelled a constant?');if(d)throw new Error("Reducers may not dispatch actions.");try{d=!0,r=s(r,e)}finally{d=!1}for(var t=o=c,i=0;i<t.length;i++)(0,t[i])();return e}function g(e){if("function"!=typeof e)throw new Error("Expected the nextReducer to be a function.");s=e,v({type:l.REPLACE})}function _(){var e,t=f;return(e={subscribe:function(e){if("object"!=typeof e||null===e)throw new TypeError("Expected the observer to be an object.");function i(){e.next&&e.next(m())}return i(),{unsubscribe:t(i)}}})[a.a]=function(){return this},e}return v({type:l.INIT}),(n={dispatch:v,subscribe:f,getState:m,replaceReducer:g})[a.a]=_,n}function d(e,t){var i=t&&t.type;return"Given "+(i&&'action "'+String(i)+'"'||"an action")+', reducer "'+e+'" returned undefined. To ignore an action, you must explicitly return the previous state. If you want this reducer to hold no value, you can return null instead of undefined.'}var p,m=[],f=[],v=[],g={loading:!1},_=function(e,t){switch(void 0===e&&(e=g),t.type){case"SET_IS_LOADING":return{loading:t.isLoading};default:return e}},b=function(e){return Array.from({length:e},(function(){return(e=0,t=36,Math.floor(Math.random()*(t-e)+e)).toString(36);var e,t})).join("")},y=function(e){return Object.prototype.toString.call(e).slice(8,-1)},E=function(e,t){return null!=t&&y(t)===e},I=function(e){return"string"!=typeof e?e:e.replace(/&/g,"&amp;").replace(/>/g,"&rt;").replace(/</g,"&lt;").replace(/"/g,"&quot;")},S=(p=document.createElement("div"),function(e){var t=e.trim();p.innerHTML=t;for(var i=p.children[0];p.firstChild;)p.removeChild(p.firstChild);return i}),w=function(e,t){return e.score-t.score},O=function(e){return JSON.parse(JSON.stringify(e))},C=function(e){for(var t=Object.keys(e),i={},n=0;n<t.length;n++){var s=t[n];"function"==typeof e[s]&&(i[s]=e[s])}var r,o=Object.keys(i);try{!function(e){Object.keys(e).forEach((function(t){var i=e[t];if(void 0===i(void 0,{type:l.INIT}))throw new Error('Reducer "'+t+"\" returned undefined during initialization. If the state passed to the reducer is undefined, you must explicitly return the initial state. The initial state may not be undefined. If you don't want to set a value for this reducer, you can use null instead of undefined.");if(void 0===i(void 0,{type:l.PROBE_UNKNOWN_ACTION()}))throw new Error('Reducer "'+t+"\" returned undefined when probed with a random type. Don't try to handle "+l.INIT+' or other actions in "redux/*" namespace. They are considered private. Instead, you must return the current state for any unknown actions, unless it is undefined, in which case you must return the initial state, regardless of the action type. The initial state may not be undefined, but can be null.')}))}(i)}catch(e){r=e}return function(e,t){if(void 0===e&&(e={}),r)throw r;for(var n=!1,s={},a=0;a<o.length;a++){var c=o[a],l=i[c],h=e[c],u=l(h,t);if(void 0===u){var p=d(c,t);throw new Error(p)}s[c]=u,n=n||u!==h}return n?s:e}}({items:function(e,t){switch(void 0===e&&(e=m),t.type){case"ADD_ITEM":return[].concat(e,[{id:t.id,choiceId:t.choiceId,groupId:t.groupId,value:t.value,label:t.label,active:!0,highlighted:!1,customProperties:t.customProperties,placeholder:t.placeholder||!1,keyCode:null}]).map((function(e){var t=e;return t.highlighted=!1,t}));case"REMOVE_ITEM":return e.map((function(e){var i=e;return i.id===t.id&&(i.active=!1),i}));case"HIGHLIGHT_ITEM":return e.map((function(e){var i=e;return i.id===t.id&&(i.highlighted=t.highlighted),i}));default:return e}},groups:function(e,t){switch(void 0===e&&(e=f),t.type){case"ADD_GROUP":return[].concat(e,[{id:t.id,value:t.value,active:t.active,disabled:t.disabled}]);case"CLEAR_CHOICES":return[];default:return e}},choices:function(e,t){switch(void 0===e&&(e=v),t.type){case"ADD_CHOICE":return[].concat(e,[{id:t.id,elementId:t.elementId,groupId:t.groupId,value:t.value,label:t.label||t.value,disabled:t.disabled||!1,selected:!1,active:!0,score:9999,customProperties:t.customProperties,placeholder:t.placeholder||!1,keyCode:null}]);case"ADD_ITEM":return t.activateOptions?e.map((function(e){var i=e;return i.active=t.active,i})):t.choiceId>-1?e.map((function(e){var i=e;return i.id===parseInt(t.choiceId,10)&&(i.selected=!0),i})):e;case"REMOVE_ITEM":return t.choiceId>-1?e.map((function(e){var i=e;return i.id===parseInt(t.choiceId,10)&&(i.selected=!1),i})):e;case"FILTER_CHOICES":return e.map((function(e){var i=e;return i.active=t.results.some((function(e){var t=e.item,n=e.score;return t.id===i.id&&(i.score=n,!0)})),i}));case"ACTIVATE_CHOICES":return e.map((function(e){var i=e;return i.active=t.active,i}));case"CLEAR_CHOICES":return v;default:return e}},general:_}),A=function(e,t){var i=e;if("CLEAR_ALL"===t.type)i=void 0;else if("RESET_TO"===t.type)return O(t.state);return C(i,t)};function L(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var T=function(){function e(){this._store=u(A,window.__REDUX_DEVTOOLS_EXTENSION__&&window.__REDUX_DEVTOOLS_EXTENSION__())}var t,i,n,s=e.prototype;return s.subscribe=function(e){this._store.subscribe(e)},s.dispatch=function(e){this._store.dispatch(e)},s.isLoading=function(){return this.state.general.loading},s.getChoiceById=function(e){return this.activeChoices.find((function(t){return t.id===parseInt(e,10)}))},s.getGroupById=function(e){return this.groups.find((function(t){return t.id===e}))},t=e,(i=[{key:"state",get:function(){return this._store.getState()}},{key:"items",get:function(){return this.state.items}},{key:"activeItems",get:function(){return this.items.filter((function(e){return!0===e.active}))}},{key:"highlightedActiveItems",get:function(){return this.items.filter((function(e){return e.active&&e.highlighted}))}},{key:"choices",get:function(){return this.state.choices}},{key:"activeChoices",get:function(){return this.choices.filter((function(e){return!0===e.active}))}},{key:"selectableChoices",get:function(){return this.choices.filter((function(e){return!0!==e.disabled}))}},{key:"searchableChoices",get:function(){return this.selectableChoices.filter((function(e){return!0!==e.placeholder}))}},{key:"placeholderChoice",get:function(){return[].concat(this.choices).reverse().find((function(e){return!0===e.placeholder}))}},{key:"groups",get:function(){return this.state.groups}},{key:"activeGroups",get:function(){var e=this.groups,t=this.choices;return e.filter((function(e){var i=!0===e.active&&!1===e.disabled,n=t.some((function(e){return!0===e.active&&!1===e.disabled}));return i&&n}),[])}}])&&L(t.prototype,i),n&&L(t,n),e}();function x(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var k=function(){function e(e){var t=e.element,i=e.type,n=e.classNames;this.element=t,this.classNames=n,this.type=i,this.isActive=!1}var t,i,n,s=e.prototype;return s.getChild=function(e){return this.element.querySelector(e)},s.show=function(){return this.element.classList.add(this.classNames.activeState),this.element.setAttribute("aria-expanded","true"),this.isActive=!0,this},s.hide=function(){return this.element.classList.remove(this.classNames.activeState),this.element.setAttribute("aria-expanded","false"),this.isActive=!1,this},t=e,(i=[{key:"distanceFromTopWindow",get:function(){return this.element.getBoundingClientRect().bottom}}])&&x(t.prototype,i),n&&x(t,n),e}(),P={items:[],choices:[],silent:!1,renderChoiceLimit:-1,maxItemCount:-1,addItems:!0,addItemFilter:null,removeItems:!0,removeItemButton:!1,editItems:!1,duplicateItemsAllowed:!0,delimiter:",",paste:!0,searchEnabled:!0,searchChoices:!0,searchFloor:1,searchResultLimit:4,searchFields:["label","value"],position:"auto",resetScrollPosition:!0,shouldSort:!0,shouldSortItems:!1,sorter:function(e,t){var i=e.value,n=e.label,s=void 0===n?i:n,r=t.value,o=t.label,a=void 0===o?r:o;return s.localeCompare(a,[],{sensitivity:"base",ignorePunctuation:!0,numeric:!0})},placeholder:!0,placeholderValue:null,searchPlaceholderValue:null,prependValue:null,appendValue:null,renderSelectedChoices:"auto",loadingText:"Loading...",noResultsText:"No results found",noChoicesText:"No choices to choose from",itemSelectText:"Press to select",uniqueItemText:"Only unique values can be added",customAddItemText:"Only values matching specific conditions can be added",addItemText:function(e){return'Press Enter to add <b>"'+I(e)+'"</b>'},maxItemText:function(e){return"Only "+e+" values can be added"},valueComparer:function(e,t){return e===t},fuseOptions:{includeScore:!0},callbackOnInit:null,callbackOnCreateTemplates:null,classNames:{containerOuter:"choices",containerInner:"choices__inner",input:"choices__input",inputCloned:"choices__input--cloned",list:"choices__list",listItems:"choices__list--multiple",listSingle:"choices__list--single",listDropdown:"choices__list--dropdown",item:"choices__item",itemSelectable:"choices__item--selectable",itemDisabled:"choices__item--disabled",itemChoice:"choices__item--choice",placeholder:"choices__placeholder",group:"choices__group",groupHeading:"choices__heading",button:"choices__button",activeState:"is-active",focusState:"is-focused",openState:"is-open",disabledState:"is-disabled",highlightedState:"is-highlighted",selectedState:"is-selected",flippedState:"is-flipped",loadingState:"is-loading",noResults:"has-no-results",noChoices:"has-no-choices"}},D="showDropdown",M="hideDropdown",N="change",F="choice",j="search",K="addItem",R="removeItem",H="highlightItem",B="highlightChoice",V="ADD_CHOICE",G="FILTER_CHOICES",q="ACTIVATE_CHOICES",U="CLEAR_CHOICES",z="ADD_GROUP",W="ADD_ITEM",X="REMOVE_ITEM",$="HIGHLIGHT_ITEM",J=46,Y=8,Z=13,Q=65,ee=27,te=38,ie=40,ne=33,se=34,re="text",oe="select-one",ae="select-multiple",ce=function(){function e(e){var t=e.element,i=e.type,n=e.classNames,s=e.position;this.element=t,this.classNames=n,this.type=i,this.position=s,this.isOpen=!1,this.isFlipped=!1,this.isFocussed=!1,this.isDisabled=!1,this.isLoading=!1,this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this)}var t=e.prototype;return t.addEventListeners=function(){this.element.addEventListener("focus",this._onFocus),this.element.addEventListener("blur",this._onBlur)},t.removeEventListeners=function(){this.element.removeEventListener("focus",this._onFocus),this.element.removeEventListener("blur",this._onBlur)},t.shouldFlip=function(e){if("number"!=typeof e)return!1;var t=!1;return"auto"===this.position?t=!window.matchMedia("(min-height: "+(e+1)+"px)").matches:"top"===this.position&&(t=!0),t},t.setActiveDescendant=function(e){this.element.setAttribute("aria-activedescendant",e)},t.removeActiveDescendant=function(){this.element.removeAttribute("aria-activedescendant")},t.open=function(e){this.element.classList.add(this.classNames.openState),this.element.setAttribute("aria-expanded","true"),this.isOpen=!0,this.shouldFlip(e)&&(this.element.classList.add(this.classNames.flippedState),this.isFlipped=!0)},t.close=function(){this.element.classList.remove(this.classNames.openState),this.element.setAttribute("aria-expanded","false"),this.removeActiveDescendant(),this.isOpen=!1,this.isFlipped&&(this.element.classList.remove(this.classNames.flippedState),this.isFlipped=!1)},t.focus=function(){this.isFocussed||this.element.focus()},t.addFocusState=function(){this.element.classList.add(this.classNames.focusState)},t.removeFocusState=function(){this.element.classList.remove(this.classNames.focusState)},t.enable=function(){this.element.classList.remove(this.classNames.disabledState),this.element.removeAttribute("aria-disabled"),this.type===oe&&this.element.setAttribute("tabindex","0"),this.isDisabled=!1},t.disable=function(){this.element.classList.add(this.classNames.disabledState),this.element.setAttribute("aria-disabled","true"),this.type===oe&&this.element.setAttribute("tabindex","-1"),this.isDisabled=!0},t.wrap=function(e){!function(e,t){void 0===t&&(t=document.createElement("div")),e.nextSibling?e.parentNode.insertBefore(t,e.nextSibling):e.parentNode.appendChild(t),t.appendChild(e)}(e,this.element)},t.unwrap=function(e){this.element.parentNode.insertBefore(e,this.element),this.element.parentNode.removeChild(this.element)},t.addLoadingState=function(){this.element.classList.add(this.classNames.loadingState),this.element.setAttribute("aria-busy","true"),this.isLoading=!0},t.removeLoadingState=function(){this.element.classList.remove(this.classNames.loadingState),this.element.removeAttribute("aria-busy"),this.isLoading=!1},t._onFocus=function(){this.isFocussed=!0},t._onBlur=function(){this.isFocussed=!1},e}();function le(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var he=function(){function e(e){var t=e.element,i=e.type,n=e.classNames,s=e.preventPaste;this.element=t,this.type=i,this.classNames=n,this.preventPaste=s,this.isFocussed=this.element===document.activeElement,this.isDisabled=t.disabled,this._onPaste=this._onPaste.bind(this),this._onInput=this._onInput.bind(this),this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this)}var t,i,n,s=e.prototype;return s.addEventListeners=function(){this.element.addEventListener("paste",this._onPaste),this.element.addEventListener("input",this._onInput,{passive:!0}),this.element.addEventListener("focus",this._onFocus,{passive:!0}),this.element.addEventListener("blur",this._onBlur,{passive:!0})},s.removeEventListeners=function(){this.element.removeEventListener("input",this._onInput,{passive:!0}),this.element.removeEventListener("paste",this._onPaste),this.element.removeEventListener("focus",this._onFocus,{passive:!0}),this.element.removeEventListener("blur",this._onBlur,{passive:!0})},s.enable=function(){this.element.removeAttribute("disabled"),this.isDisabled=!1},s.disable=function(){this.element.setAttribute("disabled",""),this.isDisabled=!0},s.focus=function(){this.isFocussed||this.element.focus()},s.blur=function(){this.isFocussed&&this.element.blur()},s.clear=function(e){return void 0===e&&(e=!0),this.element.value&&(this.element.value=""),e&&this.setWidth(),this},s.setWidth=function(){var e=this.element,t=e.style,i=e.value,n=e.placeholder;t.minWidth=n.length+1+"ch",t.width=i.length+1+"ch"},s.setActiveDescendant=function(e){this.element.setAttribute("aria-activedescendant",e)},s.removeActiveDescendant=function(){this.element.removeAttribute("aria-activedescendant")},s._onInput=function(){this.type!==oe&&this.setWidth()},s._onPaste=function(e){this.preventPaste&&e.preventDefault()},s._onFocus=function(){this.isFocussed=!0},s._onBlur=function(){this.isFocussed=!1},t=e,(i=[{key:"placeholder",set:function(e){this.element.placeholder=e}},{key:"value",get:function(){return I(this.element.value)},set:function(e){this.element.value=e}}])&&le(t.prototype,i),n&&le(t,n),e}(),ue=function(){function e(e){var t=e.element;this.element=t,this.scrollPos=this.element.scrollTop,this.height=this.element.offsetHeight}var t=e.prototype;return t.clear=function(){this.element.innerHTML=""},t.append=function(e){this.element.appendChild(e)},t.getChild=function(e){return this.element.querySelector(e)},t.hasChildren=function(){return this.element.hasChildNodes()},t.scrollToTop=function(){this.element.scrollTop=0},t.scrollToChildElement=function(e,t){var i=this;if(e){var n=this.element.offsetHeight,s=this.element.scrollTop+n,r=e.offsetHeight,o=e.offsetTop+r,a=t>0?this.element.scrollTop+o-s:e.offsetTop;requestAnimationFrame((function(){i._animateScroll(a,t)}))}},t._scrollDown=function(e,t,i){var n=(i-e)/t,s=n>1?n:1;this.element.scrollTop=e+s},t._scrollUp=function(e,t,i){var n=(e-i)/t,s=n>1?n:1;this.element.scrollTop=e-s},t._animateScroll=function(e,t){var i=this,n=this.element.scrollTop,s=!1;t>0?(this._scrollDown(n,4,e),n<e&&(s=!0)):(this._scrollUp(n,4,e),n>e&&(s=!0)),s&&requestAnimationFrame((function(){i._animateScroll(e,t)}))},e}();function de(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var pe=function(){function e(e){var t=e.element,i=e.classNames;if(this.element=t,this.classNames=i,!(t instanceof HTMLInputElement||t instanceof HTMLSelectElement))throw new TypeError("Invalid element passed");this.isDisabled=!1}var t,i,n,s=e.prototype;return s.conceal=function(){this.element.classList.add(this.classNames.input),this.element.hidden=!0,this.element.tabIndex=-1;var e=this.element.getAttribute("style");e&&this.element.setAttribute("data-choice-orig-style",e),this.element.setAttribute("data-choice","active")},s.reveal=function(){this.element.classList.remove(this.classNames.input),this.element.hidden=!1,this.element.removeAttribute("tabindex");var e=this.element.getAttribute("data-choice-orig-style");e?(this.element.removeAttribute("data-choice-orig-style"),this.element.setAttribute("style",e)):this.element.removeAttribute("style"),this.element.removeAttribute("data-choice"),this.element.value=this.element.value},s.enable=function(){this.element.removeAttribute("disabled"),this.element.disabled=!1,this.isDisabled=!1},s.disable=function(){this.element.setAttribute("disabled",""),this.element.disabled=!0,this.isDisabled=!0},s.triggerEvent=function(e,t){!function(e,t,i){void 0===i&&(i=null);var n=new CustomEvent(t,{detail:i,bubbles:!0,cancelable:!0});e.dispatchEvent(n)}(this.element,e,t)},t=e,(i=[{key:"isActive",get:function(){return"active"===this.element.dataset.choice}},{key:"dir",get:function(){return this.element.dir}},{key:"value",get:function(){return this.element.value},set:function(e){this.element.value=e}}])&&de(t.prototype,i),n&&de(t,n),e}();function me(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var fe=function(e){var t,i,n,s,r;function o(t){var i,n=t.element,s=t.classNames,r=t.delimiter;return(i=e.call(this,{element:n,classNames:s})||this).delimiter=r,i}return i=e,(t=o).prototype=Object.create(i.prototype),t.prototype.constructor=t,t.__proto__=i,n=o,(s=[{key:"value",get:function(){return this.element.value},set:function(e){var t=e.map((function(e){return e.value})).join(this.delimiter);this.element.setAttribute("value",t),this.element.value=t}}])&&me(n.prototype,s),r&&me(n,r),o}(pe);function ve(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var ge=function(e){var t,i,n,s,r;function o(t){var i,n=t.element,s=t.classNames,r=t.template;return(i=e.call(this,{element:n,classNames:s})||this).template=r,i}return i=e,(t=o).prototype=Object.create(i.prototype),t.prototype.constructor=t,t.__proto__=i,o.prototype.appendDocFragment=function(e){this.element.innerHTML="",this.element.appendChild(e)},n=o,(s=[{key:"placeholderOption",get:function(){return this.element.querySelector('option[value=""]')||this.element.querySelector("option[placeholder]")}},{key:"optionGroups",get:function(){return Array.from(this.element.getElementsByTagName("OPTGROUP"))}},{key:"options",get:function(){return Array.from(this.element.options)},set:function(e){var t=this,i=document.createDocumentFragment();e.forEach((function(e){return n=e,s=t.template(n),void i.appendChild(s);var n,s})),this.appendDocFragment(i)}}])&&ve(n.prototype,s),r&&ve(n,r),o}(pe),_e={containerOuter:function(e,t,i,n,s,r){var o=e.containerOuter,a=Object.assign(document.createElement("div"),{className:o});return a.dataset.type=r,t&&(a.dir=t),n&&(a.tabIndex=0),i&&(a.setAttribute("role",s?"combobox":"listbox"),s&&a.setAttribute("aria-autocomplete","list")),a.setAttribute("aria-haspopup","true"),a.setAttribute("aria-expanded","false"),a},containerInner:function(e){var t=e.containerInner;return Object.assign(document.createElement("div"),{className:t})},itemList:function(e,t){var i=e.list,n=e.listSingle,s=e.listItems;return Object.assign(document.createElement("div"),{className:i+" "+(t?n:s)})},placeholder:function(e,t){var i=e.placeholder;return Object.assign(document.createElement("div"),{className:i,innerHTML:t})},item:function(e,t,i){var n=e.item,s=e.button,r=e.highlightedState,o=e.itemSelectable,a=e.placeholder,c=t.id,l=t.value,h=t.label,u=t.customProperties,d=t.active,p=t.disabled,m=t.highlighted,f=t.placeholder,v=Object.assign(document.createElement("div"),{className:n,innerHTML:h});if(Object.assign(v.dataset,{item:"",id:c,value:l,customProperties:u}),d&&v.setAttribute("aria-selected","true"),p&&v.setAttribute("aria-disabled","true"),f&&v.classList.add(a),v.classList.add(m?r:o),i){p&&v.classList.remove(o),v.dataset.deletable="";var g="Remove item",_=Object.assign(document.createElement("button"),{type:"button",className:s,innerHTML:g});_.setAttribute("aria-label","Remove item: '"+l+"'"),_.dataset.button="",v.appendChild(_)}return v},choiceList:function(e,t){var i=e.list,n=Object.assign(document.createElement("div"),{className:i});return t||n.setAttribute("aria-multiselectable","true"),n.setAttribute("role","listbox"),n},choiceGroup:function(e,t){var i=e.group,n=e.groupHeading,s=e.itemDisabled,r=t.id,o=t.value,a=t.disabled,c=Object.assign(document.createElement("div"),{className:i+" "+(a?s:"")});return c.setAttribute("role","group"),Object.assign(c.dataset,{group:"",id:r,value:o}),a&&c.setAttribute("aria-disabled","true"),c.appendChild(Object.assign(document.createElement("div"),{className:n,innerHTML:o})),c},choice:function(e,t,i){var n=e.item,s=e.itemChoice,r=e.itemSelectable,o=e.selectedState,a=e.itemDisabled,c=e.placeholder,l=t.id,h=t.value,u=t.label,d=t.groupId,p=t.elementId,m=t.disabled,f=t.selected,v=t.placeholder,g=Object.assign(document.createElement("div"),{id:p,innerHTML:u,className:n+" "+s});return f&&g.classList.add(o),v&&g.classList.add(c),g.setAttribute("role",d>0?"treeitem":"option"),Object.assign(g.dataset,{choice:"",id:l,value:h,selectText:i}),m?(g.classList.add(a),g.dataset.choiceDisabled="",g.setAttribute("aria-disabled","true")):(g.classList.add(r),g.dataset.choiceSelectable=""),g},input:function(e,t){var i=e.input,n=e.inputCloned,s=Object.assign(document.createElement("input"),{type:"text",className:i+" "+n,autocomplete:"off",autocapitalize:"off",spellcheck:!1});return s.setAttribute("role","textbox"),s.setAttribute("aria-autocomplete","list"),s.setAttribute("aria-label",t),s},dropdown:function(e){var t=e.list,i=e.listDropdown,n=document.createElement("div");return n.classList.add(t,i),n.setAttribute("aria-expanded","false"),n},notice:function(e,t,i){var n=e.item,s=e.itemChoice,r=e.noResults,o=e.noChoices;void 0===i&&(i="");var a=[n,s];return"no-choices"===i?a.push(o):"no-results"===i&&a.push(r),Object.assign(document.createElement("div"),{innerHTML:t,className:a.join(" ")})},option:function(e){var t=e.label,i=e.value,n=e.customProperties,s=e.active,r=e.disabled,o=new Option(t,i,!1,s);return n&&(o.dataset.customProperties=n),o.disabled=r,o}},be=function(e){return void 0===e&&(e=!0),{type:q,active:e}},ye=function(e,t){return{type:$,id:e,highlighted:t}},Ee=function(e){var t=e.value,i=e.id,n=e.active,s=e.disabled;return{type:z,value:t,id:i,active:n,disabled:s}},Ie=function(e){return{type:"SET_IS_LOADING",isLoading:e}};function Se(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var we="-ms-scroll-limit"in document.documentElement.style&&"-ms-ime-align"in document.documentElement.style,Oe={},Ce=function(){var e,t,i;function n(e,t){var i=this;void 0===e&&(e="[data-choice]"),void 0===t&&(t={}),this.config=o.a.all([P,n.defaults.options,t],{arrayMerge:function(e,t){return[].concat(t)}});var s,r,a,c,l=(s=this.config,r=P,a=Object.keys(s).sort(),c=Object.keys(r).sort(),a.filter((function(e){return c.indexOf(e)<0})));l.length&&console.warn("Unknown config option(s) passed",l.join(", "));var h="string"==typeof e?document.querySelector(e):e;if(!(h instanceof HTMLInputElement||h instanceof HTMLSelectElement))throw TypeError("Expected one of the following types text|select-one|select-multiple");if(this._isTextElement=h.type===re,this._isSelectOneElement=h.type===oe,this._isSelectMultipleElement=h.type===ae,this._isSelectElement=this._isSelectOneElement||this._isSelectMultipleElement,this.config.searchEnabled=this._isSelectMultipleElement||this.config.searchEnabled,["auto","always"].includes(this.config.renderSelectedChoices)||(this.config.renderSelectedChoices="auto"),t.addItemFilter&&"function"!=typeof t.addItemFilter){var u=t.addItemFilter instanceof RegExp?t.addItemFilter:new RegExp(t.addItemFilter);this.config.addItemFilter=u.test.bind(u)}if(this._isTextElement?this.passedElement=new fe({element:h,classNames:this.config.classNames,delimiter:this.config.delimiter}):this.passedElement=new ge({element:h,classNames:this.config.classNames,template:function(e){return i._templates.option(e)}}),this.initialised=!1,this._store=new T,this._initialState={},this._currentState={},this._prevState={},this._currentValue="",this._canSearch=this.config.searchEnabled,this._isScrollingOnIe=!1,this._highlightPosition=0,this._wasTap=!0,this._placeholderValue=this._generatePlaceholderValue(),this._baseId=function(e,t){var i=e.id||e.name&&e.name+"-"+b(2)||b(4);return t+"-"+i.replace(/(:|\.|\[|\]|,)/g,"")}(this.passedElement.element,"choices-"),this._direction=this.passedElement.dir,!this._direction){var d=window.getComputedStyle(this.passedElement.element).direction;d!==window.getComputedStyle(document.documentElement).direction&&(this._direction=d)}if(this._idNames={itemChoice:"item-choice"},this._presetGroups=this.passedElement.optionGroups,this._presetOptions=this.passedElement.options,this._presetChoices=this.config.choices,this._presetItems=this.config.items,this.passedElement.value&&(this._presetItems=this._presetItems.concat(this.passedElement.value.split(this.config.delimiter))),this.passedElement.options&&this.passedElement.options.forEach((function(e){i._presetChoices.push({value:e.value,label:e.innerHTML,selected:e.selected,disabled:e.disabled||e.parentNode.disabled,placeholder:""===e.value||e.hasAttribute("placeholder"),customProperties:e.getAttribute("data-custom-properties")})})),this._render=this._render.bind(this),this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this),this._onKeyUp=this._onKeyUp.bind(this),this._onKeyDown=this._onKeyDown.bind(this),this._onClick=this._onClick.bind(this),this._onTouchMove=this._onTouchMove.bind(this),this._onTouchEnd=this._onTouchEnd.bind(this),this._onMouseDown=this._onMouseDown.bind(this),this._onMouseOver=this._onMouseOver.bind(this),this._onFormReset=this._onFormReset.bind(this),this._onAKey=this._onAKey.bind(this),this._onEnterKey=this._onEnterKey.bind(this),this._onEscapeKey=this._onEscapeKey.bind(this),this._onDirectionKey=this._onDirectionKey.bind(this),this._onDeleteKey=this._onDeleteKey.bind(this),this.passedElement.isActive)return this.config.silent||console.warn("Trying to initialise Choices on element already initialised"),void(this.initialised=!0);this.init()}e=n,i=[{key:"defaults",get:function(){return Object.preventExtensions({get options(){return Oe},get templates(){return _e}})}}],(t=null)&&Se(e.prototype,t),i&&Se(e,i);var r=n.prototype;return r.init=function(){if(!this.initialised){this._createTemplates(),this._createElements(),this._createStructure(),this._initialState=O(this._store.state),this._store.subscribe(this._render),this._render(),this._addEventListeners(),(!this.config.addItems||this.passedElement.element.hasAttribute("disabled"))&&this.disable(),this.initialised=!0;var e=this.config.callbackOnInit;e&&"function"==typeof e&&e.call(this)}},r.destroy=function(){this.initialised&&(this._removeEventListeners(),this.passedElement.reveal(),this.containerOuter.unwrap(this.passedElement.element),this.clearStore(),this._isSelectElement&&(this.passedElement.options=this._presetOptions),this._templates=null,this.initialised=!1)},r.enable=function(){return this.passedElement.isDisabled&&this.passedElement.enable(),this.containerOuter.isDisabled&&(this._addEventListeners(),this.input.enable(),this.containerOuter.enable()),this},r.disable=function(){return this.passedElement.isDisabled||this.passedElement.disable(),this.containerOuter.isDisabled||(this._removeEventListeners(),this.input.disable(),this.containerOuter.disable()),this},r.highlightItem=function(e,t){if(void 0===t&&(t=!0),!e)return this;var i=e.id,n=e.groupId,s=void 0===n?-1:n,r=e.value,o=void 0===r?"":r,a=e.label,c=void 0===a?"":a,l=s>=0?this._store.getGroupById(s):null;return this._store.dispatch(ye(i,!0)),t&&this.passedElement.triggerEvent(H,{id:i,value:o,label:c,groupValue:l&&l.value?l.value:null}),this},r.unhighlightItem=function(e){if(!e)return this;var t=e.id,i=e.groupId,n=void 0===i?-1:i,s=e.value,r=void 0===s?"":s,o=e.label,a=void 0===o?"":o,c=n>=0?this._store.getGroupById(n):null;return this._store.dispatch(ye(t,!1)),this.passedElement.triggerEvent(H,{id:t,value:r,label:a,groupValue:c&&c.value?c.value:null}),this},r.highlightAll=function(){var e=this;return this._store.items.forEach((function(t){return e.highlightItem(t)})),this},r.unhighlightAll=function(){var e=this;return this._store.items.forEach((function(t){return e.unhighlightItem(t)})),this},r.removeActiveItemsByValue=function(e){var t=this;return this._store.activeItems.filter((function(t){return t.value===e})).forEach((function(e){return t._removeItem(e)})),this},r.removeActiveItems=function(e){var t=this;return this._store.activeItems.filter((function(t){return t.id!==e})).forEach((function(e){return t._removeItem(e)})),this},r.removeHighlightedItems=function(e){var t=this;return void 0===e&&(e=!1),this._store.highlightedActiveItems.forEach((function(i){t._removeItem(i),e&&t._triggerChange(i.value)})),this},r.showDropdown=function(e){var t=this;return this.dropdown.isActive||requestAnimationFrame((function(){t.dropdown.show(),t.containerOuter.open(t.dropdown.distanceFromTopWindow),!e&&t._canSearch&&t.input.focus(),t.passedElement.triggerEvent(D,{})})),this},r.hideDropdown=function(e){var t=this;return this.dropdown.isActive?(requestAnimationFrame((function(){t.dropdown.hide(),t.containerOuter.close(),!e&&t._canSearch&&(t.input.removeActiveDescendant(),t.input.blur()),t.passedElement.triggerEvent(M,{})})),this):this},r.getValue=function(e){void 0===e&&(e=!1);var t=this._store.activeItems.reduce((function(t,i){var n=e?i.value:i;return t.push(n),t}),[]);return this._isSelectOneElement?t[0]:t},r.setValue=function(e){var t=this;return this.initialised?(e.forEach((function(e){return t._setChoiceOrItem(e)})),this):this},r.setChoiceByValue=function(e){var t=this;return!this.initialised||this._isTextElement||(Array.isArray(e)?e:[e]).forEach((function(e){return t._findAndSelectChoiceByValue(e)})),this},r.setChoices=function(e,t,i,n){var s=this;if(void 0===e&&(e=[]),void 0===t&&(t="value"),void 0===i&&(i="label"),void 0===n&&(n=!1),!this.initialised)throw new ReferenceError("setChoices was called on a non-initialized instance of Choices");if(!this._isSelectElement)throw new TypeError("setChoices can't be used with INPUT based Choices");if("string"!=typeof t||!t)throw new TypeError("value parameter must be a name of 'value' field in passed objects");if(n&&this.clearChoices(),"function"==typeof e){var r=e(this);if("function"==typeof Promise&&r instanceof Promise)return new Promise((function(e){return requestAnimationFrame(e)})).then((function(){return s._handleLoadingState(!0)})).then((function(){return r})).then((function(e){return s.setChoices(e,t,i,n)})).catch((function(e){s.config.silent||console.error(e)})).then((function(){return s._handleLoadingState(!1)})).then((function(){return s}));if(!Array.isArray(r))throw new TypeError(".setChoices first argument function must return either array of choices or Promise, got: "+typeof r);return this.setChoices(r,t,i,!1)}if(!Array.isArray(e))throw new TypeError(".setChoices must be called either with array of choices with a function resulting into Promise of array of choices");return this.containerOuter.removeLoadingState(),this._startLoading(),e.forEach((function(e){e.choices?s._addGroup({id:parseInt(e.id,10)||null,group:e,valueKey:t,labelKey:i}):s._addChoice({value:e[t],label:e[i],isSelected:e.selected,isDisabled:e.disabled,customProperties:e.customProperties,placeholder:e.placeholder})})),this._stopLoading(),this},r.clearChoices=function(){return this._store.dispatch({type:U}),this},r.clearStore=function(){return this._store.dispatch({type:"CLEAR_ALL"}),this},r.clearInput=function(){var e=!this._isSelectOneElement;return this.input.clear(e),!this._isTextElement&&this._canSearch&&(this._isSearching=!1,this._store.dispatch(be(!0))),this},r._render=function(){if(!this._store.isLoading()){this._currentState=this._store.state;var e=this._currentState.choices!==this._prevState.choices||this._currentState.groups!==this._prevState.groups||this._currentState.items!==this._prevState.items,t=this._isSelectElement,i=this._currentState.items!==this._prevState.items;e&&(t&&this._renderChoices(),i&&this._renderItems(),this._prevState=this._currentState)}},r._renderChoices=function(){var e=this,t=this._store,i=t.activeGroups,n=t.activeChoices,s=document.createDocumentFragment();if(this.choiceList.clear(),this.config.resetScrollPosition&&requestAnimationFrame((function(){return e.choiceList.scrollToTop()})),i.length>=1&&!this._isSearching){var r=n.filter((function(e){return!0===e.placeholder&&-1===e.groupId}));r.length>=1&&(s=this._createChoicesFragment(r,s)),s=this._createGroupsFragment(i,n,s)}else n.length>=1&&(s=this._createChoicesFragment(n,s));if(s.childNodes&&s.childNodes.length>0){var o=this._store.activeItems,a=this._canAddItem(o,this.input.value);a.response?(this.choiceList.append(s),this._highlightChoice()):this.choiceList.append(this._getTemplate("notice",a.notice))}else{var c,l;this._isSearching?(l="function"==typeof this.config.noResultsText?this.config.noResultsText():this.config.noResultsText,c=this._getTemplate("notice",l,"no-results")):(l="function"==typeof this.config.noChoicesText?this.config.noChoicesText():this.config.noChoicesText,c=this._getTemplate("notice",l,"no-choices")),this.choiceList.append(c)}},r._renderItems=function(){var e=this._store.activeItems||[];this.itemList.clear();var t=this._createItemsFragment(e);t.childNodes&&this.itemList.append(t)},r._createGroupsFragment=function(e,t,i){var n=this;return void 0===i&&(i=document.createDocumentFragment()),this.config.shouldSort&&e.sort(this.config.sorter),e.forEach((function(e){var s=function(e){return t.filter((function(t){return n._isSelectOneElement?t.groupId===e.id:t.groupId===e.id&&("always"===n.config.renderSelectedChoices||!t.selected)}))}(e);if(s.length>=1){var r=n._getTemplate("choiceGroup",e);i.appendChild(r),n._createChoicesFragment(s,i,!0)}})),i},r._createChoicesFragment=function(e,t,i){var n=this;void 0===t&&(t=document.createDocumentFragment()),void 0===i&&(i=!1);var s=this.config,r=s.renderSelectedChoices,o=s.searchResultLimit,a=s.renderChoiceLimit,c=this._isSearching?w:this.config.sorter,l=function(e){if("auto"!==r||n._isSelectOneElement||!e.selected){var i=n._getTemplate("choice",e,n.config.itemSelectText);t.appendChild(i)}},h=e;"auto"!==r||this._isSelectOneElement||(h=e.filter((function(e){return!e.selected})));var u=h.reduce((function(e,t){return t.placeholder?e.placeholderChoices.push(t):e.normalChoices.push(t),e}),{placeholderChoices:[],normalChoices:[]}),d=u.placeholderChoices,p=u.normalChoices;(this.config.shouldSort||this._isSearching)&&p.sort(c);var m=h.length,f=this._isSelectOneElement?[].concat(d,p):p;this._isSearching?m=o:a&&a>0&&!i&&(m=a);for(var v=0;v<m;v+=1)f[v]&&l(f[v]);return t},r._createItemsFragment=function(e,t){var i=this;void 0===t&&(t=document.createDocumentFragment());var n=this.config,s=n.shouldSortItems,r=n.sorter,o=n.removeItemButton;return s&&!this._isSelectOneElement&&e.sort(r),this._isTextElement?this.passedElement.value=e:this.passedElement.options=e,e.forEach((function(e){var n=i._getTemplate("item",e,o);t.appendChild(n)})),t},r._triggerChange=function(e){null!=e&&this.passedElement.triggerEvent(N,{value:e})},r._selectPlaceholderChoice=function(){var e=this._store.placeholderChoice;e&&(this._addItem({value:e.value,label:e.label,choiceId:e.id,groupId:e.groupId,placeholder:e.placeholder}),this._triggerChange(e.value))},r._handleButtonAction=function(e,t){if(e&&t&&this.config.removeItems&&this.config.removeItemButton){var i=t.parentNode.getAttribute("data-id"),n=e.find((function(e){return e.id===parseInt(i,10)}));this._removeItem(n),this._triggerChange(n.value),this._isSelectOneElement&&this._selectPlaceholderChoice()}},r._handleItemAction=function(e,t,i){var n=this;if(void 0===i&&(i=!1),e&&t&&this.config.removeItems&&!this._isSelectOneElement){var s=t.getAttribute("data-id");e.forEach((function(e){e.id!==parseInt(s,10)||e.highlighted?!i&&e.highlighted&&n.unhighlightItem(e):n.highlightItem(e)})),this.input.focus()}},r._handleChoiceAction=function(e,t){if(e&&t){var i=t.dataset.id,n=this._store.getChoiceById(i);if(n){var s=e[0]&&e[0].keyCode?e[0].keyCode:null,r=this.dropdown.isActive;n.keyCode=s,this.passedElement.triggerEvent(F,{choice:n}),n.selected||n.disabled||this._canAddItem(e,n.value).response&&(this._addItem({value:n.value,label:n.label,choiceId:n.id,groupId:n.groupId,customProperties:n.customProperties,placeholder:n.placeholder,keyCode:n.keyCode}),this._triggerChange(n.value)),this.clearInput(),r&&this._isSelectOneElement&&(this.hideDropdown(!0),this.containerOuter.focus())}}},r._handleBackspace=function(e){if(this.config.removeItems&&e){var t=e[e.length-1],i=e.some((function(e){return e.highlighted}));this.config.editItems&&!i&&t?(this.input.value=t.value,this.input.setWidth(),this._removeItem(t),this._triggerChange(t.value)):(i||this.highlightItem(t,!1),this.removeHighlightedItems(!0))}},r._startLoading=function(){this._store.dispatch(Ie(!0))},r._stopLoading=function(){this._store.dispatch(Ie(!1))},r._handleLoadingState=function(e){void 0===e&&(e=!0);var t=this.itemList.getChild("."+this.config.classNames.placeholder);e?(this.disable(),this.containerOuter.addLoadingState(),this._isSelectOneElement?t?t.innerHTML=this.config.loadingText:(t=this._getTemplate("placeholder",this.config.loadingText),this.itemList.append(t)):this.input.placeholder=this.config.loadingText):(this.enable(),this.containerOuter.removeLoadingState(),this._isSelectOneElement?t.innerHTML=this._placeholderValue||"":this.input.placeholder=this._placeholderValue||"")},r._handleSearch=function(e){if(e&&this.input.isFocussed){var t=this._store.choices,i=this.config,n=i.searchFloor,s=i.searchChoices,r=t.some((function(e){return!e.active}));if(e&&e.length>=n){var o=s?this._searchChoices(e):0;this.passedElement.triggerEvent(j,{value:e,resultCount:o})}else r&&(this._isSearching=!1,this._store.dispatch(be(!0)))}},r._canAddItem=function(e,t){var i=!0,n="function"==typeof this.config.addItemText?this.config.addItemText(t):this.config.addItemText;if(!this._isSelectOneElement){var s=function(e,t,i){return void 0===i&&(i="value"),e.some((function(e){return"string"==typeof t?e[i]===t.trim():e[i]===t}))}(e,t);this.config.maxItemCount>0&&this.config.maxItemCount<=e.length&&(i=!1,n="function"==typeof this.config.maxItemText?this.config.maxItemText(this.config.maxItemCount):this.config.maxItemText),!this.config.duplicateItemsAllowed&&s&&i&&(i=!1,n="function"==typeof this.config.uniqueItemText?this.config.uniqueItemText(t):this.config.uniqueItemText),this._isTextElement&&this.config.addItems&&i&&"function"==typeof this.config.addItemFilter&&!this.config.addItemFilter(t)&&(i=!1,n="function"==typeof this.config.customAddItemText?this.config.customAddItemText(t):this.config.customAddItemText)}return{response:i,notice:n}},r._searchChoices=function(e){var t="string"==typeof e?e.trim():e,i="string"==typeof this._currentValue?this._currentValue.trim():this._currentValue;if(t.length<1&&t===i+" ")return 0;var n=this._store.searchableChoices,r=t,o=[].concat(this.config.searchFields),a=Object.assign(this.config.fuseOptions,{keys:o}),c=new s.a(n,a).search(r);return this._currentValue=t,this._highlightPosition=0,this._isSearching=!0,this._store.dispatch(function(e){return{type:G,results:e}}(c)),c.length},r._addEventListeners=function(){var e=document.documentElement;e.addEventListener("touchend",this._onTouchEnd,!0),this.containerOuter.element.addEventListener("keydown",this._onKeyDown,!0),this.containerOuter.element.addEventListener("mousedown",this._onMouseDown,!0),e.addEventListener("click",this._onClick,{passive:!0}),e.addEventListener("touchmove",this._onTouchMove,{passive:!0}),this.dropdown.element.addEventListener("mouseover",this._onMouseOver,{passive:!0}),this._isSelectOneElement&&(this.containerOuter.element.addEventListener("focus",this._onFocus,{passive:!0}),this.containerOuter.element.addEventListener("blur",this._onBlur,{passive:!0})),this.input.element.addEventListener("keyup",this._onKeyUp,{passive:!0}),this.input.element.addEventListener("focus",this._onFocus,{passive:!0}),this.input.element.addEventListener("blur",this._onBlur,{passive:!0}),this.input.element.form&&this.input.element.form.addEventListener("reset",this._onFormReset,{passive:!0}),this.input.addEventListeners()},r._removeEventListeners=function(){var e=document.documentElement;e.removeEventListener("touchend",this._onTouchEnd,!0),this.containerOuter.element.removeEventListener("keydown",this._onKeyDown,!0),this.containerOuter.element.removeEventListener("mousedown",this._onMouseDown,!0),e.removeEventListener("click",this._onClick),e.removeEventListener("touchmove",this._onTouchMove),this.dropdown.element.removeEventListener("mouseover",this._onMouseOver),this._isSelectOneElement&&(this.containerOuter.element.removeEventListener("focus",this._onFocus),this.containerOuter.element.removeEventListener("blur",this._onBlur)),this.input.element.removeEventListener("keyup",this._onKeyUp),this.input.element.removeEventListener("focus",this._onFocus),this.input.element.removeEventListener("blur",this._onBlur),this.input.element.form&&this.input.element.form.removeEventListener("reset",this._onFormReset),this.input.removeEventListeners()},r._onKeyDown=function(e){var t,i=e.target,n=e.keyCode,s=e.ctrlKey,r=e.metaKey,o=this._store.activeItems,a=this.input.isFocussed,c=this.dropdown.isActive,l=this.itemList.hasChildren(),h=String.fromCharCode(n),u=J,d=Y,p=Z,m=Q,f=ee,v=te,g=ie,_=ne,b=se,y=s||r;!this._isTextElement&&/[a-zA-Z0-9-_ ]/.test(h)&&this.showDropdown();var E=((t={})[m]=this._onAKey,t[p]=this._onEnterKey,t[f]=this._onEscapeKey,t[v]=this._onDirectionKey,t[_]=this._onDirectionKey,t[g]=this._onDirectionKey,t[b]=this._onDirectionKey,t[d]=this._onDeleteKey,t[u]=this._onDeleteKey,t);E[n]&&E[n]({event:e,target:i,keyCode:n,metaKey:r,activeItems:o,hasFocusedInput:a,hasActiveDropdown:c,hasItems:l,hasCtrlDownKeyPressed:y})},r._onKeyUp=function(e){var t=e.target,i=e.keyCode,n=this.input.value,s=this._store.activeItems,r=this._canAddItem(s,n),o=J,a=Y;if(this._isTextElement)if(r.notice&&n){var c=this._getTemplate("notice",r.notice);this.dropdown.element.innerHTML=c.outerHTML,this.showDropdown(!0)}else this.hideDropdown(!0);else{var l=(i===o||i===a)&&!t.value,h=!this._isTextElement&&this._isSearching,u=this._canSearch&&r.response;l&&h?(this._isSearching=!1,this._store.dispatch(be(!0))):u&&this._handleSearch(this.input.value)}this._canSearch=this.config.searchEnabled},r._onAKey=function(e){var t=e.hasItems;e.hasCtrlDownKeyPressed&&t&&(this._canSearch=!1,this.config.removeItems&&!this.input.value&&this.input.element===document.activeElement&&this.highlightAll())},r._onEnterKey=function(e){var t=e.event,i=e.target,n=e.activeItems,s=e.hasActiveDropdown,r=Z,o=i.hasAttribute("data-button");if(this._isTextElement&&i.value){var a=this.input.value;this._canAddItem(n,a).response&&(this.hideDropdown(!0),this._addItem({value:a}),this._triggerChange(a),this.clearInput())}if(o&&(this._handleButtonAction(n,i),t.preventDefault()),s){var c=this.dropdown.getChild("."+this.config.classNames.highlightedState);c&&(n[0]&&(n[0].keyCode=r),this._handleChoiceAction(n,c)),t.preventDefault()}else this._isSelectOneElement&&(this.showDropdown(),t.preventDefault())},r._onEscapeKey=function(e){e.hasActiveDropdown&&(this.hideDropdown(!0),this.containerOuter.focus())},r._onDirectionKey=function(e){var t,i,n,s=e.event,r=e.hasActiveDropdown,o=e.keyCode,a=e.metaKey,c=ie,l=ne,h=se;if(r||this._isSelectOneElement){this.showDropdown(),this._canSearch=!1;var u,d=o===c||o===h?1:-1,p="[data-choice-selectable]";if(a||o===h||o===l)u=d>0?this.dropdown.element.querySelector("[data-choice-selectable]:last-of-type"):this.dropdown.element.querySelector(p);else{var m=this.dropdown.element.querySelector("."+this.config.classNames.highlightedState);u=m?function(e,t,i){if(void 0===i&&(i=1),e instanceof Element&&"string"==typeof t){for(var n=(i>0?"next":"previous")+"ElementSibling",s=e[n];s;){if(s.matches(t))return s;s=s[n]}return s}}(m,p,d):this.dropdown.element.querySelector(p)}u&&(t=u,i=this.choiceList.element,void 0===(n=d)&&(n=1),t&&(n>0?i.scrollTop+i.offsetHeight>=t.offsetTop+t.offsetHeight:t.offsetTop>=i.scrollTop)||this.choiceList.scrollToChildElement(u,d),this._highlightChoice(u)),s.preventDefault()}},r._onDeleteKey=function(e){var t=e.event,i=e.target,n=e.hasFocusedInput,s=e.activeItems;!n||i.value||this._isSelectOneElement||(this._handleBackspace(s),t.preventDefault())},r._onTouchMove=function(){this._wasTap&&(this._wasTap=!1)},r._onTouchEnd=function(e){var t=(e||e.touches[0]).target;this._wasTap&&this.containerOuter.element.contains(t)&&((t===this.containerOuter.element||t===this.containerInner.element)&&(this._isTextElement?this.input.focus():this._isSelectMultipleElement&&this.showDropdown()),e.stopPropagation()),this._wasTap=!0},r._onMouseDown=function(e){var t=e.target;if(t instanceof HTMLElement){if(we&&this.choiceList.element.contains(t)){var i=this.choiceList.element.firstElementChild,n="ltr"===this._direction?e.offsetX>=i.offsetWidth:e.offsetX<i.offsetLeft;this._isScrollingOnIe=n}if(t!==this.input.element){var s=t.closest("[data-button],[data-item],[data-choice]");if(s instanceof HTMLElement){var r=e.shiftKey,o=this._store.activeItems,a=s.dataset;"button"in a?this._handleButtonAction(o,s):"item"in a?this._handleItemAction(o,s,r):"choice"in a&&this._handleChoiceAction(o,s)}e.preventDefault()}}},r._onMouseOver=function(e){var t=e.target;t instanceof HTMLElement&&"choice"in t.dataset&&this._highlightChoice(t)},r._onClick=function(e){var t=e.target;this.containerOuter.element.contains(t)?this.dropdown.isActive||this.containerOuter.isDisabled?this._isSelectOneElement&&t!==this.input.element&&!this.dropdown.element.contains(t)&&this.hideDropdown():this._isTextElement?document.activeElement!==this.input.element&&this.input.focus():(this.showDropdown(),this.containerOuter.focus()):(this._store.highlightedActiveItems.length>0&&this.unhighlightAll(),this.containerOuter.removeFocusState(),this.hideDropdown(!0))},r._onFocus=function(e){var t,i=this,n=e.target;this.containerOuter.element.contains(n)&&((t={}).text=function(){n===i.input.element&&i.containerOuter.addFocusState()},t["select-one"]=function(){i.containerOuter.addFocusState(),n===i.input.element&&i.showDropdown(!0)},t["select-multiple"]=function(){n===i.input.element&&(i.showDropdown(!0),i.containerOuter.addFocusState())},t)[this.passedElement.element.type]()},r._onBlur=function(e){var t=this,i=e.target;if(this.containerOuter.element.contains(i)&&!this._isScrollingOnIe){var n,s=this._store.activeItems.some((function(e){return e.highlighted}));((n={}).text=function(){i===t.input.element&&(t.containerOuter.removeFocusState(),s&&t.unhighlightAll(),t.hideDropdown(!0))},n["select-one"]=function(){t.containerOuter.removeFocusState(),(i===t.input.element||i===t.containerOuter.element&&!t._canSearch)&&t.hideDropdown(!0)},n["select-multiple"]=function(){i===t.input.element&&(t.containerOuter.removeFocusState(),t.hideDropdown(!0),s&&t.unhighlightAll())},n)[this.passedElement.element.type]()}else this._isScrollingOnIe=!1,this.input.element.focus()},r._onFormReset=function(){this._store.dispatch({type:"RESET_TO",state:this._initialState})},r._highlightChoice=function(e){var t=this;void 0===e&&(e=null);var i=Array.from(this.dropdown.element.querySelectorAll("[data-choice-selectable]"));if(i.length){var n=e;Array.from(this.dropdown.element.querySelectorAll("."+this.config.classNames.highlightedState)).forEach((function(e){e.classList.remove(t.config.classNames.highlightedState),e.setAttribute("aria-selected","false")})),n?this._highlightPosition=i.indexOf(n):(n=i.length>this._highlightPosition?i[this._highlightPosition]:i[i.length-1])||(n=i[0]),n.classList.add(this.config.classNames.highlightedState),n.setAttribute("aria-selected","true"),this.passedElement.triggerEvent(B,{el:n}),this.dropdown.isActive&&(this.input.setActiveDescendant(n.id),this.containerOuter.setActiveDescendant(n.id))}},r._addItem=function(e){var t=e.value,i=e.label,n=void 0===i?null:i,s=e.choiceId,r=void 0===s?-1:s,o=e.groupId,a=void 0===o?-1:o,c=e.customProperties,l=void 0===c?null:c,h=e.placeholder,u=void 0!==h&&h,d=e.keyCode,p=void 0===d?null:d,m="string"==typeof t?t.trim():t,f=p,v=l,g=this._store.items,_=n||m,b=r||-1,y=a>=0?this._store.getGroupById(a):null,E=g?g.length+1:1;return this.config.prependValue&&(m=this.config.prependValue+m.toString()),this.config.appendValue&&(m+=this.config.appendValue.toString()),this._store.dispatch(function(e){var t=e.value,i=e.label,n=e.id,s=e.choiceId,r=e.groupId,o=e.customProperties,a=e.placeholder,c=e.keyCode;return{type:W,value:t,label:i,id:n,choiceId:s,groupId:r,customProperties:o,placeholder:a,keyCode:c}}({value:m,label:_,id:E,choiceId:b,groupId:a,customProperties:l,placeholder:u,keyCode:f})),this._isSelectOneElement&&this.removeActiveItems(E),this.passedElement.triggerEvent(K,{id:E,value:m,label:_,customProperties:v,groupValue:y&&y.value?y.value:void 0,keyCode:f}),this},r._removeItem=function(e){if(!e||!E("Object",e))return this;var t=e.id,i=e.value,n=e.label,s=e.choiceId,r=e.groupId,o=r>=0?this._store.getGroupById(r):null;return this._store.dispatch(function(e,t){return{type:X,id:e,choiceId:t}}(t,s)),o&&o.value?this.passedElement.triggerEvent(R,{id:t,value:i,label:n,groupValue:o.value}):this.passedElement.triggerEvent(R,{id:t,value:i,label:n}),this},r._addChoice=function(e){var t=e.value,i=e.label,n=void 0===i?null:i,s=e.isSelected,r=void 0!==s&&s,o=e.isDisabled,a=void 0!==o&&o,c=e.groupId,l=void 0===c?-1:c,h=e.customProperties,u=void 0===h?null:h,d=e.placeholder,p=void 0!==d&&d,m=e.keyCode,f=void 0===m?null:m;if(null!=t){var v=this._store.choices,g=n||t,_=v?v.length+1:1,b=this._baseId+"-"+this._idNames.itemChoice+"-"+_;this._store.dispatch(function(e){var t=e.value,i=e.label,n=e.id,s=e.groupId,r=e.disabled,o=e.elementId,a=e.customProperties,c=e.placeholder,l=e.keyCode;return{type:V,value:t,label:i,id:n,groupId:s,disabled:r,elementId:o,customProperties:a,placeholder:c,keyCode:l}}({id:_,groupId:l,elementId:b,value:t,label:g,disabled:a,customProperties:u,placeholder:p,keyCode:f})),r&&this._addItem({value:t,label:g,choiceId:_,customProperties:u,placeholder:p,keyCode:f})}},r._addGroup=function(e){var t=this,i=e.group,n=e.id,s=e.valueKey,r=void 0===s?"value":s,o=e.labelKey,a=void 0===o?"label":o,c=E("Object",i)?i.choices:Array.from(i.getElementsByTagName("OPTION")),l=n||Math.floor((new Date).valueOf()*Math.random()),h=!!i.disabled&&i.disabled;c?(this._store.dispatch(Ee({value:i.label,id:l,active:!0,disabled:h})),c.forEach((function(e){var i=e.disabled||e.parentNode&&e.parentNode.disabled;t._addChoice({value:e[r],label:E("Object",e)?e[a]:e.innerHTML,isSelected:e.selected,isDisabled:i,groupId:l,customProperties:e.customProperties,placeholder:e.placeholder})}))):this._store.dispatch(Ee({value:i.label,id:i.id,active:!1,disabled:i.disabled}))},r._getTemplate=function(e){var t;if(!e)return null;for(var i=this.config.classNames,n=arguments.length,s=new Array(n>1?n-1:0),r=1;r<n;r++)s[r-1]=arguments[r];return(t=this._templates[e]).call.apply(t,[this,i].concat(s))},r._createTemplates=function(){var e=this.config.callbackOnCreateTemplates,t={};e&&"function"==typeof e&&(t=e.call(this,S)),this._templates=o()(_e,t)},r._createElements=function(){this.containerOuter=new ce({element:this._getTemplate("containerOuter",this._direction,this._isSelectElement,this._isSelectOneElement,this.config.searchEnabled,this.passedElement.element.type),classNames:this.config.classNames,type:this.passedElement.element.type,position:this.config.position}),this.containerInner=new ce({element:this._getTemplate("containerInner"),classNames:this.config.classNames,type:this.passedElement.element.type,position:this.config.position}),this.input=new he({element:this._getTemplate("input",this._placeholderValue),classNames:this.config.classNames,type:this.passedElement.element.type,preventPaste:!this.config.paste}),this.choiceList=new ue({element:this._getTemplate("choiceList",this._isSelectOneElement)}),this.itemList=new ue({element:this._getTemplate("itemList",this._isSelectOneElement)}),this.dropdown=new k({element:this._getTemplate("dropdown"),classNames:this.config.classNames,type:this.passedElement.element.type})},r._createStructure=function(){this.passedElement.conceal(),this.containerInner.wrap(this.passedElement.element),this.containerOuter.wrap(this.containerInner.element),this._isSelectOneElement?this.input.placeholder=this.config.searchPlaceholderValue||"":this._placeholderValue&&(this.input.placeholder=this._placeholderValue,this.input.setWidth()),this.containerOuter.element.appendChild(this.containerInner.element),this.containerOuter.element.appendChild(this.dropdown.element),this.containerInner.element.appendChild(this.itemList.element),this._isTextElement||this.dropdown.element.appendChild(this.choiceList.element),this._isSelectOneElement?this.config.searchEnabled&&this.dropdown.element.insertBefore(this.input.element,this.dropdown.element.firstChild):this.containerInner.element.appendChild(this.input.element),this._isSelectElement&&(this._highlightPosition=0,this._isSearching=!1,this._startLoading(),this._presetGroups.length?this._addPredefinedGroups(this._presetGroups):this._addPredefinedChoices(this._presetChoices),this._stopLoading()),this._isTextElement&&this._addPredefinedItems(this._presetItems)},r._addPredefinedGroups=function(e){var t=this,i=this.passedElement.placeholderOption;i&&"SELECT"===i.parentNode.tagName&&this._addChoice({value:i.value,label:i.innerHTML,isSelected:i.selected,isDisabled:i.disabled,placeholder:!0}),e.forEach((function(e){return t._addGroup({group:e,id:e.id||null})}))},r._addPredefinedChoices=function(e){var t=this;this.config.shouldSort&&e.sort(this.config.sorter);var i=e.some((function(e){return e.selected})),n=e.findIndex((function(e){return void 0===e.disabled||!e.disabled}));e.forEach((function(e,s){var r=e.value,o=e.label,a=e.customProperties,c=e.placeholder;if(t._isSelectElement)if(e.choices)t._addGroup({group:e,id:e.id||null});else{var l=!(!t._isSelectOneElement||i||s!==n)||e.selected,h=e.disabled;t._addChoice({value:r,label:o,isSelected:l,isDisabled:h,customProperties:a,placeholder:c})}else t._addChoice({value:r,label:o,isSelected:e.selected,isDisabled:e.disabled,customProperties:a,placeholder:c})}))},r._addPredefinedItems=function(e){var t=this;e.forEach((function(e){"object"==typeof e&&e.value&&t._addItem({value:e.value,label:e.label,choiceId:e.id,customProperties:e.customProperties,placeholder:e.placeholder}),"string"==typeof e&&t._addItem({value:e})}))},r._setChoiceOrItem=function(e){var t=this;({object:function(){e.value&&(t._isTextElement?t._addItem({value:e.value,label:e.label,choiceId:e.id,customProperties:e.customProperties,placeholder:e.placeholder}):t._addChoice({value:e.value,label:e.label,isSelected:!0,isDisabled:!1,customProperties:e.customProperties,placeholder:e.placeholder}))},string:function(){t._isTextElement?t._addItem({value:e}):t._addChoice({value:e,label:e,isSelected:!0,isDisabled:!1})}})[y(e).toLowerCase()]()},r._findAndSelectChoiceByValue=function(e){var t=this,i=this._store.choices.find((function(i){return t.config.valueComparer(i.value,e)}));i&&!i.selected&&this._addItem({value:i.value,label:i.label,choiceId:i.id,groupId:i.groupId,customProperties:i.customProperties,placeholder:i.placeholder,keyCode:i.keyCode})},r._generatePlaceholderValue=function(){if(this._isSelectElement){var e=this.passedElement.placeholderOption;return!!e&&e.text}var t=this.config,i=t.placeholder,n=t.placeholderValue,s=this.passedElement.element.dataset;if(i){if(n)return n;if(s.placeholder)return s.placeholder}return!1},n}();t.default=Ce}]).default},"object"==typeof i&&"object"==typeof t?t.exports=o():"function"==typeof define&&define.amd?define([],o):"object"==typeof i?i.Choices=o():r.Choices=o()},
450: function _(o,e,i,t,r){t(),i.root="bk-root",i.default=".bk-root{}.bk-root .choices{position:relative;margin-bottom:24px;font-size:16px;}.bk-root .choices:focus{outline:none;}.bk-root .choices:last-child{margin-bottom:0;}.bk-root .choices.is-disabled .choices__inner,.bk-root .choices.is-disabled .choices__input{background-color:#eaeaea;cursor:not-allowed;-webkit-user-select:none;-ms-user-select:none;user-select:none;}.bk-root .choices.is-disabled .choices__item{cursor:not-allowed;}.bk-root .choices [hidden]{display:none !important;}.bk-root .choices[data-type*='select-one']{cursor:pointer;}.bk-root .choices[data-type*='select-one'] .choices__inner{padding-bottom:7.5px;}.bk-root .choices[data-type*='select-one'] .choices__input{display:block;width:100%;padding:10px;border-bottom:1px solid #dddddd;background-color:#ffffff;margin:0;}.bk-root .choices[data-type*='select-one'] .choices__button{background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjMDAwIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);padding:0;background-size:8px;position:absolute;top:50%;right:0;margin-top:-10px;margin-right:25px;height:20px;width:20px;border-radius:10em;opacity:0.5;}.bk-root .choices[data-type*='select-one'] .choices__button:hover,.bk-root .choices[data-type*='select-one'] .choices__button:focus{opacity:1;}.bk-root .choices[data-type*='select-one'] .choices__button:focus{box-shadow:0px 0px 0px 2px #00bcd4;}.bk-root .choices[data-type*='select-one'] .choices__item[data-value=''] .choices__button{display:none;}.bk-root .choices[data-type*='select-one']:after{content:'';height:0;width:0;border-style:solid;border-color:#333333 transparent transparent transparent;border-width:5px;position:absolute;right:11.5px;top:50%;margin-top:-2.5px;pointer-events:none;}.bk-root .choices[data-type*='select-one'].is-open:after{border-color:transparent transparent #333333 transparent;margin-top:-7.5px;}.bk-root .choices[data-type*='select-one'][dir='rtl']:after{left:11.5px;right:auto;}.bk-root .choices[data-type*='select-one'][dir='rtl'] .choices__button{right:auto;left:0;margin-left:25px;margin-right:0;}.bk-root .choices[data-type*='select-multiple'] .choices__inner,.bk-root .choices[data-type*='text'] .choices__inner{cursor:text;}.bk-root .choices[data-type*='select-multiple'] .choices__button,.bk-root .choices[data-type*='text'] .choices__button{position:relative;display:inline-block;margin-top:0;margin-right:-4px;margin-bottom:0;margin-left:8px;padding-left:16px;border-left:1px solid #008fa1;background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjRkZGIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);background-size:8px;width:8px;line-height:1;opacity:0.75;border-radius:0;}.bk-root .choices[data-type*='select-multiple'] .choices__button:hover,.bk-root .choices[data-type*='select-multiple'] .choices__button:focus,.bk-root .choices[data-type*='text'] .choices__button:hover,.bk-root .choices[data-type*='text'] .choices__button:focus{opacity:1;}.bk-root .choices__inner{display:inline-block;vertical-align:top;width:100%;background-color:#f9f9f9;padding:7.5px 7.5px 3.75px;border:1px solid #dddddd;border-radius:2.5px;font-size:14px;min-height:44px;overflow:hidden;}.bk-root .is-focused .choices__inner,.bk-root .is-open .choices__inner{border-color:#b7b7b7;}.bk-root .is-open .choices__inner{border-radius:2.5px 2.5px 0 0;}.bk-root .is-flipped.is-open .choices__inner{border-radius:0 0 2.5px 2.5px;}.bk-root .choices__list{margin:0;padding-left:0;list-style:none;}.bk-root .choices__list--single{display:inline-block;padding:4px 16px 4px 4px;width:100%;}.bk-root [dir='rtl'] .choices__list--single{padding-right:4px;padding-left:16px;}.bk-root .choices__list--single .choices__item{width:100%;}.bk-root .choices__list--multiple{display:inline;}.bk-root .choices__list--multiple .choices__item{display:inline-block;vertical-align:middle;border-radius:20px;padding:4px 10px;font-size:12px;font-weight:500;margin-right:3.75px;margin-bottom:3.75px;background-color:#00bcd4;border:1px solid #00a5bb;color:#ffffff;word-break:break-all;box-sizing:border-box;}.bk-root .choices__list--multiple .choices__item[data-deletable]{padding-right:5px;}.bk-root [dir='rtl'] .choices__list--multiple .choices__item{margin-right:0;margin-left:3.75px;}.bk-root .choices__list--multiple .choices__item.is-highlighted{background-color:#00a5bb;border:1px solid #008fa1;}.bk-root .is-disabled .choices__list--multiple .choices__item{background-color:#aaaaaa;border:1px solid #919191;}.bk-root .choices__list--dropdown{visibility:hidden;z-index:1;position:absolute;width:100%;background-color:#ffffff;border:1px solid #dddddd;top:100%;margin-top:-1px;border-bottom-left-radius:2.5px;border-bottom-right-radius:2.5px;overflow:hidden;word-break:break-all;will-change:visibility;}.bk-root .choices__list--dropdown.is-active{visibility:visible;}.bk-root .is-open .choices__list--dropdown{border-color:#b7b7b7;}.bk-root .is-flipped .choices__list--dropdown{top:auto;bottom:100%;margin-top:0;margin-bottom:-1px;border-radius:0.25rem 0.25rem 0 0;}.bk-root .choices__list--dropdown .choices__list{position:relative;max-height:300px;overflow:auto;-webkit-overflow-scrolling:touch;will-change:scroll-position;}.bk-root .choices__list--dropdown .choices__item{position:relative;padding:10px;font-size:14px;}.bk-root [dir='rtl'] .choices__list--dropdown .choices__item{text-align:right;}@media (min-width: 640px){.bk-root .choices__list--dropdown .choices__item--selectable{padding-right:100px;}.bk-root .choices__list--dropdown .choices__item--selectable:after{content:attr(data-select-text);font-size:12px;opacity:0;position:absolute;right:10px;top:50%;transform:translateY(-50%);}.bk-root [dir='rtl'] .choices__list--dropdown .choices__item--selectable{text-align:right;padding-left:100px;padding-right:10px;}.bk-root [dir='rtl'] .choices__list--dropdown .choices__item--selectable:after{right:auto;left:10px;}}.bk-root .choices__list--dropdown .choices__item--selectable.is-highlighted{background-color:#f2f2f2;}.bk-root .choices__list--dropdown .choices__item--selectable.is-highlighted:after{opacity:0.5;}.bk-root .choices__item{cursor:default;}.bk-root .choices__item--selectable{cursor:pointer;}.bk-root .choices__item--disabled{cursor:not-allowed;-webkit-user-select:none;-ms-user-select:none;user-select:none;opacity:0.5;}.bk-root .choices__heading{font-weight:600;font-size:12px;padding:10px;border-bottom:1px solid #f7f7f7;color:gray;}.bk-root .choices__button{text-indent:-9999px;-webkit-appearance:none;-moz-appearance:none;appearance:none;border:0;background-color:transparent;background-repeat:no-repeat;background-position:center;cursor:pointer;}.bk-root .choices__button:focus{outline:none;}.bk-root .choices__input{display:inline-block;vertical-align:baseline;background-color:#f9f9f9;font-size:14px;margin-bottom:5px;border:0;border-radius:0;max-width:100%;padding:4px 0 4px 2px;}.bk-root .choices__input:focus{outline:0;}.bk-root [dir='rtl'] .choices__input{padding-right:2px;padding-left:0;}.bk-root .choices__placeholder{opacity:0.5;}.bk-root .choices{width:100%;}.bk-root .choices{box-sizing:border-box;}.bk-root .choices *,.bk-root .choices *:before,.bk-root .choices *:after{box-sizing:inherit;}.bk-root .choices__inner .choices__item.light{background-color:rgba(0, 126, 255, 0.08);border-radius:5px;border:1px solid rgba(0, 126, 255, 0.24);color:#007eff;}.bk-root .choices__inner .choices__item.solid{background-color:#1f77b4;border:none;border-radius:5px;color:white;}.bk-root .choices__inner .choices__item.solid .is-highlighted{background-color:#1f77b4;border:none;}.bk-root .choices__input{background-color:transparent;}.bk-root .choices__inner{background:transparent;border:1px solid darkgray;border-radius:5px;min-height:unset;}.bk-root .choices__list{white-space:initial;}.bk-root .choices__list--dropdown{z-index:100;}.bk-root .choices[data-type*=select-multiple] .choices__button.light{background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjMDA3ZWZmIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);}.bk-root .choices[data-type*=select-multiple] .choices__button.solid{background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjZmZmZmZmIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);border-left:1px solid white;opacity:1;}"},
451: function _(e,t,l,i,n){i();const s=e(1),u=s.__importStar(e(180)),h=e(423),o=e(166),a=e(43),r=e(8),d=e(11),p=s.__importStar(e(424)),_=/^[-+]?\d*$/,m=/^[-+]?\d*\.?\d*(?:(?:\d|\d.)[eE][-+]?)*\d*$/;class c extends h.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(()=>{this.input_el.value=this.format_value,this.old_value=this.input_el.value})),this.connect(this.model.properties.low.change,(()=>{const{value:e,low:t,high:l}=this.model;null!=t&&null!=l&&d.assert(t<=l,"Invalid bounds, low must be inferior to high"),null!=e&&null!=t&&(this.model.value=Math.max(e,t))})),this.connect(this.model.properties.high.change,(()=>{const{value:e,low:t,high:l}=this.model;null!=t&&null!=l&&d.assert(l>=t,"Invalid bounds, high must be superior to low"),null!=e&&null!=l&&(this.model.value=Math.min(e,l))})),this.connect(this.model.properties.high.change,(()=>this.input_el.placeholder=this.model.placeholder)),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled)),this.connect(this.model.properties.placeholder.change,(()=>this.input_el.placeholder=this.model.placeholder))}get format_value(){return null!=this.model.value?this.model.pretty(this.model.value):""}_set_input_filter(e){this.input_el.addEventListener("input",(()=>{const{selectionStart:t,selectionEnd:l}=this.input_el;if(e(this.input_el.value))this.old_value=this.input_el.value;else{const e=this.old_value.length-this.input_el.value.length;this.input_el.value=this.old_value,t&&l&&this.input_el.setSelectionRange(t-1,l+e)}}))}render(){super.render(),this.input_el=a.input({type:"text",class:p.input,name:this.model.name,value:this.format_value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.old_value=this.format_value,this.set_input_filter(),this.input_el.addEventListener("change",(()=>this.change_input())),this.input_el.addEventListener("focusout",(()=>this.input_el.value=this.format_value)),this.group_el.appendChild(this.input_el)}set_input_filter(){"int"==this.model.mode?this._set_input_filter((e=>_.test(e))):"float"==this.model.mode&&this._set_input_filter((e=>m.test(e)))}bound_value(e){let t=e;const{low:l,high:i}=this.model;return t=null!=l?Math.max(l,t):t,t=null!=i?Math.min(i,t):t,t}get value(){let e=""!=this.input_el.value?Number(this.input_el.value):null;return null!=e&&(e=this.bound_value(e)),e}change_input(){null==this.value?this.model.value=null:Number.isNaN(this.value)||(this.model.value=this.value)}}l.NumericInputView=c,c.__name__="NumericInputView";class v extends h.InputWidget{constructor(e){super(e)}static init_NumericInput(){this.prototype.default_view=c,this.define((({Number:e,String:t,Enum:l,Ref:i,Or:n,Nullable:s})=>({value:[s(e),null],placeholder:[t,""],mode:[l("int","float"),"int"],format:[s(n(t,i(o.TickFormatter))),null],low:[s(e),null],high:[s(e),null]})))}_formatter(e,t){return r.isString(t)?u.format(e,t):t.doFormat([e],{loc:0})[0]}pretty(e){return null!=this.format?this._formatter(e,this.format):`${e}`}}l.NumericInput=v,v.__name__="NumericInput",v.init_NumericInput()},
452: function _(e,t,r,s,i){s();const n=e(441),_=e(43);class a extends n.MarkupView{render(){super.render();const e=_.pre({style:{overflow:"auto"}},this.model.text);this.markup_el.appendChild(e)}}r.PreTextView=a,a.__name__="PreTextView";class o extends n.Markup{constructor(e){super(e)}static init_PreText(){this.prototype.default_view=a}}r.PreText=o,o.__name__="PreText",o.init_PreText()},
453: function _(t,o,i,e,a){e();const n=t(1),u=t(427),s=t(43),c=n.__importStar(t(326));class _ extends u.ButtonGroupView{change_active(t){this.model.active!==t&&(this.model.active=t)}_update_active(){const{active:t}=this.model;this._buttons.forEach(((o,i)=>{s.classes(o).toggle(c.active,t===i)}))}}i.RadioButtonGroupView=_,_.__name__="RadioButtonGroupView";class r extends u.ButtonGroup{constructor(t){super(t)}static init_RadioButtonGroup(){this.prototype.default_view=_,this.define((({Int:t,Nullable:o})=>({active:[o(t),null]})))}}i.RadioButtonGroup=r,r.__name__="RadioButtonGroup",r.init_RadioButtonGroup()},
454: function _(e,i,t,n,a){n();const s=e(1),o=e(43),d=e(34),l=e(429),p=s.__importStar(e(424));class r extends l.InputGroupView{render(){super.render();const e=o.div({class:[p.input_group,this.model.inline?p.inline:null]});this.el.appendChild(e);const i=d.uniqueId(),{active:t,labels:n}=this.model;this._inputs=[];for(let a=0;a<n.length;a++){const s=o.input({type:"radio",name:i,value:`${a}`});s.addEventListener("change",(()=>this.change_active(a))),this._inputs.push(s),this.model.disabled&&(s.disabled=!0),a==t&&(s.checked=!0);const d=o.label({},s,o.span({},n[a]));e.appendChild(d)}}change_active(e){this.model.active=e}}t.RadioGroupView=r,r.__name__="RadioGroupView";class u extends l.InputGroup{constructor(e){super(e)}static init_RadioGroup(){this.prototype.default_view=r,this.define((({Boolean:e,Int:i,String:t,Array:n})=>({active:[i],labels:[n(t),[]],inline:[e,!1]})))}}t.RadioGroup=u,u.__name__="RadioGroup",u.init_RadioGroup()},
455: function _(e,t,i,r,a){r();const n=e(1).__importStar(e(180)),s=e(435),_=e(8);class d extends s.AbstractRangeSliderView{}i.RangeSliderView=d,d.__name__="RangeSliderView";class o extends s.AbstractSlider{constructor(e){super(e),this.behaviour="drag",this.connected=[!1,!0,!1]}static init_RangeSlider(){this.prototype.default_view=d,this.override({format:"0[.]00"})}_formatter(e,t){return _.isString(t)?n.format(e,t):t.compute(e)}}i.RangeSlider=o,o.__name__="RangeSlider",o.init_RangeSlider()},
456: function _(e,t,n,i,s){i();const l=e(1),u=e(43),a=e(8),o=e(13),_=e(423),p=l.__importStar(e(424));class r extends _.InputWidgetView{constructor(){super(...arguments),this._known_values=new Set}connect_signals(){super.connect_signals();const{value:e,options:t}=this.model.properties;this.on_change(e,(()=>{this._update_value()})),this.on_change(t,(()=>{u.empty(this.input_el),u.append(this.input_el,...this.options_el()),this._update_value()}))}options_el(){const{_known_values:e}=this;function t(t){return t.map((t=>{let n,i;return a.isString(t)?n=i=t:[n,i]=t,e.add(n),u.option({value:n},i)}))}e.clear();const{options:n}=this.model;return a.isArray(n)?t(n):o.entries(n).map((([e,n])=>u.optgroup({label:e},t(n))))}render(){super.render(),this.input_el=u.select({class:p.input,name:this.model.name,disabled:this.model.disabled},this.options_el()),this._update_value(),this.input_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.input_el)}change_input(){const e=this.input_el.value;this.model.value=e,super.change_input()}_update_value(){const{value:e}=this.model;this._known_values.has(e)?this.input_el.value=e:this.input_el.removeAttribute("value")}}n.SelectView=r,r.__name__="SelectView";class c extends _.InputWidget{constructor(e){super(e)}static init_Select(){this.prototype.default_view=r,this.define((({String:e,Array:t,Tuple:n,Dict:i,Or:s})=>{const l=t(s(e,n(e,e)));return{value:[e,""],options:[s(l,i(l)),[]]}}))}}n.Select=c,c.__name__="Select",c.init_Select()},
457: function _(t,e,i,r,s){r();const _=t(1).__importStar(t(180)),a=t(435),n=t(8);class o extends a.AbstractSliderView{}i.SliderView=o,o.__name__="SliderView";class d extends a.AbstractSlider{constructor(t){super(t),this.behaviour="tap",this.connected=[!0,!1]}static init_Slider(){this.prototype.default_view=o,this.override({format:"0[.]00"})}_formatter(t,e){return n.isString(e)?_.format(t,e):e.compute(t)}}i.Slider=d,d.__name__="Slider",d.init_Slider()},
458: function _(e,t,i,n,s){n();const l=e(451),o=e(43),{min:r,max:a,floor:h,abs:_}=Math;function u(e){return h(e)!==e?e.toFixed(16).replace(/0+$/,"").split(".")[1].length:0}class d extends l.NumericInputView{*buttons(){yield this.btn_up_el,yield this.btn_down_el}initialize(){super.initialize(),this._handles={interval:void 0,timeout:void 0},this._interval=200}connect_signals(){super.connect_signals();const e=this.model.properties;this.on_change(e.disabled,(()=>{for(const e of this.buttons())o.toggle_attribute(e,"disabled",this.model.disabled)}))}render(){super.render(),this.wrapper_el=o.div({class:"bk-spin-wrapper"}),this.group_el.replaceChild(this.wrapper_el,this.input_el),this.btn_up_el=o.button({class:"bk-spin-btn bk-spin-btn-up"}),this.btn_down_el=o.button({class:"bk-spin-btn bk-spin-btn-down"}),this.wrapper_el.appendChild(this.input_el),this.wrapper_el.appendChild(this.btn_up_el),this.wrapper_el.appendChild(this.btn_down_el);for(const e of this.buttons())o.toggle_attribute(e,"disabled",this.model.disabled),e.addEventListener("mousedown",(e=>this._btn_mouse_down(e))),e.addEventListener("mouseup",(()=>this._btn_mouse_up())),e.addEventListener("mouseleave",(()=>this._btn_mouse_leave()));this.input_el.addEventListener("keydown",(e=>this._input_key_down(e))),this.input_el.addEventListener("keyup",(()=>this.model.value_throttled=this.model.value)),this.input_el.addEventListener("wheel",(e=>this._input_mouse_wheel(e))),this.input_el.addEventListener("wheel",function(e,t,i=!1){let n;return function(...s){const l=this,o=i&&void 0===n;void 0!==n&&clearTimeout(n),n=setTimeout((function(){n=void 0,i||e.apply(l,s)}),t),o&&e.apply(l,s)}}((()=>{this.model.value_throttled=this.model.value}),this.model.wheel_wait,!1))}get precision(){const{low:e,high:t,step:i}=this.model,n=u;return a(n(_(null!=e?e:0)),n(_(null!=t?t:0)),n(_(i)))}remove(){this._stop_incrementation(),super.remove()}_start_incrementation(e){clearInterval(this._handles.interval),this._counter=0;const{step:t}=this.model,i=e=>{if(this._counter+=1,this._counter%5==0){const t=Math.floor(this._counter/5);t<10?(clearInterval(this._handles.interval),this._handles.interval=setInterval((()=>i(e)),this._interval/(t+1))):t>=10&&t<=13&&(clearInterval(this._handles.interval),this._handles.interval=setInterval((()=>i(2*e)),this._interval/10))}this.increment(e)};this._handles.interval=setInterval((()=>i(e*t)),this._interval)}_stop_incrementation(){clearTimeout(this._handles.timeout),this._handles.timeout=void 0,clearInterval(this._handles.interval),this._handles.interval=void 0,this.model.value_throttled=this.model.value}_btn_mouse_down(e){e.preventDefault();const t=e.currentTarget===this.btn_up_el?1:-1;this.increment(t*this.model.step),this.input_el.focus(),this._handles.timeout=setTimeout((()=>this._start_incrementation(t)),this._interval)}_btn_mouse_up(){this._stop_incrementation()}_btn_mouse_leave(){this._stop_incrementation()}_input_mouse_wheel(e){if(document.activeElement===this.input_el){e.preventDefault();const t=e.deltaY>0?-1:1;this.increment(t*this.model.step)}}_input_key_down(e){switch(e.keyCode){case o.Keys.Up:return e.preventDefault(),this.increment(this.model.step);case o.Keys.Down:return e.preventDefault(),this.increment(-this.model.step);case o.Keys.PageUp:return e.preventDefault(),this.increment(this.model.page_step_multiplier*this.model.step);case o.Keys.PageDown:return e.preventDefault(),this.increment(-this.model.page_step_multiplier*this.model.step)}}adjust_to_precision(e){return this.bound_value(Number(e.toFixed(this.precision)))}increment(e){const{low:t,high:i}=this.model;null==this.model.value?e>0?this.model.value=null!=t?t:null!=i?r(0,i):0:e<0&&(this.model.value=null!=i?i:null!=t?a(t,0):0):this.model.value=this.adjust_to_precision(this.model.value+e)}change_input(){super.change_input(),this.model.value_throttled=this.model.value}}i.SpinnerView=d,d.__name__="SpinnerView";class p extends l.NumericInput{constructor(e){super(e)}static init_Spinner(){this.prototype.default_view=d,this.define((({Number:e,Nullable:t})=>({value_throttled:[t(e),null],step:[e,1],page_step_multiplier:[e,10],wheel_wait:[e,100]}))),this.override({mode:"float"})}}i.Spinner=p,p.__name__="Spinner",p.init_Spinner()},
459: function _(e,t,s,n,i){n();const r=e(1),o=e(422),p=e(43),c=r.__importStar(e(424));class l extends o.TextLikeInputView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.rows.change,(()=>this.input_el.rows=this.model.rows)),this.connect(this.model.properties.cols.change,(()=>this.input_el.cols=this.model.cols))}_render_input(){this.input_el=p.textarea({class:c.input})}render(){super.render(),this.input_el.cols=this.model.cols,this.input_el.rows=this.model.rows}}s.TextAreaInputView=l,l.__name__="TextAreaInputView";class _ extends o.TextLikeInput{constructor(e){super(e)}static init_TextAreaInput(){this.prototype.default_view=l,this.define((({Int:e})=>({cols:[e,20],rows:[e,2]}))),this.override({max_length:500})}}s.TextAreaInput=_,_.__name__="TextAreaInput",_.init_TextAreaInput()},
460: function _(e,t,i,s,c){s();const o=e(1),a=e(416),n=e(43),l=o.__importStar(e(326));class _ extends a.AbstractButtonView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>this._update_active()))}render(){super.render(),this._update_active()}click(){this.model.active=!this.model.active,super.click()}_update_active(){n.classes(this.button_el).toggle(l.active,this.model.active)}}i.ToggleView=_,_.__name__="ToggleView";class g extends a.AbstractButton{constructor(e){super(e)}static init_Toggle(){this.prototype.default_view=_,this.define((({Boolean:e})=>({active:[e,!1]}))),this.override({label:"Toggle"})}}i.Toggle=g,g.__name__="Toggle",g.init_Toggle()},
}, 414, {"models/widgets/main":414,"models/widgets/index":415,"models/widgets/abstract_button":416,"models/widgets/control":417,"models/widgets/widget":485,"models/widgets/abstract_icon":419,"models/widgets/autocomplete_input":420,"models/widgets/text_input":421,"models/widgets/text_like_input":422,"models/widgets/input_widget":423,"styles/widgets/inputs.css":424,"models/widgets/button":425,"models/widgets/checkbox_button_group":426,"models/widgets/button_group":427,"models/widgets/checkbox_group":428,"models/widgets/input_group":429,"models/widgets/color_picker":430,"models/widgets/date_picker":431,"styles/widgets/flatpickr.css":433,"models/widgets/date_range_slider":434,"models/widgets/abstract_slider":435,"styles/widgets/sliders.css":437,"styles/widgets/nouislider.css":438,"models/widgets/date_slider":439,"models/widgets/div":440,"models/widgets/markup":441,"styles/clearfix.css":442,"models/widgets/dropdown":443,"models/widgets/file_input":444,"models/widgets/multiselect":445,"models/widgets/paragraph":446,"models/widgets/password_input":447,"models/widgets/multichoice":448,"styles/widgets/choices.css":450,"models/widgets/numeric_input":451,"models/widgets/pretext":452,"models/widgets/radio_button_group":453,"models/widgets/radio_group":454,"models/widgets/range_slider":455,"models/widgets/selectbox":456,"models/widgets/slider":457,"models/widgets/spinner":458,"models/widgets/textarea_input":459,"models/widgets/toggle":460}, {});});
