#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import message_pb2 as message__pb2
from . import metadata_service_pb2 as metadata__service__pb2


class MetadataServiceStub(object):
    """Missing associated documentation comment in .proto file."""

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.getDatasetById = channel.unary_unary(
                '/ai_flow.MetadataService/getDatasetById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getDatasetByName = channel.unary_unary(
                '/ai_flow.MetadataService/getDatasetByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.listDatasets = channel.unary_unary(
                '/ai_flow.MetadataService/listDatasets',
                request_serializer=metadata__service__pb2.ListRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerDataset = channel.unary_unary(
                '/ai_flow.MetadataService/registerDataset',
                request_serializer=metadata__service__pb2.RegisterDatasetRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerDatasetWithCatalog = channel.unary_unary(
                '/ai_flow.MetadataService/registerDatasetWithCatalog',
                request_serializer=metadata__service__pb2.RegisterDatasetRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerDatasets = channel.unary_unary(
                '/ai_flow.MetadataService/registerDatasets',
                request_serializer=metadata__service__pb2.RegisterDatasetsRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.updateDataset = channel.unary_unary(
                '/ai_flow.MetadataService/updateDataset',
                request_serializer=metadata__service__pb2.UpdateDatasetRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteDatasetById = channel.unary_unary(
                '/ai_flow.MetadataService/deleteDatasetById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteDatasetByName = channel.unary_unary(
                '/ai_flow.MetadataService/deleteDatasetByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getModelRelationById = channel.unary_unary(
                '/ai_flow.MetadataService/getModelRelationById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getModelRelationByName = channel.unary_unary(
                '/ai_flow.MetadataService/getModelRelationByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.listModelRelation = channel.unary_unary(
                '/ai_flow.MetadataService/listModelRelation',
                request_serializer=metadata__service__pb2.ListRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerModelRelation = channel.unary_unary(
                '/ai_flow.MetadataService/registerModelRelation',
                request_serializer=metadata__service__pb2.RegisterModelRelationRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteModelRelationById = channel.unary_unary(
                '/ai_flow.MetadataService/deleteModelRelationById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteModelRelationByName = channel.unary_unary(
                '/ai_flow.MetadataService/deleteModelRelationByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getModelById = channel.unary_unary(
                '/ai_flow.MetadataService/getModelById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getModelByName = channel.unary_unary(
                '/ai_flow.MetadataService/getModelByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerModel = channel.unary_unary(
                '/ai_flow.MetadataService/registerModel',
                request_serializer=metadata__service__pb2.RegisterModelRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteModelById = channel.unary_unary(
                '/ai_flow.MetadataService/deleteModelById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteModelByName = channel.unary_unary(
                '/ai_flow.MetadataService/deleteModelByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getModelVersionRelationByVersion = channel.unary_unary(
                '/ai_flow.MetadataService/getModelVersionRelationByVersion',
                request_serializer=metadata__service__pb2.ModelVersionNameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.listModelVersionRelation = channel.unary_unary(
                '/ai_flow.MetadataService/listModelVersionRelation',
                request_serializer=metadata__service__pb2.ListModelVersionRelationRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerModelVersionRelation = channel.unary_unary(
                '/ai_flow.MetadataService/registerModelVersionRelation',
                request_serializer=metadata__service__pb2.RegisterModelVersionRelationRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteModelVersionRelationByVersion = channel.unary_unary(
                '/ai_flow.MetadataService/deleteModelVersionRelationByVersion',
                request_serializer=metadata__service__pb2.ModelVersionNameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getModelVersionByVersion = channel.unary_unary(
                '/ai_flow.MetadataService/getModelVersionByVersion',
                request_serializer=metadata__service__pb2.ModelVersionNameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerModelVersion = channel.unary_unary(
                '/ai_flow.MetadataService/registerModelVersion',
                request_serializer=metadata__service__pb2.RegisterModelVersionRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteModelVersionByVersion = channel.unary_unary(
                '/ai_flow.MetadataService/deleteModelVersionByVersion',
                request_serializer=metadata__service__pb2.ModelVersionNameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getDeployedModelVersion = channel.unary_unary(
                '/ai_flow.MetadataService/getDeployedModelVersion',
                request_serializer=metadata__service__pb2.ModelNameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getLatestValidatedModelVersion = channel.unary_unary(
                '/ai_flow.MetadataService/getLatestValidatedModelVersion',
                request_serializer=metadata__service__pb2.ModelNameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getLatestGeneratedModelVersion = channel.unary_unary(
                '/ai_flow.MetadataService/getLatestGeneratedModelVersion',
                request_serializer=metadata__service__pb2.ModelNameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getProjectById = channel.unary_unary(
                '/ai_flow.MetadataService/getProjectById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getProjectByName = channel.unary_unary(
                '/ai_flow.MetadataService/getProjectByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerProject = channel.unary_unary(
                '/ai_flow.MetadataService/registerProject',
                request_serializer=metadata__service__pb2.RegisterProjectRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.updateProject = channel.unary_unary(
                '/ai_flow.MetadataService/updateProject',
                request_serializer=metadata__service__pb2.UpdateProjectRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.listProject = channel.unary_unary(
                '/ai_flow.MetadataService/listProject',
                request_serializer=metadata__service__pb2.ListRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteProjectById = channel.unary_unary(
                '/ai_flow.MetadataService/deleteProjectById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteProjectByName = channel.unary_unary(
                '/ai_flow.MetadataService/deleteProjectByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getArtifactById = channel.unary_unary(
                '/ai_flow.MetadataService/getArtifactById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getArtifactByName = channel.unary_unary(
                '/ai_flow.MetadataService/getArtifactByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.updateArtifact = channel.unary_unary(
                '/ai_flow.MetadataService/updateArtifact',
                request_serializer=metadata__service__pb2.UpdateArtifactRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerArtifact = channel.unary_unary(
                '/ai_flow.MetadataService/registerArtifact',
                request_serializer=metadata__service__pb2.RegisterArtifactRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.listArtifact = channel.unary_unary(
                '/ai_flow.MetadataService/listArtifact',
                request_serializer=metadata__service__pb2.ListRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteArtifactById = channel.unary_unary(
                '/ai_flow.MetadataService/deleteArtifactById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteArtifactByName = channel.unary_unary(
                '/ai_flow.MetadataService/deleteArtifactByName',
                request_serializer=metadata__service__pb2.NameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.registerWorkflow = channel.unary_unary(
                '/ai_flow.MetadataService/registerWorkflow',
                request_serializer=metadata__service__pb2.RegisterWorkflowRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.updateWorkflow = channel.unary_unary(
                '/ai_flow.MetadataService/updateWorkflow',
                request_serializer=metadata__service__pb2.UpdateWorkflowRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getWorkflowById = channel.unary_unary(
                '/ai_flow.MetadataService/getWorkflowById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.getWorkflowByName = channel.unary_unary(
                '/ai_flow.MetadataService/getWorkflowByName',
                request_serializer=metadata__service__pb2.WorkflowNameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteWorkflowById = channel.unary_unary(
                '/ai_flow.MetadataService/deleteWorkflowById',
                request_serializer=metadata__service__pb2.IdRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.deleteWorkflowByName = channel.unary_unary(
                '/ai_flow.MetadataService/deleteWorkflowByName',
                request_serializer=metadata__service__pb2.WorkflowNameRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )
        self.listWorkflows = channel.unary_unary(
                '/ai_flow.MetadataService/listWorkflows',
                request_serializer=metadata__service__pb2.ListWorkflowsRequest.SerializeToString,
                response_deserializer=message__pb2.Response.FromString,
                )


class MetadataServiceServicer(object):
    """Missing associated documentation comment in .proto file."""

    def getDatasetById(self, request, context):
        """dataset api
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getDatasetByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def listDatasets(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerDataset(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerDatasetWithCatalog(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerDatasets(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def updateDataset(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteDatasetById(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteDatasetByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getModelRelationById(self, request, context):
        """model relation api
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getModelRelationByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def listModelRelation(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerModelRelation(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteModelRelationById(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteModelRelationByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getModelById(self, request, context):
        """model api
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getModelByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerModel(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteModelById(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteModelByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getModelVersionRelationByVersion(self, request, context):
        """model version relation api
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def listModelVersionRelation(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerModelVersionRelation(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteModelVersionRelationByVersion(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getModelVersionByVersion(self, request, context):
        """model version api
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerModelVersion(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteModelVersionByVersion(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getDeployedModelVersion(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getLatestValidatedModelVersion(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getLatestGeneratedModelVersion(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getProjectById(self, request, context):
        """project api
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getProjectByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerProject(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def updateProject(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def listProject(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteProjectById(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteProjectByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getArtifactById(self, request, context):
        """artifact api
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getArtifactByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def updateArtifact(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerArtifact(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def listArtifact(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteArtifactById(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteArtifactByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def registerWorkflow(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def updateWorkflow(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getWorkflowById(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getWorkflowByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteWorkflowById(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteWorkflowByName(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def listWorkflows(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_MetadataServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'getDatasetById': grpc.unary_unary_rpc_method_handler(
                    servicer.getDatasetById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getDatasetByName': grpc.unary_unary_rpc_method_handler(
                    servicer.getDatasetByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'listDatasets': grpc.unary_unary_rpc_method_handler(
                    servicer.listDatasets,
                    request_deserializer=metadata__service__pb2.ListRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerDataset': grpc.unary_unary_rpc_method_handler(
                    servicer.registerDataset,
                    request_deserializer=metadata__service__pb2.RegisterDatasetRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerDatasetWithCatalog': grpc.unary_unary_rpc_method_handler(
                    servicer.registerDatasetWithCatalog,
                    request_deserializer=metadata__service__pb2.RegisterDatasetRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerDatasets': grpc.unary_unary_rpc_method_handler(
                    servicer.registerDatasets,
                    request_deserializer=metadata__service__pb2.RegisterDatasetsRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'updateDataset': grpc.unary_unary_rpc_method_handler(
                    servicer.updateDataset,
                    request_deserializer=metadata__service__pb2.UpdateDatasetRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteDatasetById': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteDatasetById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteDatasetByName': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteDatasetByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getModelRelationById': grpc.unary_unary_rpc_method_handler(
                    servicer.getModelRelationById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getModelRelationByName': grpc.unary_unary_rpc_method_handler(
                    servicer.getModelRelationByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'listModelRelation': grpc.unary_unary_rpc_method_handler(
                    servicer.listModelRelation,
                    request_deserializer=metadata__service__pb2.ListRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerModelRelation': grpc.unary_unary_rpc_method_handler(
                    servicer.registerModelRelation,
                    request_deserializer=metadata__service__pb2.RegisterModelRelationRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteModelRelationById': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteModelRelationById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteModelRelationByName': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteModelRelationByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getModelById': grpc.unary_unary_rpc_method_handler(
                    servicer.getModelById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getModelByName': grpc.unary_unary_rpc_method_handler(
                    servicer.getModelByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerModel': grpc.unary_unary_rpc_method_handler(
                    servicer.registerModel,
                    request_deserializer=metadata__service__pb2.RegisterModelRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteModelById': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteModelById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteModelByName': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteModelByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getModelVersionRelationByVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.getModelVersionRelationByVersion,
                    request_deserializer=metadata__service__pb2.ModelVersionNameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'listModelVersionRelation': grpc.unary_unary_rpc_method_handler(
                    servicer.listModelVersionRelation,
                    request_deserializer=metadata__service__pb2.ListModelVersionRelationRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerModelVersionRelation': grpc.unary_unary_rpc_method_handler(
                    servicer.registerModelVersionRelation,
                    request_deserializer=metadata__service__pb2.RegisterModelVersionRelationRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteModelVersionRelationByVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteModelVersionRelationByVersion,
                    request_deserializer=metadata__service__pb2.ModelVersionNameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getModelVersionByVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.getModelVersionByVersion,
                    request_deserializer=metadata__service__pb2.ModelVersionNameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerModelVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.registerModelVersion,
                    request_deserializer=metadata__service__pb2.RegisterModelVersionRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteModelVersionByVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteModelVersionByVersion,
                    request_deserializer=metadata__service__pb2.ModelVersionNameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getDeployedModelVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.getDeployedModelVersion,
                    request_deserializer=metadata__service__pb2.ModelNameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getLatestValidatedModelVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.getLatestValidatedModelVersion,
                    request_deserializer=metadata__service__pb2.ModelNameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getLatestGeneratedModelVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.getLatestGeneratedModelVersion,
                    request_deserializer=metadata__service__pb2.ModelNameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getProjectById': grpc.unary_unary_rpc_method_handler(
                    servicer.getProjectById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getProjectByName': grpc.unary_unary_rpc_method_handler(
                    servicer.getProjectByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerProject': grpc.unary_unary_rpc_method_handler(
                    servicer.registerProject,
                    request_deserializer=metadata__service__pb2.RegisterProjectRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'updateProject': grpc.unary_unary_rpc_method_handler(
                    servicer.updateProject,
                    request_deserializer=metadata__service__pb2.UpdateProjectRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'listProject': grpc.unary_unary_rpc_method_handler(
                    servicer.listProject,
                    request_deserializer=metadata__service__pb2.ListRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteProjectById': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteProjectById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteProjectByName': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteProjectByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getArtifactById': grpc.unary_unary_rpc_method_handler(
                    servicer.getArtifactById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getArtifactByName': grpc.unary_unary_rpc_method_handler(
                    servicer.getArtifactByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'updateArtifact': grpc.unary_unary_rpc_method_handler(
                    servicer.updateArtifact,
                    request_deserializer=metadata__service__pb2.UpdateArtifactRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerArtifact': grpc.unary_unary_rpc_method_handler(
                    servicer.registerArtifact,
                    request_deserializer=metadata__service__pb2.RegisterArtifactRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'listArtifact': grpc.unary_unary_rpc_method_handler(
                    servicer.listArtifact,
                    request_deserializer=metadata__service__pb2.ListRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteArtifactById': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteArtifactById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteArtifactByName': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteArtifactByName,
                    request_deserializer=metadata__service__pb2.NameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'registerWorkflow': grpc.unary_unary_rpc_method_handler(
                    servicer.registerWorkflow,
                    request_deserializer=metadata__service__pb2.RegisterWorkflowRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'updateWorkflow': grpc.unary_unary_rpc_method_handler(
                    servicer.updateWorkflow,
                    request_deserializer=metadata__service__pb2.UpdateWorkflowRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getWorkflowById': grpc.unary_unary_rpc_method_handler(
                    servicer.getWorkflowById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'getWorkflowByName': grpc.unary_unary_rpc_method_handler(
                    servicer.getWorkflowByName,
                    request_deserializer=metadata__service__pb2.WorkflowNameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteWorkflowById': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteWorkflowById,
                    request_deserializer=metadata__service__pb2.IdRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'deleteWorkflowByName': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteWorkflowByName,
                    request_deserializer=metadata__service__pb2.WorkflowNameRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
            'listWorkflows': grpc.unary_unary_rpc_method_handler(
                    servicer.listWorkflows,
                    request_deserializer=metadata__service__pb2.ListWorkflowsRequest.FromString,
                    response_serializer=message__pb2.Response.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'ai_flow.MetadataService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class MetadataService(object):
    """Missing associated documentation comment in .proto file."""

    @staticmethod
    def getDatasetById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getDatasetById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getDatasetByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getDatasetByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def listDatasets(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/listDatasets',
            metadata__service__pb2.ListRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerDataset(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerDataset',
            metadata__service__pb2.RegisterDatasetRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerDatasetWithCatalog(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerDatasetWithCatalog',
            metadata__service__pb2.RegisterDatasetRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerDatasets(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerDatasets',
            metadata__service__pb2.RegisterDatasetsRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def updateDataset(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/updateDataset',
            metadata__service__pb2.UpdateDatasetRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteDatasetById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteDatasetById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteDatasetByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteDatasetByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getModelRelationById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getModelRelationById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getModelRelationByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getModelRelationByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def listModelRelation(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/listModelRelation',
            metadata__service__pb2.ListRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerModelRelation(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerModelRelation',
            metadata__service__pb2.RegisterModelRelationRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteModelRelationById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteModelRelationById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteModelRelationByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteModelRelationByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getModelById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getModelById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getModelByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getModelByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerModel(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerModel',
            metadata__service__pb2.RegisterModelRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteModelById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteModelById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteModelByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteModelByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getModelVersionRelationByVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getModelVersionRelationByVersion',
            metadata__service__pb2.ModelVersionNameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def listModelVersionRelation(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/listModelVersionRelation',
            metadata__service__pb2.ListModelVersionRelationRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerModelVersionRelation(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerModelVersionRelation',
            metadata__service__pb2.RegisterModelVersionRelationRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteModelVersionRelationByVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteModelVersionRelationByVersion',
            metadata__service__pb2.ModelVersionNameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getModelVersionByVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getModelVersionByVersion',
            metadata__service__pb2.ModelVersionNameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerModelVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerModelVersion',
            metadata__service__pb2.RegisterModelVersionRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteModelVersionByVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteModelVersionByVersion',
            metadata__service__pb2.ModelVersionNameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getDeployedModelVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getDeployedModelVersion',
            metadata__service__pb2.ModelNameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getLatestValidatedModelVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getLatestValidatedModelVersion',
            metadata__service__pb2.ModelNameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getLatestGeneratedModelVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getLatestGeneratedModelVersion',
            metadata__service__pb2.ModelNameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getProjectById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getProjectById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getProjectByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getProjectByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerProject(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerProject',
            metadata__service__pb2.RegisterProjectRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def updateProject(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/updateProject',
            metadata__service__pb2.UpdateProjectRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def listProject(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/listProject',
            metadata__service__pb2.ListRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteProjectById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteProjectById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteProjectByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteProjectByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getArtifactById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getArtifactById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getArtifactByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getArtifactByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def updateArtifact(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/updateArtifact',
            metadata__service__pb2.UpdateArtifactRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerArtifact(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerArtifact',
            metadata__service__pb2.RegisterArtifactRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def listArtifact(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/listArtifact',
            metadata__service__pb2.ListRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteArtifactById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteArtifactById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteArtifactByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteArtifactByName',
            metadata__service__pb2.NameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def registerWorkflow(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/registerWorkflow',
            metadata__service__pb2.RegisterWorkflowRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def updateWorkflow(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/updateWorkflow',
            metadata__service__pb2.UpdateWorkflowRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getWorkflowById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getWorkflowById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getWorkflowByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/getWorkflowByName',
            metadata__service__pb2.WorkflowNameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteWorkflowById(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteWorkflowById',
            metadata__service__pb2.IdRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteWorkflowByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/deleteWorkflowByName',
            metadata__service__pb2.WorkflowNameRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def listWorkflows(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/ai_flow.MetadataService/listWorkflows',
            metadata__service__pb2.ListWorkflowsRequest.SerializeToString,
            message__pb2.Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
