/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class LUDecomposition
implements Serializable {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix matrix) {
        this.LU = matrix.getArrayCopy();
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.piv = new int[this.m];
        int n = 0;
        while (n < this.m) {
            this.piv[n] = n;
            ++n;
        }
        this.pivsign = 1;
        double[] dArray = new double[this.m];
        int n2 = 0;
        while (n2 < this.n) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            while (n6 < this.m) {
                dArray[n6] = this.LU[n6][n2];
                ++n6;
            }
            int n7 = 0;
            while (n7 < this.m) {
                double[] dArray2 = this.LU[n7];
                n5 = Math.min(n7, n2);
                double d = 0.0;
                n4 = 0;
                while (n4 < n5) {
                    d += dArray2[n4] * dArray[n4];
                    ++n4;
                }
                int n8 = n7++;
                double d2 = dArray[n8] - d;
                dArray[n8] = d2;
                dArray2[n2] = d2;
            }
            n5 = n2;
            int n9 = n2 + 1;
            while (n9 < this.m) {
                if (Math.abs(dArray[n9]) > Math.abs(dArray[n5])) {
                    n5 = n9;
                }
                ++n9;
            }
            if (n5 != n2) {
                n3 = 0;
                while (n3 < this.n) {
                    double d = this.LU[n5][n3];
                    this.LU[n5][n3] = this.LU[n2][n3];
                    this.LU[n2][n3] = d;
                    ++n3;
                }
                n4 = this.piv[n5];
                this.piv[n5] = this.piv[n2];
                this.piv[n2] = n4;
                this.pivsign = -this.pivsign;
            }
            if (n2 < this.m & this.LU[n2][n2] != 0.0) {
                n3 = n2 + 1;
                while (n3 < this.m) {
                    double[] dArray3 = this.LU[n3];
                    int n10 = n2;
                    dArray3[n10] = dArray3[n10] / this.LU[n2][n2];
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        int n = 0;
        while (n < this.n) {
            d *= this.LU[n][n];
            ++n;
        }
        return d;
    }

    public double[] getDoublePivot() {
        double[] dArray = new double[this.m];
        int n = 0;
        while (n < this.m) {
            dArray[n] = this.piv[n];
            ++n;
        }
        return dArray;
    }

    public Matrix getL() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = n > n2 ? this.LU[n][n2] : (n == n2 ? 1.0 : 0.0);
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public int[] getPivot() {
        int[] nArray = new int[this.m];
        int n = 0;
        while (n < this.m) {
            nArray[n] = this.piv[n];
            ++n;
        }
        return nArray;
    }

    public Matrix getU() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = n <= n2 ? this.LU[n][n2] : 0.0;
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public boolean isNonsingular() {
        int n = 0;
        while (n < this.n) {
            if (this.LU[n][n] == 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Matrix solve(Matrix matrix) {
        int n;
        int n2;
        if (matrix.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int n3 = matrix.getColumnDimension();
        Matrix matrix2 = matrix.getMatrix(this.piv, 0, n3 - 1);
        double[][] dArray = matrix2.getArray();
        int n4 = 0;
        while (n4 < this.n) {
            n2 = n4 + 1;
            while (n2 < this.n) {
                n = 0;
                while (n < n3) {
                    double[] dArray2 = dArray[n2];
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] - dArray[n4][n] * this.LU[n2][n4];
                    ++n;
                }
                ++n2;
            }
            ++n4;
        }
        n2 = this.n - 1;
        while (n2 >= 0) {
            n = 0;
            while (n < n3) {
                double[] dArray3 = dArray[n2];
                int n6 = n++;
                dArray3[n6] = dArray3[n6] / this.LU[n2][n2];
            }
            int n7 = 0;
            while (n7 < n2) {
                int n8 = 0;
                while (n8 < n3) {
                    double[] dArray4 = dArray[n7];
                    int n9 = n8;
                    dArray4[n9] = dArray4[n9] - dArray[n2][n8] * this.LU[n7][n2];
                    ++n8;
                }
                ++n7;
            }
            --n2;
        }
        return matrix2;
    }
}

