/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import javax.vecmath.Point3d;
import libpadeldescriptor.AtomConstants;
import libpadeldescriptor.IntrinsicStateDescriptor;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class RDFDescriptor
implements IMolecularDescriptor {
    private static final int maxLength = 30;
    public String[] names = new String[wtypes.length * 30];
    private static final String[] wtypes = new String[]{"u", "m", "v", "e", "p", "i", "s"};

    public RDFDescriptor() {
        int n = 0;
        for (String string : wtypes) {
            for (int i = 0; i < 30; ++i) {
                this.names[n++] = "RDF" + (i * 5 + 10) + string;
            }
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("RDF", this.getClass().getName(), "$Id: RDFDescriptor.java 1 2014-06-12 15:30:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        int n3 = iAtomContainer.getAtomCount();
        double[][] dArray = new double[wtypes.length][n3];
        IntrinsicStateDescriptor intrinsicStateDescriptor = new IntrinsicStateDescriptor();
        int n4 = 0;
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            int n5 = iAtomContainer.getAtom(i).getAtomicNumber();
            dArray[0][i] = 1.0;
            dArray[1][i] = n5 < AtomConstants.masses.length ? AtomConstants.masses[n5] / AtomConstants.masses[6] : Double.NaN;
            dArray[2][i] = n5 < AtomConstants.volumes.length ? AtomConstants.volumes[n5] / AtomConstants.volumes[6] : Double.NaN;
            dArray[3][i] = n5 < AtomConstants.sandersonelnegativities.length ? AtomConstants.sandersonelnegativities[n5] / AtomConstants.sandersonelnegativities[6] : Double.NaN;
            dArray[4][i] = n5 < AtomConstants.polarizabilities.length ? AtomConstants.polarizabilities[n5] / AtomConstants.polarizabilities[6] : Double.NaN;
            dArray[5][i] = n5 < AtomConstants.ionpotentials.length ? AtomConstants.ionpotentials[n5] / AtomConstants.ionpotentials[6] : Double.NaN;
            IAtom iAtom = iAtomContainer.getAtom(i);
            if (n5 == 1) {
                dArray[6][i] = 1.0;
                continue;
            }
            DoubleArrayResult doubleArrayResult = (DoubleArrayResult)intrinsicStateDescriptor.calculate(iAtom, iAtomContainer).getValue();
            dArray[6][i] = doubleArrayResult.get(0);
            if (n5 != 6) continue;
            ++n4;
            d += doubleArrayResult.get(0);
        }
        double d2 = d / (double)n4;
        int n6 = 0;
        while (n6 < n3) {
            double[] dArray2 = dArray[6];
            int n7 = n6++;
            dArray2[n7] = dArray2[n7] / d2;
        }
        double[][] dArray3 = new double[30][wtypes.length];
        double d3 = 1.0;
        for (int i = 0; i < 30; ++i) {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = n2 + 1; n < n3; ++n) {
                    Point3d point3d = iAtomContainer.getAtom(n2).getPoint3d();
                    Point3d point3d2 = iAtomContainer.getAtom(n).getPoint3d();
                    double d4 = Math.sqrt((point3d.x - point3d2.x) * (point3d.x - point3d2.x) + (point3d.y - point3d2.y) * (point3d.y - point3d2.y) + (point3d.z - point3d2.z) * (point3d.z - point3d2.z));
                    for (int j = 0; j < wtypes.length; ++j) {
                        double[] dArray4 = dArray3[i];
                        int n8 = j;
                        dArray4[n8] = dArray4[n8] + dArray[j][n2] * dArray[j][n] * Math.exp(-100.0 * (d3 - d4) * (d3 - d4));
                    }
                }
            }
            d3 += 0.5;
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (n2 = 0; n2 < wtypes.length; ++n2) {
            for (n = 0; n < 30; ++n) {
                doubleArrayResult.add(dArray3[n][n2]);
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

