/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.WeightedPathDescriptorTest")
public class PaDELWeightedPathDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"WTPT-1", "WTPT-2", "WTPT-3", "WTPT-4", "WTPT-5"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#weightedPath", this.getClass().getName(), "$Id: 33d8b0c3b45365eefe87fe9ff57ba735f46afb3e $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        Object object;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n3 = iAtomContainer2.getAtomCount();
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        ArrayList<List<IAtom>> arrayList = new ArrayList<List<IAtom>>();
        List[][] listArray = new List[n3][n3];
        for (int i = 0; i < n3 - 1; ++i) {
            IAtom iAtom = iAtomContainer2.getAtom(i);
            for (int j = i + 1; j < n3; ++j) {
                List<List<IAtom>> list;
                object = iAtomContainer2.getAtom(j);
                List<List<IAtom>> list2 = list = PathTools.getAllPaths(iAtomContainer2, iAtom, (IAtom)object);
                listArray[j][i] = list2;
                listArray[i][j] = list2;
                arrayList.addAll(list);
            }
        }
        double[] dArray = this.getPathWeights(arrayList, iAtomContainer2);
        double d = 0.0;
        object = dArray;
        int n4 = ((double[])object).length;
        for (n2 = 0; n2 < n4; ++n2) {
            double d2 = object[n2];
            d += d2;
        }
        doubleArrayResult.add(d += (double)n3);
        doubleArrayResult.add(d / (double)n3);
        arrayList.clear();
        int n5 = 0;
        for (n4 = 0; n4 < n3; ++n4) {
            IAtom iAtom = iAtomContainer2.getAtom(n4);
            if (iAtom.getSymbol().equalsIgnoreCase("C")) continue;
            ++n5;
            for (int i = 0; i < n3; ++i) {
                IAtom iAtom2 = iAtomContainer2.getAtom(i);
                if (iAtom.equals(iAtom2)) continue;
                arrayList.addAll(listArray[n4][i]);
            }
        }
        dArray = this.getPathWeights(arrayList, iAtomContainer2);
        d = 0.0;
        double[] dArray2 = dArray;
        n2 = dArray2.length;
        for (n = 0; n < n2; ++n) {
            double d3 = dArray2[n];
            d += d3;
        }
        doubleArrayResult.add(d += (double)n5);
        arrayList.clear();
        n5 = 0;
        for (int i = 0; i < n3; ++i) {
            IAtom iAtom = iAtomContainer2.getAtom(i);
            if (!iAtom.getSymbol().equalsIgnoreCase("O")) continue;
            ++n5;
            for (n = 0; n < n3; ++n) {
                IAtom iAtom3 = iAtomContainer2.getAtom(n);
                if (iAtom.equals(iAtom3)) continue;
                arrayList.addAll(listArray[i][n]);
            }
        }
        dArray = this.getPathWeights(arrayList, iAtomContainer2);
        d = 0.0;
        double[] dArray3 = dArray;
        n2 = dArray3.length;
        for (n = 0; n < n2; ++n) {
            double d4 = dArray3[n];
            d += d4;
        }
        doubleArrayResult.add(d += (double)n5);
        arrayList.clear();
        n5 = 0;
        for (int i = 0; i < n3; ++i) {
            IAtom iAtom = iAtomContainer2.getAtom(i);
            if (!iAtom.getSymbol().equalsIgnoreCase("N")) continue;
            ++n5;
            for (n = 0; n < n3; ++n) {
                IAtom iAtom4 = iAtomContainer2.getAtom(n);
                if (iAtom.equals(iAtom4)) continue;
                arrayList.addAll(listArray[i][n]);
            }
        }
        dArray = this.getPathWeights(arrayList, iAtomContainer2);
        d = 0.0;
        for (double d5 : dArray) {
            d += d5;
        }
        doubleArrayResult.add(d += (double)n5);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(5);
    }

    private double[] getPathWeights(List list, IAtomContainer iAtomContainer) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            List list2 = (List)list.get(i);
            dArray[i] = 1.0;
            for (int j = 0; j < list2.size() - 1; ++j) {
                IAtom iAtom = (IAtom)list2.get(j);
                IAtom iAtom2 = (IAtom)list2.get(j + 1);
                int n = iAtomContainer.getConnectedAtomsList(iAtom).size();
                int n2 = iAtomContainer.getConnectedAtomsList(iAtom2).size();
                int n3 = i;
                dArray[n3] = dArray[n3] / Math.sqrt(n * n2);
            }
        }
        return dArray;
    }
}

