/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomTypeException;
import org.openscience.cdk.graph.rebond.RebondTool;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBioPolymer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPDBStructure;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PDBFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.protein.data.PDBAtom;
import org.openscience.cdk.protein.data.PDBMonomer;
import org.openscience.cdk.protein.data.PDBPolymer;
import org.openscience.cdk.protein.data.PDBStrand;
import org.openscience.cdk.protein.data.PDBStructure;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class PaDELPDBReader
extends DefaultChemObjectReader {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(PaDELPDBReader.class);
    private BufferedReader _oInput;
    private BooleanIOSetting useRebondTool;
    private BooleanIOSetting readConnect;
    private Map atomNumberMap;
    private ArrayList bondsFromConnectRecords;
    private static AtomTypeFactory pdbFactory;

    public PaDELPDBReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public PaDELPDBReader(Reader reader) {
        this._oInput = new BufferedReader(reader);
        this.initIOSettings();
        pdbFactory = null;
    }

    public PaDELPDBReader() {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return PDBFormat.getInstance();
    }

    @Override
    public void setReader(Reader reader) throws CDKException {
        this._oInput = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @Override
    public void setReader(InputStream inputStream) throws CDKException {
        this.setReader(new InputStreamReader(inputStream));
    }

    public boolean accepts(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!IChemFile.class.equals(classArray[i])) continue;
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            return this.accepts(clazz2);
        }
        return false;
    }

    public IChemObject read(IChemObject iChemObject) throws CDKException {
        if (iChemObject instanceof IChemFile) {
            if (pdbFactory == null) {
                try {
                    pdbFactory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/pdb_atomtypes.xml", ((IChemFile)iChemObject).getBuilder());
                }
                catch (Exception exception) {
                    logger.debug(exception);
                    throw new CDKException("Could not setup list of PDB atom types! " + exception.getMessage(), exception);
                }
            }
            return this.readChemFile((IChemFile)iChemObject);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemFile iChemFile) {
        IChemSequence iChemSequence = iChemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel iChemModel = iChemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IMoleculeSet iMoleculeSet = iChemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        PDBPolymer pDBPolymer = new PDBPolymer();
        IMolecule iMolecule = iChemFile.getBuilder().newInstance(IMolecule.class, new Object[0]);
        String string = "";
        char c = 'A';
        int n = 0;
        boolean bl = true;
        this.atomNumberMap = new Hashtable();
        if (this.readConnect.isSet()) {
            this.bondsFromConnectRecords = new ArrayList();
        }
        try {
            do {
                IStrand iStrand;
                Object object;
                PDBAtom pDBAtom;
                String string2;
                string = this._oInput.readLine();
                logger.debug("Read line: ", string);
                if (string == null) continue;
                n = string.length();
                if (n < 80) {
                    logger.warn("Line is not of the expected length 80!");
                }
                if (n < 6) {
                    string = string + "      ";
                }
                if ("SEQRES".equalsIgnoreCase(string2 = string.substring(0, 6))) {
                    bl = true;
                    continue;
                }
                if ("ATOM  ".equalsIgnoreCase(string2)) {
                    pDBAtom = this.readAtom(string, n);
                    if (bl) {
                        IMonomer iMonomer;
                        StringBuffer stringBuffer = new StringBuffer(8);
                        String string3 = pDBAtom.getResName();
                        if (string3 != null) {
                            stringBuffer = stringBuffer.append(string3.trim());
                        }
                        if ((string3 = pDBAtom.getChainID()) != null) {
                            stringBuffer = stringBuffer.append(String.valueOf(c));
                        }
                        if ((string3 = pDBAtom.getResSeq()) != null) {
                            stringBuffer = stringBuffer.append(string3.trim());
                        }
                        if ((object = pDBAtom.getChainID()) == null || ((String)object).length() == 0) {
                            object = String.valueOf(c);
                        }
                        if ((iStrand = pDBPolymer.getStrand((String)object)) == null) {
                            iStrand = new PDBStrand();
                            iStrand.setStrandName((String)object);
                            iStrand.setID(String.valueOf(c));
                        }
                        if ((iMonomer = pDBPolymer.getMonomer(stringBuffer.toString(), String.valueOf(c))) == null) {
                            PDBMonomer pDBMonomer = new PDBMonomer();
                            pDBMonomer.setMonomerName(stringBuffer.toString());
                            pDBMonomer.setMonomerType(pDBAtom.getResName());
                            pDBMonomer.setChainID(pDBAtom.getChainID());
                            pDBMonomer.setICode(pDBAtom.getICode());
                            pDBMonomer.setResSeq(pDBAtom.getResSeq());
                            iMonomer = pDBMonomer;
                        }
                        pDBPolymer.addAtom(pDBAtom, iMonomer, iStrand);
                        if (this.readConnect.isSet() && this.atomNumberMap.put(new Integer(pDBAtom.getSerial()), pDBAtom) != null) {
                            logger.warn("Duplicate serial ID found for atom: ", pDBAtom);
                        }
                        iMolecule.addAtom(pDBAtom);
                    } else {
                        iMolecule.addAtom(pDBAtom);
                    }
                    logger.debug("Added ATOM: ", pDBAtom);
                    continue;
                }
                if ("HETATM".equalsIgnoreCase(string2)) {
                    pDBAtom = this.readAtom(string, n);
                    pDBAtom.setHetAtom(true);
                    pDBPolymer.addAtom(pDBAtom);
                    if (this.atomNumberMap.put(new Integer(pDBAtom.getSerial()), pDBAtom) != null) {
                        logger.warn("Duplicate serial ID found for atom: ", pDBAtom);
                    }
                    logger.debug("Added HETATM: ", pDBAtom);
                    iMolecule.addAtom(pDBAtom);
                    continue;
                }
                if ("TER   ".equalsIgnoreCase(string2)) {
                    c = (char)(c + 1);
                    iStrand = new PDBStrand();
                    iStrand.setStrandName(String.valueOf(c));
                    logger.debug("Added new STRAND");
                    try {
                        if (!this.createBondsWithRebondTool(iMolecule)) {
                            logger.info("Bonds could not be created using the RebondTool when PDB file was read.");
                            iMolecule.removeAllBonds();
                        }
                    }
                    catch (Exception exception) {
                        logger.info("Bonds could not be created when PDB file was read.");
                        logger.debug(exception);
                    }
                    iMoleculeSet.addMolecule(iMolecule);
                    continue;
                }
                if ("END   ".equalsIgnoreCase(string2)) {
                    this.atomNumberMap.clear();
                    if (bl) {
                        if (this.useRebondTool.isSet()) {
                            try {
                                if (!this.createBondsWithRebondTool(pDBPolymer)) {
                                    logger.info("Bonds could not be created using the RebondTool when PDB file was read.");
                                    pDBPolymer.removeAllBonds();
                                }
                            }
                            catch (Exception exception) {
                                logger.info("Bonds could not be created when PDB file was read.");
                                logger.debug(exception);
                            }
                        }
                        iMoleculeSet.addMolecule(pDBPolymer);
                    }
                    try {
                        if (!this.createBondsWithRebondTool(iMolecule)) {
                            logger.info("Bonds could not be created using the RebondTool when PDB file was read.");
                            iMolecule.removeAllBonds();
                        }
                    }
                    catch (Exception exception) {
                        logger.info("Bonds could not be created when PDB file was read.");
                        logger.debug(exception);
                    }
                    iMoleculeSet.addMolecule(iMolecule);
                    continue;
                }
                if (string2.equals("MODEL ")) {
                    if (bl) {
                        if (pDBPolymer.getAtomCount() <= 0) continue;
                        iMoleculeSet.addAtomContainer(pDBPolymer);
                        iChemModel.setMoleculeSet(iMoleculeSet);
                        iChemSequence.addChemModel(iChemModel);
                        pDBPolymer = new PDBPolymer();
                        iChemModel = iChemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                        iMoleculeSet = iChemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
                        continue;
                    }
                    if (iMolecule.getAtomCount() <= 0) continue;
                    iMoleculeSet.addAtomContainer(iMolecule);
                    iChemModel.setMoleculeSet(iMoleculeSet);
                    iChemSequence.addChemModel(iChemModel);
                    iMolecule = iChemFile.getBuilder().newInstance(IMolecule.class, new Object[0]);
                    iChemModel = iChemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    iMoleculeSet = iChemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
                    continue;
                }
                if ("REMARK".equalsIgnoreCase(string2)) {
                    object = iChemFile.getProperty("cdk:Comment");
                    if (object == null) {
                        object = "";
                    }
                    if (n > 12) {
                        object = object.toString() + string.substring(11).trim() + System.getProperty("line.separator");
                        iChemFile.setProperty("cdk:Comment", object);
                        continue;
                    }
                    logger.warn("REMARK line found without any comment!");
                    continue;
                }
                if ("COMPND".equalsIgnoreCase(string2)) {
                    object = string.substring(10).trim();
                    iChemFile.setProperty("cdk:Title", object);
                    continue;
                }
                if (this.readConnect.isSet() && "CONECT".equalsIgnoreCase(string2)) {
                    string.trim();
                    if (string.length() < 16) {
                        logger.debug("Skipping unexpected empty CONECT line! : ", string);
                        continue;
                    }
                    object = string.substring(7, 11).trim();
                    int n2 = Integer.parseInt((String)object);
                    String string4 = string.substring(12, 16).trim();
                    int n3 = -1;
                    try {
                        n3 = Integer.parseInt(string4);
                    }
                    catch (Exception exception) {
                        n3 = -1;
                    }
                    if (n3 != -1) {
                        this.addBond(pDBPolymer, n2, n3);
                        logger.warn("Bonded " + n2 + " with " + n3);
                    }
                    if (string.length() > 17) {
                        string4 = string.substring(17, 21);
                        string4 = string4.trim();
                        try {
                            n3 = Integer.parseInt(string4);
                        }
                        catch (Exception exception) {
                            n3 = -1;
                        }
                        if (n3 != -1) {
                            this.addBond(pDBPolymer, n2, n3);
                            logger.warn("Bonded " + n2 + " with " + n3);
                        }
                    }
                    if (string.length() > 22) {
                        string4 = string.substring(22, 26);
                        string4 = string4.trim();
                        try {
                            n3 = Integer.parseInt(string4);
                        }
                        catch (Exception exception) {
                            n3 = -1;
                        }
                        if (n3 != -1) {
                            this.addBond(pDBPolymer, n2, n3);
                            logger.warn("Bonded " + n2 + " with " + n3);
                        }
                    }
                    if (string.length() <= 27) continue;
                    string4 = string.substring(27, 31);
                    string4 = string4.trim();
                    try {
                        n3 = Integer.parseInt(string4);
                    }
                    catch (Exception exception) {
                        n3 = -1;
                    }
                    if (n3 == -1) continue;
                    this.addBond(pDBPolymer, n2, n3);
                    logger.warn("Bonded " + n2 + " with " + n3);
                    continue;
                }
                if ("HELIX ".equalsIgnoreCase(string2)) {
                    object = new PDBStructure();
                    ((PDBStructure)object).setStructureType("helix");
                    ((PDBStructure)object).setStartChainID(Character.valueOf(string.charAt(19)));
                    ((PDBStructure)object).setStartSequenceNumber(Integer.parseInt(string.substring(21, 25).trim()));
                    ((PDBStructure)object).setStartInsertionCode(Character.valueOf(string.charAt(25)));
                    ((PDBStructure)object).setEndChainID(Character.valueOf(string.charAt(31)));
                    ((PDBStructure)object).setEndSequenceNumber(Integer.parseInt(string.substring(33, 37).trim()));
                    ((PDBStructure)object).setEndInsertionCode(Character.valueOf(string.charAt(37)));
                    pDBPolymer.addStructure((IPDBStructure)object);
                    continue;
                }
                if ("SHEET ".equalsIgnoreCase(string2)) {
                    object = new PDBStructure();
                    ((PDBStructure)object).setStructureType("sheet");
                    ((PDBStructure)object).setStartChainID(Character.valueOf(string.charAt(21)));
                    ((PDBStructure)object).setStartSequenceNumber(Integer.parseInt(string.substring(22, 26).trim()));
                    ((PDBStructure)object).setStartInsertionCode(Character.valueOf(string.charAt(26)));
                    ((PDBStructure)object).setEndChainID(Character.valueOf(string.charAt(32)));
                    ((PDBStructure)object).setEndSequenceNumber(Integer.parseInt(string.substring(33, 37).trim()));
                    ((PDBStructure)object).setEndInsertionCode(Character.valueOf(string.charAt(37)));
                    pDBPolymer.addStructure((IPDBStructure)object);
                    continue;
                }
                if (!"TURN  ".equalsIgnoreCase(string2)) continue;
                object = new PDBStructure();
                ((PDBStructure)object).setStructureType("turn");
                ((PDBStructure)object).setStartChainID(Character.valueOf(string.charAt(19)));
                ((PDBStructure)object).setStartSequenceNumber(Integer.parseInt(string.substring(20, 24).trim()));
                ((PDBStructure)object).setStartInsertionCode(Character.valueOf(string.charAt(24)));
                ((PDBStructure)object).setEndChainID(Character.valueOf(string.charAt(30)));
                ((PDBStructure)object).setEndSequenceNumber(Integer.parseInt(string.substring(31, 35).trim()));
                ((PDBStructure)object).setEndInsertionCode(Character.valueOf(string.charAt(35)));
                pDBPolymer.addStructure((IPDBStructure)object);
            } while (this._oInput.ready() && string != null);
        }
        catch (Exception exception) {
            logger.error("Found a problem at line:");
            logger.error(string);
            logger.error("01234567890123456789012345678901234567890123456789012345678901234567890123456789");
            logger.error("          1         2         3         4         5         6         7         ");
            logger.error("  error: " + exception.getMessage());
            logger.debug(exception);
        }
        try {
            this._oInput.close();
        }
        catch (Exception exception) {
            logger.debug(exception);
        }
        iChemModel.setMoleculeSet(iMoleculeSet);
        iChemSequence.addChemModel(iChemModel);
        iChemFile.addChemSequence(iChemSequence);
        return iChemFile;
    }

    private void addBond(PDBPolymer pDBPolymer, int n, int n2) {
        PDBAtom pDBAtom = (PDBAtom)this.atomNumberMap.get(new Integer(n));
        PDBAtom pDBAtom2 = (PDBAtom)this.atomNumberMap.get(new Integer(n2));
        if (pDBAtom == null) {
            logger.error("Could not find bond start atom in map with serial id: ", n);
        }
        if (pDBAtom2 == null) {
            logger.error("Could not find bond target atom in map with serial id: ", n);
        }
        IBond iBond = pDBAtom.getBuilder().newInstance(IBond.class, new Object[]{pDBAtom, pDBAtom2, IBond.Order.SINGLE});
        for (int i = 0; i < this.bondsFromConnectRecords.size(); ++i) {
            IBond iBond2 = (IBond)this.bondsFromConnectRecords.get(i);
            IAtom iAtom = iBond2.getAtom(0);
            IAtom iAtom2 = iBond2.getAtom(1);
            if ((iAtom != pDBAtom || iAtom2 != pDBAtom2) && (iAtom2 != pDBAtom || iAtom != pDBAtom2)) continue;
            return;
        }
        this.bondsFromConnectRecords.add(iBond);
        pDBPolymer.addBond(iBond);
    }

    private boolean createBondsWithRebondTool(IBioPolymer iBioPolymer) {
        RebondTool rebondTool = new RebondTool(2.0, 0.5, 0.5);
        try {
            AtomTypeFactory atomTypeFactory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/jmol_atomtypes.txt", iBioPolymer.getBuilder());
            for (IAtom iAtom : iBioPolymer.atoms()) {
                try {
                    IAtomType[] iAtomTypeArray = atomTypeFactory.getAtomTypes(iAtom.getSymbol());
                    if (iAtomTypeArray.length > 0) {
                        AtomTypeManipulator.configure(iAtom, iAtomTypeArray[0]);
                        continue;
                    }
                    logger.warn("Could not configure atom with symbol: " + iAtom.getSymbol());
                }
                catch (Exception exception) {
                    logger.warn("Could not configure atom (but don't care): " + exception.getMessage());
                    logger.debug(exception);
                }
            }
            rebondTool.rebond(iBioPolymer);
        }
        catch (Exception exception) {
            logger.error("Could not rebond the polymer: " + exception.getMessage());
            logger.debug(exception);
        }
        return true;
    }

    private boolean createBondsWithRebondTool(IMolecule iMolecule) {
        RebondTool rebondTool = new RebondTool(2.0, 0.5, 0.5);
        try {
            AtomTypeFactory atomTypeFactory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/jmol_atomtypes.txt", iMolecule.getBuilder());
            for (IAtom iAtom : iMolecule.atoms()) {
                try {
                    IAtomType[] iAtomTypeArray = atomTypeFactory.getAtomTypes(iAtom.getSymbol());
                    if (iAtomTypeArray.length > 0) {
                        AtomTypeManipulator.configure(iAtom, iAtomTypeArray[0]);
                        continue;
                    }
                    logger.warn("Could not configure atom with symbol: " + iAtom.getSymbol());
                }
                catch (Exception exception) {
                    logger.warn("Could not configure atom (but don't care): " + exception.getMessage());
                    logger.debug(exception);
                }
            }
            rebondTool.rebond(iMolecule);
        }
        catch (Exception exception) {
            logger.error("Could not rebond the polymer: " + exception.getMessage());
            logger.debug(exception);
        }
        return true;
    }

    private PDBAtom readAtom(String string, int n) {
        String string2;
        IAtomType iAtomType;
        String string3;
        if (n < 59) {
            // empty if block
        }
        if ((string3 = string.substring(12, 14).trim()).length() == 2) {
            string3 = string3.charAt(0) + string3.substring(1).toLowerCase();
        }
        String string4 = string.substring(12, 16).trim();
        String string5 = string.substring(17, 20).trim();
        try {
            iAtomType = pdbFactory.getAtomType(string5 + "." + string4);
            string3 = iAtomType.getSymbol();
        }
        catch (NoSuchAtomTypeException noSuchAtomTypeException) {
            logger.error("Did not recognize PDB atom type: " + string5 + "." + string4);
        }
        iAtomType = new PDBAtom(string3, new Point3d(Double.parseDouble(string.substring(30, 38)), Double.parseDouble(string.substring(38, 46)), Double.parseDouble(string.substring(46, 54))));
        ((PDBAtom)iAtomType).setRecord(string);
        ((PDBAtom)iAtomType).setSerial(Integer.parseInt(string.substring(6, 11).trim()));
        ((PDBAtom)iAtomType).setName(string4.trim());
        ((PDBAtom)iAtomType).setAltLoc(string.substring(16, 17).trim());
        ((PDBAtom)iAtomType).setResName(string5);
        ((PDBAtom)iAtomType).setChainID(string.substring(21, 22).trim());
        ((PDBAtom)iAtomType).setResSeq(string.substring(22, 26).trim());
        ((PDBAtom)iAtomType).setICode(string.substring(26, 27).trim());
        ((AtomType)iAtomType).setAtomTypeName(((PDBAtom)iAtomType).getResName() + "." + string4);
        if (n >= 59 && (string2 = string.substring(54, 60).trim()).length() > 0) {
            ((PDBAtom)iAtomType).setOccupancy(Double.parseDouble(string2));
        }
        if (n >= 65 && (string2 = string.substring(60, 66).trim()).length() > 0) {
            ((PDBAtom)iAtomType).setTempFactor(Double.parseDouble(string2));
        }
        if (n >= 75) {
            ((PDBAtom)iAtomType).setSegID(string.substring(72, 76).trim());
        }
        if (n >= 79 && (string2 = string.substring(78, 80).trim()).length() > 0) {
            ((Atom)iAtomType).setCharge(Double.parseDouble(string2));
        }
        if ((string2 = string.substring(13, 16).trim()).equals("OXT")) {
            ((PDBAtom)iAtomType).setOxt(true);
        } else {
            ((PDBAtom)iAtomType).setOxt(false);
        }
        return iAtomType;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this._oInput.close();
    }

    private void initIOSettings() {
        this.useRebondTool = new BooleanIOSetting("UseRebondTool", 2, "Should the PDBReader deduce bonding patterns?", "false");
        this.readConnect = new BooleanIOSetting("ReadConnectSection", 2, "Should the CONECT be read?", "true");
    }

    public void customizeJob() {
        this.fireIOSettingQuestion(this.useRebondTool);
        this.fireIOSettingQuestion(this.readConnect);
    }

    @Override
    public IOSetting[] getIOSettings() {
        IOSetting[] iOSettingArray = new IOSetting[]{this.useRebondTool, this.readConnect};
        return iOSettingArray;
    }
}

