/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.qsar.result.IntegerArrayResultType;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.CarbonTypesDescriptorTest")
public class PaDELCarbonTypesDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"C1SP1", "C2SP1", "C1SP2", "C2SP2", "C3SP2", "C1SP3", "C2SP3", "C3SP3", "C4SP3"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#carbonTypes", this.getClass().getName(), "$Id: ab88e6f55b258640c8da0c1cbb96d65a2c15ecac $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer,testButane,testComplex1,testComplex2")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (IAtom iAtom : iAtomContainer.atoms()) {
            if (!iAtom.getSymbol().equals("C") && !iAtom.getSymbol().equals("c")) continue;
            List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
            int n10 = 0;
            for (IAtom iAtom2 : list) {
                if (!iAtom2.getSymbol().equals("C") && !iAtom2.getSymbol().equals("c")) continue;
                ++n10;
            }
            Object object = this.getHighestBondOrder(iAtomContainer, iAtom);
            if (object == IBond.Order.TRIPLE && n10 == 1) {
                ++n;
                continue;
            }
            if (object == IBond.Order.TRIPLE && n10 == 2) {
                ++n2;
                continue;
            }
            if (object == IBond.Order.DOUBLE && n10 == 1) {
                ++n3;
                continue;
            }
            if (object == IBond.Order.DOUBLE && n10 == 2) {
                ++n4;
                continue;
            }
            if (object == IBond.Order.DOUBLE && n10 == 3) {
                ++n5;
                continue;
            }
            if (object == IBond.Order.SINGLE && n10 == 1) {
                ++n6;
                continue;
            }
            if (object == IBond.Order.SINGLE && n10 == 2) {
                ++n7;
                continue;
            }
            if (object == IBond.Order.SINGLE && n10 == 3) {
                ++n8;
                continue;
            }
            if (object != IBond.Order.SINGLE || n10 != 4) continue;
            ++n9;
        }
        IntegerArrayResult integerArrayResult = new IntegerArrayResult(9);
        integerArrayResult.add(n);
        integerArrayResult.add(n2);
        integerArrayResult.add(n3);
        integerArrayResult.add(n4);
        integerArrayResult.add(n5);
        integerArrayResult.add(n6);
        integerArrayResult.add(n7);
        integerArrayResult.add(n8);
        integerArrayResult.add(n9);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), integerArrayResult, this.getDescriptorNames());
    }

    private IBond.Order getHighestBondOrder(IAtomContainer iAtomContainer, IAtom iAtom) {
        List<IBond> list = iAtomContainer.getConnectedBondsList(iAtom);
        IBond.Order order = IBond.Order.SINGLE;
        for (IBond iBond : list) {
            IBond.Order order2 = iBond.getOrder();
            if (iAtom.getFlag(5) && BondManipulator.isHigherOrder(IBond.Order.DOUBLE, iBond.getOrder())) {
                order2 = IBond.Order.DOUBLE;
            }
            if (!BondManipulator.isHigherOrder(order2, order)) continue;
            order = order2;
        }
        return order;
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResultType(9);
    }
}

