/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.io.IOException;
import libpadeldescriptor.AtomConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AtomValenceTool;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.kierHallElectronegativityDescriptorTest")
public class KierHallElectronegativityDescriptor
implements IAtomicDescriptor {
    private static final String[] names = new String[]{"KierHallElectronegativity"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("kierHallElectronegativityDescriptor", this.getClass().getName(), "$Id: KierHallElectronegativityDescriptor.java 1 2008-06-10 10:12:38Z yapchunwei $", "PaDEL");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom iAtom, IAtomContainer iAtomContainer) {
        try {
            double d = 0.0;
            int n = iAtom.getAtomicNumber();
            if (n != 1) {
                int n2 = AtomContainerManipulator.countHydrogens(iAtomContainer, iAtom);
                double d2 = iAtomContainer.getConnectedBondsCount(iAtom) - n2;
                int n3 = AtomValenceTool.getValence(iAtom);
                double d3 = (double)(n3 - n2) / (double)(n - n3 - 1);
                int n4 = AtomConstants.period[n];
                d = (d3 - d2) / (double)(n4 * n4);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(d), names);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(new CDKException("Error in ElementPTFactory: " + exception.getMessage()));
        }
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return null;
    }
}

