/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

@TestClass(value="org.openscience.cdk.graph.GraphUtilTest")
public class GraphUtil {
    private static final int DEFAULT_DEGREE = 4;

    private GraphUtil() {
    }

    @TestMethod(value="testToAdjList,testToAdjList_resize,testToAdjList_missingAtom,testToAdjList_Empty,testToAdjList_Null")
    public static int[][] toAdjList(IAtomContainer iAtomContainer) {
        if (iAtomContainer == null) {
            throw new NullPointerException("atom container was null");
        }
        int n = iAtomContainer.getAtomCount();
        int[][] nArray = new int[n][4];
        int[] nArray2 = new int[n];
        for (IBond iBond : iAtomContainer.bonds()) {
            int n2 = iAtomContainer.getAtomNumber(iBond.getAtom(0));
            int n3 = iAtomContainer.getAtomNumber(iBond.getAtom(1));
            if (n2 < 0 || n3 < 0) {
                throw new IllegalArgumentException("bond at index " + iAtomContainer.getBondNumber(iBond) + " contained an atom not pressent in molecule");
            }
            int n4 = n2;
            int n5 = nArray2[n4];
            nArray2[n4] = n5 + 1;
            nArray[n2][n5] = n3;
            int n6 = n3;
            int n7 = nArray2[n6];
            nArray2[n6] = n7 + 1;
            nArray[n3][n7] = n2;
            if (nArray2[n2] == nArray[n2].length) {
                nArray[n2] = Arrays.copyOf(nArray[n2], nArray2[n2] * 2);
            }
            if (nArray2[n3] != nArray[n3].length) continue;
            nArray[n3] = Arrays.copyOf(nArray[n3], nArray2[n3] * 2);
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = Arrays.copyOf(nArray[i], nArray2[i]);
        }
        return nArray;
    }

    @TestMethod(value="testToAdjList_withMap")
    public static int[][] toAdjList(IAtomContainer iAtomContainer, EdgeToBondMap edgeToBondMap) {
        if (iAtomContainer == null) {
            throw new NullPointerException("atom container was null");
        }
        int n = iAtomContainer.getAtomCount();
        int[][] nArray = new int[n][4];
        int[] nArray2 = new int[n];
        for (IBond iBond : iAtomContainer.bonds()) {
            int n2 = iAtomContainer.getAtomNumber(iBond.getAtom(0));
            int n3 = iAtomContainer.getAtomNumber(iBond.getAtom(1));
            if (n2 < 0 || n3 < 0) {
                throw new IllegalArgumentException("bond at index " + iAtomContainer.getBondNumber(iBond) + " contained an atom not pressent in molecule");
            }
            int n4 = n2;
            int n5 = nArray2[n4];
            nArray2[n4] = n5 + 1;
            nArray[n2][n5] = n3;
            int n6 = n3;
            int n7 = nArray2[n6];
            nArray2[n6] = n7 + 1;
            nArray[n3][n7] = n2;
            if (nArray2[n2] == nArray[n2].length) {
                nArray[n2] = Arrays.copyOf(nArray[n2], nArray2[n2] * 2);
            }
            if (nArray2[n3] == nArray[n3].length) {
                nArray[n3] = Arrays.copyOf(nArray[n3], nArray2[n3] * 2);
            }
            edgeToBondMap.put(n2, n3, iBond);
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = Arrays.copyOf(nArray[i], nArray2[i]);
        }
        return nArray;
    }

    @TestMethod(value="sequentialSubgraph,intermittentSubgraph,resizeSubgraph")
    public static int[][] subgraph(int[][] nArray, int[] nArray2) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int[] nArray3 = new int[n2];
        for (int i = 0; i < n3; ++i) {
            nArray3[nArray2[i]] = i + 1;
        }
        int[] nArray4 = new int[n3];
        int[][] nArray5 = new int[n3][4];
        for (n = 0; n < n2; ++n) {
            int n4 = nArray3[n] - 1;
            if (n4 < 0) continue;
            for (int n5 : nArray[n]) {
                int n6 = nArray3[n5] - 1;
                if (n6 < 0) continue;
                if (nArray4[n4] == nArray5[n4].length) {
                    nArray5[n4] = Arrays.copyOf(nArray5[n4], 2 * nArray5[n4].length);
                }
                int n7 = n4;
                int n8 = nArray4[n7];
                nArray4[n7] = n8 + 1;
                nArray5[n4][n8] = n6;
            }
        }
        for (n = 0; n < n3; ++n) {
            nArray5[n] = Arrays.copyOf(nArray5[n], nArray4[n]);
        }
        return nArray5;
    }

    @TestMethod(value="testCycle,testAcyclic,testAcyclic2")
    public static int[] cycle(int[][] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        boolean[] blArray = new boolean[n];
        for (int n3 : nArray2) {
            blArray[n3] = true;
        }
        int[] nArray3 = new int[n2 + 1];
        nArray3[0] = nArray3[n2] = nArray2[0];
        blArray[nArray2[0]] = false;
        for (int i = 1; i < n2; ++i) {
            int n4 = GraphUtil.firstMarked(nArray[nArray3[i - 1]], blArray);
            if (n4 < 0) {
                throw new IllegalArgumentException("broken path");
            }
            nArray3[i] = n4;
            blArray[n4] = false;
        }
        for (int n5 : nArray[nArray3[n2 - 1]]) {
            if (n5 != nArray3[0]) continue;
            return nArray3;
        }
        throw new IllegalArgumentException("path does not make a cycle");
    }

    @TestMethod(value="firstMarked")
    static int firstMarked(int[] nArray, boolean[] blArray) {
        for (int n : nArray) {
            if (!blArray[n]) continue;
            return n;
        }
        return -1;
    }

    private static final class Tuple {
        private final int u;
        private final int v;

        private Tuple(int n, int n2) {
            this.u = n;
            this.v = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Tuple tuple = (Tuple)object;
            return this.u == tuple.u && this.v == tuple.v || this.u == tuple.v && this.v == tuple.u;
        }

        public int hashCode() {
            return this.u ^ this.v;
        }
    }

    public static final class EdgeToBondMap {
        private final Map<Tuple, IBond> lookup;

        private EdgeToBondMap(int n) {
            this.lookup = Maps.newHashMapWithExpectedSize((int)n);
        }

        private IBond put(int n, int n2, IBond iBond) {
            return this.lookup.put(new Tuple(n, n2), iBond);
        }

        public IBond get(int n, int n2) {
            return this.lookup.get(new Tuple(n, n2));
        }

        public static EdgeToBondMap withSpaceFor(IAtomContainer iAtomContainer) {
            return new EdgeToBondMap(iAtomContainer.getBondCount());
        }
    }
}

