/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import javax.vecmath.Point3d;
import libpadeldescriptor.AtomConstants;
import libpadeldescriptor.IntrinsicStateDescriptor;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.matrix.TopologicalMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class Autocorrelation3DDescriptor
implements IMolecularDescriptor {
    private static final int maxLag = 10;
    public String[] names = new String[wtypes.length * 10];
    private static final String[] wtypes = new String[]{"u", "m", "v", "e", "p", "i", "s", "r"};

    public Autocorrelation3DDescriptor() {
        int n = 0;
        for (String string : wtypes) {
            for (int i = 1; i <= 10; ++i) {
                this.names[n++] = "TDB" + i + string;
            }
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("3D autocorrelation", this.getClass().getName(), "$Id: Autocorrelation3DDescriptor.java 1 2014-06-12 14:30:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2 = iAtomContainer.getAtomCount();
        double[][] dArray = new double[wtypes.length][n2];
        IntrinsicStateDescriptor intrinsicStateDescriptor = new IntrinsicStateDescriptor();
        for (int i = 0; i < n2; ++i) {
            int n3 = iAtomContainer.getAtom(i).getAtomicNumber();
            dArray[0][i] = 1.0;
            dArray[1][i] = n3 < AtomConstants.masses.length ? AtomConstants.masses[n3] : Double.NaN;
            dArray[2][i] = n3 < AtomConstants.volumes.length ? AtomConstants.volumes[n3] : Double.NaN;
            dArray[3][i] = n3 < AtomConstants.sandersonelnegativities.length ? AtomConstants.sandersonelnegativities[n3] : Double.NaN;
            dArray[4][i] = n3 < AtomConstants.polarizabilities.length ? AtomConstants.polarizabilities[n3] : Double.NaN;
            dArray[5][i] = n3 < AtomConstants.ionpotentials.length ? AtomConstants.ionpotentials[n3] : Double.NaN;
            IAtom iAtom = iAtomContainer.getAtom(i);
            if (n3 == 1) {
                dArray[6][i] = 1.0;
            } else {
                DoubleArrayResult doubleArrayResult = (DoubleArrayResult)intrinsicStateDescriptor.calculate(iAtom, iAtomContainer).getValue();
                dArray[6][i] = doubleArrayResult.get(0);
            }
            dArray[7][i] = n3 < AtomConstants.radius_covalent.length ? AtomConstants.radius_covalent[n3] : Double.NaN;
        }
        double[][] dArray2 = new double[11][wtypes.length];
        int[][] nArray = TopologicalMatrix.getMatrix(iAtomContainer);
        for (int i = 1; i <= 10; ++i) {
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                for (int j = n + 1; j < n2; ++j) {
                    if (nArray[n][j] != i) continue;
                    Point3d point3d = iAtomContainer.getAtom(n).getPoint3d();
                    Point3d point3d2 = iAtomContainer.getAtom(j).getPoint3d();
                    double d = Math.sqrt((point3d.x - point3d2.x) * (point3d.x - point3d2.x) + (point3d.y - point3d2.y) * (point3d.y - point3d2.y) + (point3d.z - point3d2.z) * (point3d.z - point3d2.z));
                    for (int k = 0; k < wtypes.length; ++k) {
                        double[] dArray3 = dArray2[i];
                        int n5 = k;
                        dArray3[n5] = dArray3[n5] + dArray[k][n] * d * dArray[k][j];
                    }
                    ++n4;
                }
            }
            for (n = 0; n < wtypes.length; ++n) {
                dArray2[i][n] = n4 > 0 ? dArray2[i][n] / (double)n4 : 0.0;
            }
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (int i = 0; i < wtypes.length; ++i) {
            for (n = 1; n <= 10; ++n) {
                doubleArrayResult.add(dArray2[n][i]);
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

