/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.processors.batch;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IBatchStatistics;
import ambit2.base.interfaces.IProcessor;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.base.processors.ProcessorsChain;
import ambit2.base.processors.Reporter;
import ambit2.base.processors.batch.BatchProcessor;

public abstract class BatchReporter<Item, ItemList, Output>
extends DefaultAmbitProcessor<ItemList, Output>
implements Reporter<ItemList, Output> {
    private static final long serialVersionUID = -3398613304724941241L;
    protected Output output = null;
    protected BatchProcessor<ItemList, Item> batch;
    protected String licenseURI = null;
    protected ProcessorsChain<Item, IBatchStatistics, IProcessor> processors = new ProcessorsChain();

    @Override
    public Output getOutput() throws AmbitException {
        return this.output;
    }

    @Override
    public void setOutput(Output Output) throws AmbitException {
        this.output = Output;
    }

    public ProcessorsChain<Item, IBatchStatistics, IProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(ProcessorsChain<Item, IBatchStatistics, IProcessor> processorsChain) {
        this.processors = processorsChain;
    }

    public BatchReporter() {
        this.processors.add(new DefaultAmbitProcessor<Item, Item>(){

            @Override
            public Item process(Item Item) throws AmbitException {
                BatchReporter.this.processItem(Item, BatchReporter.this.output);
                return Item;
            }
        });
    }

    public abstract void header(Output var1, ItemList var2);

    public abstract void footer(Output var1, ItemList var2);

    @Override
    public Output process(ItemList ItemList) throws AmbitException {
        this.output = this.getOutput();
        this.header(this.output, null);
        this.batch = this.createBatch();
        try {
            this.batch.setProcessorChain(this.processors);
            Object object = this.batch.process((Object)ItemList);
            Output Output = this.output;
            return Output;
        }
        catch (AmbitException ambitException) {
            throw ambitException;
        }
        catch (Exception exception) {
            throw new AmbitException(exception);
        }
        finally {
            this.footer(this.output, null);
        }
    }

    protected abstract BatchProcessor<ItemList, Item> createBatch();

    public abstract void processItem(Item var1, Output var2);

    @Override
    public long getTimeout() {
        return this.batch.getTimeout();
    }

    @Override
    public void setTimeout(long l) {
        this.batch.setTimeout(l);
    }

    @Override
    public String getLicenseURI() {
        return this.licenseURI;
    }

    @Override
    public void setLicenseURI(String string) {
        this.licenseURI = string;
    }

    @Override
    public String getFileExtension() {
        return null;
    }
}

