/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.log;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;

public class AmbitLogger {
    private boolean debug = false;
    private boolean tostdout = false;
    private Category log4jLogger;
    private AmbitLogger logger = this;
    private String classname;
    public final int DEFAULT_STACK_LENGTH = 5;

    public AmbitLogger() {
        this(AmbitLogger.class);
    }

    public AmbitLogger(Object object) {
        this(object.getClass());
    }

    public static void configureLog4j(boolean bl) {
        if (bl) {
            AmbitLogger.configureLog4j("/ambit/log/log4.console");
        } else {
            AmbitLogger.configureLog4j("/ambit/log/log4.properties");
        }
    }

    public static void configureLog4j(String string) {
        try {
            PropertyConfigurator.configure((URL)AmbitLogger.class.getResource(string));
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Properties file not found: " + nullPointerException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("Unknown error occured: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public AmbitLogger(Class clazz) {
        this.classname = clazz.getName();
        try {
            this.log4jLogger = Category.getInstance((String)this.classname);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.tostdout = true;
            this.logger.debug("Log4J class not found!");
        }
        catch (NullPointerException nullPointerException) {
            this.tostdout = true;
            this.logger.debug("Properties file not found!");
        }
        catch (Exception exception) {
            this.tostdout = true;
            this.logger.debug("Unknown error occured: " + exception.getMessage());
        }
        this.debug = false;
        String string = System.getProperty("java.version");
        if (string.compareTo("1.2") >= 0) {
            try {
                if (System.getProperty("ambit.debugging", "false").equals("true")) {
                    System.out.println("Debug=true");
                    this.debug = true;
                }
                if (System.getProperty("ambit.debug.stdout", "false").equals("true")) {
                    this.tostdout = true;
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                this.debug = false;
                this.tostdout = true;
            }
        }
    }

    public void dumpSystemProperties() {
        this.debug("os.name        : " + System.getProperty("os.name"));
        this.debug("os.version     : " + System.getProperty("os.version"));
        this.debug("os.arch        : " + System.getProperty("os.arch"));
        this.debug("java.version   : " + System.getProperty("java.version"));
        this.debug("java.vendor    : " + System.getProperty("java.vendor"));
    }

    public void setStackLength(int n) {
    }

    public void dumpClasspath() {
        this.debug("java.class.path: " + System.getProperty("java.class.path"));
    }

    public void debug(Object object) {
        if (this.debug) {
            if (object instanceof Throwable) {
                this.debugThrowable((Throwable)object);
            } else {
                this.log4jLogger.debug((Object)object.toString());
            }
        }
    }

    private void debugThrowable(Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof Error) {
                this.debug("Error: " + throwable.getMessage());
            } else {
                this.debug("Exception: " + throwable.getMessage());
            }
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string = stringWriter.toString();
            try {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                if (bufferedReader.ready()) {
                    String string2 = bufferedReader.readLine();
                    while (bufferedReader.ready() && string2 != null) {
                        this.debug(string2);
                        string2 = bufferedReader.readLine();
                    }
                }
            }
            catch (Exception exception) {
                this.error("Serious error in LoggingTool while printing exception stack trace: " + exception.getMessage());
                this.logger.debug(exception);
            }
        }
    }

    public void error(Object object) {
        if (this.debug) {
            this.log4jLogger.debug(object);
        } else {
            this.log4jLogger.error(object);
        }
    }

    public void error(Object object, Exception exception) {
        if (this.debug) {
            this.log4jLogger.error(object);
            this.log4jLogger.debug((Object)exception.toString());
        } else {
            this.log4jLogger.error((Object)(object.toString() + exception.toString()));
        }
    }

    public void fatal(Object object) {
        if (this.debug) {
            this.log4jLogger.fatal((Object)object.toString());
        }
    }

    public void info(Object object) {
        if (this.debug) {
            this.log4jLogger.info((Object)object.toString());
        }
    }

    public void warn(Object object) {
        if (this.debug) {
            this.log4jLogger.warn(object);
        }
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }
}

