/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.processors.CASProcessor;
import ambit2.core.data.MoleculeTools;
import ambit2.core.io.ReaderFactoryExtended;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.tools.LoggingTool;

public class MyIteratingMDLReader
extends DefaultIteratingChemObjectReader {
    private BufferedReader input;
    private LoggingTool logger;
    private String currentLine;
    private IChemFormat currentFormat;
    private final ReaderFactory factory = new ReaderFactoryExtended();
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IChemObjectBuilder builder;
    private IMolecule nextMolecule;
    protected CASProcessor casTransformer = new CASProcessor();

    public MyIteratingMDLReader(Reader reader, IChemObjectBuilder iChemObjectBuilder) {
        this.logger = new LoggingTool((Object)this);
        this.input = new BufferedReader(reader);
        this.builder = iChemObjectBuilder;
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
        this.currentFormat = (IChemFormat)MDLV2000Format.getInstance();
    }

    public MyIteratingMDLReader(InputStream inputStream, IChemObjectBuilder iChemObjectBuilder) {
        this(new InputStreamReader(inputStream), iChemObjectBuilder);
    }

    public IResourceFormat getFormat() {
        return this.currentFormat;
    }

    public void setReader(InputStream inputStream) throws CDKException {
        this.input = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = new BufferedReader(reader);
    }

    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                this.currentLine = this.input.readLine();
                if (this.currentLine != null) {
                    this.currentFormat = (IChemFormat)MDLV2000Format.getInstance();
                    StringBuffer stringBuffer = new StringBuffer();
                    while (this.currentLine != null && !this.currentLine.equals("M  END")) {
                        stringBuffer.append(this.currentLine);
                        stringBuffer.append("\n");
                        this.currentLine = this.input.ready() ? this.input.readLine() : null;
                        if (this.currentLine == null) continue;
                        if (this.currentLine.contains("V2000") || this.currentLine.contains("v2000")) {
                            this.currentFormat = (IChemFormat)MDLV2000Format.getInstance();
                            continue;
                        }
                        if (!this.currentLine.contains("V3000") && !this.currentLine.contains("v3000")) continue;
                        this.currentFormat = (IChemFormat)MDLV3000Format.getInstance();
                    }
                    if (this.currentLine != null) {
                        stringBuffer.append(this.currentLine);
                    }
                    stringBuffer.append("\n");
                    this.logger.debug((Object)"MDL file part read: ", new Object[]{stringBuffer});
                    ISimpleChemObjectReader iSimpleChemObjectReader = this.factory.createReader(this.currentFormat);
                    iSimpleChemObjectReader.setReader((Reader)new StringReader(stringBuffer.toString()));
                    IChemObject iChemObject = iSimpleChemObjectReader.read((IChemObject)MoleculeTools.newMolecule(this.builder));
                    this.nextMolecule = iChemObject == null ? null : (IMolecule)iChemObject;
                    this.hasNext = this.nextMolecule.getAtomCount() > 0;
                    this.hasNext = true;
                    this.currentLine = this.input.readLine();
                    this.readDataBlockInto(this.nextMolecule);
                } else {
                    this.hasNext = false;
                }
            }
            catch (Exception exception) {
                this.logger.error((Object)("Error while reading next molecule: " + exception.getMessage()));
                this.logger.debug((Object)exception);
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    private void readDataBlockInto(IMolecule iMolecule) throws IOException {
        String string = null;
        while (this.currentLine != null && !this.currentLine.trim().equals("$$$$")) {
            this.logger.debug((Object)"looking for data header: ", new Object[]{this.currentLine});
            String string2 = new String(this.currentLine);
            if (string2.startsWith("> ")) {
                int n;
                int n2 = string2.indexOf("<");
                if (n2 != -1 && (n = string2.substring(n2).indexOf(">")) != -1) {
                    string = string2.substring(n2 + 1, n2 + n);
                }
                while (string2.startsWith("> ")) {
                    this.logger.debug((Object)"data header line: ", new Object[]{this.currentLine});
                    this.currentLine = this.input.readLine();
                    string2 = new String(this.currentLine);
                }
                String string3 = "";
                String string4 = "";
                while (string2.trim().length() > 0) {
                    this.logger.debug((Object)"data line: ", new Object[]{this.currentLine});
                    string3 = String.format("%s%s%s", string3, string4, string2);
                    this.currentLine = this.input.readLine();
                    string2 = new String(this.currentLine).trim();
                    string4 = "\n";
                }
                if (string != null) {
                    this.logger.info((Object)"fieldName, data: ", new Object[]{string, ", ", string3});
                    if (CASProcessor.isValidFormat((String)string3)) {
                        try {
                            iMolecule.setProperty((Object)string, (Object)this.casTransformer.process(string3));
                        }
                        catch (Exception exception) {
                            iMolecule.setProperty((Object)string, (Object)string3);
                        }
                    } else {
                        iMolecule.setProperty((Object)string, (Object)string3);
                    }
                }
            }
            this.currentLine = this.input.readLine();
        }
    }

    public Object next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

