/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.data;

import ambit2.core.io.MyIteratingMDLReader;
import ambit2.core.processors.structure.StructureTypeProcessor;
import ambit2.core.smiles.SmilesParserWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.BitSet;
import javax.vecmath.Point2d;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomParity;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class MoleculeTools {
    public static final int _FPLength = 1024;
    protected static CDKHydrogenAdder adder = null;
    protected static Fingerprinter fingerprinter = null;
    public static final String[] substanceType = new String[]{"organic", "inorganic", "mixture/unknown", "organometallic"};
    public static final int substTypeOrganic = 1;
    public static final int substTypeInorganic = 2;
    public static final int substTypeMixture = 3;
    public static final int substTypeMetallic = 4;
    protected static StructureTypeProcessor sp = new StructureTypeProcessor();
    protected static String delim;
    protected static String bracketLeft;
    protected static String bracketRight;

    public static IMolecule getMolecule(String string) throws InvalidSmilesException {
        SmilesParser smilesParser = new SmilesParser(SilentChemObjectBuilder.getInstance());
        return smilesParser.parseSmiles(string);
    }

    public static BitSet getFingerPrint(String string, int n) throws Exception {
        SmilesParserWrapper smilesParserWrapper = SmilesParserWrapper.getInstance();
        IMolecule iMolecule = smilesParserWrapper.parseSmiles(string);
        if (fingerprinter == null) {
            fingerprinter = new Fingerprinter(n);
        }
        return fingerprinter.getFingerprint((IAtomContainer)iMolecule);
    }

    public static BitSet getFingerPrint(String string) throws Exception {
        return MoleculeTools.getFingerPrint(string, 1024);
    }

    public static long bitset2Long(BitSet bitSet) {
        long l = 0L;
        for (int i = 0; i < 64; ++i) {
            l <<= 1;
            if (!bitSet.get(i)) continue;
            l |= 1L;
        }
        return l;
    }

    public static void bitset2bigint16(BitSet bitSet, int n, BigInteger[] bigIntegerArray) {
        if (bitSet == null) {
            for (int i = 0; i < bigIntegerArray.length; ++i) {
                bigIntegerArray[i] = BigInteger.ZERO;
            }
        } else {
            int n2 = bigIntegerArray.length;
            for (int i = 0; i < n2; ++i) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = n - 1; j >= 0; --j) {
                    stringBuilder.append(bitSet.get(i * n + j) ? "1" : "0");
                }
                bigIntegerArray[i] = new BigInteger(stringBuilder.toString(), 2);
            }
        }
    }

    public static boolean analyzeSubstance(IAtomContainer iAtomContainer) throws IOException {
        IElement iElement;
        if (iAtomContainer == null || iAtomContainer.getAtomCount() == 0) {
            return false;
        }
        boolean bl = false;
        IMolecularFormula iMolecularFormula = MolecularFormulaManipulator.getMolecularFormula((IAtomContainer)iAtomContainer);
        if (MolecularFormulaManipulator.getElementCount((IMolecularFormula)iMolecularFormula, (IElement)(iElement = IsotopeFactory.getInstance((IChemObjectBuilder)iAtomContainer.getBuilder()).getElement("H"))) == 0) {
            bl = true;
            if (adder == null) {
                adder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)SilentChemObjectBuilder.getInstance());
            }
            try {
                adder.addImplicitHydrogens(iAtomContainer);
                int n = iAtomContainer.getAtomCount();
                iMolecularFormula = MolecularFormulaManipulator.getMolecularFormula((IAtomContainer)iAtomContainer);
            }
            catch (CDKException cDKException) {
                cDKException.printStackTrace();
                iMolecularFormula = null;
            }
        }
        if (iMolecularFormula != null) {
            iAtomContainer.setProperty((Object)"FORMULA", (Object)MolecularFormulaManipulator.getString((IMolecularFormula)iMolecularFormula));
            double d = MolecularFormulaManipulator.getTotalMassNumber((IMolecularFormula)iMolecularFormula);
            iAtomContainer.setProperty((Object)"MolWeigth", (Object)new Double(d));
            try {
                iAtomContainer.setProperty((Object)"STRUCTURE_TYPE", (Object)sp.process(iAtomContainer));
            }
            catch (Exception exception) {
                // empty catch block
            }
            iAtomContainer.setProperty((Object)"SUBSTANCE_TYPE", (Object)MoleculeTools.getSubstanceType(MolecularFormulaManipulator.getString((IMolecularFormula)iMolecularFormula)));
        }
        return true;
    }

    protected static int getSubstanceType(String string) {
        if (string.equals("")) {
            return 1;
        }
        if (string.startsWith("C")) {
            return 1;
        }
        return 2;
    }

    public static IMolecule readMolfile(Reader reader) throws Exception {
        MyIteratingMDLReader myIteratingMDLReader = new MyIteratingMDLReader(reader, SilentChemObjectBuilder.getInstance());
        IMolecule iMolecule = null;
        while (myIteratingMDLReader.hasNext()) {
            Object object = myIteratingMDLReader.next();
            if (!(object instanceof IMolecule)) continue;
            iMolecule = (IMolecule)object;
            break;
        }
        myIteratingMDLReader.close();
        return iMolecule;
    }

    public static IMolecule readMolfile(String string) throws Exception {
        StringReader stringReader = new StringReader(string);
        IMolecule iMolecule = MoleculeTools.readMolfile(stringReader);
        stringReader.close();
        return iMolecule;
    }

    public static IMolecule readCMLMolecule(String string) throws Exception {
        IMolecule iMolecule = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            iMolecule = MoleculeTools.readCMLMolecule(byteArrayInputStream);
            byteArrayInputStream.close();
            return iMolecule;
        }
        catch (Exception exception) {
            return iMolecule;
        }
    }

    public static IMolecule readCMLMolecule(InputStream inputStream) throws Exception {
        IMolecule iMolecule = null;
        CMLReader cMLReader = new CMLReader(inputStream);
        IChemFile iChemFile = null;
        iChemFile = (IChemFile)cMLReader.read((IChemObject)MoleculeTools.newChemFile(SilentChemObjectBuilder.getInstance()));
        int n = iChemFile.getChemSequenceCount();
        if (n > 1) {
            System.out.println("> 1 sequence in a record");
        }
        for (int i = 0; i < n; ++i) {
            IChemSequence iChemSequence = iChemFile.getChemSequence(i);
            int n2 = iChemSequence.getChemModelCount();
            if (n2 > 1) {
                System.out.println("> 1 model in a record");
            }
            for (int j = 0; j < n2; ++j) {
                int n3;
                IChemModel iChemModel = iChemSequence.getChemModel(j);
                IMoleculeSet iMoleculeSet = iChemModel.getMoleculeSet();
                if (iMoleculeSet.getMoleculeCount() > 1) {
                    System.out.println("> 1 molecule in a record");
                }
                if ((n3 = 0) >= iMoleculeSet.getMoleculeCount()) continue;
                iMolecule = iMoleculeSet.getMolecule(n3);
                return iMolecule;
            }
        }
        cMLReader = null;
        return iMolecule;
    }

    public static IAtom newAtom(IChemObjectBuilder iChemObjectBuilder, IElement iElement) {
        return (IAtom)iChemObjectBuilder.newInstance(IAtom.class, new Object[]{iElement});
    }

    public static IAtom newAtom(IChemObjectBuilder iChemObjectBuilder, IAtom iAtom) {
        return (IAtom)iChemObjectBuilder.newInstance(IAtom.class, new Object[]{iAtom});
    }

    public static IAtom newAtom(IChemObjectBuilder iChemObjectBuilder, String string) {
        return (IAtom)iChemObjectBuilder.newInstance(IAtom.class, new Object[]{string});
    }

    public static IAtom newAtom(IChemObjectBuilder iChemObjectBuilder) {
        return (IAtom)iChemObjectBuilder.newInstance(IAtom.class, new Object[0]);
    }

    public static IPseudoAtom newPseudoAtom(IChemObjectBuilder iChemObjectBuilder, String string) {
        return (IPseudoAtom)iChemObjectBuilder.newInstance(IPseudoAtom.class, new Object[]{string});
    }

    public static ILonePair newLonePair(IChemObjectBuilder iChemObjectBuilder, IAtom iAtom) {
        return (ILonePair)iChemObjectBuilder.newInstance(ILonePair.class, new Object[]{iAtom});
    }

    public static IBond newBond(IChemObjectBuilder iChemObjectBuilder, IAtom iAtom, IAtom iAtom2, IBond.Order order, IBond.Stereo stereo) {
        return (IBond)iChemObjectBuilder.newInstance(IBond.class, new Object[]{iAtom, iAtom2, order, stereo});
    }

    public static IBond newBond(IChemObjectBuilder iChemObjectBuilder, IAtom iAtom, IAtom iAtom2, IBond.Order order) {
        return (IBond)iChemObjectBuilder.newInstance(IBond.class, new Object[]{iAtom, iAtom2, order});
    }

    public static IBond newBond(IChemObjectBuilder iChemObjectBuilder, IAtom iAtom, IAtom iAtom2) {
        return (IBond)iChemObjectBuilder.newInstance(IBond.class, new Object[]{iAtom, iAtom2});
    }

    public static IBond newBond(IChemObjectBuilder iChemObjectBuilder) {
        return (IBond)iChemObjectBuilder.newInstance(IBond.class, new Object[0]);
    }

    public static IAtomContainer newAtomContainer(IChemObjectBuilder iChemObjectBuilder) {
        return (IAtomContainer)iChemObjectBuilder.newInstance(IAtomContainer.class, new Object[0]);
    }

    public static IMolecule newMolecule(IChemObjectBuilder iChemObjectBuilder) {
        return (IMolecule)iChemObjectBuilder.newInstance(IMolecule.class, new Object[0]);
    }

    public static IAtomContainer newAtomContainer(IChemObjectBuilder iChemObjectBuilder, IMolecule iMolecule) {
        return (IAtomContainer)iChemObjectBuilder.newInstance(IAtomContainer.class, new Object[]{iMolecule});
    }

    public static ISingleElectron newSingleElectron(IChemObjectBuilder iChemObjectBuilder, IAtom iAtom) {
        return (ISingleElectron)iChemObjectBuilder.newInstance(ISingleElectron.class, new Object[]{iAtom});
    }

    public static IMoleculeSet newMoleculeSet(IChemObjectBuilder iChemObjectBuilder) {
        return (IMoleculeSet)iChemObjectBuilder.newInstance(IMoleculeSet.class, new Object[0]);
    }

    public static IAtomContainerSet newAtomContainerSet(IChemObjectBuilder iChemObjectBuilder) {
        return (IAtomContainerSet)iChemObjectBuilder.newInstance(IAtomContainerSet.class, new Object[0]);
    }

    public static IChemModel newChemModel(IChemObjectBuilder iChemObjectBuilder) {
        return (IChemModel)iChemObjectBuilder.newInstance(IChemModel.class, new Object[0]);
    }

    public static IChemSequence newChemSequence(IChemObjectBuilder iChemObjectBuilder) {
        return (IChemSequence)iChemObjectBuilder.newInstance(IChemSequence.class, new Object[0]);
    }

    public static IChemFile newChemFile(IChemObjectBuilder iChemObjectBuilder) {
        return (IChemFile)iChemObjectBuilder.newInstance(IChemFile.class, new Object[0]);
    }

    public static IRingSet newRingSet(IChemObjectBuilder iChemObjectBuilder) {
        return (IRingSet)iChemObjectBuilder.newInstance(IRingSet.class, new Object[0]);
    }

    public static IRing newRing(IChemObjectBuilder iChemObjectBuilder, int n) {
        return (IRing)iChemObjectBuilder.newInstance(IRing.class, new Object[]{n});
    }

    public static IAtomParity newAtomParity(IChemObjectBuilder iChemObjectBuilder, IAtom iAtom, IAtom iAtom2, IAtom iAtom3, IAtom iAtom4, IAtom iAtom5, int n) {
        return (IAtomParity)iChemObjectBuilder.newInstance(IAtomParity.class, new Object[]{iAtom, iAtom2, iAtom3, iAtom4, iAtom5, n});
    }

    public static IElement newElement(IChemObjectBuilder iChemObjectBuilder, String string) {
        return (IElement)iChemObjectBuilder.newInstance(IElement.class, new Object[]{string});
    }

    public static IAtomContainer copyChangeBuilders(IAtomContainer iAtomContainer, IChemObjectBuilder iChemObjectBuilder) {
        int n;
        Object object;
        int n2;
        ISingleElectron iSingleElectron2;
        IMolecule iMolecule = (IMolecule)iChemObjectBuilder.newInstance(IMolecule.class, new Object[0]);
        boolean bl = false;
        for (ISingleElectron iSingleElectron2 : iAtomContainer.atoms()) {
            if (!iSingleElectron2.getFlag(5)) continue;
            bl = true;
            break;
        }
        bl = false;
        for (n2 = 0; n2 < iAtomContainer.getAtomCount(); ++n2) {
            iSingleElectron2 = iAtomContainer.getAtom(n2);
            iAtomContainer.getAtom(n2).setProperty((Object)"_NO", (Object)n2);
            object = (IAtom)iChemObjectBuilder.newInstance(IAtom.class, new Object[]{iAtomContainer.getAtom(n2).getSymbol()});
            object.setCharge(iSingleElectron2.getCharge());
            object.setFormalCharge(iSingleElectron2.getFormalCharge());
            object.setStereoParity(iSingleElectron2.getStereoParity());
            if (iSingleElectron2.getPoint2d() != null) {
                object.setPoint2d(new Point2d(iSingleElectron2.getPoint2d().x, iSingleElectron2.getPoint2d().y));
            }
            for (n = 0; n < iSingleElectron2.getFlags().length; ++n) {
                object.setFlag(n, iSingleElectron2.getFlag(n));
            }
            object.setAtomTypeName(iSingleElectron2.getAtomTypeName());
            iMolecule.addAtom((IAtom)object);
        }
        for (n2 = 0; n2 < iAtomContainer.getBondCount(); ++n2) {
            iSingleElectron2 = new IAtom[iAtomContainer.getBond(n2).getAtomCount()];
            for (int i = 0; i < iAtomContainer.getBond(n2).getAtomCount(); ++i) {
                Integer n3 = (Integer)iAtomContainer.getBond(n2).getAtom(i).getProperty((Object)"_NO");
                iSingleElectron2[i] = iMolecule.getAtom(n3.intValue());
            }
            object = (IBond)iChemObjectBuilder.newInstance(IBond.class, new Object[0]);
            object.setAtoms((IAtom[])iSingleElectron2);
            object.setOrder(iAtomContainer.getBond(n2).getOrder());
            for (n = 0; n < iAtomContainer.getBond(n2).getFlags().length; ++n) {
                object.setFlag(n, iAtomContainer.getBond(n2).getFlag(n));
            }
            iMolecule.addBond((IBond)object);
        }
        for (n2 = 0; n2 < iAtomContainer.getSingleElectronCount(); ++n2) {
            iSingleElectron2 = (ISingleElectron)iChemObjectBuilder.newInstance(ISingleElectron.class, new Object[0]);
            iSingleElectron2.setElectronCount(iAtomContainer.getSingleElectron(n2).getElectronCount());
            object = (Integer)iAtomContainer.getSingleElectron(n2).getAtom().getProperty((Object)"_NO");
            iSingleElectron2.setAtom(iMolecule.getAtom(((Integer)object).intValue()));
            iMolecule.addSingleElectron(iSingleElectron2);
        }
        for (n2 = 0; n2 < iAtomContainer.getLonePairCount(); ++n2) {
            iSingleElectron2 = (ILonePair)iChemObjectBuilder.newInstance(ILonePair.class, new Object[0]);
            iSingleElectron2.setElectronCount(iAtomContainer.getLonePair(n2).getElectronCount());
            object = (Integer)iAtomContainer.getLonePair(n2).getAtom().getProperty((Object)"_NO");
            iSingleElectron2.setAtom(iMolecule.getAtom(((Integer)object).intValue()));
            iMolecule.addElectronContainer((IElectronContainer)iSingleElectron2);
        }
        return AtomContainerManipulator.removeHydrogensPreserveMultiplyBonded((IAtomContainer)iMolecule);
    }

    static {
        bracketLeft = "[";
        bracketRight = "]";
    }
}

