/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts.query;

import ambit2.core.data.MoleculeTools;
import ambit2.smarts.IsomorphismTester;
import ambit2.smarts.SmartsParser;
import ambit2.smarts.processors.SMARTSPropertiesReader;
import ambit2.smarts.query.AbstractSmartsPattern;
import ambit2.smarts.query.SMARTSException;
import java.util.Vector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class FastSmartsMatcher
extends AbstractSmartsPattern<IAtomContainer> {
    private static final long serialVersionUID = -437122688052917294L;
    protected IsomorphismTester isoTester = new IsomorphismTester();
    protected SmartsParser sp = new SmartsParser();
    protected QueryAtomContainer query = null;
    protected SMARTSPropertiesReader reader = new SMARTSPropertiesReader();

    public FastSmartsMatcher() {
    }

    public FastSmartsMatcher(String smarts, boolean negate) throws SMARTSException {
        this.setSmarts(smarts);
        this.setNegate(negate);
    }

    @Override
    public QueryAtomContainer getQuery() {
        return this.query;
    }

    public void setQuery(QueryAtomContainer query) {
        this.query = query;
    }

    @Override
    public IAtomContainer getMatchingStructure(IAtomContainer mol) throws SMARTSException {
        if (this.query == null) {
            return null;
        }
        this.isoTester.setQuery(this.query);
        Vector<IAtom> index = this.isoTester.getIsomorphismMapping(mol);
        if (index == null) {
            return null;
        }
        IAtomContainer match = MoleculeTools.newAtomContainer(SilentChemObjectBuilder.getInstance());
        for (IAtom i : index) {
            match.addAtom(i);
        }
        for (int b = 0; b < mol.getBondCount(); ++b) {
            IBond bond = mol.getBond(b);
            int count = 0;
            for (int a = 0; a < bond.getAtomCount() && index.indexOf(bond.getAtom(a)) >= 0; ++a) {
                ++count;
            }
            if (count != bond.getAtomCount()) continue;
            match.addBond(bond);
        }
        return match;
    }

    @Override
    public IAtomContainer getObjectToVerify(IAtomContainer mol) {
        return mol;
    }

    @Override
    public void setSmarts(String smarts) throws SMARTSException {
        this.query = this.sp.parse(smarts);
        this.sp.setNeededDataFlags();
        String errorMsg = this.sp.getErrorMessages();
        if (!errorMsg.equals("")) {
            this.query = null;
            super.setSmarts(null);
            throw new SMARTSException("Smarts Parser errors:\n" + errorMsg);
        }
        super.setSmarts(smarts);
    }

    @Override
    public int hasSMARTSPattern(IAtomContainer mol) throws SMARTSException {
        this.isoTester.setQuery(this.query);
        try {
            if (this.reader.process(mol) == null) {
                this.sp.setSMARTSData(mol);
            }
        }
        catch (Exception x) {
            try {
                this.sp.setSMARTSData(mol);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.isoTester.hasIsomorphism(mol) ? 1 : 0;
    }

    @Override
    public void useMOEvPrimitive(boolean flag) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("useMOEvPrimitive");
    }
}

