/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.validate;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.validate.ValidationTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationReport {
    private List<ValidationTest> errors = new ArrayList<ValidationTest>();
    private List<ValidationTest> warnings = new ArrayList<ValidationTest>();
    private List<ValidationTest> oks = new ArrayList<ValidationTest>();
    private List<ValidationTest> cdkErrors = new ArrayList<ValidationTest>();

    public void addReport(ValidationReport report) {
        this.errors.addAll(report.errors);
        this.warnings.addAll(report.warnings);
        this.oks.addAll(report.oks);
        this.cdkErrors.addAll(report.cdkErrors);
    }

    public void addError(ValidationTest test) {
        this.errors.add(test);
    }

    public void addWarning(ValidationTest test) {
        this.warnings.add(test);
    }

    public void addOK(ValidationTest test) {
        this.oks.add(test);
    }

    public void addCDKError(ValidationTest test) {
        this.cdkErrors.add(test);
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public int getWarningCount() {
        return this.warnings.size();
    }

    public int getOKCount() {
        return this.oks.size();
    }

    public int getCDKErrorCount() {
        return this.cdkErrors.size();
    }

    public int getCount() {
        return this.cdkErrors.size() + this.errors.size() + this.warnings.size() + this.oks.size();
    }

    public List<ValidationTest> getErrors() {
        return this.errors;
    }

    public List<ValidationTest> getWarnings() {
        return this.warnings;
    }

    public List<ValidationTest> getOKs() {
        return this.oks;
    }

    public List<ValidationTest> getCDKErrors() {
        return this.cdkErrors;
    }
}

